/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg.collections;

import java.io.Serializable;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentFieldFactory;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.PBCapsule;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.TxManagerFactory;
import org.apache.ojb.odmg.collections.DListImpl;

public class DListEntry
implements Serializable {
    protected int id = 0;
    protected int dlistId = 0;
    protected DListImpl m_dList;
    protected int position;
    protected Identity oid;
    protected Object realSubject;
    protected PBKey pbKey;

    public DListEntry() {
        if (!PersistentFieldFactory.usesAccessorsAndMutators()) {
            this.id = this.generateNewId();
        }
    }

    public DListEntry(PBKey pBKey) {
        this.pbKey = pBKey;
        if (!PersistentFieldFactory.usesAccessorsAndMutators()) {
            this.id = this.generateNewId();
        }
    }

    public DListEntry(int n, int n2, int n3, Identity identity) {
        this.id = n;
        this.dlistId = n2;
        this.position = n3;
        this.oid = identity;
    }

    public DListEntry(DListImpl dListImpl, Object object) {
        this.pbKey = dListImpl.getPBKey();
        this.m_dList = dListImpl;
        this.dlistId = dListImpl.getId();
        this.position = dListImpl.size();
        TransactionImpl transactionImpl = TxManagerFactory.instance().getTransaction();
        if (transactionImpl != null) {
            this.oid = new Identity(object, transactionImpl.getBroker());
        } else {
            PersistenceBroker persistenceBroker = PersistenceBrokerFactory.defaultPersistenceBroker();
            this.oid = new Identity(object, persistenceBroker);
            persistenceBroker.close();
        }
        this.realSubject = object;
        if (!PersistentFieldFactory.usesAccessorsAndMutators()) {
            this.id = this.generateNewId();
        }
    }

    public Identity getOid() {
        return this.oid;
    }

    public void setOid(Identity identity) {
        this.oid = identity;
    }

    public PBKey getPBKey() {
        return this.pbKey;
    }

    public void setPBKey(PBKey pBKey) {
        this.pbKey = pBKey;
    }

    protected int generateNewId() {
        PBCapsule pBCapsule = new PBCapsule(this.pbKey, TxManagerFactory.instance().getTransaction());
        try {
            int n;
            PersistenceBroker persistenceBroker = pBCapsule.getBroker();
            FieldDescriptor fieldDescriptor = persistenceBroker.getClassDescriptor(this.getClass()).getAutoIncrementField();
            Integer n2 = (Integer)persistenceBroker.serviceSequenceManager().getUniqueValue(fieldDescriptor);
            int n3 = n = n2.intValue();
            return n3;
        }
        catch (Exception exception) {
            LoggerFactory.getDefaultLogger().error("DListEntry: Generation of new id failed", exception);
            throw new PersistenceBrokerException(exception);
        }
        finally {
            pBCapsule.destroy();
        }
    }

    public int getPosition() {
        return this.position;
    }

    public Object getRealSubject() {
        try {
            if (this.realSubject == null) {
                this.materializeRealSubject();
            }
        }
        catch (Exception exception) {
            LoggerFactory.getDefaultLogger().error("Cannot materialize real subject", exception);
        }
        return this.realSubject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void materializeRealSubject() throws PersistenceBrokerException {
        PBCapsule pBCapsule = new PBCapsule(this.pbKey, TxManagerFactory.instance().getTransaction());
        try {
            this.realSubject = pBCapsule.getBroker().getObjectByIdentity(this.oid);
        }
        finally {
            if (pBCapsule != null) {
                pBCapsule.destroy();
            }
        }
    }

    public void setPosition(int n) {
        this.position = n;
    }

    void setRealSubject(Object object) {
        this.realSubject = object;
    }

    public String toString() {
        if (this.realSubject == null) {
            return this.oid.toString();
        }
        return this.realSubject.toString();
    }

    public int getDlistId() {
        if (this.dlistId == -1) {
            this.dlistId = this.m_dList != null ? this.m_dList.getId() : this.generateNewId();
        }
        return this.dlistId;
    }

    public void setDlistId(int n) {
        this.dlistId = n;
    }

    public int getId() {
        if (this.id == -1) {
            this.id = this.generateNewId();
        }
        return this.id;
    }

    public void setId(int n) {
        this.id = n;
    }
}

