/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg;

import java.io.Serializable;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.ManageableCollection;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PBFactoryException;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.PersistenceBrokerSQLException;
import org.apache.ojb.broker.VirtualProxy;
import org.apache.ojb.broker.accesslayer.IndirectionHandler;
import org.apache.ojb.broker.accesslayer.MaterializationListener;
import org.apache.ojb.broker.metadata.AttributeDescriptorBase;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.DescriptorBase;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.util.ArrayIterator;
import org.apache.ojb.broker.util.GUID;
import org.apache.ojb.broker.util.ProxyHelper;
import org.apache.ojb.broker.util.configuration.Configurable;
import org.apache.ojb.broker.util.configuration.Configuration;
import org.apache.ojb.broker.util.configuration.ConfigurationException;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.DatabaseImpl;
import org.apache.ojb.odmg.OJBTxManager;
import org.apache.ojb.odmg.ObjectEnvelope;
import org.apache.ojb.odmg.ObjectEnvelopeTable;
import org.apache.ojb.odmg.OdmgConfiguration;
import org.apache.ojb.odmg.TransactionAbortedExceptionOJB;
import org.apache.ojb.odmg.TransactionExt;
import org.apache.ojb.odmg.TxManagerFactory;
import org.apache.ojb.odmg.TxUtil;
import org.apache.ojb.odmg.locking.LockManagerFactory;
import org.odmg.DatabaseClosedException;
import org.odmg.LockNotGrantedException;
import org.odmg.ODMGRuntimeException;
import org.odmg.Transaction;
import org.odmg.TransactionAbortedException;
import org.odmg.TransactionInProgressException;
import org.odmg.TransactionNotInProgressException;

public class TransactionImpl
implements Transaction,
MaterializationListener,
Configurable,
TransactionExt {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$odmg$TransactionImpl == null ? (class$org$apache$ojb$odmg$TransactionImpl = TransactionImpl.class$("org.apache.ojb.odmg.TransactionImpl")) : class$org$apache$ojb$odmg$TransactionImpl);
    private Hashtable myNrm = null;
    private boolean useWriteLocks;
    private boolean useImplicitLocking;
    private String txGUID;
    protected PersistenceBroker broker = null;
    private ArrayList registeredForLock = new ArrayList();
    private OJBTxManager txManager;
    private int m_txStatus = 6;
    private ObjectEnvelopeTable objectEnvelopeTable = null;
    private DatabaseImpl curDB;
    private ArrayList registeredIndirectionHandlers = new ArrayList();
    private ArrayList unmaterializedLocks = new ArrayList();
    static /* synthetic */ Class class$org$apache$ojb$odmg$TransactionImpl;

    public TransactionImpl(DatabaseImpl databaseImpl) {
        this.txManager = TxManagerFactory.instance();
        this.txGUID = new GUID().toString();
        this.curDB = databaseImpl;
    }

    public DatabaseImpl getAssociatedDatabase() {
        return this.curDB;
    }

    protected int getStatus() {
        return this.m_txStatus;
    }

    private void checkForDB() {
        if (this.curDB == null || !this.curDB.isOpen()) {
            this.log.error("Transaction without a associated open Database.");
            throw new TransactionAbortedExceptionOJB("No open database found. Open the database before handling transactions");
        }
    }

    public boolean isOpen() {
        return this.getStatus() == 0 || this.getStatus() == 1 || this.getStatus() == 2 || this.getStatus() == 7 || this.getStatus() == 8;
    }

    private void checkOpen() {
        if (!this.isOpen()) {
            throw new TransactionNotInProgressException("Transaction was not open, call tx.begin() before perform action, current status is: " + TxUtil.getStatusString(this.getStatus()));
        }
    }

    public void join() {
        this.checkOpen();
        this.txManager.deregisterTx(this);
        this.txManager.registerTx(this);
    }

    public void lock(Object object, int n) throws LockNotGrantedException {
        Object object2;
        if (this.log.isDebugEnabled()) {
            this.log.debug("lock object was called on tx " + this);
        }
        this.checkOpen();
        if (!ProxyHelper.isProxy(object)) {
            object2 = this.getBroker().getClassDescriptor(object.getClass());
            if (!((ClassDescriptor)object2).isAcceptLocks()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("skipping lock on class: " + ((ClassDescriptor)object2).getClassNameOfObject() + " object " + object.toString());
                }
                return;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("proceeding with lock on class: " + ((ClassDescriptor)object2).getClassNameOfObject() + " object " + object.toString());
            }
            this.assignReferenceFKs(object, this.getBroker().getClassDescriptor(object.getClass()).getObjectReferenceDescriptors());
        }
        object2 = LockManagerFactory.getLockManager();
        if (n == 1) {
            if (!object2.readLock(this, object)) {
                throw new LockNotGrantedException("Can not lock " + object + " for READ");
            }
        } else if (n == 4) {
            if (!object2.writeLock(this, object)) {
                throw new LockNotGrantedException("Can not lock " + object + " for WRITE");
            }
        } else if (n == 2 && !object2.upgradeLock(this, object)) {
            throw new LockNotGrantedException("Can not lock " + object + " for UPGRADE");
        }
        try {
            this.register(object, n);
        }
        catch (Throwable throwable) {
            this.log.error("Locking obj " + object + " with lock mode " + n + " failed", throwable);
            object2.releaseLock(this, object);
            throw new LockNotGrantedException(throwable.getMessage());
        }
    }

    public void leave() {
        this.checkOpen();
        this.txManager.deregisterTx(this);
    }

    private synchronized void doCommitOnObjects() throws TransactionAbortedException, LockNotGrantedException {
        ObjectEnvelope objectEnvelope;
        if (this.log.isDebugEnabled()) {
            this.log.debug("call beginTransaction() on PB instance");
        }
        if (!this.getBroker().isInTransaction()) {
            this.broker.beginTransaction();
        }
        Enumeration enumeration = this.objectEnvelopeTable.elements();
        while (enumeration.hasMoreElements()) {
            objectEnvelope = (ObjectEnvelope)enumeration.nextElement();
            objectEnvelope.beforeCommit();
        }
        this.objectEnvelopeTable.commit();
        enumeration = this.objectEnvelopeTable.elements();
        while (enumeration.hasMoreElements()) {
            objectEnvelope = (ObjectEnvelope)enumeration.nextElement();
            objectEnvelope.afterCommit();
        }
        this.registeredForLock.clear();
    }

    protected synchronized void doAbort() {
        ObjectEnvelope objectEnvelope;
        Enumeration enumeration = this.objectEnvelopeTable.elements();
        while (enumeration.hasMoreElements()) {
            objectEnvelope = (ObjectEnvelope)enumeration.nextElement();
            objectEnvelope.beforeAbort();
        }
        this.objectEnvelopeTable.rollback();
        enumeration = this.objectEnvelopeTable.elements();
        while (enumeration.hasMoreElements()) {
            objectEnvelope = (ObjectEnvelope)enumeration.nextElement();
            objectEnvelope.afterAbort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void doClose() {
        if (!this.isOpen()) {
            throw new IllegalStateException("persist.missingEnd. Tx Status: " + TxUtil.getStatusString(this.getStatus()));
        }
        try {
            Object object;
            Enumeration enumeration = this.objectEnvelopeTable.elements();
            while (enumeration.hasMoreElements()) {
                object = ((ObjectEnvelope)enumeration.nextElement()).getObject();
                this.removeLock(object, 4);
            }
            object = this.unmaterializedLocks.iterator();
            while (object.hasNext()) {
                this.removeLock(object.next(), 4);
            }
            this.unRegisterFromAllIndirectionHandlers();
            Object var4_3 = null;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Close Transaction and release current PB " + this.broker + " on tx " + this);
            }
            this.txManager.deregisterTx(this);
            this.refresh();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Close Transaction and release current PB " + this.broker + " on tx " + this);
            }
            this.txManager.deregisterTx(this);
            this.refresh();
            throw throwable;
        }
    }

    protected void refresh() {
        block3: {
            try {
                this.objectEnvelopeTable.refresh();
            }
            catch (Exception exception) {
                if (!this.log.isDebugEnabled()) break block3;
                this.log.debug("error closing object envelope table : " + exception.getMessage());
                exception.printStackTrace();
            }
        }
        if (this.broker != null && !this.broker.isClosed()) {
            this.broker.close();
        }
        this.myNrm.clear();
        this.broker = null;
        this.registeredForLock.clear();
        this.unmaterializedLocks.clear();
        this.m_txStatus = 6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkpoint() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Checkpoint was called, commit changes hold locks on tx " + this);
        }
        try {
            this.checkOpen();
            this.doCommitOnObjects();
            if (this.broker != null && this.broker.isInTransaction()) {
                this.broker.commitTransaction();
            }
        }
        catch (Throwable throwable) {
            this.log.error("checkpoint failed", throwable);
            try {
                this.doAbort();
            }
            finally {
                this.doClose();
                this.m_txStatus = 4;
            }
            if (throwable instanceof TransactionAbortedException) {
                throw (TransactionAbortedException)throwable;
            }
            if (throwable instanceof LockNotGrantedException) {
                throw (LockNotGrantedException)throwable;
            }
            throw new TransactionAbortedExceptionOJB(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Flush was called - write to database, do not commit, hold locks on tx " + this);
        }
        try {
            this.checkOpen();
            this.doCommitOnObjects();
        }
        catch (Throwable throwable) {
            this.log.error("flush failed", throwable);
            try {
                this.doAbort();
            }
            finally {
                this.doClose();
                this.m_txStatus = 4;
            }
            if (throwable instanceof TransactionAbortedException) {
                throw (TransactionAbortedException)throwable;
            }
            if (throwable instanceof LockNotGrantedException) {
                throw (LockNotGrantedException)throwable;
            }
            throw new TransactionAbortedExceptionOJB(throwable);
        }
    }

    public void markDelete(Object object) {
        ObjectEnvelope objectEnvelope = this.objectEnvelopeTable.get(object);
        objectEnvelope.setModificationState(objectEnvelope.getModificationState().markDelete());
    }

    public void markDirty(Object object) {
        ObjectEnvelope objectEnvelope = this.objectEnvelopeTable.get(object);
        objectEnvelope.setModificationState(objectEnvelope.getModificationState().markDirty());
    }

    public boolean tryLock(Object object, int n) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Try to lock object was called on tx " + this);
        }
        this.checkOpen();
        try {
            this.lock(object, n);
            return true;
        }
        catch (LockNotGrantedException lockNotGrantedException) {
            return false;
        }
    }

    private void removeLock(Object object, int n) {
        LockManagerFactory.getLockManager().releaseLock(this, object);
    }

    public void commit() {
        this.checkOpen();
        try {
            this.prepare();
            if (this.m_txStatus == 1) {
                throw new TransactionAbortedExceptionOJB("persist.markedRollback");
            }
            if (this.m_txStatus != 2) {
                throw new IllegalStateException("persist.missingPrepare");
            }
            this.m_txStatus = 8;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Commit transaction " + this + ", commit on broker " + this.broker);
            }
            this.getBroker().commitTransaction();
            this.doClose();
            this.m_txStatus = 3;
        }
        catch (ODMGRuntimeException oDMGRuntimeException) {
            this.m_txStatus = 1;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Commit fails, do abort this tx", oDMGRuntimeException);
            }
            this.abort();
            throw oDMGRuntimeException;
        }
    }

    protected boolean prepare() throws TransactionAbortedException, LockNotGrantedException {
        if (this.m_txStatus == 1) {
            throw new TransactionAbortedExceptionOJB("persist.markedRollback");
        }
        if (this.m_txStatus != 0) {
            throw new IllegalStateException("persist.noTransaction");
        }
        try {
            this.m_txStatus = 7;
            this.doCommitOnObjects();
            this.m_txStatus = 2;
        }
        catch (LockNotGrantedException lockNotGrantedException) {
            this.log.error("Could not prepare for commit: " + lockNotGrantedException.getMessage());
            this.m_txStatus = 1;
            throw lockNotGrantedException;
        }
        catch (TransactionAbortedException transactionAbortedException) {
            this.log.error("Could not prepare for commit: " + transactionAbortedException.getMessage());
            this.m_txStatus = 1;
            throw transactionAbortedException;
        }
        catch (PersistenceBrokerSQLException persistenceBrokerSQLException) {
            this.log.error("Could not prepare for commit: " + persistenceBrokerSQLException.getMessage());
            this.m_txStatus = 1;
            throw persistenceBrokerSQLException;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        if (this.m_txStatus == 4) {
            return;
        }
        if (this.m_txStatus != 0 && this.m_txStatus != 2 && this.m_txStatus != 1) {
            throw new IllegalStateException("persist.noTransaction");
        }
        this.log.info("Abort transaction was called on tx " + this + ", associated PB was " + this.broker);
        try {
            this.doAbort();
            PersistenceBroker persistenceBroker = this.getBroker();
            if (persistenceBroker.isInTransaction()) {
                persistenceBroker.abortTransaction();
            }
        }
        finally {
            this.doClose();
            this.m_txStatus = 4;
        }
    }

    public synchronized void begin() {
        if (this.curDB == null || !this.curDB.isOpen()) {
            throw new DatabaseClosedException("Database is not open. Must have an open DB to begin the Tx.");
        }
        if (this.isOpen()) {
            this.log.error("Transaction is already open");
            throw new TransactionInProgressException("Impossible to call begin on already opened tx");
        }
        this.objectEnvelopeTable = new ObjectEnvelopeTable(this);
        this.myNrm = new Hashtable();
        this.txManager.registerTx(this);
        this.m_txStatus = 0;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Begin transaction was called on tx " + this + ", with associated PB " + this.broker);
        }
    }

    public String getGUID() {
        return this.txGUID;
    }

    public Object getObjectByIdentity(Identity identity) throws PersistenceBrokerException {
        this.checkOpen();
        ObjectEnvelope objectEnvelope = this.objectEnvelopeTable.getByIdentity(identity);
        if (objectEnvelope != null) {
            return objectEnvelope.needsDelete() ? null : objectEnvelope.getObject();
        }
        return this.getBroker().getObjectByIdentity(identity);
    }

    public boolean isDeleted(Identity identity) {
        ObjectEnvelope objectEnvelope = this.objectEnvelopeTable.getByIdentity(identity);
        return objectEnvelope == null ? false : objectEnvelope.needsDelete();
    }

    private synchronized void register(Object object, int n) throws LockNotGrantedException, PersistenceBrokerException {
        Object object2 = object;
        IndirectionHandler indirectionHandler = null;
        if (object instanceof VirtualProxy) {
            indirectionHandler = VirtualProxy.getIndirectionHandler((VirtualProxy)object);
        } else if (object instanceof Proxy) {
            indirectionHandler = (IndirectionHandler)Proxy.getInvocationHandler(object);
        }
        if (indirectionHandler != null) {
            if (indirectionHandler.alreadyMaterialized()) {
                object2 = indirectionHandler.getRealSubject();
            } else {
                this.registerToIndirectionHandler(indirectionHandler);
                this.registerUnmaterializedLocks(object);
                return;
            }
        }
        if (object2 == null) {
            return;
        }
        ObjectEnvelope objectEnvelope = this.objectEnvelopeTable.getByIdentity(new Identity(object2, this.getBroker()));
        if (objectEnvelope == null || objectEnvelope.needsDelete()) {
            int n2 = n;
            if (!this.useWriteLocks) {
                n2 = 1;
            }
            ClassDescriptor classDescriptor = null;
            classDescriptor = this.getBroker().getClassDescriptor(object2.getClass());
            if (this.useImplicitLocking) {
                this.lockReferences(classDescriptor, object2, n2);
            }
            this.objectEnvelopeTable.put(object2, new ObjectEnvelope(object2, this));
            if (this.useImplicitLocking) {
                this.lockCollections(classDescriptor, object2, n2);
            }
        }
    }

    private void assertFkAssignment(Object object, Object object2, ObjectReferenceDescriptor objectReferenceDescriptor) {
        try {
            if (!ProxyHelper.isProxy(object) && object2 != null) {
                Object[] objectArray;
                DescriptorBase descriptorBase;
                Serializable serializable;
                Object object3 = object2;
                if (object2 instanceof VirtualProxy) {
                    object3 = ((VirtualProxy)object2).getRealSubject();
                } else if (object2 instanceof Proxy) {
                    serializable = (IndirectionHandler)Proxy.getInvocationHandler(object2);
                    object3 = serializable.getRealSubject();
                }
                serializable = this.getBroker().getClassDescriptor(object.getClass());
                FieldDescriptor[] fieldDescriptorArray = objectReferenceDescriptor.getForeignKeyFieldDescriptors((ClassDescriptor)serializable);
                if (object3 != null) {
                    descriptorBase = this.getBroker().getClassDescriptor(object3.getClass());
                    objectArray = this.getBroker().serviceBrokerHelper().getKeyValues((ClassDescriptor)descriptorBase, object3, false);
                } else {
                    objectArray = new Object[fieldDescriptorArray.length];
                    Arrays.fill(objectArray, null);
                }
                if (fieldDescriptorArray != null) {
                    descriptorBase = null;
                    for (int i = 0; i < fieldDescriptorArray.length; ++i) {
                        descriptorBase = fieldDescriptorArray[i];
                        ((AttributeDescriptorBase)descriptorBase).getPersistentField().set(object, objectArray[i]);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            throw new PersistenceBrokerException(throwable);
        }
    }

    private void assignReferenceFKs(Object object, Vector vector) throws PersistenceBrokerException {
        try {
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                ObjectReferenceDescriptor objectReferenceDescriptor = (ObjectReferenceDescriptor)iterator.next();
                Object object2 = objectReferenceDescriptor.getPersistentField().get(object);
                this.assertFkAssignment(object, object2, objectReferenceDescriptor);
            }
        }
        catch (Throwable throwable) {
            throw new PersistenceBrokerException(throwable);
        }
    }

    private void lockCollections(ClassDescriptor classDescriptor, Object object, int n) throws PersistenceBrokerException {
        Iterator iterator = classDescriptor.getCollectionDescriptors().iterator();
        while (iterator.hasNext()) {
            Object object2;
            ArrayIterator arrayIterator;
            CollectionDescriptor collectionDescriptor = (CollectionDescriptor)iterator.next();
            Object object3 = collectionDescriptor.getPersistentField().get(object);
            if (object3 == null) continue;
            if (object3 instanceof ManageableCollection) {
                arrayIterator = ((ManageableCollection)object3).ojbIterator();
            } else if (object3 instanceof Collection) {
                arrayIterator = ((Collection)object3).iterator();
            } else if (object3.getClass().isArray()) {
                arrayIterator = new ArrayIterator(object3);
            } else {
                throw new OJBRuntimeException(object3.getClass() + " can not be managed by OJB, use Array, Collection or ManageableCollection instead !");
            }
            ClassDescriptor classDescriptor2 = this.getBroker().getClassDescriptor(collectionDescriptor.getItemClass());
            Object[] objectArray = this.getBroker().serviceBrokerHelper().getKeyValues(classDescriptor, object, false);
            FieldDescriptor[] fieldDescriptorArray = collectionDescriptor.getForeignKeyFieldDescriptors(classDescriptor2);
            if (fieldDescriptorArray != null) {
                while (arrayIterator.hasNext()) {
                    Serializable serializable;
                    object2 = arrayIterator.next();
                    if (Proxy.isProxyClass(object2.getClass())) {
                        serializable = (IndirectionHandler)Proxy.getInvocationHandler(object2);
                        if (!((IndirectionHandler)serializable).alreadyMaterialized()) continue;
                        object2 = ((IndirectionHandler)serializable).getRealSubject();
                    }
                    if (object2 instanceof VirtualProxy) {
                        serializable = (VirtualProxy)object2;
                        if (!((VirtualProxy)serializable).alreadyMaterialized()) continue;
                        object2 = ((VirtualProxy)serializable).getRealSubject();
                    }
                    if (classDescriptor2.isInterface()) {
                        serializable = this.getBroker().getClassDescriptor(object2.getClass());
                        fieldDescriptorArray = collectionDescriptor.getForeignKeyFieldDescriptors((ClassDescriptor)serializable);
                    }
                    for (int i = 0; i < fieldDescriptorArray.length; ++i) {
                        FieldDescriptor fieldDescriptor = fieldDescriptorArray[i];
                        fieldDescriptor.getPersistentField().set(object2, objectArray[i]);
                    }
                    this.lock(object2, n);
                }
                continue;
            }
            while (arrayIterator.hasNext()) {
                object2 = arrayIterator.next();
                this.lock(object2, n);
            }
        }
    }

    private void lockReferences(ClassDescriptor classDescriptor, Object object, int n) throws PersistenceBrokerException {
        if (object != null && !ProxyHelper.isProxy(object)) {
            this.registeredForLock.add(object);
        }
        Iterator iterator = classDescriptor.getObjectReferenceDescriptors().iterator();
        while (iterator.hasNext()) {
            ObjectReferenceDescriptor objectReferenceDescriptor = (ObjectReferenceDescriptor)iterator.next();
            Object object2 = objectReferenceDescriptor.getPersistentField().get(object);
            if (object2 == null) continue;
            if (ProxyHelper.isProxy(object2)) {
                this.lock(object2, n);
                continue;
            }
            if (this.registeredForLock.contains(object2)) continue;
            this.lock(object2, n);
        }
    }

    Identity getNrmEntry(String string) {
        return (Identity)this.myNrm.get(string);
    }

    void putNrmEntry(String string, Identity identity) {
        this.myNrm.put(string, identity);
    }

    boolean unbindNrmEntry(String string) {
        Identity identity = (Identity)this.myNrm.get(string);
        if (identity != null) {
            this.objectEnvelopeTable.remove(identity);
        }
        return this.myNrm.remove(string) != null;
    }

    public void beforeMaterialization(IndirectionHandler indirectionHandler, Identity identity) {
    }

    public void afterMaterialization(IndirectionHandler indirectionHandler, Object object) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("deferred registration: " + new Identity(object, this.getBroker()).toString());
        }
        try {
            this.register(object, 1);
        }
        catch (Throwable throwable) {
            this.log.error("Register materialized object with this tx failed", throwable);
            throw new LockNotGrantedException(throwable.getMessage());
        }
        this.unregisterFromIndirectionHandler(indirectionHandler);
    }

    protected synchronized void unRegisterFromAllIndirectionHandlers() {
        for (int i = this.registeredIndirectionHandlers.size() - 1; i >= 0; --i) {
            this.unregisterFromIndirectionHandler((IndirectionHandler)this.registeredIndirectionHandlers.get(i));
        }
    }

    protected synchronized void unregisterFromIndirectionHandler(IndirectionHandler indirectionHandler) {
        indirectionHandler.removeListener(this);
        this.registeredIndirectionHandlers.remove(indirectionHandler);
    }

    protected synchronized void registerToIndirectionHandler(IndirectionHandler indirectionHandler) {
        indirectionHandler.addListener(this);
        this.registeredIndirectionHandlers.add(indirectionHandler);
    }

    protected void registerUnmaterializedLocks(Object object) {
        this.unmaterializedLocks.add(object);
    }

    public PersistenceBroker getBroker() {
        if (this.broker == null) {
            this.checkOpen();
            try {
                this.checkForDB();
                this.broker = PersistenceBrokerFactory.createPersistenceBroker(this.curDB.getPBKey());
            }
            catch (PBFactoryException pBFactoryException) {
                this.log.error("Cannot obtain PersistenceBroker from PersistenceBrokerFactory, found PBKey was " + this.curDB.getPBKey(), (Throwable)((Object)pBFactoryException));
                throw new PersistenceBrokerException((Throwable)((Object)pBFactoryException));
            }
        }
        return this.broker;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        OdmgConfiguration odmgConfiguration = (OdmgConfiguration)((Object)configuration);
        this.useWriteLocks = odmgConfiguration.lockAssociationAsWrites();
        this.useImplicitLocking = odmgConfiguration.useImplicitLocking();
    }

    public synchronized void setImplicitLocking(boolean bl) {
        this.useImplicitLocking = bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

