/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.VirtualProxy;
import org.apache.ojb.broker.accesslayer.IndirectionHandler;
import org.apache.ojb.broker.metadata.AttributeDescriptorBase;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;
import org.apache.ojb.broker.util.ObjectModification;
import org.apache.ojb.broker.util.ProxyHelper;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.LoadedObjectsRegistry;
import org.apache.ojb.odmg.TransactionAware;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.states.ModificationState;
import org.apache.ojb.odmg.states.StateNewDirty;
import org.apache.ojb.odmg.states.StateOldClean;
import org.apache.ojb.odmg.states.StateOldDirty;
import org.odmg.ClassNotPersistenceCapableException;
import org.odmg.ODMGRuntimeException;

public class ObjectEnvelope
implements ObjectModification,
Serializable {
    private transient Object myObj;
    private transient Map beforeImage;
    private transient TransactionImpl tx;
    private ModificationState modificationState = null;

    public void close() {
        this.myObj = null;
        this.beforeImage = null;
        this.tx = null;
    }

    public ObjectEnvelope(Object object, TransactionImpl transactionImpl) {
        this.tx = transactionImpl;
        this.manage(object);
        this.setInitialModificationState();
    }

    public void manage(Object object) {
        this.myObj = ProxyHelper.getRealObject(object);
        try {
            this.beforeImage = this.getMap();
        }
        catch (Exception exception) {
            this.beforeImage = null;
            throw new ClassNotPersistenceCapableException(exception.toString());
        }
    }

    public Object getObject() {
        return this.myObj;
    }

    public void beforeCommit() {
        if (this.myObj instanceof TransactionAware) {
            TransactionAware transactionAware = (TransactionAware)this.myObj;
            transactionAware.beforeCommit();
        }
    }

    public void afterCommit() {
        if (this.myObj instanceof TransactionAware) {
            TransactionAware transactionAware = (TransactionAware)this.myObj;
            transactionAware.afterCommit();
        }
    }

    public void beforeAbort() {
        if (this.myObj instanceof TransactionAware) {
            TransactionAware transactionAware = (TransactionAware)this.myObj;
            transactionAware.beforeAbort();
        }
    }

    public void afterAbort() {
        if (this.myObj instanceof TransactionAware) {
            TransactionAware transactionAware = (TransactionAware)this.myObj;
            transactionAware.afterAbort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getMap() throws PersistenceBrokerException {
        Object object;
        Object object2;
        AttributeDescriptorBase attributeDescriptorBase;
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        ClassDescriptor classDescriptor = this.tx.getBroker().getClassDescriptor(this.getObject().getClass());
        FieldDescriptor[] fieldDescriptorArray = classDescriptor.getFieldDescriptions();
        for (int i = 0; i < fieldDescriptorArray.length; ++i) {
            attributeDescriptorBase = fieldDescriptorArray[i];
            object2 = attributeDescriptorBase.getPersistentField();
            hashMap.put(((FieldDescriptor)attributeDescriptorBase).getColumnName(), object2.get(this.myObj));
        }
        Iterator iterator = classDescriptor.getObjectReferenceDescriptors().iterator();
        attributeDescriptorBase = null;
        object2 = null;
        while (iterator.hasNext()) {
            attributeDescriptorBase = (ObjectReferenceDescriptor)iterator.next();
            object = this.myObj;
            synchronized (object) {
                object2 = attributeDescriptorBase.getPersistentField().get(this.myObj);
            }
            if (object2 != null && Proxy.isProxyClass(object2.getClass())) {
                object = (IndirectionHandler)Proxy.getInvocationHandler(object2);
                hashMap.put(attributeDescriptorBase, ((IndirectionHandler)object).getIdentity());
                continue;
            }
            if (object2 != null && object2 instanceof VirtualProxy) {
                object = (VirtualProxy)object2;
                hashMap.put(attributeDescriptorBase, VirtualProxy.getIndirectionHandler((VirtualProxy)object).getIdentity());
                continue;
            }
            hashMap.put(attributeDescriptorBase, object2);
        }
        object = classDescriptor.getCollectionDescriptors().iterator();
        CollectionDescriptor collectionDescriptor = null;
        while (object.hasNext()) {
            Integer n;
            collectionDescriptor = (CollectionDescriptor)object.next();
            Object object3 = collectionDescriptor.getPersistentField().get(this.myObj);
            if (object3 == null) continue;
            if (object3 instanceof Collection) {
                n = new Integer(((Collection)object3).size());
                hashMap.put(collectionDescriptor, n);
                continue;
            }
            n = new Integer(object3.hashCode());
            hashMap.put(collectionDescriptor, n);
        }
        return hashMap;
    }

    private Long timeStamp() throws IllegalAccessException {
        Long l = new Long(0L);
        if (this.myObj != null) {
            try {
                Class<?> clazz = this.getObject().getClass();
                Method method = clazz.getMethod("getTimeStamp", null);
                if (method != null) {
                    l = (Long)method.invoke(this.myObj, null);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                LoggerFactory.getDefaultLogger().debug("No Such Method for object: " + this.myObj.getClass().getName());
            }
            catch (InvocationTargetException invocationTargetException) {
                LoggerFactory.getDefaultLogger().debug("InvocationTargetException: " + this.myObj.getClass().getName());
            }
        }
        return l;
    }

    public ModificationState getModificationState() {
        return this.modificationState;
    }

    public boolean needsInsert() {
        return this.getModificationState().needsInsert();
    }

    public boolean needsUpdate() {
        return this.getModificationState().needsUpdate();
    }

    public boolean needsDelete() {
        return this.getModificationState().needsDelete();
    }

    private void setInitialModificationState() {
        ModificationState modificationState = null;
        if (LoadedObjectsRegistry.isRegistered(this.myObj)) {
            modificationState = StateOldClean.getInstance();
        } else {
            Object object;
            LoadedObjectsRegistry.register(this.myObj);
            Identity identity = new Identity(this.myObj, this.tx.getBroker());
            try {
                object = this.tx.getBroker().getObjectByIdentity(identity);
            }
            catch (PersistenceBrokerException persistenceBrokerException) {
                LoggerFactory.getDefaultLogger().error("ObjectEnvelope: ", (Throwable)((Object)persistenceBrokerException));
                throw new ODMGRuntimeException(persistenceBrokerException.getMessage());
            }
            modificationState = object == null ? StateNewDirty.getInstance() : (this.tx.isDeleted(identity) ? StateOldDirty.getInstance() : StateOldClean.getInstance());
        }
        this.modificationState = modificationState;
    }

    public void setModificationState(ModificationState modificationState) {
        if (modificationState != this.modificationState) {
            if (LoggerFactory.getDefaultLogger().isDebugEnabled()) {
                LoggerFactory.getDefaultLogger().debug("transition: " + new Identity(this.myObj, this.tx.getBroker()) + " (" + this.modificationState + " --> " + modificationState + ")");
            }
            this.modificationState = modificationState;
        }
    }

    public String toString() {
        String string = null;
        string = this.myObj == null ? "null" : new Identity(this.myObj, this.tx.getBroker()).toString();
        return string + "(" + this.modificationState + ")";
    }

    public boolean hasChanged() {
        Map map = null;
        try {
            map = this.getMap();
        }
        catch (Exception exception) {
            LoggerFactory.getDefaultLogger().warn("Could not verify object changes, return hasChanged 'true'", exception);
        }
        return !((Object)this.beforeImage).equals(map);
    }

    public void rollback() {
        if (this.myObj != null && this.beforeImage != null) {
            PersistentField persistentField;
            Object object;
            ClassDescriptor classDescriptor = this.tx.getBroker().getClassDescriptor(this.getObject().getClass());
            FieldDescriptor[] fieldDescriptorArray = classDescriptor.getFieldDescriptions();
            for (int i = 0; i < fieldDescriptorArray.length; ++i) {
                object = fieldDescriptorArray[i];
                persistentField = ((AttributeDescriptorBase)object).getPersistentField();
                Object v = this.beforeImage.get(((FieldDescriptor)object).getColumnName());
                persistentField.set(this.myObj, v);
            }
            Iterator iterator = classDescriptor.getObjectReferenceDescriptors().iterator();
            while (iterator.hasNext()) {
                object = (ObjectReferenceDescriptor)iterator.next();
                persistentField = this.beforeImage.get(object);
                if (persistentField instanceof Identity) continue;
                ((AttributeDescriptorBase)object).getPersistentField().set(this.myObj, persistentField);
            }
            object = classDescriptor.getCollectionDescriptors().iterator();
        }
    }
}

