/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg;

import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.util.configuration.Configuration;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.J2EETransactionImpl;
import org.apache.ojb.odmg.OJBTxManager;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.transaction.TransactionManagerFactoryException;
import org.apache.ojb.odmg.transaction.TransactionManagerFactoryFactory;
import org.odmg.TransactionNotInProgressException;

public class JTATxManager
implements OJBTxManager {
    private static Logger log = LoggerFactory.getLogger(class$org$apache$ojb$odmg$JTATxManager == null ? (class$org$apache$ojb$odmg$JTATxManager = JTATxManager.class$("org.apache.ojb.odmg.JTATxManager")) : class$org$apache$ojb$odmg$JTATxManager);
    private static ThreadLocal txRepository = new ThreadLocal();
    static /* synthetic */ Class class$org$apache$ojb$odmg$JTATxManager;

    public void deregisterTx(Object object) {
        TxBuffer txBuffer = (TxBuffer)txRepository.get();
        if (txBuffer != null) {
            txBuffer.setInternTx(null);
        }
    }

    public void registerTx(TransactionImpl transactionImpl) {
        if (log.isDebugEnabled()) {
            log.debug("registerSynchronization was called");
        }
        Transaction transaction = null;
        try {
            transaction = this.getJTATransaction();
        }
        catch (SystemException systemException) {
            log.error("Obtain current transaction from container failed", systemException);
        }
        if (transaction == null) {
            log.error("Cannot get the external transaction from the external TM");
            throw new TransactionNotInProgressException("No external transaction found");
        }
        if (log.isDebugEnabled()) {
            log.debug("registerSynchronization was called with parameters\n  J2EETransactionImpl: " + transactionImpl + "\n  Transaction: " + transaction);
        }
        this.registerSynchronization(transactionImpl, transaction);
    }

    private void registerSynchronization(TransactionImpl transactionImpl, Transaction transaction) {
        if (transactionImpl == null || transaction == null) {
            log.error("One of the given parameters was null --> cannot do synchronization! omdg transaction was null: " + (transactionImpl == null) + ", external transaction was null: " + (transaction == null));
            return;
        }
        int n = -1;
        try {
            n = transaction.getStatus();
            if (n != 0) {
                throw new OJBRuntimeException("Transaction synchronization failed - wrong status of external container tx: " + JTATxManager.getStatusString(n));
            }
        }
        catch (SystemException systemException) {
            throw new OJBRuntimeException("Can't read status of external tx", systemException);
        }
        try {
            transaction.registerSynchronization((Synchronization)((J2EETransactionImpl)transactionImpl));
            txRepository.set(new TxBuffer(transactionImpl, transaction));
        }
        catch (Exception exception) {
            log.error("Cannot associate PersistenceBroker with running Transaction", exception);
            throw new OJBRuntimeException("Transaction synchronization failed - wrong status of external container tx", exception);
        }
    }

    private static String getStatusString(int n) {
        switch (n) {
            case 0: {
                return "STATUS_ACTIVE";
            }
            case 3: {
                return "STATUS_COMMITTED";
            }
            case 8: {
                return "STATUS_COMMITTING";
            }
            case 1: {
                return "STATUS_MARKED_ROLLBACK";
            }
            case 6: {
                return "STATUS_NO_TRANSACTION";
            }
            case 2: {
                return "STATUS_PREPARED";
            }
            case 7: {
                return "STATUS_PREPARING";
            }
            case 4: {
                return "STATUS_ROLLEDBACK";
            }
            case 9: {
                return "STATUS_ROLLING_BACK";
            }
            case 5: {
                return "STATUS_UNKNOWN";
            }
        }
        return "NO STATUS FOUND";
    }

    private TransactionManager getTransactionManager() {
        TransactionManager transactionManager = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug("getTransactionManager called");
            }
            transactionManager = TransactionManagerFactoryFactory.instance().getTransactionManager();
        }
        catch (TransactionManagerFactoryException transactionManagerFactoryException) {
            log.warn("Exception trying to obtain TransactionManager from Factory", transactionManagerFactoryException);
            transactionManagerFactoryException.printStackTrace();
        }
        return transactionManager;
    }

    public Transaction getJTATransaction() throws SystemException {
        if (log.isDebugEnabled()) {
            log.debug("getTransaction called");
        }
        if (this.getTransactionManager() == null) {
            log.warn("TransactionManager was null");
            return null;
        }
        return this.getTransactionManager().getTransaction();
    }

    public TransactionImpl getCurrentTransaction() {
        TransactionImpl transactionImpl = this.getTransaction();
        if (null == transactionImpl) {
            throw new TransactionNotInProgressException("Calling method needed transaction, but no transaction found via TransactionManager");
        }
        return transactionImpl;
    }

    public TransactionImpl getTransaction() {
        TxBuffer txBuffer = (TxBuffer)txRepository.get();
        return txBuffer != null ? txBuffer.getInternTx() : null;
    }

    public void abortExternalTx(TransactionImpl transactionImpl) {
        if (log.isDebugEnabled()) {
            log.debug("abortExternTransaction was called");
        }
        if (transactionImpl == null) {
            return;
        }
        TxBuffer txBuffer = (TxBuffer)txRepository.get();
        Transaction transaction = txBuffer != null ? txBuffer.externTx : null;
        try {
            if (transaction != null && transaction.getStatus() == 0) {
                log.info("Set extern transaction to rollback");
                transaction.setRollbackOnly();
            }
        }
        catch (Exception exception) {
            log.warn("Cannot work on extern transaction", exception);
        }
    }

    public void configure(Configuration configuration) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    final class TxBuffer {
        Transaction externTx = null;
        TransactionImpl internTx = null;

        public TxBuffer() {
        }

        public TxBuffer(TransactionImpl transactionImpl, Transaction transaction) {
            this.internTx = transactionImpl;
            this.externTx = transaction;
        }

        public Transaction getExternTx() {
            return this.externTx;
        }

        public void setExternTx(Transaction transaction) {
            this.externTx = transaction;
        }

        public TransactionImpl getInternTx() {
            return this.internTx;
        }

        public void setInternTx(TransactionImpl transactionImpl) {
            this.internTx = transactionImpl;
        }
    }
}

