/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg;

import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PBFactoryException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.util.BrokerHelper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.HasBroker;
import org.apache.ojb.odmg.NamedRootsMap;
import org.apache.ojb.odmg.OJB;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.TxManagerFactory;
import org.apache.ojb.odmg.TxUtil;
import org.odmg.ClassNotPersistenceCapableException;
import org.odmg.Database;
import org.odmg.DatabaseClosedException;
import org.odmg.DatabaseNotFoundException;
import org.odmg.DatabaseOpenException;
import org.odmg.ODMGException;
import org.odmg.ObjectNameNotFoundException;
import org.odmg.ObjectNameNotUniqueException;
import org.odmg.TransactionInProgressException;
import org.odmg.TransactionNotInProgressException;

public class DatabaseImpl
implements Database {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$odmg$DatabaseImpl == null ? (class$org$apache$ojb$odmg$DatabaseImpl = DatabaseImpl.class$("org.apache.ojb.odmg.DatabaseImpl")) : class$org$apache$ojb$odmg$DatabaseImpl);
    private PBKey pbKey;
    private boolean isOpen = false;
    private OJB ojb;
    private NamedRootsMap nrm = NamedRootsMap.getInstance();
    static /* synthetic */ Class class$org$apache$ojb$odmg$DatabaseImpl;

    public DatabaseImpl(OJB oJB) {
        this.ojb = oJB;
    }

    private TransactionImpl getTransaction() {
        return TxManagerFactory.instance().getTransaction();
    }

    public PBKey getPBKey() {
        if (this.pbKey == null) {
            this.log.error("## PBKey not set, Database isOpen=" + this.isOpen + " ##");
            if (!this.isOpen) {
                throw new DatabaseClosedException("Database is not open");
            }
        }
        return this.pbKey;
    }

    public OJB getAssociatedImplementation() {
        return this.ojb;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public synchronized void open(String string, int n) throws ODMGException {
        if (this.isOpen()) {
            throw new DatabaseOpenException("Database is already open");
        }
        PersistenceBroker persistenceBroker = null;
        try {
            if (string == null) {
                this.log.info("Given argument was 'null', open default database");
                persistenceBroker = PersistenceBrokerFactory.defaultPersistenceBroker();
            } else {
                persistenceBroker = PersistenceBrokerFactory.createPersistenceBroker(BrokerHelper.extractAllTokens(string));
            }
            this.pbKey = persistenceBroker.getPBKey();
            this.isOpen = true;
            this.ojb.registerOpenDatabase(this);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Open database using PBKey " + this.pbKey);
            }
        }
        catch (PBFactoryException pBFactoryException) {
            this.log.error("Open database failed: " + pBFactoryException.getMessage(), (Throwable)((Object)pBFactoryException));
            throw new DatabaseNotFoundException("OJB can't open database " + string + "\n" + pBFactoryException.getMessage());
        }
        finally {
            if (persistenceBroker != null) {
                persistenceBroker.close();
            }
        }
    }

    public void close() throws ODMGException {
        if (!this.isOpen()) {
            throw new DatabaseClosedException("Database is not Open. Must have an open DB to call close.");
        }
        if (this.getTransaction() != null && this.getTransaction().isOpen() && this.getTransaction().getAssociatedDatabase().equals(this)) {
            this.log.error("Could not close database, found active transaction. tx-status was '" + TxUtil.getStatusString(this.getTransaction().getStatus()) + "'");
            throw new TransactionInProgressException("Database cannot be closed, associated Tx is still open.\nUsed PBKey was " + this.getTransaction().getBroker().getPBKey());
        }
        this.isOpen = false;
        this.pbKey = null;
        if (this == this.ojb.getCurrentDatabase()) {
            this.ojb.setCurrentDatabase(null);
        }
    }

    public void bind(Object object, String string) throws ObjectNameNotUniqueException {
        if (!this.isOpen()) {
            throw new DatabaseClosedException("Database is not open. Must have an open DB to call bind.");
        }
        TransactionImpl transactionImpl = this.getTransaction();
        if (transactionImpl == null || !transactionImpl.isOpen()) {
            throw new TransactionNotInProgressException("Tx is not open. Must have an open TX to call bind.");
        }
        Identity identity = new Identity(object, transactionImpl.getBroker());
        this.makePersistent(object);
        this.nrm.put(string, identity);
        transactionImpl.putNrmEntry(string, identity);
    }

    public Object lookup(String string) throws ObjectNameNotFoundException {
        if (!this.isOpen()) {
            throw new DatabaseClosedException("Database is not open. Must have an open DB to call lookup");
        }
        TransactionImpl transactionImpl = this.getTransaction();
        if (transactionImpl == null || !transactionImpl.isOpen()) {
            throw new TransactionNotInProgressException("Tx is not open. Must have an open TX to call lookup.");
        }
        Identity identity = this.nrm.get(string);
        if (identity == null) {
            identity = transactionImpl.getNrmEntry(string);
        }
        if (identity != null) {
            try {
                Object object = transactionImpl.getObjectByIdentity(identity);
                if (object != null) {
                    transactionImpl.lock(object, 1);
                }
                return object;
            }
            catch (PersistenceBrokerException persistenceBrokerException) {
                throw new ObjectNameNotFoundException("Error in lookup of: " + string + ", " + persistenceBrokerException.getMessage());
            }
        }
        throw new ObjectNameNotFoundException("Name not found: " + string);
    }

    public void unbind(String string) throws ObjectNameNotFoundException {
        if (!this.isOpen()) {
            throw new DatabaseClosedException("Database is not open. Must have an open DB to call unbind");
        }
        TransactionImpl transactionImpl = this.getTransaction();
        if (transactionImpl == null || !transactionImpl.isOpen()) {
            throw new TransactionNotInProgressException("Tx is not open. Must have an open TX to call unbind.");
        }
        boolean bl = false;
        boolean bl2 = false;
        if (!transactionImpl.unbindNrmEntry(string)) {
            bl2 = true;
        }
        try {
            this.nrm.unbind(string);
        }
        catch (ObjectNameNotFoundException objectNameNotFoundException) {
            bl = true;
        }
        if (bl2 && bl) {
            throw new ObjectNameNotFoundException("don't know about " + string);
        }
    }

    public void makePersistent(Object object) {
        if (!this.isOpen()) {
            throw new DatabaseClosedException("Database is not open");
        }
        TransactionImpl transactionImpl = this.getTransaction();
        if (transactionImpl == null || !transactionImpl.isOpen()) {
            throw new TransactionNotInProgressException("No transaction in progress, cannot persist");
        }
        try {
            PersistenceBroker persistenceBroker = ((HasBroker)transactionImpl).getBroker();
            persistenceBroker.getClassDescriptor(object.getClass());
            transactionImpl.lock(object, 4);
        }
        catch (org.apache.ojb.broker.metadata.ClassNotPersistenceCapableException classNotPersistenceCapableException) {
            this.log.error("Persistence object failed: " + object, (Throwable)((Object)classNotPersistenceCapableException));
            throw new ClassNotPersistenceCapableException(classNotPersistenceCapableException.getMessage());
        }
    }

    public void deletePersistent(Object object) {
        if (!this.isOpen()) {
            throw new DatabaseClosedException("Database is not open");
        }
        TransactionImpl transactionImpl = this.getTransaction();
        if (transactionImpl == null || !transactionImpl.isOpen()) {
            throw new TransactionNotInProgressException("No transaction in progress, cannot delete persistent");
        }
        transactionImpl.lock(object, 4);
        transactionImpl.markDelete(object);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

