/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.jdori.sql;

import com.sun.jdori.Connector;
import com.sun.jdori.FieldManager;
import com.sun.jdori.PersistenceManagerInternal;
import com.sun.jdori.StateManagerInternal;
import com.sun.jdori.StoreManager;
import com.sun.jdori.common.model.jdo.RuntimeJDOModelFactoryImpl;
import com.sun.jdori.common.query.BasicQueryResult;
import com.sun.jdori.model.jdo.JDOClass;
import com.sun.jdori.model.jdo.JDOModel;
import com.sun.jdori.model.jdo.JDOModelException;
import com.sun.jdori.query.QueryResult;
import com.sun.jdori.query.QueryResultHelper;
import java.lang.reflect.Field;
import java.util.BitSet;
import java.util.Iterator;
import javax.jdo.Extent;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.JDOUserException;
import javax.jdo.spi.PersistenceCapable;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.util.ObjectModificationDefaultImpl;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.jdori.sql.OjbExtent;
import org.apache.ojb.jdori.sql.OjbFieldManager;
import org.apache.ojb.jdori.sql.OjbStoreConnector;
import org.apache.ojb.jdori.sql.OjbStoreFatalInternalException;
import org.apache.ojb.jdori.sql.OjbStorePMF;

class OjbStoreManager
implements StoreManager {
    private final OjbStorePMF pmf;
    private final OjbStoreConnector connector;
    private boolean optimistic;
    private Logger logger = LoggerFactory.getLogger("JDO");

    OjbStoreManager(OjbStorePMF ojbStorePMF) {
        this.pmf = ojbStorePMF;
        this.connector = new OjbStoreConnector(ojbStorePMF);
    }

    public Connector getConnector() {
        return this.connector;
    }

    public Connector getConnector(String string, String string2) {
        throw new JDOUserException("Not implemented");
    }

    public synchronized int insert(BitSet bitSet, BitSet bitSet2, StateManagerInternal stateManagerInternal) {
        try {
            this.logger.debug("OjbStoreManager.insert");
            PersistenceBroker persistenceBroker = this.connector.getBroker();
            PersistenceCapable persistenceCapable = stateManagerInternal.getObject();
            persistenceBroker.store(persistenceCapable, ObjectModificationDefaultImpl.INSERT);
        }
        catch (Exception exception) {
            throw new OjbStoreFatalInternalException(this.getClass(), "insert", exception);
        }
        bitSet2.xor(bitSet2);
        return 1;
    }

    public synchronized int update(BitSet bitSet, BitSet bitSet2, StateManagerInternal stateManagerInternal) {
        try {
            this.logger.debug("OjbStoreManager.update");
            PersistenceBroker persistenceBroker = this.connector.getBroker();
            this.fetch(stateManagerInternal, null);
            PersistenceCapable persistenceCapable = stateManagerInternal.getObject();
            persistenceBroker.store(persistenceCapable, ObjectModificationDefaultImpl.UPDATE);
        }
        catch (Exception exception) {
            throw new OjbStoreFatalInternalException(this.getClass(), "update", exception);
        }
        bitSet2.xor(bitSet2);
        return 1;
    }

    public synchronized int verifyFields(BitSet bitSet, BitSet bitSet2, StateManagerInternal stateManagerInternal) {
        bitSet2.xor(bitSet2);
        return 1;
    }

    public synchronized int delete(BitSet bitSet, BitSet bitSet2, StateManagerInternal stateManagerInternal) {
        Identity identity = (Identity)stateManagerInternal.getInternalObjectId();
        this.logger.debug("OjbStoreManager.delete(" + identity + ")");
        try {
            this.fetch(stateManagerInternal, null);
            this.connector.getBroker().delete(stateManagerInternal.getObject());
        }
        catch (Exception exception) {
            throw new OjbStoreFatalInternalException(this.getClass(), "delete", exception);
        }
        bitSet2.xor(bitSet2);
        return 1;
    }

    public synchronized void fetch(StateManagerInternal stateManagerInternal, int[] nArray) {
        PersistenceBroker persistenceBroker = this.connector.getBroker();
        try {
            PersistenceCapable persistenceCapable = stateManagerInternal.getObject();
            Identity identity = (Identity)stateManagerInternal.getInternalObjectId();
            if (identity == null) {
                identity = new Identity(persistenceCapable, persistenceBroker);
            }
            persistenceBroker.removeFromCache(persistenceCapable);
            PersistenceCapable persistenceCapable2 = (PersistenceCapable)persistenceBroker.getObjectByIdentity(identity);
            JDOClass jDOClass = this.getJDOClass(persistenceCapable2.getClass());
            if (nArray == null) {
                nArray = jDOClass.getManagedFieldNumbers();
            }
            OjbFieldManager ojbFieldManager = new OjbFieldManager(persistenceCapable2, persistenceBroker);
            stateManagerInternal.replaceFields(nArray, (FieldManager)ojbFieldManager);
            this.getConnector().flush();
        }
        catch (Exception exception) {
            throw new OjbStoreFatalInternalException(this.getClass(), "fetch", exception);
        }
    }

    JDOClass getJDOClass(Class clazz) {
        JDOClass jDOClass = null;
        try {
            ClassLoader classLoader = clazz.getClassLoader();
            JDOModel jDOModel = RuntimeJDOModelFactoryImpl.getInstance().getJDOModel((Object)classLoader);
            jDOClass = jDOModel.getJDOClass(clazz.getName());
        }
        catch (JDOModelException jDOModelException) {
            throw new JDOFatalInternalException("Not a JDO class: " + clazz.getName());
        }
        return jDOClass;
    }

    public synchronized Extent getExtent(Class clazz, boolean bl, PersistenceManagerInternal persistenceManagerInternal) {
        PersistenceBroker persistenceBroker = this.connector.getBroker();
        return new OjbExtent(clazz, persistenceBroker);
    }

    public synchronized Object createObjectId(StateManagerInternal stateManagerInternal, PersistenceManagerInternal persistenceManagerInternal) {
        PersistenceCapable persistenceCapable = stateManagerInternal.getObject();
        Identity identity = new Identity(persistenceCapable, this.connector.getBroker());
        return identity;
    }

    public synchronized Object createInternalObjectId(StateManagerInternal stateManagerInternal, PersistenceCapable persistenceCapable, Object object, Class clazz, PersistenceManagerInternal persistenceManagerInternal) {
        return new Identity(persistenceCapable, this.connector.getBroker());
    }

    public synchronized Object getExternalObjectId(Object object, PersistenceCapable persistenceCapable) {
        return new Identity(persistenceCapable, this.connector.getBroker());
    }

    public void copyKeyFieldsFromObjectId(StateManagerInternal stateManagerInternal, Class clazz) {
        new Identity(stateManagerInternal.getObject(), this.connector.getBroker());
    }

    public boolean hasActualPCClass(Object object) {
        boolean bl = true;
        return bl;
    }

    public synchronized Object getInternalObjectId(Object object, PersistenceManagerInternal persistenceManagerInternal) {
        return object;
    }

    public synchronized Class getPCClassForOid(Object object, PersistenceManagerInternal persistenceManagerInternal) {
        return ((Identity)object).getObjectsTopLevelClass();
    }

    public Object newObjectIdInstance(Class clazz, String string) {
        return Identity.fromByteArray(string.getBytes());
    }

    public void flush(Iterator iterator, PersistenceManagerInternal persistenceManagerInternal) {
        this.optimistic = persistenceManagerInternal.currentTransaction().getOptimistic();
        boolean bl = false;
        while (iterator.hasNext()) {
            StateManagerInternal stateManagerInternal = (StateManagerInternal)iterator.next();
            this.logger.debug("OjbStoreManager.flush: " + stateManagerInternal.getInternalObjectId() + ", " + this.getLCState(stateManagerInternal));
            stateManagerInternal.preStore();
            stateManagerInternal.replaceSCOFields();
            stateManagerInternal.flush((StoreManager)this);
            if (stateManagerInternal.isFlushed()) continue;
            bl = true;
            break;
        }
        this.logger.debug("OjbStoreManager.flush: end, err=" + bl);
        if (bl) {
            throw new JDOFatalInternalException("Error in flush");
        }
    }

    protected Object getLCState(StateManagerInternal stateManagerInternal) {
        try {
            Field field = stateManagerInternal.getClass().getDeclaredField("myLC");
            field.setAccessible(true);
            return field.get(stateManagerInternal);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return noSuchFieldException;
        }
        catch (IllegalAccessException illegalAccessException) {
            return illegalAccessException;
        }
    }

    public QueryResult newQueryResult(QueryResultHelper queryResultHelper) {
        return new BasicQueryResult(queryResultHelper);
    }
}

