/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.jdo;

import java.util.Collection;
import java.util.Iterator;
import javax.jdo.Extent;
import javax.jdo.InstanceCallbacks;
import javax.jdo.JDOFatalUserException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import javax.jdo.Transaction;
import javax.jdo.spi.StateManager;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.jdo.ExtentImpl;
import org.apache.ojb.jdo.StateManagerImpl;
import org.apache.ojb.jdo.TransactionImpl;
import org.apache.ojb.otm.OTMConnection;
import org.apache.ojb.otm.copy.ObjectCopyStrategy;
import org.apache.ojb.otm.kit.SimpleKit;
import org.apache.ojb.otm.lock.LockingException;
import org.apache.ojb.otm.states.State;

public class PersistenceManagerImpl
implements PersistenceManager {
    private OTMConnection m_conn;
    private SimpleKit m_kit;
    private boolean m_multiThreaded = false;
    private boolean m_ignoreCache = false;
    private PersistenceManagerFactory m_factory;
    private String m_userID;
    private String m_password;
    private String m_alias;
    private Object m_usersObject;
    private Transaction m_tx;
    private StateManager m_stateManager;

    public PersistenceManagerImpl(PersistenceManagerFactory persistenceManagerFactory, String string, String string2, String string3) {
        this.m_factory = persistenceManagerFactory;
        this.m_userID = string2;
        this.m_password = string3;
        this.m_alias = string;
        this.m_kit = SimpleKit.getInstance();
        if (null == this.m_alias) {
            this.m_conn = this.m_kit.acquireConnection(PersistenceBrokerFactory.getDefaultKey());
        } else {
            PBKey pBKey = new PBKey(this.m_alias, this.m_userID, this.m_password);
            this.m_conn = this.m_kit.acquireConnection(pBKey);
        }
        this.m_stateManager = new StateManagerImpl(this);
    }

    public boolean isClosed() {
        return this.m_conn.isClosed();
    }

    public void close() {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("close()"));
        }
        this.m_conn.close();
    }

    public Transaction currentTransaction() {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("currentTransaction()"));
        }
        if (this.m_tx == null) {
            this.m_tx = new TransactionImpl(this, this.m_kit.getTransaction(this.m_conn));
        }
        return this.m_tx;
    }

    public void evict(Object object) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("evict(Object)"));
        }
        if (null != object) {
            try {
                Identity identity = this.m_conn.getIdentity(object);
                State state = this.m_conn.getEditingContext().lookupState(identity);
                if (State.PERSISTENT_CLEAN == state) {
                    if (object instanceof InstanceCallbacks) {
                        ((InstanceCallbacks)object).jdoPreClear();
                    }
                    this.m_conn.invalidate(this.m_conn.getIdentity(object));
                }
                if (null == state) {
                    this.m_conn.serviceObjectCache().remove(this.m_conn.getIdentity(object));
                }
            }
            catch (LockingException lockingException) {
                // empty catch block
            }
        }
    }

    public void evictAll(Object[] objectArray) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("evictAll(Object[])"));
        }
        if (null == objectArray) {
            throw new NullPointerException("evictAll(Object[]) was passed a null Array.");
        }
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            this.evict(objectArray[i]);
        }
    }

    public void evictAll(Collection collection) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("evictAll(Collection)"));
        }
        if (null == collection) {
            throw new NullPointerException("evictAll(Collection) was passed a null Collection.");
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.evict(iterator.next());
        }
    }

    public void evictAll() {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("evictAll()"));
        }
        Collection collection = this.m_conn.getEditingContext().getAllObjectsInContext();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.evict(iterator.next());
        }
        this.m_conn.serviceObjectCache().clear();
    }

    public void refresh(Object object) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("refresh(Object)"));
        }
        Identity identity = this.m_conn.getIdentity(object);
        try {
            Object object2 = this.m_conn.getObjectByIdentity(identity);
            ObjectCopyStrategy objectCopyStrategy = this.m_kit.getCopyStrategy(identity);
            objectCopyStrategy.copy(object2, object);
            if (object instanceof InstanceCallbacks) {
                ((InstanceCallbacks)object).jdoPostLoad();
            }
            this.m_conn.getEditingContext().setState(identity, State.PERSISTENT_CLEAN);
        }
        catch (LockingException lockingException) {
            // empty catch block
        }
    }

    public void refreshAll(Object[] objectArray) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("refreshAll(Object[])"));
        }
        if (null == objectArray) {
            throw new NullPointerException("refreshAll(Object[]) was passed a null Array.");
        }
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            this.refresh(objectArray[i]);
        }
    }

    public void refreshAll(Collection collection) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("refreshAll(Collection)"));
        }
        if (null == collection) {
            throw new NullPointerException("refreshAll(Collection) was passed a null Collection.");
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.refresh(iterator.next());
        }
    }

    public void refreshAll() {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("refreshAll()"));
        }
        if (this.currentTransaction().isActive()) {
            Collection collection = this.m_conn.getEditingContext().getAllObjectsInContext();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.refresh(iterator.next());
            }
        }
    }

    public Query newQuery() {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("newQuery()"));
        }
        return null;
    }

    public Query newQuery(Object object) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("newQuery(Object)"));
        }
        return null;
    }

    public Query newQuery(String string, Object object) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("newQuery(String, Object)"));
        }
        return null;
    }

    public Query newQuery(Class clazz) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("newQuery(Class)"));
        }
        return null;
    }

    public Query newQuery(Extent extent) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("newQuery(Extent)"));
        }
        return null;
    }

    public Query newQuery(Class clazz, Collection collection) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("newQuery(Class, Collection)"));
        }
        return null;
    }

    public Query newQuery(Class clazz, String string) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("newQuery(Class, String)"));
        }
        return null;
    }

    public Query newQuery(Class clazz, Collection collection, String string) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("newQuery(Class, Collection, String)"));
        }
        return null;
    }

    public Query newQuery(Extent extent, String string) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("newQuery(Extent, String)"));
        }
        return null;
    }

    public Extent getExtent(Class clazz, boolean bl) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("getExtent(Class, boolean)"));
        }
        return new ExtentImpl(clazz, this.m_conn, this);
    }

    public Object getObjectById(Object object, boolean bl) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("getObjectById(Object, boolean)"));
        }
        Object object2 = null;
        try {
            object2 = this.m_conn.getObjectByIdentity((Identity)object);
        }
        catch (LockingException lockingException) {
            lockingException.printStackTrace();
        }
        return object2;
    }

    public Object getObjectId(Object object) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("getObjectId(Object)"));
        }
        return this.m_conn.getIdentity(object);
    }

    public Object getTransactionalObjectId(Object object) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("getTransactionalObjectId(Object)"));
        }
        return this.m_conn.getIdentity(object);
    }

    public Object newObjectIdInstance(Class clazz, String string) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("newObjectIdInstance(Class, String)"));
        }
        return null;
    }

    public void makePersistent(Object object) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("makePersistent(Object)"));
        }
        try {
            this.m_conn.makePersistent(object);
        }
        catch (LockingException lockingException) {
            // empty catch block
        }
    }

    public void makePersistentAll(Object[] objectArray) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("makePersistentAll(Object[])"));
        }
        if (null == objectArray) {
            throw new NullPointerException("makePersistentAll(Object[]) was passed a null Array.");
        }
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            this.makePersistent(objectArray[i]);
        }
    }

    public void makePersistentAll(Collection collection) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("makePersistentAll(Collection)"));
        }
        if (null == collection) {
            throw new NullPointerException("makePersistentAll(Collection) was passed a null Collection.");
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.makePersistent(iterator.next());
        }
    }

    public void deletePersistent(Object object) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("deletePersistent(Object)"));
        }
        try {
            this.m_conn.deletePersistent(object);
        }
        catch (LockingException lockingException) {
            // empty catch block
        }
    }

    public void deletePersistentAll(Object[] objectArray) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("deletePersistentAll(Object[])"));
        }
        if (null == objectArray) {
            throw new NullPointerException("deletePersistentAll(Object[]) was passed a null Array.");
        }
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            this.deletePersistent(objectArray[i]);
        }
    }

    public void deletePersistentAll(Collection collection) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("deletePersistentAll(Collection)"));
        }
        if (null == collection) {
            throw new NullPointerException("deletePersistentAll(Collection) was passed a null Collection.");
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.deletePersistent(iterator.next());
        }
    }

    public void makeTransient(Object object) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("makeTransient(Object)"));
        }
    }

    public void makeTransientAll(Object[] objectArray) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("makeTransientAll(Object[])"));
        }
        if (null == objectArray) {
            throw new NullPointerException("makeTransientAll(Object[]) was passed a null Array.");
        }
    }

    public void makeTransientAll(Collection collection) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("makeTransientAll(Collection)"));
        }
        if (null == collection) {
            throw new NullPointerException("makeTransientAll(Collection) was passed a null Collection.");
        }
    }

    public void makeTransactional(Object object) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("makeTransactional(Object)"));
        }
    }

    public void makeTransactionalAll(Object[] objectArray) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("makeTransactionalAll(Object[])"));
        }
        if (null == objectArray) {
            throw new NullPointerException("makeTransactionalAll(Object[]) was passed a null Array.");
        }
    }

    public void makeTransactionalAll(Collection collection) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("makeTransactionalAll(Collection)"));
        }
        if (null == collection) {
            throw new NullPointerException("makeTransactionalAll(Collection) was passed a null Collection.");
        }
    }

    public void makeNontransactional(Object object) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("makeNontransactional(Object)"));
        }
    }

    public void makeNontransactionalAll(Object[] objectArray) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("makeNontransactionalAll(Object[])"));
        }
        if (null == objectArray) {
            throw new NullPointerException("makeNontransactionalAll(Object[]) was passed a null Array.");
        }
    }

    public void makeNontransactionalAll(Collection collection) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("makeNontransactionalAll(Collection)"));
        }
        if (null == collection) {
            throw new NullPointerException("makeNontransactionalAll(Collection) was passed a null Collection.");
        }
    }

    public void retrieve(Object object) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("retrieve(Object)"));
        }
    }

    public void retrieveAll(Collection collection) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("retrieveAll(Collection)"));
        }
        if (null == collection) {
            throw new NullPointerException("retrieveAll(Collection) was passed a null Collection.");
        }
    }

    public void retrieveAll(Object[] objectArray) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("retrieveAll(Object[])"));
        }
        if (null == objectArray) {
            throw new NullPointerException("retrieveAll(Object[]) was passed a null Array.");
        }
    }

    public void setUserObject(Object object) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("setUserObject(Object)"));
        }
        this.m_usersObject = object;
    }

    public Object getUserObject() {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("getUserObject()"));
        }
        return this.m_usersObject;
    }

    public PersistenceManagerFactory getPersistenceManagerFactory() {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("getPersistenceManagerFactory()"));
        }
        return this.m_factory;
    }

    public Class getObjectIdClass(Class clazz) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("getObjectIdClass(Class)"));
        }
        return null;
    }

    public void setMultithreaded(boolean bl) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("setMultithreaded(boolean)"));
        }
        this.m_multiThreaded = bl;
    }

    public boolean getMultithreaded() {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("getMultithreaded()"));
        }
        return this.m_multiThreaded;
    }

    public void setIgnoreCache(boolean bl) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("setIgnoreCache(boolean)"));
        }
        this.m_ignoreCache = bl;
    }

    public boolean getIgnoreCache() {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("getIgnoreCache()"));
        }
        return this.m_ignoreCache;
    }

    private static final String generateIsClosedErrorMessage(String string) {
        return "PersistenceManager already closed, cannot call '" + string + "'. Obtain a new PersistenceBroker and retry.";
    }

    private static final String generateNullParameterErrorMessage(String string, String string2) {
        return string + " was passed a null " + string2 + ".";
    }
}

