/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.sequence;

import java.util.HashMap;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.util.sequence.SequenceManagerException;
import org.apache.ojb.broker.util.sequence.SequenceManagerNextValImpl;

public class SequenceManagerSeqHiLoImpl
extends SequenceManagerNextValImpl {
    public static final String PROPERTY_GRAB_SIZE = "grabSize";
    private static HashMap hiLoMap = new HashMap();
    protected int grabSize = new Integer(this.getConfigurationProperty("grabSize", "20"));

    public SequenceManagerSeqHiLoImpl(PersistenceBroker persistenceBroker) {
        super(persistenceBroker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getUniqueLong(FieldDescriptor fieldDescriptor) throws SequenceManagerException {
        String string = this.calculateSequenceName(fieldDescriptor);
        HashMap hashMap = hiLoMap;
        synchronized (hashMap) {
            HiLoEntry hiLoEntry = (HiLoEntry)hiLoMap.get(string);
            if (hiLoEntry == null) {
                hiLoEntry = new HiLoEntry(this.grabSize, this.grabSize);
                hiLoMap.put(string, hiLoEntry);
            }
            if (hiLoEntry.needNewSequence()) {
                hiLoEntry.maxVal = (long)this.grabSize * (super.getUniqueLong(fieldDescriptor) + 1L);
                hiLoEntry.counter = 0L;
            }
            return hiLoEntry.nextVal();
        }
    }

    class HiLoEntry {
        long maxVal;
        long counter;

        public HiLoEntry(long l, long l2) {
            this.maxVal = l;
            this.counter = l2;
        }

        boolean needNewSequence() {
            return this.counter == (long)SequenceManagerSeqHiLoImpl.this.grabSize;
        }

        long nextVal() {
            return this.maxVal + this.counter++;
        }
    }
}

