/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.sequence;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.accesslayer.JdbcAccess;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;
import org.apache.ojb.broker.util.ProxyHelper;
import org.apache.ojb.broker.util.SqlTypeHelper;
import org.apache.ojb.broker.util.sequence.AbstractSequenceManager;
import org.apache.ojb.broker.util.sequence.SequenceManagerException;

public class SequenceManagerNativeImpl
extends AbstractSequenceManager {
    private Log log = LogFactory.getLog((Class)(class$org$apache$ojb$broker$util$sequence$SequenceManagerNativeImpl == null ? (class$org$apache$ojb$broker$util$sequence$SequenceManagerNativeImpl = SequenceManagerNativeImpl.class$("org.apache.ojb.broker.util.sequence.SequenceManagerNativeImpl")) : class$org$apache$ojb$broker$util$sequence$SequenceManagerNativeImpl));
    private long tempKey = -1L;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$sequence$SequenceManagerNativeImpl;

    public SequenceManagerNativeImpl(PersistenceBroker persistenceBroker) {
        super(persistenceBroker);
    }

    public void afterStore(JdbcAccess jdbcAccess, ClassDescriptor classDescriptor, Object object) throws SequenceManagerException {
        FieldDescriptor fieldDescriptor = this.extractAutoIncrementField(classDescriptor);
        if (fieldDescriptor != null) {
            this.ifNotReadOnlyFail(fieldDescriptor);
            long l = this.getLastInsert(classDescriptor, fieldDescriptor);
            this.setFieldValue(object, fieldDescriptor, new Long(l));
        }
    }

    private FieldDescriptor extractAutoIncrementField(ClassDescriptor classDescriptor) {
        FieldDescriptor[] fieldDescriptorArray = classDescriptor.getPkFields();
        FieldDescriptor fieldDescriptor = null;
        for (int i = 0; i < fieldDescriptorArray.length && !(fieldDescriptor = fieldDescriptorArray[i]).isAutoIncrement(); ++i) {
        }
        return fieldDescriptor;
    }

    private void ifNotReadOnlyFail(FieldDescriptor fieldDescriptor) throws SequenceManagerException {
        if (!fieldDescriptor.isAccessReadOnly()) {
            throw new SequenceManagerException("Can't find Identity column: Identity columns/fields need to be declared as 'autoincrement' with 'readonly' access in field-descriptor");
        }
    }

    public void setReferenceFKs(Object object, ClassDescriptor classDescriptor) throws SequenceManagerException {
        FieldDescriptor fieldDescriptor = this.extractAutoIncrementField(classDescriptor);
        if (fieldDescriptor != null && fieldDescriptor.isAccessReadOnly()) {
            Vector vector = classDescriptor.getObjectReferenceDescriptors();
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                ObjectReferenceDescriptor objectReferenceDescriptor = (ObjectReferenceDescriptor)iterator.next();
                Object object2 = objectReferenceDescriptor.getPersistentField().get(object);
                if (object2 == null) continue;
                this.assertFkAssignment(object, object2, objectReferenceDescriptor);
            }
        }
    }

    private void assertFkAssignment(Object object, Object object2, ObjectReferenceDescriptor objectReferenceDescriptor) {
        Object[] objectArray;
        Object object3 = ProxyHelper.getRealObject(object);
        Class<?> clazz = object3.getClass();
        ClassDescriptor classDescriptor = this.getBrokerForClass().getDescriptorRepository().getDescriptorFor(clazz);
        FieldDescriptor[] fieldDescriptorArray = objectReferenceDescriptor.getForeignKeyFieldDescriptors(classDescriptor);
        if (fieldDescriptorArray == null) {
            throw new PersistenceBrokerException("No ForeignKeyFields !");
        }
        if (object2 == null) {
            objectArray = new Object[fieldDescriptorArray.length];
        } else {
            Class clazz2 = ProxyHelper.getRealClass(object2);
            ClassDescriptor classDescriptor2 = this.getBrokerForClass().getDescriptorRepository().getDescriptorFor(clazz2);
            objectArray = this.getBrokerForClass().serviceBrokerHelper().getKeyValues(classDescriptor2, object2, false);
        }
        for (int i = 0; i < fieldDescriptorArray.length; ++i) {
            fieldDescriptorArray[i].getPersistentField().set(object3, objectArray[i]);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getLastInsert(ClassDescriptor classDescriptor, FieldDescriptor fieldDescriptor) throws SequenceManagerException {
        FieldDescriptor fieldDescriptor2 = fieldDescriptor;
        long l = 0L;
        Statement statement = null;
        if (fieldDescriptor2 == null) throw new SequenceManagerException("No autoincrement field declared, please check repository for " + classDescriptor);
        try {
            try {
                statement = this.getBrokerForClass().serviceConnectionManager().getConnection().createStatement();
                ResultSet resultSet = statement.executeQuery(this.lastInsertSelect(classDescriptor.getFullTableName()));
                if (!resultSet.next()) {
                    throw new SequenceManagerException("Could not find native identifier");
                }
                l = resultSet.getLong(1);
                resultSet.close();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("After store - newid=" + l));
                }
            }
            catch (Exception exception) {
                throw new SequenceManagerException(exception);
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            try {
                if (statement == null) throw throwable;
                statement.close();
                throw throwable;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (SQLException sQLException) {}
        if (statement == null) return l;
        statement.close();
        return l;
    }

    protected String lastInsertSelect(String string) {
        return this.getBrokerForClass().serviceConnectionManager().getSupportedPlatform().getLastInsertIdentityQuery(string);
    }

    private void setFieldValue(Object object, FieldDescriptor fieldDescriptor, Long l) throws SequenceManagerException {
        Object object2 = SqlTypeHelper.sequenceKeyConversion(fieldDescriptor.getColumnJdbcType(), l);
        object2 = fieldDescriptor.getFieldConversion().sqlToJava(object2);
        PersistentField persistentField = fieldDescriptor.getPersistentField();
        persistentField.set(object, object2);
    }

    protected long getUniqueLong(FieldDescriptor fieldDescriptor) throws SequenceManagerException {
        return --this.tempKey;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

