/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.sequence;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.SystemUtils;
import org.apache.ojb.broker.OptimisticLockException;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.broker.util.sequence.AbstractSequenceManager;
import org.apache.ojb.broker.util.sequence.HighLowSequence;
import org.apache.ojb.broker.util.sequence.SequenceManagerException;
import org.apache.ojb.broker.util.sequence.SequenceManagerHelper;

public class SequenceManagerHighLowImpl
extends AbstractSequenceManager {
    private static Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$util$sequence$SequenceManagerHighLowImpl == null ? (class$org$apache$ojb$broker$util$sequence$SequenceManagerHighLowImpl = SequenceManagerHighLowImpl.class$("org.apache.ojb.broker.util.sequence.SequenceManagerHighLowImpl")) : class$org$apache$ojb$broker$util$sequence$SequenceManagerHighLowImpl);
    private static final String GLOBAL_SEQUENCE_NAME = "global - default sequence name";
    public static final String PROPERTY_GRAB_SIZE = "grabSize";
    public static final String PROPERTY_GLOBAL_SEQUENCE_ID = "globalSequenceId";
    public static final String PROPERTY_GLOBAL_SEQUENCE_START = "globalSequenceStart";
    protected static Map sequencesMap = new HashMap();
    protected boolean useGlobalSequenceIdentities;
    protected int grabSize = new Integer(this.getConfigurationProperty("grabSize", "20"));
    protected long globalSequenceStart;
    protected int attempts;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$sequence$SequenceManagerHighLowImpl;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$sequence$HighLowSequence;

    public SequenceManagerHighLowImpl(PersistenceBroker persistenceBroker) {
        super(persistenceBroker);
        this.useGlobalSequenceIdentities = new Boolean(this.getConfigurationProperty(PROPERTY_GLOBAL_SEQUENCE_ID, "false"));
        this.globalSequenceStart = new Long(this.getConfigurationProperty(PROPERTY_GLOBAL_SEQUENCE_START, "10000"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getUniqueLong(FieldDescriptor fieldDescriptor) throws SequenceManagerException {
        String string = this.useGlobalSequenceIdentities ? GLOBAL_SEQUENCE_NAME : this.calculateSequenceName(fieldDescriptor);
        Map map = sequencesMap;
        synchronized (map) {
            long l;
            HighLowSequence highLowSequence = (HighLowSequence)sequencesMap.get(string);
            if (highLowSequence == null) {
                highLowSequence = this.getSequence(this.getBrokerForClass(), fieldDescriptor, string);
                sequencesMap.put(string, highLowSequence);
            }
            if ((l = highLowSequence.getNextId()) == 0L) {
                highLowSequence = this.getSequence(this.getBrokerForClass(), fieldDescriptor, string);
                sequencesMap.put(string, highLowSequence);
                l = highLowSequence.getNextId();
                if (l == 0L) {
                    sequencesMap.remove(string);
                    throw new SequenceManagerException("Sequence generation failed: " + SystemUtils.LINE_SEPARATOR + "Sequence: " + highLowSequence + ". Unable to build new ID, id was always 0." + SystemUtils.LINE_SEPARATOR + "Thread: " + Thread.currentThread() + SystemUtils.LINE_SEPARATOR + "PB: " + this.getBrokerForClass());
                }
            }
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HighLowSequence getSequence(PersistenceBroker persistenceBroker, FieldDescriptor fieldDescriptor, String string) {
        HighLowSequence highLowSequence;
        block11: {
            highLowSequence = null;
            PersistenceBroker persistenceBroker2 = null;
            try {
                Criteria criteria = new Criteria();
                criteria.addLike("tableName", string);
                if (this.useGlobalSequenceIdentities) {
                    criteria.addLike("fieldName", PROPERTY_GLOBAL_SEQUENCE_ID);
                } else {
                    criteria.addLike("fieldName", fieldDescriptor.getColumnName());
                }
                QueryByCriteria queryByCriteria = new QueryByCriteria(class$org$apache$ojb$broker$util$sequence$HighLowSequence == null ? (class$org$apache$ojb$broker$util$sequence$HighLowSequence = SequenceManagerHighLowImpl.class$("org.apache.ojb.broker.util.sequence.HighLowSequence")) : class$org$apache$ojb$broker$util$sequence$HighLowSequence, criteria);
                persistenceBroker2 = PersistenceBrokerFactory.createPersistenceBroker(persistenceBroker.getPBKey());
                persistenceBroker2.beginTransaction();
                highLowSequence = (HighLowSequence)persistenceBroker2.getObjectByQuery(queryByCriteria);
                if (highLowSequence == null) {
                    if (log.isDebugEnabled()) {
                        log.debug("sequence for field " + fieldDescriptor + " not found in db, store new HighLowSequence");
                    }
                    long l = this.getMaxKeyForSequence(persistenceBroker, fieldDescriptor);
                    highLowSequence = this.newSequenceObject(string, fieldDescriptor);
                    highLowSequence.setMaxKey(l);
                }
                highLowSequence.setGrabSize(this.grabSize);
                highLowSequence.grabNextKeySet();
                try {
                    persistenceBroker2.removeFromCache(highLowSequence);
                    persistenceBroker2.store(highLowSequence);
                }
                catch (OptimisticLockException optimisticLockException) {
                    if (this.attempts < 5) {
                        log.info("OptimisticLockException was thrown, will try again to store sequence. Sequence was " + highLowSequence);
                        ++this.attempts;
                        this.getSequence(persistenceBroker, fieldDescriptor, string);
                    }
                    throw optimisticLockException;
                }
                persistenceBroker2.commitTransaction();
                if (log.isDebugEnabled()) {
                    log.debug("new sequence was " + highLowSequence);
                }
                Object var11_10 = null;
                this.attempts = 0;
                if (persistenceBroker2 == null) break block11;
                persistenceBroker2.close();
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                this.attempts = 0;
                if (persistenceBroker2 != null) {
                    persistenceBroker2.close();
                }
                throw throwable;
            }
            {
            }
        }
        return highLowSequence;
    }

    protected HighLowSequence newSequenceObject(String string, FieldDescriptor fieldDescriptor) {
        HighLowSequence highLowSequence = new HighLowSequence();
        highLowSequence.setTableName(string);
        if (this.useGlobalSequenceIdentities) {
            highLowSequence.setFieldName(PROPERTY_GLOBAL_SEQUENCE_ID);
        } else {
            highLowSequence.setFieldName(fieldDescriptor.getColumnName());
        }
        highLowSequence.setGrabSize(this.grabSize);
        return highLowSequence;
    }

    protected long getMaxKeyForSequence(PersistenceBroker persistenceBroker, FieldDescriptor fieldDescriptor) {
        long l = 0L;
        l = this.useGlobalSequenceIdentities ? this.globalSequenceStart : SequenceManagerHelper.getMaxForExtent(persistenceBroker, fieldDescriptor);
        return l;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

