/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.sequence;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Vector;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.broker.util.sequence.SequenceManagerException;

public class SequenceManagerHelper {
    private static Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$util$sequence$SequenceManagerHelper == null ? (class$org$apache$ojb$broker$util$sequence$SequenceManagerHelper = SequenceManagerHelper.class$("org.apache.ojb.broker.util.sequence.SequenceManagerHelper")) : class$org$apache$ojb$broker$util$sequence$SequenceManagerHelper);
    private static final String SEQ_PREFIX = "SEQ_";
    private static final String SEQ_UNASSIGNED = "UNASSIGNED";
    private static final String SM_SELECT_MAX = "SELECT MAX(";
    private static final String SM_FROM = ") FROM ";
    static /* synthetic */ Class class$org$apache$ojb$broker$util$sequence$SequenceManagerHelper;

    public static String buildSequenceName(PersistenceBroker persistenceBroker, FieldDescriptor fieldDescriptor, boolean bl) throws SequenceManagerException {
        String string = fieldDescriptor.getSequenceName();
        if (string != null && string.trim().length() != 0) {
            return string;
        }
        if (!bl) {
            throw new SequenceManagerException("Could not find sequence-name for field '" + fieldDescriptor + "' of class '" + fieldDescriptor.getClassDescriptor().getClassNameOfObject() + "', property 'autoNaming' in sequence-manager element in repository was '" + bl + "'. Set autoNaming true in sequence-descriptor or define a " + " sequence-name in field-descriptor.");
        }
        ClassDescriptor classDescriptor = fieldDescriptor.getClassDescriptor();
        Class clazz = persistenceBroker.getTopLevelClass(classDescriptor.getClassOfObject());
        ClassDescriptor classDescriptor2 = persistenceBroker.getClassDescriptor(clazz);
        string = classDescriptor2.isExtent() ? SequenceManagerHelper.firstFoundTableName(persistenceBroker, classDescriptor2) : classDescriptor.getFullTableName();
        if (string == null) {
            string = SEQ_UNASSIGNED;
            log.warn("Too complex structure, can not assign automatic sequence name for field '" + fieldDescriptor.getAttributeName() + "' in class '" + fieldDescriptor.getClassDescriptor().getClassNameOfObject() + "'. Use a default sequence name instead: " + SEQ_PREFIX + string);
        }
        string = SEQ_PREFIX + string;
        if (bl) {
            if (log.isDebugEnabled()) {
                log.debug("Set automatic generated sequence-name for field '" + fieldDescriptor.getAttributeName() + "' in class '" + fieldDescriptor.getClassDescriptor().getClassNameOfObject() + "'.");
            }
            fieldDescriptor.setSequenceName(string);
        }
        return string;
    }

    private static String firstFoundTableName(PersistenceBroker persistenceBroker, ClassDescriptor classDescriptor) {
        String string;
        block2: {
            string = null;
            if (!classDescriptor.isInterface() && classDescriptor.getFullTableName() != null) {
                return classDescriptor.getFullTableName();
            }
            if (!classDescriptor.isExtent()) break block2;
            Vector vector = classDescriptor.getExtentClasses();
            Iterator iterator = vector.iterator();
            while (iterator.hasNext() && (string = SequenceManagerHelper.firstFoundTableName(persistenceBroker, persistenceBroker.getClassDescriptor((Class)iterator.next()))) == null) {
            }
        }
        return string;
    }

    public static long getMaxForExtent(PersistenceBroker persistenceBroker, FieldDescriptor fieldDescriptor) throws PersistenceBrokerException {
        if (fieldDescriptor == null) {
            log.error("Given FieldDescriptor was null, could not detect max value across all extents");
            return 0L;
        }
        Class clazz = persistenceBroker.getTopLevelClass(fieldDescriptor.getClassDescriptor().getClassOfObject());
        return SequenceManagerHelper.getMaxId(persistenceBroker, clazz, fieldDescriptor);
    }

    public static long getMaxId(PersistenceBroker persistenceBroker, Class clazz, FieldDescriptor fieldDescriptor) throws PersistenceBrokerException {
        long l = 0L;
        long l2 = 0L;
        ClassDescriptor classDescriptor = persistenceBroker.getClassDescriptor(clazz);
        if (!classDescriptor.isInterface() && !classDescriptor.isAbstract() && (l2 = SequenceManagerHelper.getMaxIdForClass(persistenceBroker, classDescriptor, fieldDescriptor)) > l) {
            l = l2;
            l2 = 0L;
        }
        if (classDescriptor.isExtent()) {
            Vector vector = classDescriptor.getExtentClasses();
            for (int i = 0; i < vector.size(); ++i) {
                Class clazz2 = (Class)vector.get(i);
                if (classDescriptor.getClassOfObject().equals(clazz2)) {
                    throw new PersistenceBrokerException("Circular extent in " + clazz2 + ", please check the repository");
                }
                l2 = SequenceManagerHelper.getMaxId(persistenceBroker, clazz2, fieldDescriptor);
                if (l2 <= l) continue;
                l = l2;
                l2 = 0L;
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static long getMaxIdForClass(PersistenceBroker persistenceBroker, ClassDescriptor classDescriptor, FieldDescriptor fieldDescriptor) throws PersistenceBrokerException {
        long l;
        block18: {
            FieldDescriptor fieldDescriptor2 = null;
            if (!fieldDescriptor.getClassDescriptor().equals(classDescriptor)) {
                if (!fieldDescriptor.getClassDescriptor().getFullTableName().equals(classDescriptor.getFullTableName())) {
                    fieldDescriptor2 = classDescriptor.getFieldDescriptorByName(fieldDescriptor.getAttributeName());
                }
            } else {
                fieldDescriptor2 = fieldDescriptor;
            }
            if (fieldDescriptor2 == null) {
                return 0L;
            }
            String string = fieldDescriptor2.getColumnName();
            l = 0L;
            ResultSet resultSet = null;
            Statement statement = null;
            String string2 = classDescriptor.getFullTableName();
            String string3 = SM_SELECT_MAX + string + SM_FROM + string2;
            statement = persistenceBroker.serviceStatementManager().getGenericStatement(classDescriptor, false);
            resultSet = statement.executeQuery(string3);
            resultSet.next();
            l = resultSet.getLong(1);
            Object var13_10 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                break block18;
            }
            catch (SQLException sQLException) {}
            break block18;
            {
                catch (Exception exception) {
                    log.warn("Cannot lookup max value from table " + string2 + " for column " + string + ", PB was " + persistenceBroker + ", using jdbc-descriptor " + persistenceBroker.serviceConnectionManager().getConnectionDescriptor(), exception);
                    Object var13_11 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        if (statement != null) {
                            statement.close();
                        }
                        break block18;
                    }
                    catch (SQLException sQLException) {}
                }
            }
            catch (Throwable throwable) {
                Object var13_12 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return l;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

