/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.pooling;

import java.io.Serializable;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class PoolInfo
implements Serializable {
    private int maxActive = DEFAULT_MAX_ACTIVE;
    private int maxIdle = DEFAULT_MAX_IDLE;
    private long maxWait = DEFAULT_MAX_WAIT;
    private byte whenExhaustedAction = DEFAULT_WHEN_EXHAUSTED_ACTION;
    private boolean testOnBorrow = DEFAULT_TEST_ON_BORROW;
    private boolean testOnReturn = DEFAULT_TEST_ON_RETURN;
    private boolean testWhileIdle = DEFAULT_TEST_WHILE_IDLE;
    private long timeBetweenEvictionRunsMillis = DEFAULT_TIME_BETWEEN_EVICTION_RUNS_MILLIS;
    private int numTestsPerEvictionRun = DEFAULT_NUM_TESTS_PER_EVICTION_RUN;
    private long minEvictableIdleTimeMillis = DEFAULT_MIN_EVICTABLE_IDLE_TIME_MILLIS;
    public static int DEFAULT_MAX_ACTIVE = 15;
    public static int DEFAULT_MAX_IDLE = -1;
    public static long DEFAULT_MAX_WAIT = 5000L;
    public static byte DEFAULT_WHEN_EXHAUSTED_ACTION = 0;
    public static boolean DEFAULT_TEST_ON_BORROW = true;
    public static boolean DEFAULT_TEST_ON_RETURN = true;
    public static boolean DEFAULT_TEST_WHILE_IDLE = true;
    public static long DEFAULT_TIME_BETWEEN_EVICTION_RUNS_MILLIS = -1L;
    public static int DEFAULT_NUM_TESTS_PER_EVICTION_RUN = 10;
    public static long DEFAULT_MIN_EVICTABLE_IDLE_TIME_MILLIS = 600000L;

    public int getMaxActive() {
        return this.maxActive;
    }

    public void setMaxActive(int n) {
        if (n > 0) {
            this.maxActive = n;
        } else {
            LoggerFactory.getDefaultLogger().error("Size for connection pool must > 0. Value was " + n);
        }
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public void setMaxIdle(int n) {
        this.maxIdle = n;
    }

    public long getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(long l) {
        this.maxWait = l;
    }

    public byte getWhenExhaustedAction() {
        return this.whenExhaustedAction;
    }

    public void setWhenExhaustedAction(byte by) {
        this.whenExhaustedAction = by;
    }

    public boolean isTestOnBorrow() {
        return this.testOnBorrow;
    }

    public void setTestOnBorrow(boolean bl) {
        this.testOnBorrow = bl;
    }

    public boolean isTestOnReturn() {
        return this.testOnReturn;
    }

    public void setTestOnReturn(boolean bl) {
        this.testOnReturn = bl;
    }

    public boolean isTestWhileIdle() {
        return this.testWhileIdle;
    }

    public void setTestWhileIdle(boolean bl) {
        this.testWhileIdle = bl;
    }

    public long getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    public void setMinEvictableIdleTimeMillis(long l) {
        this.minEvictableIdleTimeMillis = l;
    }

    public long getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public void setTimeBetweenEvictionRunsMillis(long l) {
        this.timeBetweenEvictionRunsMillis = l;
    }

    public int getNumTestsPerEvictionRun() {
        return this.numTestsPerEvictionRun;
    }

    public void setNumTestsPerEvictionRun(int n) {
        this.numTestsPerEvictionRun = n;
    }
}

