/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.logging;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class LoggingHelper {
    public static final int SPACING_LENGTH = 30;
    public static final String BLANK = " ";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String CONSOLE_START_INDENT = "# ";
    public static final String CONSOLE_FOLLOW_INDENT = "#   ";
    public static final String CONSOLE_SPACE = "    ";

    public static String getSystemPropertiesAsString() {
        Properties properties = System.getProperties();
        return LoggingHelper.mapToString(properties);
    }

    private static String createSpacing(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 30 - object.toString().length();
        stringBuffer.append(": ");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(BLANK);
        }
        return stringBuffer.toString();
    }

    public static String mapToString(Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Object v = map.get(k);
            stringBuffer.append(LINE_SEPARATOR + k + LoggingHelper.createSpacing(k) + v);
        }
        return stringBuffer.toString();
    }

    public static String collectionToString(Collection collection) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            stringBuffer.append(LINE_SEPARATOR + e.toString());
        }
        return stringBuffer.toString();
    }

    public static String traceObject(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        if (object == null) {
            return null;
        }
        stringBuffer.append(LINE_SEPARATOR + CONSOLE_START_INDENT + "Trace object of class " + object.getClass().getName() + ": " + LINE_SEPARATOR);
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Field[] fieldArray = clazz.getDeclaredFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                Field field = fieldArray[i];
                field.setAccessible(true);
                try {
                    stringBuffer.append(CONSOLE_FOLLOW_INDENT + field.getName() + CONSOLE_SPACE + field.get(object) + LINE_SEPARATOR);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String traceObject(Object[] objectArray) {
        String string = "## object[";
        String string2 = "]";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(LINE_SEPARATOR + "## Start tracing array ##");
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuffer.append(LINE_SEPARATOR + string + (i + 1) + string2);
            stringBuffer.append(LINE_SEPARATOR + LoggingHelper.traceObject(objectArray[i]));
        }
        stringBuffer.append("## Stop tracing array ##");
        return stringBuffer.toString();
    }

    public static String traceObject(Object[][] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return "Matrix was null or empty";
        }
        String string = "## object[";
        String string2 = "][";
        String string3 = "]";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(LINE_SEPARATOR + "## Start tracing matrix ##");
        for (int i = 0; i < objectArray.length; ++i) {
            for (int j = 0; j < objectArray[0].length; ++j) {
                stringBuffer.append(LINE_SEPARATOR + string + (i + 1) + string2 + (j + 1) + string3);
                stringBuffer.append(LINE_SEPARATOR + LoggingHelper.traceObject(objectArray[i][j]));
            }
        }
        stringBuffer.append(LINE_SEPARATOR + "## Stop tracing matrix ##" + LINE_SEPARATOR);
        return stringBuffer.toString();
    }
}

