/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.logging;

import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.helpers.NullEnumeration;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.configuration.impl.OjbConfigurator;
import org.apache.ojb.broker.util.logging.CommonsLoggerImpl;
import org.apache.ojb.broker.util.logging.Log4jLoggerImpl;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggingConfiguration;
import org.apache.ojb.broker.util.logging.PoorMansLoggerImpl;

public class LoggerFactoryImpl {
    public static final LoggerFactoryImpl INSTANCE = new LoggerFactoryImpl();
    Logger defaultLogger = null;
    Logger bootLogger = null;
    Map cache = new HashMap();
    private boolean log4jConfigured = false;
    static /* synthetic */ Class class$java$lang$String;

    private LoggerFactoryImpl() {
    }

    public static LoggerFactoryImpl getInstance() {
        return INSTANCE;
    }

    public Logger getBootLogger() {
        if (this.bootLogger == null) {
            this.bootLogger = new PoorMansLoggerImpl("BOOT");
            String string = System.getProperty("OJB.bootLogLevel", "WARN");
            ((PoorMansLoggerImpl)this.bootLogger).setLevel(string);
        }
        return this.bootLogger;
    }

    public Logger getDefaultLogger() {
        if (this.defaultLogger == null) {
            this.defaultLogger = this.getLogger("DEFAULT");
        }
        return this.defaultLogger;
    }

    public Logger getLogger(Class clazz) {
        return this.getLogger(clazz.getName());
    }

    public Logger getLogger(String string) {
        if (this.cache.containsKey(string)) {
            this.getBootLogger().debug("Returning cached version of Logger[" + string + "]");
            return (Logger)this.cache.get(string);
        }
        this.getBootLogger().debug("Logger[" + string + "] not cached");
        Logger logger = null;
        Class clazz = null;
        try {
            OjbConfigurator ojbConfigurator = OjbConfigurator.getInstance();
            LoggingConfiguration loggingConfiguration = (LoggingConfiguration)ojbConfigurator.getConfigurationFor(null);
            clazz = loggingConfiguration.getLoggerClass();
            this.getBootLogger().debug("Using logger class : " + clazz + " for:" + string);
            logger = (Logger)ClassHelper.newInstance(clazz, class$java$lang$String == null ? (class$java$lang$String = LoggerFactoryImpl.class$("java.lang.String")) : class$java$lang$String, (Object)string);
            if (logger instanceof Log4jLoggerImpl) {
                this.getBootLogger().debug("Initializing Log4j logger instance " + string);
                if (!this.isLog4JConfigured()) {
                    this.initializeLog4JSubSystem(loggingConfiguration.getLoggerConfigFile());
                }
            } else if (logger instanceof PoorMansLoggerImpl) {
                this.getBootLogger().debug("Initializing PoorMans logger instance " + string);
                logger.configure(loggingConfiguration);
            } else if (logger instanceof CommonsLoggerImpl) {
                this.getBootLogger().debug("Initializing Commons logger instance " + string);
                logger.configure(loggingConfiguration);
            } else {
                try {
                    this.getBootLogger().debug("Initializing Custom logger instance " + string);
                    logger.configure(loggingConfiguration);
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException("Don't know how to initialize : " + logger);
                }
            }
            this.cache.put(string, logger);
        }
        catch (Throwable throwable) {
            logger = this.getBootLogger();
            logger.error("[" + this.getClass().getName() + "]   Could not set logger for class " + clazz, throwable);
        }
        return logger;
    }

    synchronized boolean isLog4JConfigured() {
        if (this.log4jConfigured) {
            return true;
        }
        Enumeration enumeration = org.apache.log4j.Logger.getRootLogger().getAllAppenders();
        if (!(enumeration instanceof NullEnumeration)) {
            this.log4jConfigured = true;
            return true;
        }
        Enumeration enumeration2 = LogManager.getCurrentLoggers();
        while (enumeration2.hasMoreElements()) {
            org.apache.log4j.Logger logger = (org.apache.log4j.Logger)enumeration2.nextElement();
            if (logger.getAllAppenders() instanceof NullEnumeration) continue;
            this.log4jConfigured = true;
            return true;
        }
        return false;
    }

    synchronized void initializeLog4JSubSystem(String string) {
        this.getBootLogger().info("Initializing Log4J using file:" + string);
        if (string != null) {
            URL uRL = Thread.currentThread().getContextClassLoader().getResource(string);
            this.getBootLogger().info("Initializing Log4J : resource from config file:" + uRL);
            if (uRL != null) {
                PropertyConfigurator.configure((URL)uRL);
            } else if (string != "") {
                PropertyConfigurator.configure((String)string);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

