/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.logging;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ojb.broker.util.configuration.Configuration;
import org.apache.ojb.broker.util.configuration.ConfigurationException;
import org.apache.ojb.broker.util.logging.Logger;

public class CommonsLoggerImpl
implements Logger {
    private String name;
    private transient Log log;

    public CommonsLoggerImpl(String string) {
        this.name = string;
        this.log = LogFactory.getLog((String)string);
    }

    public void debug(Object object) {
        this.getLog().debug(object);
    }

    public void info(Object object) {
        this.getLog().info(object);
    }

    public void warn(Object object) {
        this.getLog().warn(object);
    }

    public void error(Object object) {
        this.getLog().error(object);
    }

    public void fatal(Object object) {
        this.getLog().fatal(object);
    }

    public void debug(Object object, Throwable throwable) {
        this.getLog().debug(object, throwable);
    }

    public void info(Object object, Throwable throwable) {
        this.getLog().info(object, throwable);
    }

    public void warn(Object object, Throwable throwable) {
        this.getLog().warn(object, throwable);
    }

    public void error(Object object, Throwable throwable) {
        this.getLog().error(object, throwable);
    }

    public void fatal(Object object, Throwable throwable) {
        this.getLog().fatal(object, throwable);
    }

    public boolean isEnabledFor(int n) {
        return false;
    }

    public boolean isDebugEnabled() {
        return this.getLog().isDebugEnabled();
    }

    public String getName() {
        return this.name;
    }

    public void safeDebug(String string, Object object) {
        if (this.getLog().isDebugEnabled()) {
            String string2 = this.safeToString(object);
            this.getLog().debug((Object)(string + " : " + string2));
        }
    }

    public void safeDebug(String string, Object object, Throwable throwable) {
        if (this.getLog().isDebugEnabled()) {
            String string2 = this.safeToString(object);
            this.getLog().debug((Object)(string + " : " + string2), throwable);
        }
    }

    public void safeInfo(String string, Object object) {
        if (this.getLog().isInfoEnabled()) {
            String string2 = this.safeToString(object);
            this.getLog().info((Object)(string + " : " + string2));
        }
    }

    public void safeInfo(String string, Object object, Throwable throwable) {
        if (this.getLog().isInfoEnabled()) {
            String string2 = this.safeToString(object);
            this.getLog().info((Object)(string + " : " + string2), throwable);
        }
    }

    public void safeWarn(String string, Object object) {
        if (this.getLog().isWarnEnabled()) {
            String string2 = this.safeToString(object);
            this.getLog().warn((Object)(string + " : " + string2));
        }
    }

    public void safeWarn(String string, Object object, Throwable throwable) {
        if (this.getLog().isWarnEnabled()) {
            String string2 = this.safeToString(object);
            this.getLog().warn((Object)(string + " : " + string2), throwable);
        }
    }

    public void safeError(String string, Object object) {
        if (this.getLog().isErrorEnabled()) {
            String string2 = this.safeToString(object);
            this.getLog().error((Object)(string + " : " + string2));
        }
    }

    public void safeError(String string, Object object, Throwable throwable) {
        if (this.getLog().isErrorEnabled()) {
            String string2 = this.safeToString(object);
            this.getLog().error((Object)(string + " : " + string2), throwable);
        }
    }

    public void safeFatal(String string, Object object) {
        if (this.getLog().isFatalEnabled()) {
            String string2 = this.safeToString(object);
            this.getLog().fatal((Object)(string + " : " + string2));
        }
    }

    public void safeFatal(String string, Object object, Throwable throwable) {
        if (this.getLog().isFatalEnabled()) {
            String string2 = this.safeToString(object);
            this.getLog().fatal((Object)(string + " : " + string2), throwable);
        }
    }

    private String safeToString(Object object) {
        String string = null;
        if (object != null) {
            try {
                string = object.toString();
            }
            catch (Throwable throwable) {
                string = "BAD toString() impl for " + object.getClass().getName();
            }
        }
        return string;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
    }

    public Log getLog() {
        return this.log;
    }
}

