/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;

public class WrappedConnection
implements Connection {
    private Connection _conn = null;
    private boolean _isClosed = false;

    public WrappedConnection(Connection connection) {
        this._conn = connection;
    }

    public Connection getDelegate() {
        return this._conn;
    }

    public Connection getInnermostDelegate() {
        Connection connection = this._conn;
        while (connection != null && connection instanceof WrappedConnection) {
            if (this != (connection = ((WrappedConnection)connection).getDelegate())) continue;
            return null;
        }
        return connection;
    }

    public void setDelegate(Connection connection) {
        this._conn = connection;
    }

    protected void checkOpen() throws SQLException {
        if (this._isClosed) {
            throw new SQLException("Connection is closed. " + this);
        }
    }

    public void activateConnection() {
        this._isClosed = false;
        if (this._conn instanceof WrappedConnection) {
            ((WrappedConnection)this._conn).activateConnection();
        }
    }

    public void passivateConnection() throws SQLException {
        this._isClosed = true;
        if (this._conn instanceof WrappedConnection) {
            ((WrappedConnection)this._conn).passivateConnection();
        }
    }

    public void close() throws SQLException {
        this.passivateConnection();
        this._conn.close();
    }

    public boolean isClosed() throws SQLException {
        return this._isClosed || this._conn.isClosed();
    }

    public Statement createStatement() throws SQLException {
        this.checkOpen();
        return this._conn.createStatement();
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        this.checkOpen();
        return this._conn.createStatement(n, n2);
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        this.checkOpen();
        return this._conn.prepareStatement(string);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.checkOpen();
        return this._conn.prepareStatement(string, n, n2);
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        this.checkOpen();
        return this._conn.prepareCall(string);
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        this.checkOpen();
        return this._conn.prepareCall(string, n, n2);
    }

    public void clearWarnings() throws SQLException {
        this.checkOpen();
        this._conn.clearWarnings();
    }

    public void commit() throws SQLException {
        this.checkOpen();
        this._conn.commit();
    }

    public boolean getAutoCommit() throws SQLException {
        this.checkOpen();
        return this._conn.getAutoCommit();
    }

    public String getCatalog() throws SQLException {
        this.checkOpen();
        return this._conn.getCatalog();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkOpen();
        return this._conn.getMetaData();
    }

    public int getTransactionIsolation() throws SQLException {
        this.checkOpen();
        return this._conn.getTransactionIsolation();
    }

    public Map getTypeMap() throws SQLException {
        this.checkOpen();
        return this._conn.getTypeMap();
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        return this._conn.getWarnings();
    }

    public boolean isReadOnly() throws SQLException {
        this.checkOpen();
        return this._conn.isReadOnly();
    }

    public String nativeSQL(String string) throws SQLException {
        this.checkOpen();
        return this._conn.nativeSQL(string);
    }

    public void rollback() throws SQLException {
        this.checkOpen();
        this._conn.rollback();
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.checkOpen();
        this._conn.setAutoCommit(bl);
    }

    public void setCatalog(String string) throws SQLException {
        this.checkOpen();
        this._conn.setCatalog(string);
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.checkOpen();
        this._conn.setReadOnly(bl);
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.checkOpen();
        this._conn.setTransactionIsolation(n);
    }

    public void setTypeMap(Map map) throws SQLException {
        this.checkOpen();
        this._conn.setTypeMap(map);
    }

    public int getHoldability() throws SQLException {
        this.checkOpen();
        return this._conn.getHoldability();
    }

    public void setHoldability(int n) throws SQLException {
        this.checkOpen();
        this._conn.setHoldability(n);
    }

    public Savepoint setSavepoint() throws SQLException {
        this.checkOpen();
        return this._conn.setSavepoint();
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        this.checkOpen();
        return this._conn.setSavepoint(string);
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkOpen();
        this._conn.rollback(savepoint);
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkOpen();
        this._conn.releaseSavepoint(savepoint);
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        this.checkOpen();
        return this._conn.createStatement(n, n2, n3);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        this.checkOpen();
        return this._conn.prepareStatement(string, n, n2, n3);
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        this.checkOpen();
        return this._conn.prepareCall(string, n, n2, n3);
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        this.checkOpen();
        return this._conn.prepareStatement(string, n);
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        this.checkOpen();
        return this._conn.prepareStatement(string, nArray);
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        this.checkOpen();
        return this._conn.prepareStatement(string, stringArray);
    }
}

