/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util;

import java.math.BigDecimal;
import java.net.URL;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.util.sequence.SequenceManagerException;

public class SqlTypeHelper {
    private static final int MIN_INT = Integer.MIN_VALUE;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$sql$Ref;
    static /* synthetic */ Class class$java$sql$Struct;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$net$URL;

    public static int getSqlTypeByName(String string) {
        int n;
        String string2 = string.toLowerCase();
        if (string2.equals("bit")) {
            n = -7;
        } else if (string2.equals("tinyint")) {
            n = -6;
        } else if (string2.equals("smallint")) {
            n = 5;
        } else if (string2.equals("integer")) {
            n = 4;
        } else if (string2.equals("bigint")) {
            n = -5;
        } else if (string2.equals("float")) {
            n = 6;
        } else if (string2.equals("real")) {
            n = 7;
        } else if (string2.equals("double")) {
            n = 8;
        } else if (string2.equals("numeric")) {
            n = 2;
        } else if (string2.equals("decimal")) {
            n = 3;
        } else if (string2.equals("char")) {
            n = 1;
        } else if (string2.equals("varchar")) {
            n = 12;
        } else if (string2.equals("longvarchar")) {
            n = -1;
        } else if (string2.equals("date")) {
            n = 91;
        } else if (string2.equals("time")) {
            n = 92;
        } else if (string2.equals("timestamp")) {
            n = 93;
        } else if (string2.equals("binary")) {
            n = -2;
        } else if (string2.equals("varbinary")) {
            n = -3;
        } else if (string2.equals("longvarbinary")) {
            n = -4;
        } else if (string2.equals("clob")) {
            n = 2005;
        } else if (string2.equals("blob")) {
            n = 2004;
        } else if (string2.equals("struct")) {
            n = 2002;
        } else if (string2.equals("ref")) {
            n = 2006;
        } else if (string2.equals("array")) {
            n = 2003;
        } else if (string2.equals("boolean")) {
            n = 16;
        } else if (string2.equals("datalink")) {
            n = 70;
        } else {
            throw new OJBRuntimeException("The type " + string + " can not be handled by OJB. Please specify only types as defined by java.sql.Types.");
        }
        return n;
    }

    public static int getSqlTypeByReflection(String string) {
        int n;
        if (string.equals((class$java$lang$Character == null ? (class$java$lang$Character = SqlTypeHelper.class$("java.lang.Character")) : class$java$lang$Character).getName()) || string.equals("char")) {
            n = 1;
        } else if (string.equals((class$java$lang$Short == null ? (class$java$lang$Short = SqlTypeHelper.class$("java.lang.Short")) : class$java$lang$Short).getName()) || string.equals("short")) {
            n = 5;
        } else if (string.equals((class$java$lang$Integer == null ? (class$java$lang$Integer = SqlTypeHelper.class$("java.lang.Integer")) : class$java$lang$Integer).getName()) || string.equals("int")) {
            n = 4;
        } else if (string.equals((class$java$lang$Long == null ? (class$java$lang$Long = SqlTypeHelper.class$("java.lang.Long")) : class$java$lang$Long).getName()) || string.equals("long")) {
            n = -5;
        } else if (string.equals((class$java$lang$Byte == null ? (class$java$lang$Byte = SqlTypeHelper.class$("java.lang.Byte")) : class$java$lang$Byte).getName()) || string.equals("byte")) {
            n = 1;
        } else if (string.equals((class$java$lang$Float == null ? (class$java$lang$Float = SqlTypeHelper.class$("java.lang.Float")) : class$java$lang$Float).getName()) || string.equals("float")) {
            n = 6;
        } else if (string.equals((class$java$lang$Double == null ? (class$java$lang$Double = SqlTypeHelper.class$("java.lang.Double")) : class$java$lang$Double).getName()) || string.equals("double")) {
            n = 8;
        } else if (string.equals((class$java$lang$String == null ? (class$java$lang$String = SqlTypeHelper.class$("java.lang.String")) : class$java$lang$String).getName())) {
            n = 12;
        } else if (string.equals((class$java$util$Date == null ? (class$java$util$Date = SqlTypeHelper.class$("java.util.Date")) : class$java$util$Date).getName())) {
            n = 91;
        } else if (string.equals((class$java$sql$Time == null ? (class$java$sql$Time = SqlTypeHelper.class$("java.sql.Time")) : class$java$sql$Time).getName())) {
            n = 92;
        } else if (string.equals((class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = SqlTypeHelper.class$("java.sql.Timestamp")) : class$java$sql$Timestamp).getName())) {
            n = 93;
        } else if (string.equals((class$java$sql$Date == null ? (class$java$sql$Date = SqlTypeHelper.class$("java.sql.Date")) : class$java$sql$Date).getName())) {
            n = 91;
        } else if (string.equals((class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = SqlTypeHelper.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).getName())) {
            n = 3;
        } else if (string.equals((class$java$sql$Ref == null ? (class$java$sql$Ref = SqlTypeHelper.class$("java.sql.Ref")) : class$java$sql$Ref).getName())) {
            n = 2006;
        } else if (string.equals((class$java$sql$Struct == null ? (class$java$sql$Struct = SqlTypeHelper.class$("java.sql.Struct")) : class$java$sql$Struct).getName())) {
            n = 2002;
        } else if (string.equals((class$java$lang$Boolean == null ? (class$java$lang$Boolean = SqlTypeHelper.class$("java.lang.Boolean")) : class$java$lang$Boolean).getName()) || string.equals("boolean")) {
            n = 16;
        } else if (string.equals((class$java$net$URL == null ? (class$java$net$URL = SqlTypeHelper.class$("java.net.URL")) : class$java$net$URL).getName())) {
            n = 70;
        } else {
            throw new OJBRuntimeException("The type " + string + " can not be handled by OJB automatically." + "Please specify a type as defined by java.sql.Types in your field-descriptor");
        }
        return n;
    }

    public static Object sequenceKeyConversion(int n, Long l) throws SequenceManagerException {
        Object[] objectArray = null;
        switch (n) {
            case 2003: {
                Object[] objectArray2;
                objectArray = objectArray2 = new Object[]{l.toString()};
                break;
            }
            case -5: {
                objectArray = l;
                break;
            }
            case -2: {
                objectArray = l.toString().getBytes();
                break;
            }
            case 1: {
                objectArray = l.toString();
                break;
            }
            case 91: {
                objectArray = new Date(l);
                break;
            }
            case 3: {
                objectArray = new BigDecimal((double)l.longValue());
                break;
            }
            case 8: {
                objectArray = new Double(l.doubleValue());
                break;
            }
            case 6: {
                objectArray = new Double(l.doubleValue());
                break;
            }
            case 4: {
                objectArray = new Integer(l.intValue());
                break;
            }
            case -4: {
                objectArray = l.toString().getBytes();
                break;
            }
            case -1: {
                objectArray = l.toString();
                break;
            }
            case 2: {
                objectArray = new BigDecimal((double)l.longValue());
                break;
            }
            case 7: {
                objectArray = new Float(l.floatValue());
                break;
            }
            case 5: {
                objectArray = new Short(l.shortValue());
                break;
            }
            case 92: {
                objectArray = new Time(l);
                break;
            }
            case 93: {
                objectArray = new Timestamp(l);
                break;
            }
            case -6: {
                objectArray = new Byte(l.byteValue());
                break;
            }
            case -3: {
                objectArray = l.toString().getBytes();
                break;
            }
            case 12: {
                objectArray = l.toString();
                break;
            }
            default: {
                throw new SequenceManagerException("Not supported sequence key type '" + SqlTypeHelper.getJdbcTypeAsString(n) + "' (int: " + n + ")");
            }
        }
        return objectArray;
    }

    public static Object getObjectFromColumn(ResultSet resultSet, int n, String string) throws SQLException {
        return SqlTypeHelper.getObjectFromColumn(resultSet, n, string, Integer.MIN_VALUE);
    }

    public static Object getObjectFromColumn(ResultSet resultSet, int n, int n2) throws SQLException {
        return SqlTypeHelper.getObjectFromColumn(resultSet, n, null, n2);
    }

    public static Object getObjectFromColumn(CallableStatement callableStatement, int n, int n2) throws SQLException {
        Object object = null;
        switch (n) {
            case -7: {
                boolean bl = n2 == Integer.MIN_VALUE ? callableStatement.getBoolean(n2) : callableStatement.getBoolean(n2);
                object = callableStatement.wasNull() ? null : new Boolean(bl);
                break;
            }
            case -6: {
                byte by = n2 == Integer.MIN_VALUE ? callableStatement.getByte(n2) : callableStatement.getByte(n2);
                object = callableStatement.wasNull() ? null : new Byte(by);
                break;
            }
            case 5: {
                short s = n2 == Integer.MIN_VALUE ? callableStatement.getShort(n2) : callableStatement.getShort(n2);
                object = callableStatement.wasNull() ? null : new Short(s);
                break;
            }
            case 4: {
                int n3 = n2 == Integer.MIN_VALUE ? callableStatement.getInt(n2) : callableStatement.getInt(n2);
                object = callableStatement.wasNull() ? null : new Integer(n3);
                break;
            }
            case -5: {
                long l = n2 == Integer.MIN_VALUE ? callableStatement.getLong(n2) : callableStatement.getLong(n2);
                object = callableStatement.wasNull() ? null : new Long(l);
                break;
            }
            case 6: 
            case 8: {
                double d = n2 == Integer.MIN_VALUE ? callableStatement.getDouble(n2) : callableStatement.getDouble(n2);
                object = callableStatement.wasNull() ? null : new Double(d);
                break;
            }
            case 7: {
                float f = n2 == Integer.MIN_VALUE ? callableStatement.getFloat(n2) : callableStatement.getFloat(n2);
                object = callableStatement.wasNull() ? null : new Float(f);
                break;
            }
            case 2: {
                object = n2 == Integer.MIN_VALUE ? callableStatement.getBigDecimal(n2) : callableStatement.getBigDecimal(n2);
                break;
            }
            case 3: {
                object = n2 == Integer.MIN_VALUE ? callableStatement.getBigDecimal(n2) : callableStatement.getBigDecimal(n2);
                break;
            }
            case 1: {
                object = n2 == Integer.MIN_VALUE ? callableStatement.getString(n2) : callableStatement.getString(n2);
                break;
            }
            case 12: {
                object = n2 == Integer.MIN_VALUE ? callableStatement.getString(n2) : callableStatement.getString(n2);
                break;
            }
            case -1: {
                object = n2 == Integer.MIN_VALUE ? callableStatement.getString(n2) : callableStatement.getString(n2);
                break;
            }
            case 91: {
                object = n2 == Integer.MIN_VALUE ? callableStatement.getDate(n2) : callableStatement.getDate(n2);
                break;
            }
            case 92: {
                object = n2 == Integer.MIN_VALUE ? callableStatement.getTime(n2) : callableStatement.getTime(n2);
                break;
            }
            case 93: {
                object = n2 == Integer.MIN_VALUE ? callableStatement.getTimestamp(n2) : callableStatement.getTimestamp(n2);
                break;
            }
            case -2: {
                object = n2 == Integer.MIN_VALUE ? callableStatement.getBytes(n2) : callableStatement.getBytes(n2);
                break;
            }
            case -3: {
                object = n2 == Integer.MIN_VALUE ? callableStatement.getBytes(n2) : callableStatement.getBytes(n2);
                break;
            }
            case -4: {
                object = n2 == Integer.MIN_VALUE ? callableStatement.getBytes(n2) : callableStatement.getBytes(n2);
                break;
            }
            case 2005: {
                Clob clob = n2 == Integer.MIN_VALUE ? callableStatement.getClob(n2) : callableStatement.getClob(n2);
                object = callableStatement.wasNull() ? null : clob.getSubString(1L, (int)clob.length());
                break;
            }
            case 2004: {
                Blob blob = n2 == Integer.MIN_VALUE ? callableStatement.getBlob(n2) : callableStatement.getBlob(n2);
                object = callableStatement.wasNull() ? null : blob.getBytes(1L, (int)blob.length());
                break;
            }
            case 2002: {
                object = n2 == Integer.MIN_VALUE ? callableStatement.getObject(n2) : callableStatement.getObject(n2);
                break;
            }
            case 2003: {
                object = n2 == Integer.MIN_VALUE ? callableStatement.getArray(n2) : callableStatement.getArray(n2);
                break;
            }
            case 2006: {
                object = n2 == Integer.MIN_VALUE ? callableStatement.getRef(n2) : callableStatement.getRef(n2);
                break;
            }
            case 16: {
                boolean bl = n2 == Integer.MIN_VALUE ? callableStatement.getBoolean(n2) : callableStatement.getBoolean(n2);
                object = callableStatement.wasNull() ? null : new Boolean(bl);
                break;
            }
            case 70: {
                object = n2 == Integer.MIN_VALUE ? callableStatement.getURL(n2) : callableStatement.getURL(n2);
                break;
            }
            default: {
                throw new OJBRuntimeException("The type " + SqlTypeHelper.getJdbcTypeAsString(n) + " (id: " + n + ")" + " for attribute " + n2 + " can not be handled by OJB. Please specify only types as defined by java.sql.Types.");
            }
        }
        return object;
    }

    private static Object getObjectFromColumn(ResultSet resultSet, int n, String string, int n2) throws SQLException {
        Object object = null;
        switch (n) {
            case -7: {
                boolean bl = n2 == Integer.MIN_VALUE ? resultSet.getBoolean(string) : resultSet.getBoolean(n2);
                object = resultSet.wasNull() ? null : new Boolean(bl);
                break;
            }
            case -6: {
                byte by = n2 == Integer.MIN_VALUE ? resultSet.getByte(string) : resultSet.getByte(n2);
                object = resultSet.wasNull() ? null : new Byte(by);
                break;
            }
            case 5: {
                short s = n2 == Integer.MIN_VALUE ? resultSet.getShort(string) : resultSet.getShort(n2);
                object = resultSet.wasNull() ? null : new Short(s);
                break;
            }
            case 4: {
                int n3 = n2 == Integer.MIN_VALUE ? resultSet.getInt(string) : resultSet.getInt(n2);
                object = resultSet.wasNull() ? null : new Integer(n3);
                break;
            }
            case -5: {
                long l = n2 == Integer.MIN_VALUE ? resultSet.getLong(string) : resultSet.getLong(n2);
                object = resultSet.wasNull() ? null : new Long(l);
                break;
            }
            case 6: 
            case 8: {
                double d = n2 == Integer.MIN_VALUE ? resultSet.getDouble(string) : resultSet.getDouble(n2);
                object = resultSet.wasNull() ? null : new Double(d);
                break;
            }
            case 7: {
                float f = n2 == Integer.MIN_VALUE ? resultSet.getFloat(string) : resultSet.getFloat(n2);
                object = resultSet.wasNull() ? null : new Float(f);
                break;
            }
            case 2: {
                object = n2 == Integer.MIN_VALUE ? resultSet.getBigDecimal(string) : resultSet.getBigDecimal(n2);
                break;
            }
            case 3: {
                object = n2 == Integer.MIN_VALUE ? resultSet.getBigDecimal(string) : resultSet.getBigDecimal(n2);
                break;
            }
            case 1: {
                object = n2 == Integer.MIN_VALUE ? resultSet.getString(string) : resultSet.getString(n2);
                break;
            }
            case 12: {
                object = n2 == Integer.MIN_VALUE ? resultSet.getString(string) : resultSet.getString(n2);
                break;
            }
            case -1: {
                object = n2 == Integer.MIN_VALUE ? resultSet.getString(string) : resultSet.getString(n2);
                break;
            }
            case 91: {
                object = n2 == Integer.MIN_VALUE ? resultSet.getDate(string) : resultSet.getDate(n2);
                break;
            }
            case 92: {
                object = n2 == Integer.MIN_VALUE ? resultSet.getTime(string) : resultSet.getTime(n2);
                break;
            }
            case 93: {
                object = n2 == Integer.MIN_VALUE ? resultSet.getTimestamp(string) : resultSet.getTimestamp(n2);
                break;
            }
            case -2: {
                object = n2 == Integer.MIN_VALUE ? resultSet.getBytes(string) : resultSet.getBytes(n2);
                break;
            }
            case -3: {
                object = n2 == Integer.MIN_VALUE ? resultSet.getBytes(string) : resultSet.getBytes(n2);
                break;
            }
            case -4: {
                object = n2 == Integer.MIN_VALUE ? resultSet.getBytes(string) : resultSet.getBytes(n2);
                break;
            }
            case 2005: {
                Clob clob = n2 == Integer.MIN_VALUE ? resultSet.getClob(string) : resultSet.getClob(n2);
                object = resultSet.wasNull() ? null : clob.getSubString(1L, (int)clob.length());
                break;
            }
            case 2004: {
                Blob blob = n2 == Integer.MIN_VALUE ? resultSet.getBlob(string) : resultSet.getBlob(n2);
                object = resultSet.wasNull() ? null : blob.getBytes(1L, (int)blob.length());
                break;
            }
            case 2002: {
                object = n2 == Integer.MIN_VALUE ? resultSet.getObject(string) : resultSet.getObject(n2);
                break;
            }
            case 2003: {
                object = n2 == Integer.MIN_VALUE ? resultSet.getArray(string) : resultSet.getArray(n2);
                break;
            }
            case 2006: {
                object = n2 == Integer.MIN_VALUE ? resultSet.getRef(string) : resultSet.getRef(n2);
                break;
            }
            case 16: {
                boolean bl = n2 == Integer.MIN_VALUE ? resultSet.getBoolean(string) : resultSet.getBoolean(n2);
                object = resultSet.wasNull() ? null : new Boolean(bl);
                break;
            }
            case 70: {
                object = n2 == Integer.MIN_VALUE ? resultSet.getURL(string) : resultSet.getURL(n2);
                break;
            }
            default: {
                throw new OJBRuntimeException("The type " + SqlTypeHelper.getJdbcTypeAsString(n) + " (id: " + n + ")" + " for attribute " + string + " can not be handled by OJB. Please specify only types as defined by java.sql.Types.");
            }
        }
        return object;
    }

    public static int getSqlTypeByValue(Object object) {
        if (object instanceof Integer) {
            return 4;
        }
        if (object instanceof BigDecimal) {
            return 2;
        }
        if (object instanceof String) {
            return 12;
        }
        if (object instanceof Byte) {
            return -6;
        }
        if (object instanceof Short) {
            return 5;
        }
        if (object instanceof Long) {
            return -5;
        }
        if (object instanceof Float) {
            return 7;
        }
        if (object instanceof Double) {
            return 8;
        }
        if (object instanceof byte[]) {
            return -3;
        }
        if (object instanceof Date) {
            return 91;
        }
        if (object instanceof Time) {
            return 92;
        }
        if (object instanceof Timestamp) {
            return 93;
        }
        if (object instanceof Boolean) {
            return -7;
        }
        if (object instanceof Struct) {
            return 2002;
        }
        if (object instanceof URL) {
            return 70;
        }
        return 1111;
    }

    public static Object getJdbcTypeAsString(int n) {
        switch (n) {
            case -7: {
                return "Types.BIT";
            }
            case -6: {
                return "Types.TINYINT";
            }
            case 5: {
                return "Types.SMALLINT";
            }
            case 4: {
                return "Types.INTEGER";
            }
            case -5: {
                return "Types.BIGINT";
            }
            case 8: {
                return "Types.DOUBLE";
            }
            case 6: {
                return "Types.FLOAT";
            }
            case 7: {
                return "Types.REAL";
            }
            case 2: {
                return "Types.NUMERIC";
            }
            case 3: {
                return "Types.DECIMAL";
            }
            case 1: {
                return "Types.CHAR";
            }
            case 12: {
                return "Types.VARCHAR";
            }
            case -1: {
                return "Types.LONGVARCHAR";
            }
            case 91: {
                return "Types.DATE";
            }
            case 92: {
                return "Types.TIME";
            }
            case 93: {
                return "Types.TIMESTAMP";
            }
            case -2: {
                return "Types.BINARY";
            }
            case -3: {
                return "Types.VARBINARY";
            }
            case -4: {
                return "Types.LONGVARBINARY";
            }
            case 2005: {
                return "Types.CLOB";
            }
            case 2004: {
                return "Types.BLOB";
            }
            case 2002: {
                return "Types.STRUCT";
            }
            case 2003: {
                return "Types.ARRAY";
            }
            case 2001: {
                return "Types.DISTINCT";
            }
            case 2006: {
                return "Types.REF";
            }
            case 2000: {
                return "Types.JAVA_OBJECT";
            }
            case 0: {
                return "Types.NULL";
            }
            case 16: {
                return "Types.BOOLEAN";
            }
            case 70: {
                return "Types.DATALINK";
            }
        }
        return "UNKOWN Type id " + n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

