/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.util.SqlTypeHelper;

public class SqlHelper {
    public static String cleanPath(String string) {
        return SqlHelper.splitPath((String)string).column;
    }

    public static PathInfo splitPath(String string) {
        int n;
        String string2 = null;
        String string3 = null;
        String string4 = string;
        if (string == null) {
            return new PathInfo(null, null, null);
        }
        int n2 = string.indexOf("(");
        if (n2 >= 0 && (n = string.lastIndexOf(")")) >= 0) {
            String string5 = string.substring(n2 + 1, n).trim();
            int n3 = string5.lastIndexOf(" ");
            if (n3 >= 0) {
                string2 = string.substring(0, n2 + 1) + string5.substring(0, n3 + 1);
                string4 = string5.substring(n3 + 1).trim();
            } else {
                string2 = string.substring(0, n2 + 1);
                string4 = string5;
            }
            string3 = string.substring(n);
        }
        return new PathInfo(string2, string4, string3);
    }

    public static Object getObjectFromColumn(ResultSet resultSet, FieldDescriptor fieldDescriptor) throws SQLException {
        return SqlTypeHelper.getObjectFromColumn(resultSet, fieldDescriptor.getColumnJdbcType(), fieldDescriptor.getColumnName());
    }

    public static Object getObjectFromColumn(ResultSet resultSet, int n, int n2) throws SQLException {
        return SqlTypeHelper.getObjectFromColumn(resultSet, n, n2);
    }

    public static Object getObjectFromColumn(CallableStatement callableStatement, int n, int n2) throws SQLException {
        return SqlTypeHelper.getObjectFromColumn(callableStatement, n, n2);
    }

    public static int getSqlTypeRwAll(ClassDescriptor classDescriptor, int n) {
        FieldDescriptor fieldDescriptor = classDescriptor.getAllRwFields()[n];
        return fieldDescriptor.getColumnJdbcType();
    }

    public static int getSqlTypeRwNonPk(ClassDescriptor classDescriptor, int n) {
        FieldDescriptor fieldDescriptor = classDescriptor.getNonPkRwFields()[n];
        return fieldDescriptor.getColumnJdbcType();
    }

    public static int getSqlTypePk(ClassDescriptor classDescriptor, int n) {
        FieldDescriptor fieldDescriptor = classDescriptor.getPkFields()[n];
        return fieldDescriptor.getColumnJdbcType();
    }

    public static int getSqlTypeLocking(ClassDescriptor classDescriptor, int n) {
        FieldDescriptor fieldDescriptor = classDescriptor.getLockingFields()[n];
        return fieldDescriptor.getColumnJdbcType();
    }

    public static int getSqlTypeByValue(Object object) {
        return SqlTypeHelper.getSqlTypeByValue(object);
    }

    public static final class PathInfo {
        public String column;
        public String prefix;
        public String suffix;

        PathInfo(String string, String string2, String string3) {
            this.column = string2;
            this.prefix = string;
            this.suffix = string3;
        }
    }
}

