/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Proxy;
import org.apache.ojb.broker.ManageableCollection;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.VirtualProxy;
import org.apache.ojb.broker.accesslayer.IndirectionHandler;
import org.apache.ojb.broker.core.PersistenceBrokerConfiguration;
import org.apache.ojb.broker.core.PersistenceBrokerImpl;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.util.configuration.impl.OjbConfigurator;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class ProxyHelper {
    private static Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$util$ProxyHelper == null ? (class$org$apache$ojb$broker$util$ProxyHelper = ProxyHelper.class$("org.apache.ojb.broker.util.ProxyHelper")) : class$org$apache$ojb$broker$util$ProxyHelper);
    private static final Constructor listProxyConstructor;
    private static final Constructor setProxyConstructor;
    private static final Constructor collectionProxyConstructor;
    private static Constructor collectionProxyConstructorUserDefined;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$ProxyHelper;
    static /* synthetic */ Class class$org$apache$ojb$broker$PBKey;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$org$apache$ojb$broker$query$Query;
    static /* synthetic */ Class class$org$apache$ojb$broker$accesslayer$ListProxy;
    static /* synthetic */ Class class$org$apache$ojb$broker$accesslayer$SetProxy;
    static /* synthetic */ Class class$org$apache$ojb$broker$accesslayer$CollectionProxy;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$Set;

    public static final Object getRealObject(Object object) {
        if (object instanceof Proxy && Proxy.isProxyClass(object.getClass())) {
            try {
                IndirectionHandler indirectionHandler = (IndirectionHandler)Proxy.getInvocationHandler(object);
                return indirectionHandler.getRealSubject();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.error("Could not retrieve real object for given Proxy: " + object);
                throw new PersistenceBrokerException(illegalArgumentException);
            }
            catch (PersistenceBrokerException persistenceBrokerException) {
                log.error("Could not retrieve real object for given Proxy: " + object);
                throw persistenceBrokerException;
            }
        }
        if (object instanceof VirtualProxy) {
            try {
                return ((VirtualProxy)object).getRealSubject();
            }
            catch (PersistenceBrokerException persistenceBrokerException) {
                log.error("Could not retrieve real object for VirtualProxy: " + object);
                throw persistenceBrokerException;
            }
        }
        return object;
    }

    public static final Object getRealObjectIfMaterialized(Object object) {
        if (object instanceof Proxy && Proxy.isProxyClass(object.getClass())) {
            try {
                IndirectionHandler indirectionHandler = (IndirectionHandler)Proxy.getInvocationHandler(object);
                if (indirectionHandler.alreadyMaterialized()) {
                    return indirectionHandler.getRealSubject();
                }
                return null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.error("Could not retrieve real object for given Proxy: " + object);
                throw new PersistenceBrokerException(illegalArgumentException);
            }
            catch (PersistenceBrokerException persistenceBrokerException) {
                log.error("Could not retrieve real object for given Proxy: " + object);
                throw persistenceBrokerException;
            }
        }
        if (object instanceof VirtualProxy) {
            try {
                VirtualProxy virtualProxy = (VirtualProxy)object;
                if (virtualProxy.alreadyMaterialized()) {
                    return virtualProxy.getRealSubject();
                }
                return null;
            }
            catch (PersistenceBrokerException persistenceBrokerException) {
                log.error("Could not retrieve real object for VirtualProxy: " + object);
                throw persistenceBrokerException;
            }
        }
        return object;
    }

    public static final Class getRealClass(Object object) {
        if (object instanceof Proxy && Proxy.isProxyClass(object.getClass())) {
            try {
                IndirectionHandler indirectionHandler = (IndirectionHandler)Proxy.getInvocationHandler(object);
                return indirectionHandler.getIdentity().getObjectsRealClass();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.error("Could not retrieve real Class for Proxy: " + object);
                throw illegalArgumentException;
            }
        }
        if (object instanceof VirtualProxy) {
            IndirectionHandler indirectionHandler = VirtualProxy.getIndirectionHandler((VirtualProxy)object);
            return indirectionHandler.getIdentity().getObjectsRealClass();
        }
        return object.getClass();
    }

    public static final ManageableCollection createCollectionProxy(PersistenceBrokerImpl persistenceBrokerImpl, Query query, Class clazz) {
        Object[] objectArray = new Object[]{persistenceBrokerImpl.getPBKey(), clazz, query};
        Constructor constructor = collectionProxyConstructorUserDefined;
        if (constructor == null) {
            constructor = ProxyHelper.getCollectionProxyConstructor(clazz);
        }
        try {
            return (ManageableCollection)constructor.newInstance(objectArray);
        }
        catch (Throwable throwable) {
            throw new PersistenceBrokerException(throwable);
        }
    }

    private static Constructor getCollectionProxyConstructor(Class clazz) {
        if ((class$java$util$List == null ? (class$java$util$List = ProxyHelper.class$("java.util.List")) : class$java$util$List).isAssignableFrom(clazz)) {
            return listProxyConstructor;
        }
        if ((class$java$util$Set == null ? (class$java$util$Set = ProxyHelper.class$("java.util.Set")) : class$java$util$Set).isAssignableFrom(clazz)) {
            return setProxyConstructor;
        }
        return collectionProxyConstructor;
    }

    public static boolean isProxy(Object object) {
        return object instanceof Proxy && Proxy.isProxyClass(object.getClass()) || object instanceof VirtualProxy;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class[] classArray = new Class[]{class$org$apache$ojb$broker$PBKey == null ? (class$org$apache$ojb$broker$PBKey = ProxyHelper.class$("org.apache.ojb.broker.PBKey")) : class$org$apache$ojb$broker$PBKey, class$java$lang$Class == null ? (class$java$lang$Class = ProxyHelper.class$("java.lang.Class")) : class$java$lang$Class, class$org$apache$ojb$broker$query$Query == null ? (class$org$apache$ojb$broker$query$Query = ProxyHelper.class$("org.apache.ojb.broker.query.Query")) : class$org$apache$ojb$broker$query$Query};
        try {
            listProxyConstructor = (class$org$apache$ojb$broker$accesslayer$ListProxy == null ? (class$org$apache$ojb$broker$accesslayer$ListProxy = ProxyHelper.class$("org.apache.ojb.broker.accesslayer.ListProxy")) : class$org$apache$ojb$broker$accesslayer$ListProxy).getConstructor(classArray);
            setProxyConstructor = (class$org$apache$ojb$broker$accesslayer$SetProxy == null ? (class$org$apache$ojb$broker$accesslayer$SetProxy = ProxyHelper.class$("org.apache.ojb.broker.accesslayer.SetProxy")) : class$org$apache$ojb$broker$accesslayer$SetProxy).getConstructor(classArray);
            collectionProxyConstructor = (class$org$apache$ojb$broker$accesslayer$CollectionProxy == null ? (class$org$apache$ojb$broker$accesslayer$CollectionProxy = ProxyHelper.class$("org.apache.ojb.broker.accesslayer.CollectionProxy")) : class$org$apache$ojb$broker$accesslayer$CollectionProxy).getConstructor(classArray);
        }
        catch (Throwable throwable) {
            throw new PersistenceBrokerException("Error accessing constructor for collection proxy class.", throwable);
        }
        Class clazz = null;
        try {
            PersistenceBrokerConfiguration persistenceBrokerConfiguration = (PersistenceBrokerConfiguration)((Object)OjbConfigurator.getInstance().getConfigurationFor(null));
            clazz = persistenceBrokerConfiguration.getCollectionProxyClass();
            if (clazz != null) {
                collectionProxyConstructorUserDefined = clazz.getConstructor(classArray);
            }
        }
        catch (Exception exception) {
            throw new PersistenceBrokerException("Could not build constructor for collectionProxy class [" + clazz + "] defined in configuration", exception);
        }
    }
}

