/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util;

import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import java.util.StringTokenizer;
import org.apache.commons.lang.SystemUtils;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.VirtualProxy;
import org.apache.ojb.broker.accesslayer.IndirectionHandler;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.metadata.MetadataManager;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;
import org.apache.ojb.broker.util.sequence.SequenceManagerException;

public class BrokerHelper {
    public static final String REPOSITORY_NAME_SEPARATOR = "#";
    private PersistenceBroker broker;

    public BrokerHelper(PersistenceBroker persistenceBroker) {
        this.broker = persistenceBroker;
    }

    public static PBKey extractAllTokens(String string) {
        if (string == null) {
            throw new PersistenceBrokerException("Could not extract PBKey, given argument is 'null'");
        }
        String string2 = null;
        String string3 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, REPOSITORY_NAME_SEPARATOR);
        String string4 = stringTokenizer.nextToken();
        if (stringTokenizer.hasMoreTokens() && (string2 = stringTokenizer.nextToken()) != null && string2.trim().equals("")) {
            string2 = null;
        }
        if (stringTokenizer.hasMoreTokens() && string2 != null) {
            string3 = stringTokenizer.nextToken();
        }
        if (string2 != null && string3 == null) {
            string3 = "";
        }
        PBKey pBKey = new PBKey(string4, string2, string3);
        return pBKey;
    }

    public static PBKey crossCheckPBKey(PBKey pBKey) {
        PBKey pBKey2;
        if (pBKey.getUser() == null && (pBKey2 = MetadataManager.getInstance().connectionRepository().getStandardPBKeyForJcdAlias(pBKey.getAlias())) != null) {
            return pBKey2;
        }
        return pBKey;
    }

    public static boolean isRunningInServerMode() {
        return false;
    }

    protected ClassDescriptor getRealClassDescriptor(ClassDescriptor classDescriptor, Object object) {
        ClassDescriptor classDescriptor2 = classDescriptor.getClassOfObject() == object.getClass() ? classDescriptor : classDescriptor.getRepository().getDescriptorFor(object.getClass());
        return classDescriptor2;
    }

    public Object[] getKeyValues(ClassDescriptor classDescriptor, Object object, boolean bl) throws PersistenceBrokerException {
        if (object instanceof Proxy && Proxy.isProxyClass(object.getClass())) {
            IndirectionHandler indirectionHandler = (IndirectionHandler)Proxy.getInvocationHandler(object);
            return this.getKeyValues(classDescriptor, indirectionHandler.getIdentity(), bl);
        }
        if (object instanceof VirtualProxy) {
            IndirectionHandler indirectionHandler = VirtualProxy.getIndirectionHandler((VirtualProxy)object);
            return this.getKeyValues(classDescriptor, indirectionHandler.getIdentity(), bl);
        }
        ClassDescriptor classDescriptor2 = this.getRealClassDescriptor(classDescriptor, object);
        return this.getValuesForObject(classDescriptor2.getPkFields(), object, bl);
    }

    public Object[] getKeyValues(ClassDescriptor classDescriptor, Identity identity) throws PersistenceBrokerException {
        return this.getKeyValues(classDescriptor, identity, true);
    }

    public Object[] getKeyValues(ClassDescriptor classDescriptor, Identity identity, boolean bl) throws PersistenceBrokerException {
        FieldDescriptor[] fieldDescriptorArray = classDescriptor.getPkFields();
        Object[] objectArray = new Object[fieldDescriptorArray.length];
        Object[] objectArray2 = identity.getPrimaryKeyValues();
        try {
            for (int i = 0; i < objectArray.length; ++i) {
                FieldDescriptor fieldDescriptor = fieldDescriptorArray[i];
                Object object = objectArray2[i];
                if (bl) {
                    object = fieldDescriptor.getFieldConversion().javaToSql(object);
                }
                objectArray[i] = object;
            }
        }
        catch (Exception exception) {
            throw new PersistenceBrokerException("Could not generate primary key values for given Identity " + SystemUtils.LINE_SEPARATOR + identity + ", exception was " + exception, exception);
        }
        return objectArray;
    }

    public Object[] getKeyValues(ClassDescriptor classDescriptor, Object object) throws PersistenceBrokerException {
        return this.getKeyValues(classDescriptor, object, true);
    }

    private boolean isNull(Object object) {
        return object == null || object instanceof Number && ((Number)object).longValue() == 0L || object instanceof String && ((String)object).length() == 0;
    }

    protected Object getAutoIncrementValue(FieldDescriptor fieldDescriptor, Object object, Object object2) {
        if (this.isNull(object2)) {
            PersistentField persistentField = fieldDescriptor.getPersistentField();
            try {
                Object object3 = this.broker.serviceSequenceManager().getUniqueValue(fieldDescriptor);
                persistentField.set(object, object3);
                return object3;
            }
            catch (MetadataException metadataException) {
                throw new PersistenceBrokerException("Error while trying to autoincrement field " + persistentField.getDeclaringClass() + REPOSITORY_NAME_SEPARATOR + persistentField.getName(), (Throwable)((Object)metadataException));
            }
            catch (SequenceManagerException sequenceManagerException) {
                throw new PersistenceBrokerException("Could not get key value", (Throwable)((Object)sequenceManagerException));
            }
        }
        return object2;
    }

    protected Object[] getValuesForObject(FieldDescriptor[] fieldDescriptorArray, Object object, boolean bl) throws PersistenceBrokerException {
        Object[] objectArray = new Object[fieldDescriptorArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            FieldDescriptor fieldDescriptor = fieldDescriptorArray[i];
            PersistentField persistentField = fieldDescriptor.getPersistentField();
            Object object2 = persistentField.get(object);
            if (fieldDescriptor.isAutoIncrement()) {
                object2 = this.getAutoIncrementValue(fieldDescriptor, object, object2);
            }
            if (bl) {
                object2 = fieldDescriptor.getFieldConversion().javaToSql(object2);
            }
            objectArray[i] = object2;
        }
        return objectArray;
    }

    public Object[] getNonKeyRwValues(ClassDescriptor classDescriptor, Object object) throws PersistenceBrokerException {
        ClassDescriptor classDescriptor2 = this.getRealClassDescriptor(classDescriptor, object);
        return this.getValuesForObject(classDescriptor2.getNonPkRwFields(), object, true);
    }

    public Object[] getAllRwValues(ClassDescriptor classDescriptor, Object object) throws PersistenceBrokerException {
        ClassDescriptor classDescriptor2 = this.getRealClassDescriptor(classDescriptor, object);
        return this.getValuesForObject(classDescriptor2.getAllRwFields(), object, true);
    }

    public static String buildMessageString(Object object, Object object2, Field field) {
        String string = SystemUtils.LINE_SEPARATOR;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string + "object class[ " + (object != null ? object.getClass().getName() : null)).append(string + "target field: " + field.getName()).append(string + "target field type: " + (field != null ? field.getType() : null)).append(string + "object value class: " + (object2 != null ? object2.getClass().getName() : null)).append(string + "object value: " + (object2 != null ? object2 : null)).append("]");
        return stringBuffer.toString();
    }
}

