/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.query;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.core.PersistenceBrokerConfiguration;
import org.apache.ojb.broker.metadata.FieldHelper;
import org.apache.ojb.broker.query.ExistsCriteria;
import org.apache.ojb.broker.query.FieldCriteria;
import org.apache.ojb.broker.query.InCriteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.SelectionCriteria;
import org.apache.ojb.broker.query.SqlCriteria;
import org.apache.ojb.broker.query.ValueCriteria;
import org.apache.ojb.broker.util.configuration.ConfigurationException;

public class Criteria
implements Serializable {
    public static final int OR = 0;
    public static final int AND = 1;
    public static final int NONE = 9;
    public static String PARENT_QUERY_PREFIX = "parentQuery.";
    private Vector m_criteria = new Vector();
    private int m_type = 9;
    private boolean m_embraced = false;
    private List orderby = null;
    private List groupby = new ArrayList();
    private List prefetchedRelationships = null;
    private String m_alias = null;
    protected static final int IN_LIMIT = Criteria.getSqlInLimit();
    private QueryByCriteria m_query;
    private Criteria m_parentCriteria;

    public Criteria() {
        this.orderby = new ArrayList();
        this.prefetchedRelationships = new ArrayList();
    }

    public Criteria(SelectionCriteria selectionCriteria) {
        this();
        this.addSelectionCriteria(selectionCriteria);
    }

    public Criteria copy(boolean bl, boolean bl2, boolean bl3) {
        Criteria criteria = new Criteria();
        criteria.m_criteria = this.m_criteria;
        if (bl) {
            criteria.groupby = this.groupby;
        }
        if (bl2) {
            criteria.orderby = this.orderby;
        }
        if (bl3) {
            criteria.prefetchedRelationships = this.prefetchedRelationships;
        }
        return criteria;
    }

    protected void addSelectionCriteria(SelectionCriteria selectionCriteria) {
        selectionCriteria.setCriteria(this);
        this.m_criteria.addElement(selectionCriteria);
    }

    protected void addCriteria(Criteria criteria) {
        criteria.setParentCriteria(this);
        this.m_criteria.addElement(criteria);
    }

    protected void addCriteria(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.elementAt(i);
            if (e instanceof SelectionCriteria) {
                this.addSelectionCriteria((SelectionCriteria)e);
                continue;
            }
            if (!(e instanceof Criteria)) continue;
            this.addCriteria((Criteria)e);
        }
    }

    protected List splitInCriteria(Object object, Collection collection, boolean bl, int n) {
        ArrayList<InCriteria> arrayList = new ArrayList<InCriteria>();
        ArrayList arrayList2 = new ArrayList();
        if (collection == null || collection.isEmpty()) {
            arrayList.add(this.buildInCriteria(object, bl, collection));
        } else {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                arrayList2.add(iterator.next());
                if (arrayList2.size() != n && iterator.hasNext()) continue;
                arrayList.add(this.buildInCriteria(object, bl, arrayList2));
                arrayList2 = new ArrayList();
            }
        }
        return arrayList;
    }

    private InCriteria buildInCriteria(Object object, boolean bl, Collection collection) {
        if (bl) {
            return ValueCriteria.buildNotInCriteria(object, collection, this.getAlias());
        }
        return ValueCriteria.buildInCriteria(object, collection, this.getAlias());
    }

    public Enumeration getElements() {
        return this.getCriteria().elements();
    }

    protected Vector getCriteria() {
        return this.m_criteria;
    }

    public int getType() {
        return this.m_type;
    }

    public void setType(int n) {
        this.m_type = n;
    }

    public boolean isEmbraced() {
        return this.m_embraced;
    }

    public void setEmbraced(boolean bl) {
        this.m_embraced = bl;
    }

    public void addEqualTo(String string, Object object) {
        this.addSelectionCriteria(ValueCriteria.buildEqualToCriteria(string, object, this.getAlias()));
    }

    public void addColumnEqualTo(String string, Object object) {
        ValueCriteria valueCriteria = ValueCriteria.buildEqualToCriteria(string, object, this.getAlias());
        valueCriteria.setTranslateAttribute(false);
        this.addSelectionCriteria(valueCriteria);
    }

    public void addColumnEqualToField(String string, Object object) {
        FieldCriteria fieldCriteria = FieldCriteria.buildEqualToCriteria(string, object, this.getAlias());
        fieldCriteria.setTranslateAttribute(false);
        this.addSelectionCriteria(fieldCriteria);
    }

    protected String generateSQLSearchPattern(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '\\') {
                if (++i >= cArray.length) continue;
                stringBuffer.append(cArray[i]);
                continue;
            }
            if (cArray[i] == '*') {
                stringBuffer.append("%");
                continue;
            }
            if (cArray[i] == '?') {
                stringBuffer.append("_");
                continue;
            }
            stringBuffer.append(cArray[i]);
        }
        return stringBuffer.toString();
    }

    public void addEqualToField(String string, String string2) {
        FieldCriteria fieldCriteria = FieldCriteria.buildEqualToCriteria(string, string2, this.getAlias());
        this.addSelectionCriteria(fieldCriteria);
    }

    public void addNotEqualToField(String string, String string2) {
        FieldCriteria fieldCriteria = FieldCriteria.buildNotEqualToCriteria(string, string2, this.getAlias());
        this.addSelectionCriteria(fieldCriteria);
    }

    public void addNotEqualToColumn(String string, String string2) {
        FieldCriteria fieldCriteria = FieldCriteria.buildNotEqualToCriteria(string, string2, this.getAlias());
        fieldCriteria.setTranslateField(false);
        this.addSelectionCriteria(fieldCriteria);
    }

    public void addEqualToColumn(String string, String string2) {
        FieldCriteria fieldCriteria = FieldCriteria.buildEqualToCriteria(string, string2, this.getAlias());
        fieldCriteria.setTranslateField(false);
        this.addSelectionCriteria(fieldCriteria);
    }

    public void addGreaterOrEqualThan(Object object, Object object2) {
        this.addSelectionCriteria(ValueCriteria.buildNotLessCriteria(object, object2, this.getAlias()));
    }

    public void addGreaterOrEqualThanField(String string, Object object) {
        this.addSelectionCriteria(FieldCriteria.buildLessCriteria(string, object, this.getAlias()));
    }

    public void addLessOrEqualThan(Object object, Object object2) {
        this.addSelectionCriteria(ValueCriteria.buildNotGreaterCriteria(object, object2, this.getAlias()));
    }

    public void addLessOrEqualThanField(String string, Object object) {
        this.addSelectionCriteria(FieldCriteria.buildNotGreaterCriteria(string, object, this.getAlias()));
    }

    public void addLike(Object object, Object object2) {
        String string = object2 != null ? this.generateSQLSearchPattern((String)object2) : null;
        this.addSelectionCriteria(ValueCriteria.buildLikeCriteria(object, string, this.getAlias()));
    }

    public void addNotLike(String string, Object object) {
        String string2 = object != null ? this.generateSQLSearchPattern((String)object) : null;
        this.addSelectionCriteria(ValueCriteria.buildNotLikeCriteria(string, string2, this.getAlias()));
    }

    public void addNotEqualTo(Object object, Object object2) {
        this.addSelectionCriteria(ValueCriteria.buildNotEqualToCriteria(object, object2, this.getAlias()));
    }

    public void addGreaterThan(Object object, Object object2) {
        this.addSelectionCriteria(ValueCriteria.buildGreaterCriteria(object, object2, this.getAlias()));
    }

    public void addGreaterThanField(String string, Object object) {
        this.addSelectionCriteria(FieldCriteria.buildGreaterCriteria(string, object, this.getAlias()));
    }

    public void addLessThan(Object object, Object object2) {
        this.addSelectionCriteria(ValueCriteria.buildLessCriteria(object, object2, this.getAlias()));
    }

    public void addLessThanField(String string, Object object) {
        this.addSelectionCriteria(FieldCriteria.buildLessCriteria(string, object, this.getAlias()));
    }

    public void addOrderBy(String string) {
        this.addOrderBy(string, true);
    }

    public void addOrderBy(String string, boolean bl) {
        if (string != null) {
            this._getOrderby().add(new FieldHelper(string, bl));
        }
    }

    public void addOrderBy(FieldHelper fieldHelper) {
        if (fieldHelper != null) {
            this._getOrderby().add(fieldHelper);
        }
    }

    public void addOrderByAscending(String string) {
        this.addOrderBy(string, true);
    }

    public void addOrderByDescending(String string) {
        this.addOrderBy(string, false);
    }

    List getOrderby() {
        List list = this._getOrderby();
        Iterator iterator = this.getCriteria().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof Criteria)) continue;
            list.addAll(((Criteria)e).getOrderby());
        }
        return list;
    }

    protected List _getOrderby() {
        return this.orderby;
    }

    public void addOrCriteria(Criteria criteria) {
        if (!this.m_criteria.isEmpty()) {
            criteria.setEmbraced(true);
            criteria.setType(0);
            this.addCriteria(criteria);
        } else {
            this.setEmbraced(false);
            this.setType(9);
            this.addCriteria(criteria.getCriteria());
            this.orderby.addAll(criteria._getOrderby());
            this.groupby.addAll(criteria._getGroupby());
        }
    }

    public void addIsNull(String string) {
        this.addSelectionCriteria(ValueCriteria.buildNullCriteria(string, this.getAlias()));
    }

    public void addNotNull(String string) {
        this.addSelectionCriteria(ValueCriteria.buildNotNullCriteria(string, this.getAlias()));
    }

    public void addBetween(Object object, Object object2, Object object3) {
        this.addSelectionCriteria(ValueCriteria.buildBeweenCriteria(object, object2, object3, this.getAlias()));
    }

    public void addNotBetween(Object object, Object object2, Object object3) {
        this.addSelectionCriteria(ValueCriteria.buildNotBeweenCriteria(object, object2, object3, this.getAlias()));
    }

    public void addIn(String string, Collection collection) {
        List list = this.splitInCriteria(string, collection, false, IN_LIMIT);
        int n = 0;
        InCriteria inCriteria = (InCriteria)list.get(n);
        Criteria criteria = new Criteria(inCriteria);
        for (n = 1; n < list.size(); ++n) {
            inCriteria = (InCriteria)list.get(n);
            criteria.addOrCriteria(new Criteria(inCriteria));
        }
        this.addAndCriteria(criteria);
    }

    public void addNotIn(String string, Collection collection) {
        List list = this.splitInCriteria(string, collection, true, IN_LIMIT);
        int n = 0;
        for (n = 0; n < list.size(); ++n) {
            InCriteria inCriteria = (InCriteria)list.get(n);
            this.addSelectionCriteria(inCriteria);
        }
    }

    public void addIn(Object object, Query query) {
        this.addSelectionCriteria(ValueCriteria.buildInCriteria(object, query, this.getAlias()));
    }

    public void addNotIn(String string, Query query) {
        this.addSelectionCriteria(ValueCriteria.buildNotInCriteria(string, query, this.getAlias()));
    }

    public void addSql(String string) {
        this.addSelectionCriteria(new SqlCriteria(string));
    }

    public void addAndCriteria(Criteria criteria) {
        if (!this.m_criteria.isEmpty()) {
            this.setEmbraced(true);
            criteria.setEmbraced(true);
            criteria.setType(1);
            this.addCriteria(criteria);
        } else {
            this.setEmbraced(false);
            this.setType(9);
            this.addCriteria(criteria.getCriteria());
            this.orderby.addAll(criteria._getOrderby());
            this.groupby.addAll(criteria._getGroupby());
        }
    }

    public void addExists(Query query) {
        this.addSelectionCriteria(new ExistsCriteria(query, false));
    }

    public void addNotExists(Query query) {
        this.addSelectionCriteria(new ExistsCriteria(query, true));
    }

    public boolean isEmpty() {
        return this.m_criteria.isEmpty();
    }

    List getGroupby() {
        List list = this._getGroupby();
        Iterator iterator = this.getCriteria().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof Criteria)) continue;
            list.addAll(((Criteria)e).getGroupby());
        }
        return list;
    }

    protected List _getGroupby() {
        return this.groupby;
    }

    public void addGroupBy(String string) {
        if (string != null) {
            this._getGroupby().add(new FieldHelper(string, false));
        }
    }

    public void addGroupBy(FieldHelper fieldHelper) {
        if (fieldHelper != null) {
            this._getGroupby().add(fieldHelper);
        }
    }

    public void addGroupBy(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.addGroupBy(stringArray[i]);
        }
    }

    List getPrefetchedRelationships() {
        return this.prefetchedRelationships;
    }

    public void addPrefetchedRelationship(String string) {
        this.getPrefetchedRelationships().add(string);
    }

    private static int getSqlInLimit() {
        try {
            PersistenceBrokerConfiguration persistenceBrokerConfiguration = (PersistenceBrokerConfiguration)((Object)PersistenceBrokerFactory.getConfigurator().getConfigurationFor(null));
            return persistenceBrokerConfiguration.getSqlInLimit();
        }
        catch (ConfigurationException configurationException) {
            return 200;
        }
    }

    public String getAlias() {
        return this.m_alias;
    }

    public void setAlias(String string) {
        this.m_alias = string == null || string.trim().equals("") ? null : string;
        for (int i = 0; i < this.m_criteria.size(); ++i) {
            if (this.m_criteria.elementAt(i) instanceof Criteria) continue;
            ((SelectionCriteria)this.m_criteria.elementAt(i)).setAlias(this.m_alias);
        }
    }

    public QueryByCriteria getQuery() {
        if (this.getParentCriteria() != null) {
            return this.getParentCriteria().getQuery();
        }
        return this.m_query;
    }

    void setQuery(QueryByCriteria queryByCriteria) {
        this.m_query = queryByCriteria;
    }

    public Criteria getParentCriteria() {
        return this.m_parentCriteria;
    }

    void setParentCriteria(Criteria criteria) {
        this.m_parentCriteria = criteria;
    }

    public String toString() {
        return this.m_criteria.toString();
    }
}

