/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.platforms;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.platforms.Oracle9iLobHandler;
import org.apache.ojb.broker.platforms.PlatformException;
import org.apache.ojb.broker.platforms.PlatformOracleImpl;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class PlatformOracle9iImpl
extends PlatformOracleImpl {
    private Logger logger = LoggerFactory.getLogger(class$org$apache$ojb$broker$platforms$PlatformOracle9iImpl == null ? (class$org$apache$ojb$broker$platforms$PlatformOracle9iImpl = PlatformOracle9iImpl.class$("org.apache.ojb.broker.platforms.PlatformOracle9iImpl")) : class$org$apache$ojb$broker$platforms$PlatformOracle9iImpl);
    private static final Object[] BATCH_SIZE = new Object[]{new Integer(10)};
    private static final Class[] PARAM_TYPE_INTEGER = new Class[]{Integer.TYPE};
    private static final Class[] PARAM_TYPE_BOOLEAN = new Class[]{Boolean.TYPE};
    private static boolean STATEMENT_CACHING_SUPPORTED = true;
    private static boolean SET_EXECUTE_BATCH_METHOD_EXISTS = true;
    private static boolean SEND_BATCH_METHOD_EXISTS = true;
    private static Method SET_EXECUTE_BATCH = null;
    private static Method SEND_BATCH = null;
    private static Method SET_STATEMENT_CACHING_ENABLE = null;
    private static Method SET_IMPLICIT_CACHING_ENABLED = null;
    private static Method SET_CLOB = null;
    private static Method SET_BLOB = null;
    private static boolean SET_CLOB_AND_LOB_SUPPORTED = false;
    private static Method GET_CLOB = null;
    private static boolean GET_CLOB_AND_LOB_SUPPORTED = false;
    private static boolean ROW_PREFETCH_SUPPORTED = true;
    private static Method SET_ROW_PREFETCH = null;
    private static final int STATEMENT_CACHE_SIZE = 100;
    private static final int ROW_PREFETCH_SIZE = 100;
    static /* synthetic */ Class class$org$apache$ojb$broker$platforms$PlatformOracle9iImpl;
    static /* synthetic */ Class class$java$lang$String;

    public void initializeJdbcConnection(JdbcConnectionDescriptor jdbcConnectionDescriptor, Connection connection) throws PlatformException {
        super.initializeJdbcConnection(jdbcConnectionDescriptor, connection);
        if (SET_STATEMENT_CACHING_ENABLE == null && SET_IMPLICIT_CACHING_ENABLED == null && STATEMENT_CACHING_SUPPORTED) {
            try {
                SET_STATEMENT_CACHING_ENABLE = connection.getClass().getMethod("setStatementCacheSize", PARAM_TYPE_INTEGER);
                SET_IMPLICIT_CACHING_ENABLED = connection.getClass().getMethod("setImplicitCachingEnabled", PARAM_TYPE_BOOLEAN);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                STATEMENT_CACHING_SUPPORTED = false;
            }
            catch (SecurityException securityException) {
                STATEMENT_CACHING_SUPPORTED = false;
                throw new PlatformException(securityException.getMessage(), securityException);
            }
        }
        if (STATEMENT_CACHING_SUPPORTED) {
            try {
                SET_STATEMENT_CACHING_ENABLE.invoke((Object)connection, new Integer(100));
                SET_IMPLICIT_CACHING_ENABLED.invoke((Object)connection, new Boolean(true));
            }
            catch (IllegalAccessException illegalAccessException) {
                STATEMENT_CACHING_SUPPORTED = false;
                throw new PlatformException(illegalAccessException.getMessage(), illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                STATEMENT_CACHING_SUPPORTED = false;
                throw new PlatformException(illegalArgumentException.getMessage(), illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                STATEMENT_CACHING_SUPPORTED = false;
                throw new PlatformException(invocationTargetException.getMessage(), invocationTargetException);
            }
        }
    }

    public void XXXXafterStatementCreate(Statement statement) throws PlatformException {
        super.afterStatementCreate(statement);
        if (ROW_PREFETCH_SUPPORTED && SET_ROW_PREFETCH == null) {
            try {
                SET_ROW_PREFETCH = statement.getClass().getMethod("setRowPrefetch", PARAM_TYPE_INTEGER);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                ROW_PREFETCH_SUPPORTED = false;
            }
            catch (SecurityException securityException) {
                ROW_PREFETCH_SUPPORTED = false;
                throw new PlatformException(securityException.getMessage(), securityException);
            }
        }
        if (ROW_PREFETCH_SUPPORTED) {
            try {
                SET_ROW_PREFETCH.invoke((Object)statement, new Integer(100));
            }
            catch (IllegalAccessException illegalAccessException) {
                STATEMENT_CACHING_SUPPORTED = false;
                throw new PlatformException(illegalAccessException.getMessage(), illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                STATEMENT_CACHING_SUPPORTED = false;
                throw new PlatformException(illegalArgumentException.getMessage(), illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                STATEMENT_CACHING_SUPPORTED = false;
                throw new PlatformException(invocationTargetException.getMessage(), invocationTargetException);
            }
        }
    }

    public void beforeBatch(PreparedStatement preparedStatement) throws PlatformException {
        if (SET_EXECUTE_BATCH_METHOD_EXISTS && SEND_BATCH_METHOD_EXISTS) {
            try {
                if (SET_EXECUTE_BATCH == null) {
                    SET_EXECUTE_BATCH = preparedStatement.getClass().getMethod("setExecuteBatch", PARAM_TYPE_INTEGER);
                }
                SET_EXECUTE_BATCH.invoke((Object)preparedStatement, BATCH_SIZE);
            }
            catch (IllegalAccessException illegalAccessException) {
                SET_EXECUTE_BATCH_METHOD_EXISTS = false;
                throw new PlatformException(illegalAccessException.getMessage(), illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                SET_EXECUTE_BATCH_METHOD_EXISTS = false;
                throw new PlatformException(illegalArgumentException.getMessage(), illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                SET_EXECUTE_BATCH_METHOD_EXISTS = false;
                throw new PlatformException(invocationTargetException.getMessage(), invocationTargetException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                SET_EXECUTE_BATCH_METHOD_EXISTS = false;
            }
        }
        if (!SET_EXECUTE_BATCH_METHOD_EXISTS) {
            super.beforeBatch(preparedStatement);
        }
    }

    public void addBatch(PreparedStatement preparedStatement) throws PlatformException {
        if (SET_EXECUTE_BATCH_METHOD_EXISTS && SEND_BATCH_METHOD_EXISTS) {
            try {
                preparedStatement.executeUpdate();
            }
            catch (SQLException sQLException) {
                throw new PlatformException(sQLException.getMessage(), sQLException);
            }
        } else {
            super.addBatch(preparedStatement);
        }
    }

    public int[] executeBatch(PreparedStatement preparedStatement) throws PlatformException {
        int[] nArray = null;
        if (SEND_BATCH_METHOD_EXISTS) {
            try {
                if (SEND_BATCH == null) {
                    SEND_BATCH = preparedStatement.getClass().getMethod("sendBatch", null);
                }
                int n = (Integer)SEND_BATCH.invoke((Object)preparedStatement, null);
                nArray = new int[n];
                for (int i = 0; i < n; ++i) {
                    nArray[i] = 1;
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                SEND_BATCH_METHOD_EXISTS = false;
                throw new PlatformException(illegalAccessException.getMessage(), illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                SEND_BATCH_METHOD_EXISTS = false;
                throw new PlatformException(illegalArgumentException.getMessage(), illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                SEND_BATCH_METHOD_EXISTS = false;
                throw new PlatformException(invocationTargetException.getMessage(), invocationTargetException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                SEND_BATCH_METHOD_EXISTS = false;
            }
        }
        if (!SEND_BATCH_METHOD_EXISTS) {
            nArray = super.executeBatch(preparedStatement);
        }
        return nArray;
    }

    public void setObjectForStatement(PreparedStatement preparedStatement, int n, Object object, int n2) throws SQLException {
        if (SET_CLOB == null && SET_CLOB_AND_LOB_SUPPORTED) {
            try {
                SET_CLOB = preparedStatement.getClass().getMethod("setCLOB", Integer.TYPE, Class.forName("oracle.sql.CLOB"));
                SET_BLOB = preparedStatement.getClass().getMethod("setBLOB", Integer.TYPE, Class.forName("oracle.sql.BLOB"));
                SET_CLOB_AND_LOB_SUPPORTED = true;
            }
            catch (Throwable throwable) {
                SET_CLOB_AND_LOB_SUPPORTED = false;
            }
        }
        if ((n2 == -3 || n2 == -4) && object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            super.changePreparedStatementResultSetType(preparedStatement);
            preparedStatement.setBinaryStream(n, (InputStream)byteArrayInputStream, byArray.length);
        } else if (object instanceof Double) {
            preparedStatement.setDouble(n, (Double)object);
        } else if (n2 == -5 && object instanceof Integer) {
            preparedStatement.setLong(n, ((Integer)object).intValue());
        } else if (n2 == 4 && object instanceof Long) {
            preparedStatement.setLong(n, (Long)object);
        } else if (n2 == 2005 && object instanceof String) {
            if (SET_CLOB_AND_LOB_SUPPORTED) {
                try {
                    SET_CLOB.invoke((Object)preparedStatement, new Integer(n), Oracle9iLobHandler.createCLOBFromString(preparedStatement.getConnection(), (String)object));
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new SQLException(illegalAccessException.getMessage());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new SQLException(illegalArgumentException.getMessage());
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new SQLException(invocationTargetException.getMessage());
                }
            }
        } else if (n2 == 2004) {
            if (SET_CLOB_AND_LOB_SUPPORTED) {
                try {
                    SET_BLOB.invoke((Object)preparedStatement, new Integer(n));
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new SQLException(illegalAccessException.getMessage());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new SQLException(illegalArgumentException.getMessage());
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new SQLException(invocationTargetException.getMessage());
                }
            }
        } else {
            super.setObjectForStatement(preparedStatement, n, object, n2);
        }
    }

    public Object getClob(ResultSet resultSet, int n, String string) throws SQLException {
        String string2 = "";
        if (GET_CLOB == null && GET_CLOB_AND_LOB_SUPPORTED) {
            try {
                GET_CLOB = resultSet.getClass().getMethod("getCLOB", class$java$lang$String == null ? (class$java$lang$String = PlatformOracle9iImpl.class$("java.lang.String")) : class$java$lang$String);
                GET_CLOB_AND_LOB_SUPPORTED = true;
            }
            catch (Throwable throwable) {
                GET_CLOB_AND_LOB_SUPPORTED = false;
            }
        }
        if (GET_CLOB_AND_LOB_SUPPORTED) {
            try {
                Object object = GET_CLOB.invoke((Object)resultSet, string);
                string2 = Oracle9iLobHandler.convertCLOBtoString(resultSet.getStatement().getConnection(), object);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SQLException(illegalAccessException.getMessage());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new SQLException(illegalArgumentException.getMessage());
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new SQLException(invocationTargetException.getMessage());
            }
        }
        return string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

