/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.platforms;

import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Connection;
import org.apache.ojb.broker.platforms.BlobWrapper;
import org.apache.ojb.broker.platforms.ClobWrapper;

public class Oracle9iLobHandler {
    Connection m_connection = null;
    BlobWrapper m_tempBlob = null;

    private static ClobWrapper createTempCLOB(Connection connection, ClobWrapper clobWrapper) {
        ClobWrapper clobWrapper2 = null;
        if (clobWrapper != null) {
            try {
                clobWrapper2 = ClobWrapper.createTemporary(connection, true, 10);
                clobWrapper.open(0);
                clobWrapper2.open(1);
                int n = 0;
                Reader reader = clobWrapper.getCharacterStream();
                Writer writer = clobWrapper2.getCharacterOutputStream();
                char[] cArray = new char[clobWrapper.getBufferSize()];
                while ((n = reader.read(cArray)) != -1) {
                    writer.write(cArray, 0, n);
                }
                writer.flush();
                writer.close();
                reader.close();
                clobWrapper.close();
                clobWrapper2.close();
            }
            catch (Exception exception) {
                Oracle9iLobHandler.freeTempLOB(clobWrapper2, null);
            }
        }
        return clobWrapper2;
    }

    public static String convertCLOBtoString(Connection connection, Object object) {
        String string = null;
        ClobWrapper clobWrapper = new ClobWrapper();
        clobWrapper.setClob(object);
        ClobWrapper clobWrapper2 = Oracle9iLobHandler.createTempCLOB(connection, clobWrapper);
        if (clobWrapper2 != null) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            try {
                clobWrapper2.open(0);
                Reader reader = clobWrapper2.getCharacterStream();
                char[] cArray = new char[clobWrapper2.getBufferSize()];
                while ((n = reader.read(cArray)) != -1) {
                    stringBuffer.append(cArray, 0, n);
                }
                reader.close();
                clobWrapper2.close();
                string = stringBuffer.toString();
                stringBuffer = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    public static Object createCLOBFromString(Connection connection, String string) {
        ClobWrapper clobWrapper = new ClobWrapper();
        if (string != null) {
            try {
                clobWrapper = ClobWrapper.createTemporary(connection, true, 10);
                clobWrapper.open(1);
                clobWrapper.trim(0L);
                Writer writer = clobWrapper.getCharacterOutputStream();
                writer.write(string);
                writer.flush();
                writer.close();
                clobWrapper.close();
            }
            catch (Exception exception) {
                Oracle9iLobHandler.freeTempLOB(clobWrapper, null);
            }
        }
        return clobWrapper.getClob();
    }

    void createBLOBFromFile(File file) {
        if (file != null) {
            try {
                Object object;
                if (this.m_tempBlob == null) {
                    object = new BlobWrapper();
                    this.m_tempBlob = ((BlobWrapper)object).createTemporary(this.m_connection, true, 10);
                }
                this.m_tempBlob.open(1);
                this.m_tempBlob.trim(0L);
                object = new FileInputStream(file);
                OutputStream outputStream = this.m_tempBlob.getBinaryOutputStream();
                byte[] byArray = new byte[this.m_tempBlob.getBufferSize()];
                int n = 0;
                while ((n = ((FileInputStream)object).read(byArray)) != -1) {
                    outputStream.write(byArray, 0, n);
                }
                outputStream.flush();
                ((FileInputStream)object).close();
                outputStream.close();
                this.m_tempBlob.close();
            }
            catch (Exception exception) {
                Oracle9iLobHandler.freeTempLOB(null, this.m_tempBlob);
            }
        }
    }

    private static void freeTempLOB(ClobWrapper clobWrapper, BlobWrapper blobWrapper) {
        try {
            if (clobWrapper != null) {
                if (clobWrapper.isOpen()) {
                    clobWrapper.close();
                }
                clobWrapper.freeTemporary();
                clobWrapper = null;
            }
            if (blobWrapper != null) {
                if (blobWrapper.isOpen()) {
                    blobWrapper.close();
                }
                blobWrapper.freeTemporary();
                blobWrapper = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

