/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.platforms;

import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;

public class ClobWrapper {
    public static final int MAX_CHUNK_SIZE = 32768;
    public static final int DURATION_SESSION = 10;
    public static final int DURATION_CALL = 12;
    static final int OLD_WRONG_DURATION_SESSION = 1;
    static final int OLD_WRONG_DURATION_CALL = 2;
    public static final int MODE_READONLY = 0;
    public static final int MODE_READWRITE = 1;
    private Object m_clob = null;
    private static Method createTemporary = null;
    private static Method open = null;
    private static Method isOpen = null;
    private static Method getCharacterStream = null;
    private static Method getCharacterOutputStream = null;
    private static Method getBufferSize = null;
    private static Method close = null;
    private static Method trim = null;
    private static Method freeTemporary = null;
    static /* synthetic */ Class class$java$sql$Connection;

    public Object getClob() {
        return this.m_clob;
    }

    public void setClob(Object object) {
        this.m_clob = object;
    }

    public static ClobWrapper createTemporary(Connection connection, boolean bl, int n) {
        ClobWrapper clobWrapper = new ClobWrapper();
        try {
            clobWrapper.m_clob = createTemporary.invoke(null, connection, new Boolean(bl), new Integer(n));
        }
        catch (IllegalAccessException illegalAccessException) {
            System.out.println(illegalAccessException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println(illegalArgumentException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            System.out.println(invocationTargetException.getMessage());
        }
        return clobWrapper;
    }

    public void open(int n) throws SQLException {
        try {
            open.invoke(this.m_clob, new Integer(n));
        }
        catch (Throwable throwable) {
            throw new SQLException(throwable.getMessage());
        }
    }

    public boolean isOpen() throws SQLException {
        Boolean bl = null;
        try {
            bl = (Boolean)isOpen.invoke(this.m_clob, null);
        }
        catch (Throwable throwable) {
            throw new SQLException(throwable.getMessage());
        }
        return bl;
    }

    public Reader getCharacterStream() throws SQLException {
        Reader reader = null;
        try {
            reader = (Reader)getCharacterStream.invoke(this.m_clob, null);
        }
        catch (Throwable throwable) {
            throw new SQLException(throwable.getMessage());
        }
        return reader;
    }

    public Writer getCharacterOutputStream() throws SQLException {
        Writer writer = null;
        try {
            writer = (Writer)getCharacterOutputStream.invoke(this.m_clob, null);
        }
        catch (Throwable throwable) {
            throw new SQLException(throwable.getMessage());
        }
        return writer;
    }

    public int getBufferSize() throws SQLException {
        Integer n = null;
        try {
            n = (Integer)getBufferSize.invoke(this.m_clob, null);
        }
        catch (Throwable throwable) {
            throw new SQLException(throwable.getMessage());
        }
        return n;
    }

    public void close() throws SQLException {
        try {
            close.invoke(this.m_clob, null);
        }
        catch (Throwable throwable) {
            throw new SQLException(throwable.getMessage());
        }
    }

    public void trim(long l) throws SQLException {
        try {
            trim.invoke(this.m_clob, new Long(l));
        }
        catch (Throwable throwable) {
            throw new SQLException(throwable.getMessage());
        }
    }

    public void freeTemporary() throws SQLException {
        try {
            freeTemporary.invoke(this.m_clob, null);
        }
        catch (Throwable throwable) {
            throw new SQLException(throwable.getMessage());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            Class<?> clazz = Class.forName("oracle.sql.CLOB");
            createTemporary = clazz.getDeclaredMethod("createTemporary", class$java$sql$Connection == null ? (class$java$sql$Connection = ClobWrapper.class$("java.sql.Connection")) : class$java$sql$Connection, Boolean.TYPE, Integer.TYPE);
            open = clazz.getMethod("open", Integer.TYPE);
            isOpen = clazz.getMethod("isOpen", null);
            getCharacterStream = clazz.getMethod("getCharacterStream", null);
            getCharacterOutputStream = clazz.getMethod("getCharacterOutputStream", null);
            getBufferSize = clazz.getMethod("getBufferSize", null);
            close = clazz.getMethod("close", null);
            trim = clazz.getMethod("trim", Long.TYPE);
            freeTemporary = clazz.getMethod("freeTemporary", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.out.println(noSuchMethodException.getMessage());
        }
        catch (SecurityException securityException) {
            System.out.println(securityException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println(classNotFoundException.getMessage());
        }
    }
}

