/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata.torque;

import java.util.HashMap;
import java.util.Iterator;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.torque.TableDescriptor;

public class TorqueTablePreprocessor {
    private DescriptorRepository repository;
    private HashMap standardTables = new HashMap();

    public TorqueTablePreprocessor(DescriptorRepository descriptorRepository) {
        this.repository = descriptorRepository;
    }

    public void buildStandardTables() {
        Iterator iterator = this.repository.iterator();
        while (iterator.hasNext()) {
            ClassDescriptor classDescriptor = (ClassDescriptor)iterator.next();
            if (classDescriptor.isAbstract() || classDescriptor.isInterface()) {
                System.out.println("Skip table build for abstract base class / interface called " + classDescriptor.getClassNameOfObject());
                continue;
            }
            this.buildStandardTable(classDescriptor);
        }
    }

    public HashMap getStandardTables() {
        return this.standardTables;
    }

    private void buildStandardTable(ClassDescriptor classDescriptor) {
        String string = classDescriptor.getFullTableName();
        TableDescriptor tableDescriptor = (TableDescriptor)this.standardTables.get(string);
        if (tableDescriptor == null) {
            tableDescriptor = new TableDescriptor();
            tableDescriptor.setName(string);
            this.standardTables.put(string, tableDescriptor);
        }
        this.buildStandardTableFieldDescriptors(classDescriptor.getFieldDescriptions(), tableDescriptor);
        tableDescriptor.getIndices().addAll(classDescriptor.getIndexes());
        tableDescriptor.getReferences().addAll(classDescriptor.getObjectReferenceDescriptors());
    }

    private void buildStandardTableFieldDescriptors(FieldDescriptor[] fieldDescriptorArray, TableDescriptor tableDescriptor) {
        if (fieldDescriptorArray != null) {
            for (int i = 0; i < fieldDescriptorArray.length; ++i) {
                tableDescriptor.addColumn(fieldDescriptorArray[i]);
            }
        }
    }
}

