/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata.torque;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.metadata.torque.TableDescriptor;

public class TorqueForeignKeyGenerator {
    private DescriptorRepository repository;
    private HashMap mappingTables = new HashMap();
    private HashMap foreignKeyVectors = new HashMap();

    public TorqueForeignKeyGenerator(DescriptorRepository descriptorRepository) {
        this.repository = descriptorRepository;
    }

    public void buildConstraintsMap() {
        Iterator iterator = this.repository.iterator();
        while (iterator.hasNext()) {
            ClassDescriptor classDescriptor = (ClassDescriptor)iterator.next();
            if (classDescriptor.isAbstract() || classDescriptor.isInterface()) {
                System.out.println("Skip constraint build for abstract class/ interface " + classDescriptor.getClassNameOfObject());
                continue;
            }
            this.buildConstraints(classDescriptor);
            this.buildOneToOneConstraints(classDescriptor);
        }
    }

    public Vector getForeignKeysForTable(String string) {
        return (Vector)this.foreignKeyVectors.get(string);
    }

    public HashMap getMappingTables() {
        return this.mappingTables;
    }

    private void buildTableFieldDescriptors(FieldDescriptor[] fieldDescriptorArray, TableDescriptor tableDescriptor) {
        for (int i = 0; i < fieldDescriptorArray.length; ++i) {
            tableDescriptor.addColumn(fieldDescriptorArray[i]);
        }
    }

    private void buildConstraints(ClassDescriptor classDescriptor) {
        Vector vector = classDescriptor.getCollectionDescriptors();
        for (int i = 0; i < vector.size(); ++i) {
            CollectionDescriptor collectionDescriptor = (CollectionDescriptor)vector.get(i);
            if (collectionDescriptor.isMtoNRelation()) {
                this.buildManyToManyConstraints(classDescriptor, collectionDescriptor);
                continue;
            }
            this.buildOneToManyReferences(classDescriptor, collectionDescriptor);
        }
    }

    private void buildManyToManyConstraints(ClassDescriptor classDescriptor, CollectionDescriptor collectionDescriptor) {
        Vector vector = new Vector();
        ClassDescriptor classDescriptor2 = this.repository.getDescriptorFor(collectionDescriptor.getItemClass());
        this.buildManyToManyReferences(classDescriptor, collectionDescriptor, collectionDescriptor.getFksToThisClass(), vector);
        this.buildManyToManyReferences(classDescriptor2, collectionDescriptor, collectionDescriptor.getFksToItemClass(), vector);
        if (this.isImplicitlyMapped(collectionDescriptor.getIndirectionTable())) {
            TableDescriptor tableDescriptor = new TableDescriptor();
            this.buildTableFieldDescriptors(vector.toArray(new FieldDescriptor[0]), tableDescriptor);
            tableDescriptor.setName(collectionDescriptor.getIndirectionTable());
            this.mappingTables.put(tableDescriptor.getName(), tableDescriptor);
        }
    }

    private void buildManyToManyReferences(ClassDescriptor classDescriptor, CollectionDescriptor collectionDescriptor, Object[] objectArray, Vector vector) {
        if (classDescriptor.isAbstract() || classDescriptor.isInterface()) {
            System.out.println("Skip foreign key build for MtoM, found abstract base class or interface " + classDescriptor.getClassNameOfObject());
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        this.buildForeignKeyHeader(classDescriptor.getFullTableName(), stringBuffer);
        for (int i = 0; i < objectArray.length; ++i) {
            String string = (String)objectArray[i];
            FieldDescriptor fieldDescriptor = classDescriptor.getPkFields()[i];
            String string2 = fieldDescriptor.getPersistentField().getName();
            this.buildReferenceForColumn(stringBuffer, string, string2);
            FieldDescriptor fieldDescriptor2 = (FieldDescriptor)fieldDescriptor.clone();
            fieldDescriptor2.setColumnName(string);
            vector.add(fieldDescriptor2);
        }
        stringBuffer.append("        </foreign-key>\n");
        this.addReferenceToTable(collectionDescriptor.getIndirectionTable(), stringBuffer.toString());
    }

    private void buildOneToManyReferences(ClassDescriptor classDescriptor, CollectionDescriptor collectionDescriptor) {
        Vector vector = collectionDescriptor.getForeignKeyFields();
        ClassDescriptor classDescriptor2 = this.repository.getDescriptorFor(collectionDescriptor.getItemClass());
        this.buildForeignKey(classDescriptor, vector, classDescriptor2);
    }

    private void buildOneToOneConstraints(ClassDescriptor classDescriptor) {
        Vector vector = classDescriptor.getObjectReferenceDescriptors();
        for (int i = 0; i < vector.size(); ++i) {
            ObjectReferenceDescriptor objectReferenceDescriptor = (ObjectReferenceDescriptor)vector.get(i);
            Vector vector2 = objectReferenceDescriptor.getForeignKeyFields();
            ClassDescriptor classDescriptor2 = this.repository.getDescriptorFor(objectReferenceDescriptor.getItemClass());
            this.buildForeignKey(classDescriptor2, vector2, classDescriptor);
        }
    }

    private void buildForeignKey(ClassDescriptor classDescriptor, Vector vector, ClassDescriptor classDescriptor2) {
        if (classDescriptor2.isAbstract() || classDescriptor2.isInterface()) {
            System.out.println("Skip foreign key build, found abstract base class or interface " + classDescriptor2.getClassNameOfObject());
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        this.buildForeignKeyHeader(classDescriptor.getFullTableName(), stringBuffer);
        for (int i = 0; i < vector.size(); ++i) {
            FieldDescriptor fieldDescriptor;
            String string = null;
            Object e = vector.get(i);
            if (e instanceof Integer) {
                int n = (Integer)e;
                string = classDescriptor2.getFieldDescriptorByIndex(n).getColumnName();
            } else {
                fieldDescriptor = classDescriptor2.getFieldDescriptorByName((String)e);
                if (fieldDescriptor == null) {
                    System.err.println("FieldDescriptor for foreign key parameter \n" + e + " was not found in ClassDescriptor \n" + classDescriptor2);
                } else {
                    string = fieldDescriptor.getColumnName();
                }
            }
            fieldDescriptor = classDescriptor.getPkFields()[i];
            String string2 = fieldDescriptor.getColumnName();
            this.buildReferenceForColumn(stringBuffer, string, string2);
        }
        stringBuffer.append("        </foreign-key>\n");
        this.addReferenceToTable(classDescriptor2.getFullTableName(), stringBuffer.toString());
    }

    private void buildForeignKeyHeader(String string, StringBuffer stringBuffer) {
        stringBuffer.append("        <foreign-key foreignTable=\"");
        stringBuffer.append(string);
        stringBuffer.append("\">\n");
    }

    private void buildReferenceForColumn(StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append("            <reference local=\"");
        stringBuffer.append(string);
        stringBuffer.append("\" foreign=\"");
        stringBuffer.append(string2);
        stringBuffer.append("\"/>\n");
    }

    private boolean isImplicitlyMapped(String string) {
        Iterator iterator = this.repository.iterator();
        while (iterator.hasNext()) {
            ClassDescriptor classDescriptor = (ClassDescriptor)iterator.next();
            if (!string.equals(classDescriptor.getFullTableName())) continue;
            return false;
        }
        return true;
    }

    private void addReferenceToTable(String string, String string2) {
        Vector<String> vector = (Vector<String>)this.foreignKeyVectors.get(string);
        if (vector == null) {
            vector = new Vector<String>();
            this.foreignKeyVectors.put(string, vector);
        }
        if (!vector.contains(string2)) {
            vector.add(string2);
        }
    }
}

