/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata.torque;

import org.apache.ojb.broker.metadata.FieldDescriptor;

public class TorqueFieldGenerator {
    private boolean ignoreAutoIncrement;

    public TorqueFieldGenerator(boolean bl) {
        this.ignoreAutoIncrement = bl;
    }

    public void generateFieldDescriptors(FieldDescriptor[] fieldDescriptorArray, StringBuffer stringBuffer) {
        if (fieldDescriptorArray != null) {
            for (int i = 0; i < fieldDescriptorArray.length; ++i) {
                FieldDescriptor fieldDescriptor = fieldDescriptorArray[i];
                this.generateFieldDescriptor(fieldDescriptor, fieldDescriptor.getColumnName(), fieldDescriptor.isRequired(), fieldDescriptor.isAutoIncrement(), fieldDescriptor.isPrimaryKey(), stringBuffer);
            }
        }
    }

    public void generateMappingFieldDescriptors(FieldDescriptor[] fieldDescriptorArray, StringBuffer stringBuffer) {
        if (fieldDescriptorArray != null) {
            for (int i = 0; i < fieldDescriptorArray.length; ++i) {
                FieldDescriptor fieldDescriptor = fieldDescriptorArray[i];
                StringBuffer stringBuffer2 = new StringBuffer();
                this.generateFieldDescriptor(fieldDescriptor, fieldDescriptor.getColumnName(), true, false, true, stringBuffer2);
                stringBuffer.append(stringBuffer2);
            }
        }
    }

    private void generateFieldDescriptor(FieldDescriptor fieldDescriptor, String string, boolean bl, boolean bl2, boolean bl3, StringBuffer stringBuffer) {
        stringBuffer.append("        <column name=\"");
        stringBuffer.append(string);
        stringBuffer.append("\" required=\"");
        stringBuffer.append(bl || bl3);
        if (!this.ignoreAutoIncrement) {
            stringBuffer.append("\" autoIncrement=\"");
            stringBuffer.append(bl2);
        }
        stringBuffer.append("\" primaryKey=\"");
        stringBuffer.append(bl3);
        stringBuffer.append("\" type=\"");
        stringBuffer.append(fieldDescriptor.getColumnType());
        this.generateConstraints(fieldDescriptor, stringBuffer);
        stringBuffer.append("\"/>\n");
    }

    private void generateConstraints(FieldDescriptor fieldDescriptor, StringBuffer stringBuffer) {
        int n = fieldDescriptor.getColumnJdbcType();
        switch (n) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (fieldDescriptor.isPrecisionSpecified()) {
                    stringBuffer.append("\" precision=\"");
                    stringBuffer.append(fieldDescriptor.getPrecision());
                }
                if (!fieldDescriptor.isScaleSpecified()) break;
                stringBuffer.append("\" scale=\"");
                stringBuffer.append(fieldDescriptor.getScale());
                break;
            }
            default: {
                if (!fieldDescriptor.isLengthSpecified()) break;
                stringBuffer.append("\" size=\"");
                stringBuffer.append(fieldDescriptor.getLength());
            }
        }
    }
}

