/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata.fieldaccess;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.metadata.fieldaccess.AbstractPersistentField;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class PersistentFieldIntrospectorImpl
extends AbstractPersistentField {
    private transient PropertyDescriptor propertyDescriptor;

    public PersistentFieldIntrospectorImpl() {
    }

    public PersistentFieldIntrospectorImpl(Class clazz, String string) {
        super(clazz, string);
    }

    public String getName() {
        return this.fieldName;
    }

    public Class getType() {
        return this.getPropertyDescriptor().getPropertyType();
    }

    public Class getDeclaringClass() {
        return this.rootObjectType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doSet(Object object, Object object2) throws MetadataException {
        Method method = this.getPropertyDescriptor().getWriteMethod();
        Object[] objectArray = new Object[]{object2};
        if (method != null) {
            try {
                if (object2 == null && method.getParameterTypes()[0].isPrimitive()) return;
                method.invoke(object, objectArray);
                return;
            }
            catch (Throwable throwable) {
                this.logProblem(object, object2, throwable.getClass().getName());
                throw new MetadataException("Error invoking method:" + method.getName() + " in object:" + object.getClass().getName(), throwable);
            }
        } else {
            this.logProblem(object, object2, "set: getWriteMethod returned null");
            throw new MetadataException("Can't get WriteMethod for property:" + this.getPropertyDescriptor().getName() + " in object:" + object.getClass().getName());
        }
    }

    public Object doGet(Object object) throws MetadataException {
        Method method = this.getPropertyDescriptor().getReadMethod();
        Object[] objectArray = null;
        if (method != null) {
            try {
                Object object2 = method.invoke(object, objectArray);
                return object2;
            }
            catch (Throwable throwable) {
                this.logProblem(object, null, throwable.getClass().getName());
                throw new MetadataException("Error invoking method:" + method.getName() + " in object:" + object.getClass().getName(), throwable);
            }
        }
        this.logProblem(object, null, "get: getReadMethod returned null");
        throw new MetadataException("Can't get ReadMethod for property:" + this.getPropertyDescriptor().getName() + " in object:" + object.getClass().getName());
    }

    protected PropertyDescriptor findPropertyDescriptor(Class clazz, String string) {
        PropertyDescriptor propertyDescriptor = null;
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                if (!propertyDescriptorArray[i].getName().equals(string)) continue;
                propertyDescriptor = propertyDescriptorArray[i];
                break;
            }
            if (propertyDescriptor == null) {
                throw new MetadataException("Can't find property " + string + " in " + clazz.getName());
            }
            return propertyDescriptor;
        }
        catch (IntrospectionException introspectionException) {
            throw new MetadataException("Can't find property " + string + " in " + clazz.getName(), introspectionException);
        }
    }

    protected PropertyDescriptor getPropertyDescriptor() {
        if (this.propertyDescriptor == null) {
            this.setPropertyDescriptor(this.findPropertyDescriptor(this.getDeclaringClass(), this.getName()));
        }
        return this.propertyDescriptor;
    }

    protected void setPropertyDescriptor(PropertyDescriptor propertyDescriptor) {
        this.propertyDescriptor = propertyDescriptor;
    }

    public boolean makeAccessible() {
        return false;
    }

    public boolean usesAccessorsAndMutators() {
        return true;
    }

    protected void logProblem(Object object, Object object2, String string) {
        Logger logger = LoggerFactory.getDefaultLogger();
        logger.error("Error in [PersistentFieldPropertyImpl], " + string);
        logger.error("Declaring class [" + this.getDeclaringClass().getName() + "]");
        logger.error("Property Name [" + this.getName() + "]");
        logger.error("Property Type [" + this.getPropertyDescriptor().getPropertyType().getName() + "]");
        if (object != null) {
            logger.error("anObject was class [" + object.getClass().getName() + "]");
        } else {
            logger.error("anObject was null");
        }
        if (object2 != null) {
            logger.error("aValue was class [" + object2.getClass().getName() + "]");
        } else {
            logger.error("aValue was null");
        }
    }
}

