/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata;

import org.apache.ojb.broker.accesslayer.QueryCustomizer;
import org.apache.ojb.broker.metadata.AnonymousFieldDescriptor;
import org.apache.ojb.broker.metadata.AnonymousObjectReferenceDescriptor;
import org.apache.ojb.broker.metadata.ArgumentDescriptor;
import org.apache.ojb.broker.metadata.AttributeContainer;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.DeleteProcedureDescriptor;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.IndexDescriptor;
import org.apache.ojb.broker.metadata.InsertProcedureDescriptor;
import org.apache.ojb.broker.metadata.IsolationLevels;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.metadata.ObjectCacheDescriptor;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.metadata.ProcedureDescriptor;
import org.apache.ojb.broker.metadata.RepositoryElements;
import org.apache.ojb.broker.metadata.RepositoryTags;
import org.apache.ojb.broker.metadata.UpdateProcedureDescriptor;
import org.apache.ojb.broker.metadata.fieldaccess.AnonymousPersistentFieldHelper;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class RepositoryXmlHandler
extends DefaultHandler
implements RepositoryElements,
IsolationLevels {
    private Logger logger = LoggerFactory.getLogger(class$org$apache$ojb$broker$metadata$RepositoryXmlHandler == null ? (class$org$apache$ojb$broker$metadata$RepositoryXmlHandler = RepositoryXmlHandler.class$("org.apache.ojb.broker.metadata.RepositoryXmlHandler")) : class$org$apache$ojb$broker$metadata$RepositoryXmlHandler);
    private DescriptorRepository m_repository;
    private ClassDescriptor m_CurrentCLD;
    private ProcedureDescriptor m_CurrentProcedure;
    private FieldDescriptor m_CurrentFLD;
    private ObjectReferenceDescriptor m_CurrentORD;
    private CollectionDescriptor m_CurrentCOD;
    private IndexDescriptor m_CurrentIndexDescriptor;
    private String m_CurrentString;
    private AttributeContainer m_CurrentAttrContainer;
    private int defIsoLevel = 0;
    private int defProxyPrefetchingLimit = 50;
    private int m_lastId;
    private RepositoryTags tags = RepositoryTags.getInstance();
    static /* synthetic */ Class class$org$apache$ojb$broker$metadata$RepositoryXmlHandler;

    private int getLiteralId(String string) throws MetadataException {
        try {
            return this.tags.getIdByTag(string);
        }
        catch (NullPointerException nullPointerException) {
            throw new MetadataException("Found Unknown literal '" + string + "' in the repository file. Check repository file or/and RepositoryTags.java", nullPointerException);
        }
    }

    public RepositoryXmlHandler(DescriptorRepository descriptorRepository) {
        if (descriptorRepository == null) {
            throw new MetadataException("Given DescriptorRepository argument was null");
        }
        this.m_repository = descriptorRepository;
    }

    public void startDocument() {
        this.logger.debug("startDoc");
    }

    public void endDocument() {
        AnonymousPersistentFieldHelper.computeInheritedPersistentFields(this.m_repository);
        this.logger.debug("endDoc");
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        boolean bl = this.logger.isDebugEnabled();
        this.m_CurrentString = null;
        try {
            switch (this.getLiteralId(string3)) {
                case 0: {
                    this.m_CurrentAttrContainer = this.m_repository;
                    String string4 = attributes.getValue(this.tags.getTagById(34));
                    if (string4 != null) {
                        this.defIsoLevel = this.getIsoLevel(string4);
                    }
                    String string5 = attributes.getValue(this.tags.getTagById(114));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(114) + ": " + string5);
                    }
                    if (string5 != null) {
                        this.defProxyPrefetchingLimit = Integer.parseInt(string5);
                    }
                    String string6 = attributes.getValue(this.tags.getTagById(67));
                    if (!DescriptorRepository.getVersion().equals(string6)) {
                        throw new MetadataException("Repository version does not match. expected " + DescriptorRepository.getVersion() + " but found: " + string6 + ". Please update your repository.dtd and your repository.xml" + " version attribute entry");
                    }
                    if (!bl) break;
                    this.logger.debug(" > " + this.tags.getTagById(0));
                    break;
                }
                case 12: {
                    String string7;
                    if (bl) {
                        this.logger.debug("  > " + this.tags.getTagById(12));
                    }
                    this.m_CurrentCLD = new ClassDescriptor(this.m_repository);
                    this.m_CurrentAttrContainer = this.m_CurrentCLD;
                    String string8 = attributes.getValue(this.tags.getTagById(34));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(34) + ": " + string8);
                    }
                    this.m_CurrentCLD.setIsolationLevel(this.getIsoLevel(string8));
                    String string9 = attributes.getValue(this.tags.getTagById(13));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(13) + ": " + string9);
                    }
                    try {
                        this.m_CurrentCLD.setClassOfObject(ClassHelper.getClass(string9));
                        this.m_repository.put(string9, this.m_CurrentCLD);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        this.m_CurrentCLD = null;
                        throw new MetadataException("Class " + string9 + " could not be found" + " in the classpath. This could cause unexpected behaviour of OJB," + " please remove or comment out this class descriptor" + " in the repository.xml file.", classNotFoundException);
                    }
                    String string10 = attributes.getValue(this.tags.getTagById(5));
                    if (string10 != null) {
                        if (bl) {
                            this.logger.debug("     " + this.tags.getTagById(5) + ": " + string10);
                        }
                        this.m_CurrentCLD.setSchema(string10);
                    }
                    String string11 = attributes.getValue(this.tags.getTagById(35));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(35) + ": " + string11);
                    }
                    if (string11 != null) {
                        if (string11.equalsIgnoreCase("dynamic")) {
                            this.m_CurrentCLD.setProxyClassName("dynamic");
                        } else {
                            this.m_CurrentCLD.setProxyClassName(string11);
                        }
                    }
                    String string12 = attributes.getValue(this.tags.getTagById(114));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(114) + ": " + string12);
                    }
                    if (string12 == null) {
                        this.m_CurrentCLD.setProxyPrefetchingLimit(this.defProxyPrefetchingLimit);
                    } else {
                        this.m_CurrentCLD.setProxyPrefetchingLimit(Integer.parseInt(string12));
                    }
                    String string13 = attributes.getValue(this.tags.getTagById(14));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(14) + ": " + string13);
                    }
                    this.m_CurrentCLD.setTableName(string13);
                    if (string13 == null) {
                        this.m_CurrentCLD.setIsInterface(true);
                    }
                    String string14 = attributes.getValue(this.tags.getTagById(32));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(32) + ": " + string14);
                    }
                    if (string14 != null) {
                        this.m_CurrentCLD.setRowReader(string14);
                    }
                    String string15 = attributes.getValue(this.tags.getTagById(76));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(76) + ": " + string15);
                    }
                    if (string15 != null) {
                        this.m_CurrentCLD.setSuperClass(string15);
                    }
                    if ((string7 = attributes.getValue(this.tags.getTagById(78))) == null) {
                        string7 = "true";
                    }
                    this.logger.debug("     " + this.tags.getTagById(78) + ": " + string7);
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(78) + ": " + string7);
                    }
                    boolean bl2 = new Boolean(string7);
                    this.m_CurrentCLD.setAcceptLocks(bl2);
                    String string16 = attributes.getValue(this.tags.getTagById(93));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(93) + ": " + string16);
                    }
                    if (string16 != null) {
                        this.m_CurrentCLD.setInitializationMethod(string16);
                    }
                    String string17 = attributes.getValue(this.tags.getTagById(100));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(100) + ": " + string17);
                    }
                    if (string17 != null) {
                        this.m_CurrentCLD.setFactoryClass(string17);
                    }
                    String string18 = attributes.getValue(this.tags.getTagById(101));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(101) + ": " + string18);
                    }
                    if (string18 != null) {
                        this.m_CurrentCLD.setFactoryMethod(string18);
                    }
                    String string19 = attributes.getValue(this.tags.getTagById(47));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(47) + ": " + string19);
                    }
                    bl2 = new Boolean(string19);
                    this.m_CurrentCLD.setAlwaysRefresh(bl2);
                    break;
                }
                case 113: {
                    String string20 = attributes.getValue(this.tags.getTagById(13));
                    if (!this.checkString(string20)) break;
                    ObjectCacheDescriptor objectCacheDescriptor = new ObjectCacheDescriptor();
                    this.m_CurrentAttrContainer = objectCacheDescriptor;
                    objectCacheDescriptor.setObjectCache(ClassHelper.getClass(string20));
                    if (this.m_CurrentCLD != null) {
                        this.m_CurrentCLD.setObjectCacheDescriptor(objectCacheDescriptor);
                    }
                    if (bl) {
                        this.logger.debug("    > " + this.tags.getTagById(113));
                    }
                    if (!bl) break;
                    this.logger.debug("     " + this.tags.getTagById(13) + ": " + string20);
                    break;
                }
                case 33: {
                    String string21 = attributes.getValue("class-ref");
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(33) + ": " + string21);
                    }
                    this.m_CurrentCLD.addExtentClassName(string21);
                    break;
                }
                case 15: {
                    String string22;
                    String string23;
                    String string24;
                    String string25;
                    String string26;
                    if (bl) {
                        this.logger.debug("    > " + this.tags.getTagById(15));
                    }
                    this.m_lastId = (string26 = attributes.getValue(this.tags.getTagById(69))) == null ? this.m_lastId + 1 : Integer.parseInt(string26);
                    String string27 = attributes.getValue(this.tags.getTagById(99));
                    this.m_CurrentFLD = "anonymous".equalsIgnoreCase(string27) ? new AnonymousFieldDescriptor(this.m_CurrentCLD, this.m_lastId) : new FieldDescriptor(this.m_CurrentCLD, this.m_lastId);
                    this.m_CurrentFLD.setAccess(string27);
                    this.m_CurrentCLD.addFieldDescriptor(this.m_CurrentFLD);
                    this.m_CurrentAttrContainer = this.m_CurrentFLD;
                    String string28 = attributes.getValue(this.tags.getTagById(16));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(16) + ": " + string28);
                    }
                    if ("anonymous".equalsIgnoreCase(string27)) {
                        this.m_CurrentFLD.setPersistentField(null, string28);
                    } else {
                        string25 = this.m_CurrentCLD.getClassNameOfObject();
                        this.m_CurrentFLD.setPersistentField(ClassHelper.getClass(string25), string28);
                    }
                    string25 = attributes.getValue(this.tags.getTagById(17));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(17) + ": " + string25);
                    }
                    this.m_CurrentFLD.setColumnName(string25);
                    String string29 = attributes.getValue(this.tags.getTagById(18));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(18) + ": " + string29);
                    }
                    this.m_CurrentFLD.setColumnType(string29);
                    String string30 = attributes.getValue(this.tags.getTagById(19));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(19) + ": " + string30);
                    }
                    boolean bl3 = new Boolean(string30);
                    this.m_CurrentFLD.setPrimaryKey(bl3);
                    String string31 = attributes.getValue(this.tags.getTagById(50));
                    if (string31 != null) {
                        if (bl) {
                            this.logger.debug("     " + this.tags.getTagById(50) + ": " + string31);
                        }
                        bl3 = new Boolean(string31) == false;
                        this.m_CurrentFLD.setRequired(bl3);
                    }
                    String string32 = attributes.getValue(this.tags.getTagById(51));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(51) + ": " + string32);
                    }
                    bl3 = new Boolean(string32);
                    this.m_CurrentFLD.setIndexed(bl3);
                    String string33 = attributes.getValue(this.tags.getTagById(31));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(31) + ": " + string33);
                    }
                    bl3 = new Boolean(string33);
                    this.m_CurrentFLD.setAutoIncrement(bl3);
                    String string34 = attributes.getValue(this.tags.getTagById(77));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(77) + ": " + string34);
                    }
                    this.m_CurrentFLD.setSequenceName(string34);
                    String string35 = attributes.getValue(this.tags.getTagById(46));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(46) + ": " + string35);
                    }
                    bl3 = new Boolean(string35);
                    this.m_CurrentFLD.setLocking(bl3);
                    String string36 = attributes.getValue(this.tags.getTagById(98));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(98) + ": " + string36);
                    }
                    bl3 = new Boolean(string36);
                    this.m_CurrentFLD.setUpdateLock(bl3);
                    String string37 = attributes.getValue(this.tags.getTagById(30));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(30) + ": " + string37);
                    }
                    if (string37 != null) {
                        this.m_CurrentFLD.setFieldConversionClassName(string37);
                    }
                    if ((string24 = attributes.getValue(this.tags.getTagById(52))) != null) {
                        int n = Integer.parseInt(string24);
                        if (bl) {
                            this.logger.debug("     " + this.tags.getTagById(52) + ": " + n);
                        }
                        this.m_CurrentFLD.setLength(n);
                        this.m_CurrentFLD.setLengthSpecified(true);
                    }
                    if ((string23 = attributes.getValue(this.tags.getTagById(53))) != null) {
                        int n = Integer.parseInt(string23);
                        if (bl) {
                            this.logger.debug("     " + this.tags.getTagById(53) + ": " + n);
                        }
                        this.m_CurrentFLD.setPrecision(n);
                        this.m_CurrentFLD.setPrecisionSpecified(true);
                    }
                    if ((string22 = attributes.getValue(this.tags.getTagById(54))) == null) break;
                    int n = Integer.parseInt(string22);
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(54) + ": " + n);
                    }
                    this.m_CurrentFLD.setScale(n);
                    this.m_CurrentFLD.setScaleSpecified(true);
                    break;
                }
                case 20: {
                    Object object;
                    if (bl) {
                        this.logger.debug("    > " + this.tags.getTagById(20));
                    }
                    string2 = attributes.getValue(this.tags.getTagById(16));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(16) + ": " + string2);
                    }
                    String string38 = attributes.getValue(this.tags.getTagById(22));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(22) + ": " + string38);
                    }
                    ObjectReferenceDescriptor objectReferenceDescriptor = null;
                    if (string2.equals("super")) {
                        this.checkThis(string38);
                        object = new AnonymousObjectReferenceDescriptor(this.m_CurrentCLD);
                        ((AnonymousObjectReferenceDescriptor)object).setPersistentField(null, "super");
                        objectReferenceDescriptor = object;
                    } else {
                        objectReferenceDescriptor = new ObjectReferenceDescriptor(this.m_CurrentCLD);
                        objectReferenceDescriptor.setPersistentField(this.m_CurrentCLD.getClassOfObject(), string2);
                    }
                    this.m_CurrentORD = objectReferenceDescriptor;
                    this.m_CurrentCLD.addObjectReferenceDescriptor(this.m_CurrentORD);
                    this.m_CurrentORD.setItemClass(ClassHelper.getClass(string38));
                    this.m_CurrentAttrContainer = this.m_CurrentORD;
                    object = attributes.getValue(this.tags.getTagById(48));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(48) + ": " + (String)object);
                    }
                    boolean bl4 = new Boolean((String)object);
                    this.m_CurrentORD.setLazy(bl4);
                    String string39 = attributes.getValue(this.tags.getTagById(114));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(114) + ": " + string39);
                    }
                    if (string39 == null) {
                        this.m_CurrentCLD.setProxyPrefetchingLimit(this.defProxyPrefetchingLimit);
                    } else {
                        this.m_CurrentCLD.setProxyPrefetchingLimit(Integer.parseInt(string39));
                    }
                    String string40 = attributes.getValue(this.tags.getTagById(47));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(47) + ": " + string40);
                    }
                    bl4 = new Boolean(string40);
                    this.m_CurrentORD.setRefresh(bl4);
                    String string41 = attributes.getValue(this.tags.getTagById(24));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(24) + ": " + string41);
                    }
                    bl4 = new Boolean(string41);
                    this.m_CurrentORD.setCascadeRetrieve(bl4);
                    String string42 = attributes.getValue(this.tags.getTagById(25));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(25) + ": " + string42);
                    }
                    bl4 = new Boolean(string42);
                    this.m_CurrentORD.setCascadeStore(bl4);
                    String string43 = attributes.getValue(this.tags.getTagById(26));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(26) + ": " + string43);
                    }
                    bl4 = new Boolean(string43);
                    this.m_CurrentORD.setCascadeDelete(bl4);
                    String string44 = attributes.getValue(this.tags.getTagById(102));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(102) + ": " + string44);
                    }
                    bl4 = new Boolean(string44);
                    this.m_CurrentORD.setOtmDependent(bl4);
                    break;
                }
                case 49: {
                    String string45;
                    if (bl) {
                        this.logger.debug("    > " + this.tags.getTagById(49));
                    }
                    if ((string45 = attributes.getValue(this.tags.getTagById(70))) != null) {
                        if (bl) {
                            this.logger.debug("      " + this.tags.getTagById(70) + ": " + string45);
                        }
                        try {
                            int n = Integer.parseInt(string45);
                            this.m_CurrentORD.addForeignKeyField(n);
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new MetadataException(this.tags.getTagById(70) + " attribute must be an int. Found: " + string45 + ". Please check your repository file.", numberFormatException);
                        }
                    }
                    String string46 = attributes.getValue(this.tags.getTagById(84));
                    if (bl) {
                        this.logger.debug("      " + this.tags.getTagById(84) + ": " + string46);
                    }
                    this.m_CurrentORD.addForeignKeyField(string46);
                    break;
                }
                case 27: {
                    if (bl) {
                        this.logger.debug("    > " + this.tags.getTagById(27));
                    }
                    this.m_CurrentCOD = new CollectionDescriptor(this.m_CurrentCLD);
                    this.m_CurrentAttrContainer = this.m_CurrentCOD;
                    string2 = attributes.getValue(this.tags.getTagById(16));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(16) + ": " + string2);
                    }
                    this.m_CurrentCOD.setPersistentField(this.m_CurrentCLD.getClassOfObject(), string2);
                    String string47 = attributes.getValue(this.tags.getTagById(37));
                    if (string47 != null) {
                        if (bl) {
                            this.logger.debug("     " + this.tags.getTagById(37) + ": " + string47);
                        }
                        this.m_CurrentCOD.setCollectionClass(ClassHelper.getClass(string47));
                    }
                    String string48 = attributes.getValue(this.tags.getTagById(29));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(29) + ": " + string48);
                    }
                    if (string48 != null) {
                        this.m_CurrentCOD.setItemClass(ClassHelper.getClass(string48));
                    }
                    String string49 = attributes.getValue(this.tags.getTagById(36));
                    String string50 = attributes.getValue(this.tags.getTagById(3));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(3) + ": " + string49 + ", " + string50);
                    }
                    if (string49 != null) {
                        this.m_CurrentCOD.addOrderBy(string49, "ASC".equalsIgnoreCase(string50));
                    }
                    String string51 = attributes.getValue(this.tags.getTagById(39));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(39) + ": " + string51);
                    }
                    this.m_CurrentCOD.setIndirectionTable(string51);
                    String string52 = attributes.getValue(this.tags.getTagById(48));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(48) + ": " + string52);
                    }
                    boolean bl5 = new Boolean(string52);
                    this.m_CurrentCOD.setLazy(bl5);
                    String string53 = attributes.getValue(this.tags.getTagById(114));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(114) + ": " + string53);
                    }
                    if (string53 == null) {
                        this.m_CurrentCLD.setProxyPrefetchingLimit(this.defProxyPrefetchingLimit);
                    } else {
                        this.m_CurrentCLD.setProxyPrefetchingLimit(Integer.parseInt(string53));
                    }
                    String string54 = attributes.getValue(this.tags.getTagById(47));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(47) + ": " + string54);
                    }
                    bl5 = new Boolean(string54);
                    this.m_CurrentCOD.setRefresh(bl5);
                    String string55 = attributes.getValue(this.tags.getTagById(24));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(24) + ": " + string55);
                    }
                    bl5 = new Boolean(string55);
                    this.m_CurrentCOD.setCascadeRetrieve(bl5);
                    String string56 = attributes.getValue(this.tags.getTagById(25));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(25) + ": " + string56);
                    }
                    bl5 = new Boolean(string56);
                    this.m_CurrentCOD.setCascadeStore(bl5);
                    String string57 = attributes.getValue(this.tags.getTagById(26));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(26) + ": " + string57);
                    }
                    bl5 = new Boolean(string57);
                    this.m_CurrentCOD.setCascadeDelete(bl5);
                    String string58 = attributes.getValue(this.tags.getTagById(102));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(102) + ": " + string58);
                    }
                    bl5 = new Boolean(string58);
                    this.m_CurrentCOD.setOtmDependent(bl5);
                    this.m_CurrentCLD.addCollectionDescriptor(this.m_CurrentCOD);
                    break;
                }
                case 36: {
                    if (bl) {
                        this.logger.debug("    > " + this.tags.getTagById(36));
                    }
                    string2 = attributes.getValue(this.tags.getTagById(16));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(16) + ": " + string2);
                    }
                    String string59 = attributes.getValue(this.tags.getTagById(3));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(3) + ": " + string2 + ", " + string59);
                    }
                    this.m_CurrentCOD.addOrderBy(string2, "ASC".equalsIgnoreCase(string59));
                    break;
                }
                case 38: {
                    String string60;
                    if (bl) {
                        this.logger.debug("    > " + this.tags.getTagById(38));
                    }
                    if ((string60 = attributes.getValue(this.tags.getTagById(70))) != null) {
                        if (bl) {
                            this.logger.debug("      " + this.tags.getTagById(70) + ": " + string60);
                        }
                        try {
                            int n = Integer.parseInt(string60);
                            this.m_CurrentCOD.addForeignKeyField(n);
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new MetadataException(this.tags.getTagById(70) + " attribute must be an int. Found: " + string60 + " Please check your repository file.", numberFormatException);
                        }
                    }
                    String string61 = attributes.getValue(this.tags.getTagById(84));
                    if (bl) {
                        this.logger.debug("      " + this.tags.getTagById(84) + ": " + string61);
                    }
                    this.m_CurrentCOD.addForeignKeyField(string61);
                    break;
                }
                case 41: {
                    if (bl) {
                        this.logger.debug("    > " + this.tags.getTagById(41));
                    }
                    String string62 = attributes.getValue("column");
                    if (bl) {
                        this.logger.debug("      column: " + string62);
                    }
                    this.m_CurrentCOD.addFkToThisClass(string62);
                    break;
                }
                case 40: {
                    if (bl) {
                        this.logger.debug("    > " + this.tags.getTagById(40));
                    }
                    String string63 = attributes.getValue("column");
                    if (bl) {
                        this.logger.debug("      column: " + string63);
                    }
                    this.m_CurrentCOD.addFkToItemClass(string63);
                    break;
                }
                case 71: {
                    String string64 = attributes.getValue(this.tags.getTagById(72));
                    String string65 = attributes.getValue(this.tags.getTagById(73));
                    if (this.m_CurrentAttrContainer != null) {
                        if (bl) {
                            this.logger.debug("    > " + this.tags.getTagById(71));
                        }
                        if (bl) {
                            this.logger.debug("     " + this.tags.getTagById(72) + ": " + string64);
                        }
                        if (bl) {
                            this.logger.debug("     " + this.tags.getTagById(73) + ": " + string65);
                        }
                        this.m_CurrentAttrContainer.addAttribute(string64, string65);
                        break;
                    }
                    this.logger.info("Found attribute (name=" + string64 + ", value=" + string65 + ") but I can not assign them to a descriptor");
                    break;
                }
                case 92: {
                    String string66 = attributes.getValue("class");
                    if (string66 == null) break;
                    if (bl) {
                        this.logger.debug("     class: " + string66);
                    }
                    QueryCustomizer queryCustomizer = (QueryCustomizer)ClassHelper.getClass(string66).newInstance();
                    this.m_CurrentAttrContainer = queryCustomizer;
                    this.m_CurrentCOD.setQueryCustomizer(queryCustomizer);
                    break;
                }
                case 94: {
                    this.m_CurrentIndexDescriptor = new IndexDescriptor();
                    this.m_CurrentIndexDescriptor.setName(attributes.getValue(this.tags.getTagById(97)));
                    this.m_CurrentIndexDescriptor.setUnique(new Boolean(attributes.getValue(this.tags.getTagById(96))));
                    break;
                }
                case 95: {
                    this.m_CurrentIndexDescriptor.getIndexColumns().add(attributes.getValue(this.tags.getTagById(97)));
                    break;
                }
                case 103: {
                    if (bl) {
                        this.logger.debug("    > " + this.tags.getTagById(103));
                    }
                    String string67 = attributes.getValue(this.tags.getTagById(97));
                    String string68 = attributes.getValue(this.tags.getTagById(109));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(97) + ": " + string67);
                    }
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(109) + ": " + string68);
                    }
                    InsertProcedureDescriptor insertProcedureDescriptor = new InsertProcedureDescriptor(this.m_CurrentCLD, string67, new Boolean(string68));
                    this.m_CurrentProcedure = insertProcedureDescriptor;
                    String string69 = attributes.getValue(this.tags.getTagById(108));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(108) + ": " + string69);
                    }
                    insertProcedureDescriptor.setReturnValueFieldRef(string69);
                    break;
                }
                case 104: {
                    if (bl) {
                        this.logger.debug("    > " + this.tags.getTagById(104));
                    }
                    String string70 = attributes.getValue(this.tags.getTagById(97));
                    String string71 = attributes.getValue(this.tags.getTagById(109));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(97) + ": " + string70);
                    }
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(109) + ": " + string71);
                    }
                    UpdateProcedureDescriptor updateProcedureDescriptor = new UpdateProcedureDescriptor(this.m_CurrentCLD, string70, new Boolean(string71));
                    this.m_CurrentProcedure = updateProcedureDescriptor;
                    String string72 = attributes.getValue(this.tags.getTagById(108));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(108) + ": " + string72);
                    }
                    updateProcedureDescriptor.setReturnValueFieldRef(string72);
                    break;
                }
                case 105: {
                    if (bl) {
                        this.logger.debug("    > " + this.tags.getTagById(104));
                    }
                    String string73 = attributes.getValue(this.tags.getTagById(97));
                    String string74 = attributes.getValue(this.tags.getTagById(110));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(97) + ": " + string73);
                    }
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(110) + ": " + string74);
                    }
                    DeleteProcedureDescriptor deleteProcedureDescriptor = new DeleteProcedureDescriptor(this.m_CurrentCLD, string73, new Boolean(string74));
                    this.m_CurrentProcedure = deleteProcedureDescriptor;
                    String string75 = attributes.getValue(this.tags.getTagById(108));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(108) + ": " + string75);
                    }
                    deleteProcedureDescriptor.setReturnValueFieldRef(string75);
                    break;
                }
                case 106: {
                    String string76 = null;
                    if (bl) {
                        this.logger.debug("    > " + this.tags.getTagById(106));
                    }
                    ArgumentDescriptor argumentDescriptor = new ArgumentDescriptor(this.m_CurrentProcedure);
                    string76 = attributes.getValue(this.tags.getTagById(112));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(112) + ": " + string76);
                    }
                    argumentDescriptor.setValue(string76);
                    this.m_CurrentProcedure.addArgument(argumentDescriptor);
                    break;
                }
                case 107: {
                    if (bl) {
                        this.logger.debug("    > " + this.tags.getTagById(107));
                    }
                    ArgumentDescriptor argumentDescriptor = new ArgumentDescriptor(this.m_CurrentProcedure);
                    String string77 = attributes.getValue(this.tags.getTagById(84));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(84) + ": " + string77);
                    }
                    String string78 = attributes.getValue(this.tags.getTagById(111));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(111) + ": " + string78);
                    }
                    if (string77 != null && string77.trim().length() != 0) {
                        argumentDescriptor.setValue(string77, new Boolean(string78));
                    }
                    this.m_CurrentProcedure.addArgument(argumentDescriptor);
                    break;
                }
            }
        }
        catch (Exception exception) {
            if (exception instanceof MetadataException) {
                throw (MetadataException)((Object)exception);
            }
            throw new MetadataException("Exception when reading metadata information, please check your repository.xml file", exception);
        }
    }

    public void endElement(String string, String string2, String string3) {
        boolean bl = this.logger.isDebugEnabled();
        try {
            switch (this.getLiteralId(string3)) {
                case 0: {
                    if (bl) {
                        this.logger.debug(" < " + this.tags.getTagById(0));
                    }
                    this.m_CurrentAttrContainer = null;
                    this.m_CurrentCLD = null;
                    break;
                }
                case 12: {
                    if (bl) {
                        this.logger.debug("  < " + this.tags.getTagById(12));
                    }
                    this.m_CurrentCLD = null;
                    this.m_CurrentAttrContainer = null;
                    break;
                }
                case 113: {
                    if (bl) {
                        this.logger.debug("    < " + this.tags.getTagById(113));
                    }
                    this.m_CurrentAttrContainer = this.m_CurrentCLD;
                    break;
                }
                case 33: {
                    break;
                }
                case 15: {
                    if (bl) {
                        this.logger.debug("    < " + this.tags.getTagById(15));
                    }
                    this.m_CurrentFLD = null;
                    this.m_CurrentAttrContainer = this.m_CurrentCLD;
                    break;
                }
                case 20: {
                    if (bl) {
                        this.logger.debug("    < " + this.tags.getTagById(20));
                    }
                    this.m_CurrentORD = null;
                    this.m_CurrentAttrContainer = this.m_CurrentCLD;
                    break;
                }
                case 49: {
                    if (bl) {
                        this.logger.debug("    < " + this.tags.getTagById(49));
                    }
                    break;
                }
                case 27: {
                    if (bl) {
                        this.logger.debug("    < " + this.tags.getTagById(27));
                    }
                    this.m_CurrentCOD = null;
                    this.m_CurrentAttrContainer = this.m_CurrentCLD;
                    break;
                }
                case 38: {
                    if (bl) {
                        this.logger.debug("    < " + this.tags.getTagById(38));
                    }
                    break;
                }
                case 36: {
                    if (bl) {
                        this.logger.debug("    < " + this.tags.getTagById(36));
                    }
                    break;
                }
                case 41: {
                    if (bl) {
                        this.logger.debug("    < " + this.tags.getTagById(41));
                    }
                    break;
                }
                case 40: {
                    if (bl) {
                        this.logger.debug("    < " + this.tags.getTagById(40));
                    }
                    break;
                }
                case 71: {
                    if (bl) {
                        this.logger.debug("    < " + this.tags.getTagById(71));
                    }
                    break;
                }
                case 75: {
                    if (bl) {
                        this.logger.debug("    < " + this.tags.getTagById(75));
                    }
                    break;
                }
                case 88: {
                    this.m_CurrentAttrContainer = null;
                    break;
                }
                case 65: {
                    this.m_CurrentAttrContainer = null;
                    break;
                }
                case 1: {
                    if (bl) {
                        this.logger.debug("    < " + this.tags.getTagById(75));
                    }
                    this.m_CurrentAttrContainer = null;
                    break;
                }
                case 92: {
                    this.m_CurrentAttrContainer = this.m_CurrentCOD;
                    break;
                }
                case 94: {
                    this.m_CurrentCLD.getIndexes().add(this.m_CurrentIndexDescriptor);
                    this.m_CurrentIndexDescriptor = null;
                    break;
                }
                case 95: {
                    break;
                }
                case 103: {
                    if (bl) {
                        this.logger.debug("    < " + this.tags.getTagById(103));
                    }
                    this.m_CurrentCLD.setInsertProcedure((InsertProcedureDescriptor)this.m_CurrentProcedure);
                    this.m_CurrentProcedure = null;
                    break;
                }
                case 104: {
                    if (bl) {
                        this.logger.debug("    < " + this.tags.getTagById(104));
                    }
                    this.m_CurrentCLD.setUpdateProcedure((UpdateProcedureDescriptor)this.m_CurrentProcedure);
                    this.m_CurrentProcedure = null;
                    break;
                }
                case 105: {
                    if (bl) {
                        this.logger.debug("    < " + this.tags.getTagById(105));
                    }
                    this.m_CurrentCLD.setDeleteProcedure((DeleteProcedureDescriptor)this.m_CurrentProcedure);
                    this.m_CurrentProcedure = null;
                    break;
                }
                case 106: {
                    if (bl) {
                        this.logger.debug("    < " + this.tags.getTagById(106));
                    }
                    break;
                }
                case 107: {
                    if (bl) {
                        this.logger.debug("    < " + this.tags.getTagById(107));
                    }
                    break;
                }
                default: {
                    this.logger.info("Ignoring unused Element " + string3);
                    break;
                }
            }
        }
        catch (Exception exception) {
            if (exception instanceof MetadataException) {
                throw (MetadataException)((Object)exception);
            }
            throw new MetadataException("Exception when reading metadata information, please check your repository.xml file", exception);
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        this.m_CurrentString = this.m_CurrentString == null ? new String(cArray, n, n2) : this.m_CurrentString + new String(cArray, n, n2);
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        this.logger.error(sAXParseException);
        throw sAXParseException;
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.logger.fatal(sAXParseException);
        throw sAXParseException;
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.logger.warn(sAXParseException);
        throw sAXParseException;
    }

    private int getIsoLevel(String string) {
        if (string.equalsIgnoreCase("read-uncommitted")) {
            return 0;
        }
        if (string.equalsIgnoreCase("read-committed")) {
            return 1;
        }
        if (string.equalsIgnoreCase("repeatable-read")) {
            return 2;
        }
        if (string.equalsIgnoreCase("serializable")) {
            return 3;
        }
        if (string.equalsIgnoreCase("optimistic")) {
            return 4;
        }
        this.logger.warn("unknown isolation-level: " + string + " using RW_UNCOMMITTED as default");
        return this.defIsoLevel;
    }

    private boolean checkString(String string) {
        return string != null && !string.trim().equals("");
    }

    private void checkThis(String string) {
        Class clazz = this.m_CurrentCLD.getClassOfObject();
        String string2 = clazz.getSuperclass().getName();
        if (string2.equals(string)) {
            if (null != this.m_CurrentCLD.getBaseClass()) {
                throw new MetadataException("Multiple anonymous reference descriptor not authorized in " + clazz.getName());
            }
        } else {
            if (string2.equalsIgnoreCase(string)) {
                throw new MetadataException("Classes name are case sensitive: super class of " + clazz.getName() + " is " + string2 + " not " + string);
            }
            throw new MetadataException("Class " + string + " is not a superclass of class " + clazz.getName());
        }
        this.m_CurrentCLD.setBaseClass(string2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

