/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata;

import java.util.Hashtable;
import java.util.Vector;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.metadata.AttributeDescriptorBase;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.RepositoryTags;
import org.apache.ojb.broker.metadata.XmlCapable;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;

public class ObjectReferenceDescriptor
extends AttributeDescriptorBase
implements XmlCapable {
    private Class m_ClassOfItems = null;
    private Vector m_ForeignKeyFields = new Vector();
    private boolean m_CascadeRetrieve = true;
    private boolean m_CascadeStore = false;
    private boolean m_CascadeDelete = false;
    private int m_ProxyPrefetchingLimit = 50;
    private Class m_ProxyOfItems = null;
    private boolean m_LookedUpProxy = false;
    private boolean m_OtmDependent = false;
    private Hashtable fkFieldMap = new Hashtable();
    private boolean lazy = false;
    private boolean refresh = false;

    public ObjectReferenceDescriptor(ClassDescriptor classDescriptor) {
        super(classDescriptor);
    }

    public Class getItemProxyClass() throws PersistenceBrokerException {
        if (!this.m_LookedUpProxy) {
            this.m_ProxyOfItems = this.getClassDescriptor().getRepository().getDescriptorFor(this.m_ClassOfItems).getProxyClass();
            this.m_LookedUpProxy = true;
        }
        return this.m_ProxyOfItems;
    }

    public FieldDescriptor[] getForeignKeyFieldDescriptors(ClassDescriptor classDescriptor) {
        Vector vector;
        FieldDescriptor[] fieldDescriptorArray = null;
        fieldDescriptorArray = (FieldDescriptor[])this.fkFieldMap.get(classDescriptor);
        if (fieldDescriptorArray == null && (vector = this.getForeignKeyFields()) != null) {
            Class<Object> clazz;
            Object object;
            if (classDescriptor.isInterface()) {
                object = classDescriptor.getExtentClasses();
                clazz = (Class)((Vector)object).get(0);
                classDescriptor = this.getClassDescriptor().getRepository().getDescriptorFor(clazz);
            }
            Vector<FieldDescriptor> vector2 = new Vector<FieldDescriptor>();
            object = vector.iterator();
            while (object.hasNext()) {
                FieldDescriptor fieldDescriptor;
                clazz = object.next();
                if (clazz instanceof Integer) {
                    Integer n = (Integer)((Object)clazz);
                    fieldDescriptor = classDescriptor.getFieldDescriptorByIndex(n);
                } else {
                    fieldDescriptor = classDescriptor.getFieldDescriptorByName((String)((Object)clazz));
                }
                if (fieldDescriptor == null) {
                    throw new OJBRuntimeException("Incorrect field reference \"" + clazz + "\" in " + this);
                }
                vector2.add(fieldDescriptor);
            }
            fieldDescriptorArray = vector2.toArray(new FieldDescriptor[vector2.size()]);
            this.fkFieldMap.put(classDescriptor, fieldDescriptorArray);
        }
        return fieldDescriptorArray;
    }

    public Object[] getForeignKeyValues(Object object, ClassDescriptor classDescriptor) throws PersistenceBrokerException {
        FieldDescriptor[] fieldDescriptorArray = this.getForeignKeyFieldDescriptors(classDescriptor);
        Object[] objectArray = new Object[fieldDescriptorArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            Object object2;
            FieldDescriptor fieldDescriptor = fieldDescriptorArray[i];
            PersistentField persistentField = fieldDescriptor.getPersistentField();
            objectArray[i] = object2 = persistentField.get(object);
        }
        return objectArray;
    }

    public Class getItemClass() {
        return this.m_ClassOfItems;
    }

    public String getItemClassName() {
        return this.m_ClassOfItems != null ? this.m_ClassOfItems.getName() : null;
    }

    public void setItemClass(Class clazz) {
        this.m_ClassOfItems = clazz;
    }

    public Vector getForeignKeyFields() {
        return this.m_ForeignKeyFields;
    }

    public void setForeignKeyFields(Vector vector) {
        this.m_ForeignKeyFields = vector;
    }

    public void addForeignKeyField(int n) {
        if (this.m_ForeignKeyFields == null) {
            this.m_ForeignKeyFields = new Vector();
        }
        this.m_ForeignKeyFields.add(new Integer(n));
    }

    public void addForeignKeyField(String string) {
        if (this.m_ForeignKeyFields == null) {
            this.m_ForeignKeyFields = new Vector();
        }
        this.m_ForeignKeyFields.add(string);
    }

    public boolean isRefresh() {
        return this.refresh;
    }

    public void setRefresh(boolean bl) {
        this.refresh = bl;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public void setLazy(boolean bl) {
        this.lazy = bl;
    }

    public boolean getCascadeRetrieve() {
        return this.m_CascadeRetrieve;
    }

    public void setCascadeRetrieve(boolean bl) {
        this.m_CascadeRetrieve = bl;
    }

    public boolean getCascadeStore() {
        return this.m_CascadeStore;
    }

    public void setCascadeStore(boolean bl) {
        this.m_CascadeStore = bl;
    }

    public boolean getCascadeDelete() {
        return this.m_CascadeDelete;
    }

    public void setCascadeDelete(boolean bl) {
        this.m_CascadeDelete = bl;
    }

    public int getProxyPrefetchingLimit() {
        return this.m_ProxyPrefetchingLimit;
    }

    public void setProxyPrefetchingLimit(int n) {
        this.m_ProxyPrefetchingLimit = n;
    }

    public boolean getOtmDependent() {
        return this.m_OtmDependent;
    }

    public void setOtmDependent(boolean bl) {
        this.m_OtmDependent = bl;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("cascade delete", this.m_CascadeDelete).append("cascade retrieve", this.m_CascadeRetrieve).append("cascade store", this.m_CascadeStore).append("is lazy", this.lazy).append("class of Items", (Object)this.m_ClassOfItems).toString();
    }

    public String toXML() {
        RepositoryTags repositoryTags = RepositoryTags.getInstance();
        String string = System.getProperty("line.separator");
        String string2 = "      " + repositoryTags.getOpeningTagNonClosingById(20) + string;
        String string3 = this.getAttributeName();
        if (string3 == null) {
            string3 = "super";
        }
        string2 = string2 + "        " + repositoryTags.getAttribute(16, string3) + string;
        string2 = string2 + "        " + repositoryTags.getAttribute(22, this.getItemClassName()) + string;
        if (this.isLazy()) {
            string2 = string2 + "        " + repositoryTags.getAttribute(48, "true") + string;
            string2 = string2 + "        " + repositoryTags.getAttribute(114, "" + this.getProxyPrefetchingLimit()) + string;
        }
        if (this.isRefresh()) {
            string2 = string2 + "        " + repositoryTags.getAttribute(47, "true") + string;
        }
        if (!this.getCascadeRetrieve()) {
            string2 = string2 + "        " + repositoryTags.getAttribute(24, "false") + string;
        }
        if (this.getCascadeStore()) {
            string2 = string2 + "        " + repositoryTags.getAttribute(25, "true") + string;
        }
        if (this.getCascadeDelete()) {
            string2 = string2 + "        " + repositoryTags.getAttribute(26, "true") + string;
        }
        if (this.getOtmDependent()) {
            string2 = string2 + "        " + repositoryTags.getAttribute(102, "true") + string;
        }
        string2 = string2 + "      >" + string;
        for (int i = 0; i < this.getForeignKeyFields().size(); ++i) {
            String string4;
            Object e = this.getForeignKeyFields().get(i);
            if (e instanceof Integer) {
                string4 = e.toString();
                string2 = string2 + "        " + repositoryTags.getOpeningTagNonClosingById(49) + " ";
                string2 = string2 + repositoryTags.getAttribute(70, string4) + "/>" + string;
                continue;
            }
            string4 = (String)e;
            string2 = string2 + "        " + repositoryTags.getOpeningTagNonClosingById(49) + " ";
            string2 = string2 + repositoryTags.getAttribute(84, string4) + "/>" + string;
        }
        string2 = string2 + "      " + repositoryTags.getClosingTagById(20) + string;
        return string2;
    }
}

