/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.SerializationUtils;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.core.PersistenceBrokerConfiguration;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.ConnectionRepository;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.metadata.RepositoryPersistor;
import org.apache.ojb.broker.util.configuration.impl.OjbConfigurator;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class MetadataManager {
    private static Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$metadata$MetadataManager == null ? (class$org$apache$ojb$broker$metadata$MetadataManager = MetadataManager.class$("org.apache.ojb.broker.metadata.MetadataManager")) : class$org$apache$ojb$broker$metadata$MetadataManager);
    private static ThreadLocal threadedRepository = new ThreadLocal();
    private static MetadataManager singleton = new MetadataManager();
    private Hashtable metadataProfiles;
    private DescriptorRepository globalRepository;
    private ConnectionRepository connectionRepository;
    private boolean enablePerThreadChanges;
    private PBKey defaultPBKey;
    static /* synthetic */ Class class$org$apache$ojb$broker$metadata$MetadataManager;

    private MetadataManager() {
        this.init();
    }

    private void init() {
        this.metadataProfiles = new Hashtable();
        String string = ((PersistenceBrokerConfiguration)((Object)OjbConfigurator.getInstance().getConfigurationFor(null))).getRepositoryFilename();
        try {
            this.globalRepository = new RepositoryPersistor().readDescriptorRepository(string);
        }
        catch (Exception exception) {
            throw new MetadataException("Can not read repository class descriptor data, using repository: " + string, exception);
        }
        try {
            this.connectionRepository = new RepositoryPersistor().readConnectionRepository(string);
        }
        catch (Exception exception) {
            throw new MetadataException("Can not read jdbc-connection-descriptor data, using repository: " + string, exception);
        }
        this.defaultPBKey = this.buildDefaultKey();
    }

    public static MetadataManager getInstance() {
        return singleton;
    }

    public DescriptorRepository getRepository() {
        if (this.enablePerThreadChanges) {
            DescriptorRepository descriptorRepository = (DescriptorRepository)threadedRepository.get();
            if (descriptorRepository == null) {
                descriptorRepository = this.getGlobalRepository();
                log.info("Can't find DescriptorRepository for current thread, use default one");
            }
            return descriptorRepository;
        }
        return this.globalRepository;
    }

    public DescriptorRepository getGlobalRepository() {
        return this.globalRepository;
    }

    public ConnectionRepository connectionRepository() {
        return this.connectionRepository;
    }

    public void mergeConnectionRepository(ConnectionRepository connectionRepository) {
        this.mergeConnectionRepository(this.connectionRepository(), connectionRepository, false);
    }

    public void mergeConnectionRepository(ConnectionRepository connectionRepository, ConnectionRepository connectionRepository2, boolean bl) {
        List list = connectionRepository2.getAllDescriptor();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            JdbcConnectionDescriptor jdbcConnectionDescriptor = (JdbcConnectionDescriptor)iterator.next();
            if (bl) {
                jdbcConnectionDescriptor = (JdbcConnectionDescriptor)SerializationUtils.clone((Serializable)jdbcConnectionDescriptor);
            }
            connectionRepository.addDescriptor(jdbcConnectionDescriptor);
        }
    }

    public void mergeDescriptorRepository(DescriptorRepository descriptorRepository) {
        this.mergeDescriptorRepository(this.getRepository(), descriptorRepository, false);
    }

    public void mergeDescriptorRepository(DescriptorRepository descriptorRepository, DescriptorRepository descriptorRepository2, boolean bl) {
        Iterator iterator = descriptorRepository2.iterator();
        while (iterator.hasNext()) {
            ClassDescriptor classDescriptor = (ClassDescriptor)iterator.next();
            if (bl) {
                classDescriptor = (ClassDescriptor)SerializationUtils.clone((Serializable)classDescriptor);
            }
            descriptorRepository.put(classDescriptor.getClassOfObject(), classDescriptor);
            classDescriptor.setRepository(descriptorRepository);
        }
    }

    public DescriptorRepository readDescriptorRepository(String string) {
        try {
            RepositoryPersistor repositoryPersistor = new RepositoryPersistor();
            return repositoryPersistor.readDescriptorRepository(string);
        }
        catch (Exception exception) {
            throw new MetadataException("Can not read repository " + string, exception);
        }
    }

    public DescriptorRepository readDescriptorRepository(InputStream inputStream) {
        try {
            RepositoryPersistor repositoryPersistor = new RepositoryPersistor();
            return repositoryPersistor.readDescriptorRepository(inputStream);
        }
        catch (Exception exception) {
            throw new MetadataException("Can not read repository " + inputStream, exception);
        }
    }

    public ConnectionRepository readConnectionRepository(String string) {
        try {
            RepositoryPersistor repositoryPersistor = new RepositoryPersistor();
            return repositoryPersistor.readConnectionRepository(string);
        }
        catch (Exception exception) {
            throw new MetadataException("Can not read repository " + string, exception);
        }
    }

    public ConnectionRepository readConnectionRepository(InputStream inputStream) {
        try {
            RepositoryPersistor repositoryPersistor = new RepositoryPersistor();
            return repositoryPersistor.readConnectionRepository(inputStream);
        }
        catch (Exception exception) {
            throw new MetadataException("Can not read repository from " + inputStream, exception);
        }
    }

    public void setDescriptor(DescriptorRepository descriptorRepository, boolean bl) {
        if (bl) {
            if (log.isDebugEnabled()) {
                log.debug("Set new global repository: " + descriptorRepository);
            }
            this.globalRepository = descriptorRepository;
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Set new threaded repository: " + descriptorRepository);
            }
            threadedRepository.set(descriptorRepository);
        }
    }

    public void setDescriptor(DescriptorRepository descriptorRepository) {
        this.setDescriptor(descriptorRepository, false);
    }

    public void setPerThreadDescriptor(DescriptorRepository descriptorRepository) {
        this.setDescriptor(descriptorRepository, false);
    }

    public DescriptorRepository copyOfGlobalRepository() {
        return (DescriptorRepository)SerializationUtils.clone((Serializable)this.globalRepository);
    }

    public boolean isEnablePerThreadChanges() {
        return this.enablePerThreadChanges;
    }

    public void setEnablePerThreadChanges(boolean bl) {
        this.enablePerThreadChanges = bl;
    }

    public void addProfile(Object object, DescriptorRepository descriptorRepository) {
        if (this.metadataProfiles.contains(object)) {
            throw new MetadataException("Duplicate profile key. Key '" + object + "' already exists.");
        }
        this.metadataProfiles.put(object, descriptorRepository);
    }

    public void loadProfile(Object object) {
        if (!this.isEnablePerThreadChanges()) {
            throw new MetadataException("Can not load profile with disabled per thread mode");
        }
        DescriptorRepository descriptorRepository = (DescriptorRepository)this.metadataProfiles.get(object);
        if (descriptorRepository == null) {
            throw new MetadataException("Can not find profile for key '" + object + "'");
        }
        this.setDescriptor(descriptorRepository);
    }

    public DescriptorRepository removeProfile(Object object) {
        return (DescriptorRepository)this.metadataProfiles.remove(object);
    }

    public void removeAllProfiles() {
        this.metadataProfiles.clear();
    }

    public PBKey getDefaultPBKey() {
        return this.defaultPBKey;
    }

    public void setDefaultPBKey(PBKey pBKey) {
        if (this.defaultPBKey != null) {
            throw new MetadataException("Default key is already set. Current key is " + this.defaultPBKey);
        }
        this.defaultPBKey = pBKey;
        log.info("Set default PBKey for convenience broker creation: " + pBKey);
    }

    private PBKey buildDefaultKey() {
        List list = this.connectionRepository().getAllDescriptor();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            JdbcConnectionDescriptor jdbcConnectionDescriptor = (JdbcConnectionDescriptor)iterator.next();
            if (!jdbcConnectionDescriptor.isDefaultConnection()) continue;
            return new PBKey(jdbcConnectionDescriptor.getJcdAlias(), jdbcConnectionDescriptor.getUserName(), jdbcConnectionDescriptor.getPassWord());
        }
        log.info("No 'default-connection' attribute set in jdbc-connection-descriptors, thus it's currently not possible to use 'defaultPersistenceBroker()'  convenience method to lookup PersistenceBroker instances. But it's possible to enable this at runtime using 'setDefaultKey' method.");
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

