/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata;

import java.io.Serializable;
import java.util.Comparator;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.accesslayer.conversions.FieldConversion;
import org.apache.ojb.broker.accesslayer.conversions.FieldConversionDefaultImpl;
import org.apache.ojb.broker.metadata.AttributeDescriptorBase;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.metadata.RepositoryTags;
import org.apache.ojb.broker.metadata.XmlCapable;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.SqlTypeHelper;

public class FieldDescriptor
extends AttributeDescriptorBase
implements XmlCapable,
Serializable {
    public static final String ACCESS_ANONYMOUS = "anonymous";
    public static final String ACCESS_READONLY = "readonly";
    public static final String ACCESS_READWRITE = "readwrite";
    private int m_ColNo;
    private String m_ColumnName;
    private String m_ColumnType;
    private boolean m_IsKeyField = false;
    private boolean indexed = false;
    private boolean m_autoIncrement = false;
    private String m_sequenceName;
    private int m_ColumnTypeId = -99999;
    private int length = 0;
    private int precision = 0;
    private int scale = 0;
    private boolean required = false;
    private boolean scaleSpecified = false;
    private boolean precisionSpecified = false;
    private boolean lengthSpecified = false;
    private FieldConversion fieldConversion = null;
    private boolean m_locking = false;
    private boolean updateLock = true;
    private String m_access;
    static /* synthetic */ Class class$org$apache$ojb$broker$accesslayer$conversions$FieldConversionDefaultImpl;

    public static Comparator getComparator() {
        return new Comparator(){

            public int compare(Object object, Object object2) {
                FieldDescriptor fieldDescriptor = (FieldDescriptor)object;
                FieldDescriptor fieldDescriptor2 = (FieldDescriptor)object2;
                if (fieldDescriptor.getColNo() < fieldDescriptor2.getColNo()) {
                    return -1;
                }
                if (fieldDescriptor.getColNo() > fieldDescriptor2.getColNo()) {
                    return 1;
                }
                return 0;
            }
        };
    }

    public FieldDescriptor(ClassDescriptor classDescriptor, int n) {
        super(classDescriptor);
        this.m_ColNo = n;
    }

    public String getColumnName() {
        return this.m_ColumnName;
    }

    public String getFullColumnName() {
        return this.getClassDescriptor().getFullTableName() + "." + this.getColumnName();
    }

    public void setColumnName(String string) {
        this.m_ColumnName = string;
    }

    public String getColumnType() {
        return this.m_ColumnType;
    }

    public void setColumnType(String string) {
        this.m_ColumnType = string;
    }

    public int getColumnJdbcType() {
        if (this.m_ColumnTypeId == -99999) {
            this.m_ColumnTypeId = this.getSqlType();
        }
        return this.m_ColumnTypeId;
    }

    private int getSqlType() {
        int n = Integer.MIN_VALUE;
        String string = this.getColumnType();
        n = string == null ? SqlTypeHelper.getSqlTypeByReflection(this.m_PersistentField.getType().getName()) : SqlTypeHelper.getSqlTypeByName(string);
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        stringBuffer.append(ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.DEFAULT_STYLE));
        stringBuffer.append(", " + super.toString());
        stringBuffer.append(SystemUtils.LINE_SEPARATOR + " --> belonging class was ");
        stringBuffer.append(this.getClassDescriptor().getClassNameOfObject());
        stringBuffer.append("]" + SystemUtils.LINE_SEPARATOR);
        return stringBuffer.toString();
    }

    public FieldConversion getFieldConversion() {
        if (this.fieldConversion == null) {
            this.fieldConversion = new FieldConversionDefaultImpl();
        }
        return this.fieldConversion;
    }

    public void setFieldConversion(FieldConversion fieldConversion) {
        this.fieldConversion = fieldConversion;
    }

    public void setFieldConversionClassName(String string) {
        try {
            this.fieldConversion = (FieldConversion)ClassHelper.newInstance(string);
        }
        catch (Exception exception) {
            throw new MetadataException("Could not instantiate FieldConversion class using default constructor", exception);
        }
    }

    public boolean isIndexed() {
        return this.indexed;
    }

    public void setIndexed(boolean bl) {
        this.indexed = bl;
    }

    public boolean isAutoIncrement() {
        return this.m_autoIncrement;
    }

    public void setAutoIncrement(boolean bl) {
        this.m_autoIncrement = bl;
    }

    public String getSequenceName() {
        return this.m_sequenceName;
    }

    public void setSequenceName(String string) {
        this.m_sequenceName = string;
    }

    public boolean isPrimaryKey() {
        return this.m_IsKeyField;
    }

    public void setPrimaryKey(boolean bl) {
        this.m_IsKeyField = bl;
    }

    public int getColNo() {
        return this.m_ColNo;
    }

    public boolean isLocking() {
        return this.m_locking;
    }

    public void setLocking(boolean bl) {
        this.m_locking = bl;
    }

    public boolean isUpdateLock() {
        return this.updateLock;
    }

    public void setUpdateLock(boolean bl) {
        this.updateLock = bl;
    }

    public void setLength(int n) {
        this.length = n;
    }

    public int getLength() {
        return this.length;
    }

    public void setPrecision(int n) {
        this.precision = n;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setScale(int n) {
        this.scale = n;
    }

    public int getScale() {
        return this.scale;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean bl) {
        this.required = bl;
    }

    public boolean isScaleSpecified() {
        return this.scaleSpecified;
    }

    public void setScaleSpecified(boolean bl) {
        this.scaleSpecified = bl;
    }

    public boolean isPrecisionSpecified() {
        return this.precisionSpecified;
    }

    public void setPrecisionSpecified(boolean bl) {
        this.precisionSpecified = bl;
    }

    public boolean isLengthSpecified() {
        return this.lengthSpecified;
    }

    public void setLengthSpecified(boolean bl) {
        this.lengthSpecified = bl;
    }

    public String getAccess() {
        return this.m_access;
    }

    public void setAccess(String string) {
        if (string == null) {
            string = ACCESS_READWRITE;
        }
        if (!(ACCESS_ANONYMOUS.equals(string) || ACCESS_READONLY.equals(string) || ACCESS_READWRITE.equals(string))) {
            throw new OJBRuntimeException("Try to set unkown field 'access' value: " + string);
        }
        this.m_access = string;
    }

    public boolean isAccessReadOnly() {
        return ACCESS_READONLY.equals(this.getAccess());
    }

    public String toXML() {
        RepositoryTags repositoryTags = RepositoryTags.getInstance();
        String string = SystemUtils.LINE_SEPARATOR;
        String string2 = "      " + repositoryTags.getOpeningTagNonClosingById(15) + " " + string;
        string2 = string2 + "        " + repositoryTags.getAttribute(16, this.getAttributeName()) + string;
        string2 = string2 + "        " + repositoryTags.getAttribute(17, this.getColumnName()) + string;
        string2 = string2 + "        " + repositoryTags.getAttribute(18, this.getColumnType()) + string;
        if (this.isPrimaryKey()) {
            string2 = string2 + "        " + repositoryTags.getAttribute(19, "true") + string;
        }
        if (this.isRequired()) {
            string2 = string2 + "        " + repositoryTags.getAttribute(50, "false") + string;
        }
        if (this.isAutoIncrement()) {
            string2 = string2 + "        " + repositoryTags.getAttribute(31, "true") + string;
        }
        if (this.isLocking()) {
            string2 = string2 + "        " + repositoryTags.getAttribute(46, "true") + string;
        }
        if (!this.isUpdateLock()) {
            string2 = string2 + "        " + repositoryTags.getAttribute(98, "false") + string;
        }
        if (this.getFieldConversion().getClass() != (class$org$apache$ojb$broker$accesslayer$conversions$FieldConversionDefaultImpl == null ? (class$org$apache$ojb$broker$accesslayer$conversions$FieldConversionDefaultImpl = FieldDescriptor.class$("org.apache.ojb.broker.accesslayer.conversions.FieldConversionDefaultImpl")) : class$org$apache$ojb$broker$accesslayer$conversions$FieldConversionDefaultImpl)) {
            string2 = string2 + "        " + repositoryTags.getAttribute(30, this.getFieldConversion().getClass().getName()) + string;
        }
        if (this.isLengthSpecified()) {
            string2 = string2 + "        " + repositoryTags.getAttribute(52, "" + this.getLength()) + string;
        }
        if (this.isPrecisionSpecified()) {
            string2 = string2 + "        " + repositoryTags.getAttribute(53, "" + this.getPrecision()) + string;
        }
        if (this.isScaleSpecified()) {
            string2 = string2 + "        " + repositoryTags.getAttribute(54, "" + this.getScale()) + string;
        }
        string2 = string2 + "        " + repositoryTags.getAttribute(99, this.getAccess()) + string;
        string2 = string2 + "      />" + string;
        return string2;
    }

    public Object clone() {
        return SerializationUtils.deserialize((byte[])SerializationUtils.serialize((Serializable)this));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

