/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.ClassNotPersistenceCapableException;
import org.apache.ojb.broker.metadata.DescriptorBase;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.IsolationLevels;
import org.apache.ojb.broker.metadata.XmlCapable;

public final class DescriptorRepository
extends DescriptorBase
implements Serializable,
XmlCapable,
IsolationLevels {
    private static final String VERSION = "1.0";
    private int defaultIsolationLevel = 0;
    private Hashtable descriptorTable = new Hashtable();
    private HashMap extentTable = new HashMap();
    private Map m_multiMappedTableMap = new HashMap();
    private Map m_extentClassTable = new HashMap();

    public static String getVersion() {
        return VERSION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addExtent(String string, ClassDescriptor classDescriptor) {
        HashMap hashMap = this.extentTable;
        synchronized (hashMap) {
            this.extentTable.put(string, classDescriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class getTopLevelClass(Class clazz) throws ClassNotPersistenceCapableException {
        Class clazz2 = (Class)this.m_extentClassTable.get(clazz);
        if (clazz2 == null) {
            HashMap hashMap = this.extentTable;
            synchronized (hashMap) {
                ClassDescriptor classDescriptor = (ClassDescriptor)this.extentTable.get(clazz.getName());
                if (classDescriptor != null) {
                    clazz2 = this.getTopLevelClass(classDescriptor.getClassOfObject());
                    if (clazz2 == null) {
                        clazz2 = clazz;
                    }
                } else {
                    this.getDescriptorFor(clazz);
                    clazz2 = clazz;
                }
                this.m_extentClassTable.put(clazz, clazz2);
            }
        }
        return clazz2;
    }

    public FieldDescriptor[] getFieldDescriptorsForMultiMappedTable(ClassDescriptor classDescriptor) {
        FieldDescriptor[] fieldDescriptorArray = (FieldDescriptor[])this.m_multiMappedTableMap.get(classDescriptor);
        if (fieldDescriptorArray == null) {
            fieldDescriptorArray = this.getAllMappedColumns(this.getClassesMappedToSameTable(classDescriptor));
            this.m_multiMappedTableMap.put(classDescriptor, fieldDescriptorArray);
        }
        return fieldDescriptorArray;
    }

    private FieldDescriptor[] getAllMappedColumns(List list) {
        Iterator iterator = list.iterator();
        HashMap<String, FieldDescriptor> hashMap = new HashMap<String, FieldDescriptor>();
        ClassDescriptor classDescriptor = null;
        while (iterator.hasNext()) {
            classDescriptor = (ClassDescriptor)iterator.next();
            FieldDescriptor[] fieldDescriptorArray = classDescriptor.getFieldDescriptions();
            if (fieldDescriptorArray == null) continue;
            for (int i = 0; i < fieldDescriptorArray.length; ++i) {
                hashMap.put(fieldDescriptorArray[i].getColumnName(), fieldDescriptorArray[i]);
            }
        }
        Iterator iterator2 = hashMap.values().iterator();
        FieldDescriptor[] fieldDescriptorArray = new FieldDescriptor[hashMap.size()];
        int n = 0;
        while (iterator2.hasNext()) {
            fieldDescriptorArray[n] = (FieldDescriptor)iterator2.next();
            ++n;
        }
        return fieldDescriptorArray;
    }

    private List getClassesMappedToSameTable(ClassDescriptor classDescriptor) {
        Iterator iterator = this.descriptorTable.values().iterator();
        ArrayList<ClassDescriptor> arrayList = new ArrayList<ClassDescriptor>();
        while (iterator.hasNext()) {
            ClassDescriptor classDescriptor2 = (ClassDescriptor)iterator.next();
            if (classDescriptor2.getFullTableName() == null || !classDescriptor2.getFullTableName().equals(classDescriptor.getFullTableName())) continue;
            arrayList.add(classDescriptor2);
        }
        return arrayList;
    }

    public Hashtable getDescriptorTable() {
        return this.descriptorTable;
    }

    public List getConcreteSubclassesOf(Class clazz) {
        ArrayList<Class> arrayList = new ArrayList<Class>();
        ClassDescriptor classDescriptor = this.getDescriptorFor(clazz);
        Vector vector = classDescriptor.getExtentClasses();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            Class clazz2 = (Class)iterator.next();
            ClassDescriptor classDescriptor2 = this.getDescriptorFor(clazz2);
            if (!classDescriptor2.isAbstract()) {
                arrayList.add(clazz2);
            }
            arrayList.addAll(this.getConcreteSubclassesOf(clazz2));
        }
        return arrayList;
    }

    public boolean hasDescriptorFor(Class clazz) {
        return this.descriptorTable.containsKey(clazz.getName());
    }

    public ClassDescriptor getDescriptorFor(String string) throws ClassNotPersistenceCapableException {
        ClassDescriptor classDescriptor = this.discoverDescriptor(string);
        if (classDescriptor == null) {
            throw new ClassNotPersistenceCapableException(string + " not found in OJB Repository");
        }
        return classDescriptor;
    }

    public ClassDescriptor getDescriptorFor(Class clazz) throws ClassNotPersistenceCapableException {
        return this.getDescriptorFor(clazz.getName());
    }

    public void setClassDescriptor(ClassDescriptor classDescriptor) {
        this.put(classDescriptor.getClassNameOfObject(), classDescriptor);
    }

    public void put(Class clazz, ClassDescriptor classDescriptor) {
        this.put(clazz.getName(), classDescriptor);
    }

    public void put(String string, ClassDescriptor classDescriptor) {
        classDescriptor.setRepository(this);
        this.descriptorTable.put(string, classDescriptor);
        Vector vector = classDescriptor.getExtentClasses();
        for (int i = 0; i < vector.size(); ++i) {
            this.addExtent(((Class)vector.get(i)).getName(), classDescriptor);
        }
    }

    public Iterator iterator() {
        return this.descriptorTable.values().iterator();
    }

    public int getDefaultIsolationLevel() {
        return this.defaultIsolationLevel;
    }

    public void setDefaultIsolationLevel(int n) {
        this.defaultIsolationLevel = n;
    }

    public String toString() {
        Enumeration enumeration = this.descriptorTable.keys();
        Enumeration enumeration2 = this.descriptorTable.elements();
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE);
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            ClassDescriptor classDescriptor = (ClassDescriptor)enumeration2.nextElement();
            toStringBuilder.append(k.toString(), (Object)classDescriptor.getFullTableName());
        }
        return toStringBuilder.toString();
    }

    public String toXML() {
        String string = SystemUtils.LINE_SEPARATOR;
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(((XmlCapable)iterator.next()).toXML() + string);
        }
        return stringBuffer.toString();
    }

    protected String getIsolationLevelAsString() {
        if (this.defaultIsolationLevel == 0) {
            return "read-uncommitted";
        }
        if (this.defaultIsolationLevel == 1) {
            return "read-committed";
        }
        if (this.defaultIsolationLevel == 2) {
            return "repeatable-read";
        }
        if (this.defaultIsolationLevel == 3) {
            return "serializable";
        }
        if (this.defaultIsolationLevel == 4) {
            return "optimistic";
        }
        return "read-uncommitted";
    }

    protected ClassDescriptor discoverDescriptor(String string) {
        ClassDescriptor classDescriptor = (ClassDescriptor)this.descriptorTable.get(string);
        if (classDescriptor == null) {
            Class<?> clazz;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new OJBRuntimeException("Class, " + string + ", could not be found.", classNotFoundException);
            }
            Class<?> clazz2 = clazz.getSuperclass();
            if (clazz2 != null) {
                classDescriptor = this.discoverDescriptor(clazz2.getName());
            }
        }
        if (classDescriptor != null && !this.descriptorTable.containsKey(string)) {
            this.descriptorTable.put(string, classDescriptor);
        }
        return classDescriptor;
    }
}

