/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.metadata.AttributeContainer;
import org.apache.ojb.broker.metadata.ConnectionPoolDescriptor;
import org.apache.ojb.broker.metadata.ConnectionRepository;
import org.apache.ojb.broker.metadata.IsolationLevels;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.metadata.ObjectCacheDescriptor;
import org.apache.ojb.broker.metadata.RepositoryElements;
import org.apache.ojb.broker.metadata.RepositoryTags;
import org.apache.ojb.broker.metadata.SequenceDescriptor;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ConnectionDescriptorXmlHandler
extends DefaultHandler
implements RepositoryElements,
IsolationLevels {
    private Logger logger = LoggerFactory.getLogger(class$org$apache$ojb$broker$metadata$ConnectionDescriptorXmlHandler == null ? (class$org$apache$ojb$broker$metadata$ConnectionDescriptorXmlHandler = ConnectionDescriptorXmlHandler.class$("org.apache.ojb.broker.metadata.ConnectionDescriptorXmlHandler")) : class$org$apache$ojb$broker$metadata$ConnectionDescriptorXmlHandler);
    private ConnectionRepository con_repository;
    private JdbcConnectionDescriptor m_CurrentJCD;
    private SequenceDescriptor currentSequenceDescriptor;
    private List conDesList;
    private AttributeContainer currentAttributeContainer;
    private boolean defaultConnectionFound = false;
    private RepositoryTags tags = RepositoryTags.getInstance();
    static /* synthetic */ Class class$org$apache$ojb$broker$metadata$ConnectionDescriptorXmlHandler;

    public ConnectionDescriptorXmlHandler(ConnectionRepository connectionRepository) {
        if (connectionRepository == null) {
            throw new MetadataException("Given ConnectionRepository argument was null");
        }
        this.con_repository = connectionRepository;
        this.conDesList = new ArrayList();
    }

    public void startDocument() {
        this.logger.debug("****   startDoc   ****");
    }

    public void endDocument() {
        this.logger.debug("****   endDoc   ****");
        Iterator iterator = this.conDesList.iterator();
        while (iterator.hasNext()) {
            JdbcConnectionDescriptor jdbcConnectionDescriptor = (JdbcConnectionDescriptor)iterator.next();
            this.con_repository.addDescriptor(jdbcConnectionDescriptor);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        boolean bl = this.logger.isDebugEnabled();
        try {
            switch (this.getLiteralId(string3)) {
                case 1: {
                    if (bl) {
                        this.logger.debug("   > " + this.tags.getTagById(1));
                    }
                    JdbcConnectionDescriptor jdbcConnectionDescriptor = new JdbcConnectionDescriptor();
                    this.currentAttributeContainer = jdbcConnectionDescriptor;
                    this.conDesList.add(jdbcConnectionDescriptor);
                    this.m_CurrentJCD = jdbcConnectionDescriptor;
                    String string4 = attributes.getValue(this.tags.getTagById(82));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(82) + ": " + string4);
                    }
                    this.m_CurrentJCD.setJcdAlias(string4);
                    String string5 = attributes.getValue(this.tags.getTagById(80));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(80) + ": " + string5);
                    }
                    this.m_CurrentJCD.setDefaultConnection(Boolean.valueOf(string5));
                    if (this.m_CurrentJCD.isDefaultConnection()) {
                        if (this.defaultConnectionFound) {
                            throw new MetadataException("Found two jdbc-connection-descriptor elements with default-connection=\"true\"");
                        }
                        this.defaultConnectionFound = true;
                    }
                    String string6 = attributes.getValue(this.tags.getTagById(2));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(2) + ": " + string6);
                    }
                    this.m_CurrentJCD.setDbms(string6);
                    String string7 = attributes.getValue(this.tags.getTagById(45));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(45) + ": " + string7);
                    }
                    this.m_CurrentJCD.setJdbcLevel(string7);
                    String string8 = attributes.getValue(this.tags.getTagById(6));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(6) + ": " + string8);
                    }
                    this.m_CurrentJCD.setDriver(string8);
                    String string9 = attributes.getValue(this.tags.getTagById(7));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(7) + ": " + string9);
                    }
                    this.m_CurrentJCD.setProtocol(string9);
                    String string10 = attributes.getValue(this.tags.getTagById(8));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(8) + ": " + string10);
                    }
                    this.m_CurrentJCD.setSubProtocol(string10);
                    String string11 = attributes.getValue(this.tags.getTagById(9));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(9) + ": " + string11);
                    }
                    this.m_CurrentJCD.setDbAlias(string11);
                    String string12 = attributes.getValue(this.tags.getTagById(44));
                    if (string12 != null && string12.trim().equals("")) {
                        string12 = null;
                    }
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(44) + ": " + string12);
                    }
                    this.m_CurrentJCD.setDatasourceName(string12);
                    String string13 = attributes.getValue(this.tags.getTagById(10));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(10) + ": " + string13);
                    }
                    this.m_CurrentJCD.setUserName(string13);
                    String string14 = attributes.getValue(this.tags.getTagById(11));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(11) + ": " + string14);
                    }
                    this.m_CurrentJCD.setPassWord(string14);
                    String string15 = attributes.getValue(this.tags.getTagById(74));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(74) + ": " + string15);
                    }
                    this.m_CurrentJCD.setEagerRelease(Boolean.valueOf(string15));
                    String string16 = attributes.getValue(this.tags.getTagById(83));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(83) + ": " + string16);
                    }
                    this.m_CurrentJCD.setBatchMode(Boolean.valueOf(string16));
                    String string17 = attributes.getValue(this.tags.getTagById(90));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(90) + ": " + string17);
                    }
                    this.m_CurrentJCD.setUseAutoCommit(Integer.valueOf(string17));
                    String string18 = attributes.getValue(this.tags.getTagById(91));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(91) + ": " + string18);
                    }
                    this.m_CurrentJCD.setIgnoreAutoCommitExceptions(Boolean.valueOf(string18));
                    break;
                }
                case 65: {
                    if (bl) {
                        this.logger.debug("    > " + this.tags.getTagById(65));
                    }
                    ConnectionPoolDescriptor connectionPoolDescriptor = this.m_CurrentJCD.getConnectionPoolDescriptor();
                    String string19 = attributes.getValue(this.tags.getTagById(55));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(55) + ": " + string19);
                    }
                    if (this.checkString(string19)) {
                        connectionPoolDescriptor.setMaxActive(new Integer(string19));
                    }
                    String string20 = attributes.getValue(this.tags.getTagById(56));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(56) + ": " + string20);
                    }
                    if (this.checkString(string20)) {
                        connectionPoolDescriptor.setMaxIdle(new Integer(string20));
                    }
                    String string21 = attributes.getValue(this.tags.getTagById(57));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(57) + ": " + string21);
                    }
                    if (this.checkString(string21)) {
                        connectionPoolDescriptor.setMaxWait(new Integer(string21).intValue());
                    }
                    String string22 = attributes.getValue(this.tags.getTagById(58));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(58) + ": " + string22);
                    }
                    if (this.checkString(string22)) {
                        connectionPoolDescriptor.setMinEvictableIdleTimeMillis(new Long(string22));
                    }
                    String string23 = attributes.getValue(this.tags.getTagById(59));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(59) + ": " + string23);
                    }
                    if (this.checkString(string23)) {
                        connectionPoolDescriptor.setNumTestsPerEvictionRun(new Integer(string23));
                    }
                    String string24 = attributes.getValue(this.tags.getTagById(60));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(60) + ": " + string24);
                    }
                    if (this.checkString(string24)) {
                        connectionPoolDescriptor.setTestOnBorrow(new Boolean(string24));
                    }
                    String string25 = attributes.getValue(this.tags.getTagById(61));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(61) + ": " + string25);
                    }
                    if (this.checkString(string25)) {
                        connectionPoolDescriptor.setTestOnReturn(new Boolean(string25));
                    }
                    String string26 = attributes.getValue(this.tags.getTagById(62));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(62) + ": " + string26);
                    }
                    if (this.checkString(string26)) {
                        connectionPoolDescriptor.setTestWhileIdle(new Boolean(string26));
                    }
                    String string27 = attributes.getValue(this.tags.getTagById(63));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(63) + ": " + string27);
                    }
                    if (this.checkString(string27)) {
                        connectionPoolDescriptor.setTimeBetweenEvictionRunsMillis(new Long(string27));
                    }
                    String string28 = attributes.getValue(this.tags.getTagById(64));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(64) + ": " + string28);
                    }
                    if (this.checkString(string28)) {
                        connectionPoolDescriptor.setWhenExhaustedAction(new Byte(string28));
                    }
                    String string29 = attributes.getValue(this.tags.getTagById(66));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(66) + ": " + string29);
                    }
                    if (this.checkString(string29)) {
                        connectionPoolDescriptor.setConnectionFactory(ClassHelper.getClass(string29));
                    }
                    String string30 = attributes.getValue(this.tags.getTagById(79));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(79) + ": " + string30);
                    }
                    if (this.checkString(string30)) {
                        connectionPoolDescriptor.setValidationQuery(string30);
                    }
                    String string31 = attributes.getValue(this.tags.getTagById(87));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(87) + ": " + string31);
                    }
                    if (this.checkString(string31)) {
                        connectionPoolDescriptor.setLogAbandoned(new Boolean(string31));
                    }
                    String string32 = attributes.getValue(this.tags.getTagById(85));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(85) + ": " + string32);
                    }
                    if (this.checkString(string32)) {
                        connectionPoolDescriptor.setRemoveAbandoned(new Boolean(string32));
                    }
                    String string33 = attributes.getValue(this.tags.getTagById(86));
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(86) + ": " + string33);
                    }
                    if (!this.checkString(string33)) break;
                    connectionPoolDescriptor.setRemoveAbandonedTimeout(new Integer(string33));
                    break;
                }
                case 113: {
                    String string34 = attributes.getValue(this.tags.getTagById(13));
                    if (!this.checkString(string34) || this.m_CurrentJCD == null) break;
                    ObjectCacheDescriptor objectCacheDescriptor = new ObjectCacheDescriptor();
                    this.currentAttributeContainer = objectCacheDescriptor;
                    objectCacheDescriptor.setObjectCache(ClassHelper.getClass(string34));
                    this.m_CurrentJCD.setObjectCacheDescriptor(objectCacheDescriptor);
                    if (bl) {
                        this.logger.debug("    > " + this.tags.getTagById(113));
                    }
                    if (!bl) break;
                    this.logger.debug("     " + this.tags.getTagById(13) + ": " + string34);
                    break;
                }
                case 88: {
                    String string35 = attributes.getValue(this.tags.getTagById(89));
                    if (!this.checkString(string35)) break;
                    this.currentSequenceDescriptor = new SequenceDescriptor(this.m_CurrentJCD);
                    this.currentAttributeContainer = this.currentSequenceDescriptor;
                    this.m_CurrentJCD.setSequenceDescriptor(this.currentSequenceDescriptor);
                    if (bl) {
                        this.logger.debug("    > " + this.tags.getTagById(88));
                    }
                    if (bl) {
                        this.logger.debug("     " + this.tags.getTagById(89) + ": " + string35);
                    }
                    if (!this.checkString(string35)) break;
                    this.currentSequenceDescriptor.setSequenceManagerClass(ClassHelper.getClass(string35));
                    break;
                }
                case 71: {
                    String string36 = attributes.getValue(this.tags.getTagById(72));
                    String string37 = attributes.getValue(this.tags.getTagById(73));
                    if (this.currentAttributeContainer == null) break;
                    if (this.checkString(string36)) {
                        if (bl) {
                            this.logger.debug("    > " + this.tags.getTagById(71));
                        }
                        if (bl) {
                            this.logger.debug("     " + this.tags.getTagById(72) + ": " + string36);
                        }
                        if (bl) {
                            this.logger.debug("     " + this.tags.getTagById(73) + ": " + string37);
                        }
                        this.currentAttributeContainer.addAttribute(string36, string37);
                        break;
                    }
                    this.logger.info("Found 'null' or 'empty' attribute object for element " + this.currentAttributeContainer.getClass() + " attribute-name=" + string36 + ", attribute-value=" + string37 + " See jdbc-connection-descriptor with jcdAlias '" + this.m_CurrentJCD.getJcdAlias() + "'");
                    break;
                }
            }
        }
        catch (Exception exception) {
            this.logger.error(exception);
            throw new PersistenceBrokerException(exception);
        }
    }

    private boolean checkString(String string) {
        return string != null && !string.trim().equals("");
    }

    private int getLiteralId(String string) throws PersistenceBrokerException {
        try {
            return this.tags.getIdByTag(string);
        }
        catch (Exception exception) {
            throw new MetadataException("unknown literal: '" + string + "'", exception);
        }
    }

    public void endElement(String string, String string2, String string3) {
        boolean bl = this.logger.isDebugEnabled();
        try {
            switch (this.getLiteralId(string3)) {
                case 0: {
                    this.currentAttributeContainer = null;
                    break;
                }
                case 12: {
                    this.currentAttributeContainer = null;
                    break;
                }
                case 1: {
                    this.logger.debug("   < " + this.tags.getTagById(1));
                    this.m_CurrentJCD = null;
                    this.currentAttributeContainer = null;
                    break;
                }
                case 65: {
                    this.logger.debug("   < " + this.tags.getTagById(65));
                    this.currentAttributeContainer = this.m_CurrentJCD;
                    break;
                }
                case 88: {
                    if (bl) {
                        this.logger.debug("    < " + this.tags.getTagById(88));
                    }
                    this.currentSequenceDescriptor = null;
                    this.currentAttributeContainer = this.m_CurrentJCD;
                    break;
                }
                case 113: {
                    if (bl) {
                        this.logger.debug("    < " + this.tags.getTagById(113));
                    }
                    this.currentAttributeContainer = this.m_CurrentJCD;
                    break;
                }
                case 71: {
                    if (!bl) break;
                    this.logger.debug("    < " + this.tags.getTagById(71));
                    break;
                }
            }
        }
        catch (Exception exception) {
            this.logger.error(exception);
            throw new PersistenceBrokerException(exception);
        }
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        this.logger.error(sAXParseException);
        throw sAXParseException;
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.logger.fatal(sAXParseException);
        throw sAXParseException;
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.logger.warn(sAXParseException);
        throw sAXParseException;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

