/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata;

import java.io.Serializable;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.ojb.broker.accesslayer.conversions.FieldConversion;
import org.apache.ojb.broker.metadata.DescriptorBase;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.ProcedureDescriptor;
import org.apache.ojb.broker.metadata.RepositoryTags;
import org.apache.ojb.broker.metadata.XmlCapable;

public final class ArgumentDescriptor
extends DescriptorBase
implements XmlCapable,
Serializable {
    private static final int SOURCE_NULL = 0;
    private static final int SOURCE_FIELD = 1;
    private static final int SOURCE_VALUE = 2;
    private int fieldSource = 0;
    private String constantValue = null;
    private String fieldRefName = null;
    private boolean returnedByProcedure = false;
    private ProcedureDescriptor procedureDescriptor;

    public ArgumentDescriptor(ProcedureDescriptor procedureDescriptor) {
        this.procedureDescriptor = procedureDescriptor;
        this.setValue();
    }

    public void setValue() {
        this.fieldSource = 0;
        this.fieldRefName = null;
        this.returnedByProcedure = false;
        this.constantValue = null;
    }

    public void setValue(String string, boolean bl) {
        this.fieldSource = 1;
        this.fieldRefName = string;
        this.returnedByProcedure = bl;
        this.constantValue = null;
        if (this.getFieldRef() == null) {
            this.returnedByProcedure = false;
        }
        if (this.getFieldRef() == null) {
            this.returnedByProcedure = false;
        }
    }

    public void setValue(String string) {
        this.fieldSource = 2;
        this.fieldRefName = null;
        this.returnedByProcedure = false;
        this.constantValue = string;
    }

    public boolean getIsReturnedByProcedure() {
        return this.returnedByProcedure;
    }

    public Object getValue(Object object) {
        switch (this.fieldSource) {
            case 1: {
                if (object == null) {
                    return null;
                }
                FieldDescriptor fieldDescriptor = this.getFieldRef();
                Object object2 = null;
                FieldConversion fieldConversion = null;
                if (fieldDescriptor != null) {
                    fieldConversion = fieldDescriptor.getFieldConversion();
                    object2 = fieldDescriptor.getPersistentField().get(object);
                    if (fieldConversion != null) {
                        object2 = fieldConversion.javaToSql(object2);
                    }
                }
                return object2;
            }
            case 2: {
                return this.constantValue;
            }
            case 0: {
                return null;
            }
        }
        return null;
    }

    public void saveValue(Object object, Object object2) {
        if (this.fieldSource == 1 && this.returnedByProcedure) {
            FieldDescriptor fieldDescriptor = this.getFieldRef();
            FieldConversion fieldConversion = null;
            if (fieldDescriptor != null) {
                fieldConversion = fieldDescriptor.getFieldConversion();
                if (fieldConversion == null) {
                    fieldDescriptor.getPersistentField().set(object, object2);
                } else {
                    fieldDescriptor.getPersistentField().set(object, fieldConversion.sqlToJava(object2));
                }
            }
        }
    }

    public final FieldDescriptor getFieldRef() {
        if (this.fieldSource == 1) {
            return this.getProcedureDescriptor().getClassDescriptor().getFieldDescriptorByName(this.fieldRefName);
        }
        return null;
    }

    public final int getJdbcType() {
        switch (this.fieldSource) {
            case 1: {
                return this.getFieldRef().getColumnJdbcType();
            }
            case 0: {
                return 0;
            }
            case 2: {
                return 12;
            }
        }
        return 0;
    }

    public final ProcedureDescriptor getProcedureDescriptor() {
        return this.procedureDescriptor;
    }

    public String toXML() {
        String string = System.getProperty("line.separator");
        RepositoryTags repositoryTags = RepositoryTags.getInstance();
        String string2 = "     ";
        switch (this.fieldSource) {
            case 1: {
                string2 = string2 + " " + repositoryTags.getOpeningTagNonClosingById(107);
                string2 = string2 + " " + repositoryTags.getAttribute(84, this.fieldRefName);
                string2 = string2 + " " + repositoryTags.getAttribute(111, String.valueOf(this.returnedByProcedure));
                string2 = string2 + "/>";
                break;
            }
            case 2: {
                string2 = string2 + " " + repositoryTags.getOpeningTagNonClosingById(106);
                string2 = string2 + " " + repositoryTags.getAttribute(112, this.constantValue);
                string2 = string2 + "/>";
                break;
            }
            case 0: {
                string2 = string2 + " " + repositoryTags.getOpeningTagNonClosingById(107);
                string2 = string2 + "/>";
                break;
            }
        }
        return string2 + string;
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE);
        switch (this.fieldSource) {
            case 1: {
                toStringBuilder.append("fieldRefName", (Object)this.fieldRefName);
                toStringBuilder.append("returnedByProcedure", this.returnedByProcedure);
                break;
            }
            case 0: {
                break;
            }
            case 2: {
                toStringBuilder.append("constantValue", (Object)this.constantValue);
            }
        }
        return toStringBuilder.toString();
    }
}

