/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.WeakHashMap;
import org.apache.ojb.broker.PBFactoryException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;

public class PersistenceBrokerThreadMapping {
    private static ThreadLocal currentBrokerMap = new ThreadLocal();

    public static void setCurrentPersistenceBroker(PBKey pBKey, PersistenceBroker persistenceBroker) throws PBFactoryException {
        HashMap<PBKey, WeakHashMap<PersistenceBroker, Object>> hashMap = (HashMap<PBKey, WeakHashMap<PersistenceBroker, Object>>)currentBrokerMap.get();
        WeakHashMap<PersistenceBroker, Object> weakHashMap = null;
        if (hashMap == null) {
            hashMap = new HashMap<PBKey, WeakHashMap<PersistenceBroker, Object>>();
            currentBrokerMap.set(hashMap);
        } else {
            weakHashMap = (WeakHashMap<PersistenceBroker, Object>)hashMap.get(pBKey);
        }
        if (weakHashMap == null) {
            weakHashMap = new WeakHashMap<PersistenceBroker, Object>();
            hashMap.put(pBKey, weakHashMap);
        }
        weakHashMap.put(persistenceBroker, null);
    }

    public static void unsetCurrentPersistenceBroker(PBKey pBKey, PersistenceBroker persistenceBroker) throws PBFactoryException {
        HashMap hashMap = (HashMap)currentBrokerMap.get();
        WeakHashMap weakHashMap = null;
        if (hashMap != null && (weakHashMap = (WeakHashMap)hashMap.get(pBKey)) != null) {
            weakHashMap.remove(persistenceBroker);
        }
    }

    public static PersistenceBroker currentPersistenceBroker(PBKey pBKey) throws PBFactoryException, PersistenceBrokerException {
        HashMap hashMap = (HashMap)currentBrokerMap.get();
        PersistenceBroker persistenceBroker = null;
        if (hashMap == null) {
            return null;
        }
        WeakHashMap weakHashMap = (WeakHashMap)hashMap.get(pBKey);
        if (weakHashMap == null) {
            return null;
        }
        Iterator iterator = weakHashMap.keySet().iterator();
        while (iterator.hasNext()) {
            PersistenceBroker persistenceBroker2 = (PersistenceBroker)iterator.next();
            if (persistenceBroker2 == null || persistenceBroker2.isClosed()) {
                iterator.remove();
                continue;
            }
            persistenceBroker = persistenceBroker2;
            if (!persistenceBroker2.isInTransaction()) continue;
            break;
        }
        return persistenceBroker;
    }
}

