/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.core;

import java.lang.reflect.Array;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.ManageableCollection;
import org.apache.ojb.broker.MtoNImplementor;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PBState;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.TransactionAbortedException;
import org.apache.ojb.broker.TransactionInProgressException;
import org.apache.ojb.broker.TransactionNotInProgressException;
import org.apache.ojb.broker.VirtualProxy;
import org.apache.ojb.broker.accesslayer.BasePrefetcher;
import org.apache.ojb.broker.accesslayer.ChainingIterator;
import org.apache.ojb.broker.accesslayer.CollectionPrefetcher;
import org.apache.ojb.broker.accesslayer.CollectionProxy;
import org.apache.ojb.broker.accesslayer.CollectionProxyListener;
import org.apache.ojb.broker.accesslayer.ConnectionManagerFactory;
import org.apache.ojb.broker.accesslayer.ConnectionManagerIF;
import org.apache.ojb.broker.accesslayer.IndirectionHandler;
import org.apache.ojb.broker.accesslayer.JdbcAccess;
import org.apache.ojb.broker.accesslayer.JdbcAccessFactory;
import org.apache.ojb.broker.accesslayer.MaterializationListener;
import org.apache.ojb.broker.accesslayer.OJBIterator;
import org.apache.ojb.broker.accesslayer.PkEnumeration;
import org.apache.ojb.broker.accesslayer.PlainPrefetcher;
import org.apache.ojb.broker.accesslayer.ReferencePrefetcher;
import org.apache.ojb.broker.accesslayer.RelationshipPrefetcherImpl;
import org.apache.ojb.broker.accesslayer.ResultSetAndStatement;
import org.apache.ojb.broker.accesslayer.StatementManagerFactory;
import org.apache.ojb.broker.accesslayer.StatementManagerIF;
import org.apache.ojb.broker.accesslayer.sql.SqlGenerator;
import org.apache.ojb.broker.accesslayer.sql.SqlGeneratorFactory;
import org.apache.ojb.broker.cache.ObjectCache;
import org.apache.ojb.broker.cache.ObjectCacheFactory;
import org.apache.ojb.broker.core.PersistenceBrokerAbstractImpl;
import org.apache.ojb.broker.core.PersistenceBrokerFactoryIF;
import org.apache.ojb.broker.core.ReportRsIteratorFactoryImpl;
import org.apache.ojb.broker.core.RsIteratorFactory;
import org.apache.ojb.broker.core.RsIteratorFactoryImpl;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.ClassNotPersistenceCapableException;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.FieldHelper;
import org.apache.ojb.broker.metadata.MetadataManager;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.MtoNQuery;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryByIdentity;
import org.apache.ojb.broker.query.QueryBySQL;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.apache.ojb.broker.query.ReportQueryByMtoNCriteria;
import org.apache.ojb.broker.util.ArrayIterator;
import org.apache.ojb.broker.util.BrokerHelper;
import org.apache.ojb.broker.util.ObjectModification;
import org.apache.ojb.broker.util.ProxyHelper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.broker.util.sequence.SequenceManager;
import org.apache.ojb.broker.util.sequence.SequenceManagerException;
import org.apache.ojb.broker.util.sequence.SequenceManagerFactory;
import org.apache.ojb.soda.QueryImpl;
import org.odbms.Query;

public class PersistenceBrokerImpl
extends PersistenceBrokerAbstractImpl
implements PBState {
    private Logger logger = LoggerFactory.getLogger(class$org$apache$ojb$broker$core$PersistenceBrokerImpl == null ? (class$org$apache$ojb$broker$core$PersistenceBrokerImpl = PersistenceBrokerImpl.class$("org.apache.ojb.broker.core.PersistenceBrokerImpl")) : class$org$apache$ojb$broker$core$PersistenceBrokerImpl);
    private final boolean batchRetrieval = true;
    private final boolean prefetchProxies = true;
    protected PersistenceBrokerFactoryIF pbf;
    private boolean isClosed;
    protected ObjectCache objectCache;
    private JdbcAccess dbAccess;
    private DescriptorRepository descriptorRepository = null;
    private ConnectionManagerIF connectionManager = null;
    private SequenceManager sequenceManager = null;
    private StatementManagerIF statementManager = null;
    private SqlGenerator sqlGenerator;
    protected BrokerHelper brokerHelper;
    private PBKey pbKey;
    private List markedForDelete;
    private Class classToPrefetch;
    private ArrayList prefetchingListeners;
    private HashMap m_retrievalTasks;
    private ArrayList nowStoring = new ArrayList();
    static /* synthetic */ Class class$org$apache$ojb$broker$core$PersistenceBrokerImpl;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$collections$RemovalAwareCollection;

    protected PersistenceBrokerImpl() {
    }

    public PersistenceBrokerImpl(PBKey pBKey, PersistenceBrokerFactoryIF persistenceBrokerFactoryIF) {
        this.refresh();
        if (pBKey == null) {
            throw new PersistenceBrokerException("Could not instantiate broker with PBKey 'null'");
        }
        this.pbf = persistenceBrokerFactoryIF;
        this.pbKey = pBKey;
        this.brokerHelper = new BrokerHelper(this);
        this.connectionManager = ConnectionManagerFactory.getInstance().createConnectionManager(this);
        this.objectCache = ObjectCacheFactory.getInstance().createObjectCache(this);
        this.sequenceManager = SequenceManagerFactory.getSequenceManager(this);
        this.dbAccess = JdbcAccessFactory.getInstance().createJdbcAccess(this);
        this.statementManager = StatementManagerFactory.getInstance().createStatementManager(this);
        this.sqlGenerator = SqlGeneratorFactory.getInstance().createSqlGenerator(this.connectionManager.getSupportedPlatform());
        this.markedForDelete = new ArrayList();
    }

    public SqlGenerator serviceSqlGenerator() {
        return this.sqlGenerator;
    }

    public StatementManagerIF serviceStatementManager() {
        return this.statementManager;
    }

    public JdbcAccess serviceJdbcAccess() {
        return this.dbAccess;
    }

    public ConnectionManagerIF serviceConnectionManager() {
        return this.connectionManager;
    }

    public SequenceManager serviceSequenceManager() {
        return this.sequenceManager;
    }

    public BrokerHelper serviceBrokerHelper() {
        return this.brokerHelper;
    }

    public ObjectCache serviceObjectCache() {
        return this.objectCache;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void setClosed(boolean bl) {
        if (!bl) {
            this.refresh();
        }
        this.isClosed = bl;
    }

    public void refresh() {
        this.descriptorRepository = MetadataManager.getInstance().getRepository();
    }

    public void destroy() {
        this.removeAllListeners();
        if (this.connectionManager != null) {
            this.connectionManager.releaseConnection();
        }
        this.setClosed(true);
        this.descriptorRepository = null;
        this.pbKey = null;
        this.pbf = null;
        this.connectionManager = null;
        this.dbAccess = null;
        this.objectCache = null;
        this.sequenceManager = null;
        this.sqlGenerator = null;
        this.statementManager = null;
    }

    public PBKey getPBKey() {
        return this.pbKey;
    }

    public void setPBKey(PBKey pBKey) {
        this.pbKey = pBKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close() {
        if (this.isInTransaction()) {
            this.abortTransaction();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("PB.close was called: " + this);
        }
        try {
            this.fireBrokerEvent(this.BEFORE_CLOSE_EVENT);
            this.clearRegistrationLists();
            this.removePrefetchingListeners();
            if (this.connectionManager != null) {
                this.connectionManager.releaseConnection();
                this.connectionManager.setBatchMode(false);
            }
            this.removeAllListeners();
        }
        finally {
            this.setClosed(true);
        }
        return true;
    }

    public synchronized void abortTransaction() throws TransactionNotInProgressException {
        if (!this.connectionManager.isInLocalTransaction()) {
            throw new TransactionNotInProgressException("ConnectionManager is NOT in transaction");
        }
        this.fireBrokerEvent(this.BEFORE_ROLLBACK_EVENT);
        this.clearRegistrationLists();
        this.removePrefetchingListeners();
        this.connectionManager.localRollback();
        this.fireBrokerEvent(this.AFTER_ROLLBACK_EVENT);
    }

    public synchronized void beginTransaction() throws TransactionInProgressException, TransactionAbortedException {
        if (this.connectionManager.isInLocalTransaction()) {
            throw new TransactionInProgressException("ConnectionManager is already in transaction");
        }
        this.fireBrokerEvent(this.BEFORE_BEGIN_EVENT);
        this.connectionManager.localBegin();
        this.fireBrokerEvent(this.AFTER_BEGIN_EVENT);
    }

    public synchronized void commitTransaction() throws TransactionNotInProgressException, TransactionAbortedException {
        if (!this.connectionManager.isInLocalTransaction()) {
            throw new TransactionNotInProgressException("ConnectionManager is NOT in transaction");
        }
        this.fireBrokerEvent(this.BEFORE_COMMIT_EVENT);
        this.clearRegistrationLists();
        this.removePrefetchingListeners();
        this.connectionManager.localCommit();
        this.fireBrokerEvent(this.AFTER_COMMIT_EVENT);
    }

    public void delete(Object object) throws PersistenceBrokerException {
        if (object != null) {
            if (this.markedForDelete.contains(object = ProxyHelper.getRealObject(object))) {
                return;
            }
            this.markedForDelete.add(object);
            ClassDescriptor classDescriptor = this.getClassDescriptor(object.getClass());
            Identity identity = new Identity(object, this, classDescriptor);
            this.BEFORE_DELETE_EVENT.setTarget(object);
            this.fireBrokerEvent(this.BEFORE_DELETE_EVENT);
            if (classDescriptor.getCollectionDescriptors().size() > 0) {
                this.deleteCollections(object, classDescriptor.getCollectionDescriptors());
            }
            this.dbAccess.executeDelete(classDescriptor, object);
            if (classDescriptor.getObjectReferenceDescriptors().size() > 0) {
                this.deleteReferences(object, classDescriptor.getObjectReferenceDescriptors());
            }
            this.objectCache.remove(identity);
            this.AFTER_DELETE_EVENT.setTarget(object);
            this.fireBrokerEvent(this.AFTER_DELETE_EVENT);
            this.connectionManager.executeBatchIfNecessary();
        }
    }

    private void deleteByQuery(org.apache.ojb.broker.query.Query query, ClassDescriptor classDescriptor) throws PersistenceBrokerException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("deleteByQuery " + classDescriptor.getClassNameOfObject() + ", " + query);
        }
        if (query instanceof QueryBySQL) {
            String string = ((QueryBySQL)query).getSql();
            this.dbAccess.executeUpdateSQL(string, classDescriptor);
        } else {
            Iterator iterator;
            Object object;
            if (query instanceof QueryByIdentity) {
                object = (QueryByIdentity)query;
                iterator = ((QueryByIdentity)object).getExampleObject();
                if (!(iterator instanceof Identity)) {
                    iterator = new Identity(iterator, this);
                }
                query = this.getPKQuery((Identity)((Object)iterator));
            }
            if (!classDescriptor.isInterface()) {
                this.dbAccess.executeDelete(query, classDescriptor);
            }
            object = classDescriptor.getFullTableName();
            if (classDescriptor.isExtent()) {
                iterator = classDescriptor.getAllConcreteExtentClasses().iterator();
                while (iterator.hasNext()) {
                    Class clazz = (Class)iterator.next();
                    ClassDescriptor classDescriptor2 = this.getClassDescriptor(clazz);
                    if (classDescriptor2.getFullTableName().equals(object)) continue;
                    object = classDescriptor2.getFullTableName();
                    this.dbAccess.executeDelete(query, classDescriptor2);
                }
            }
        }
    }

    public void deleteByQuery(org.apache.ojb.broker.query.Query query) throws PersistenceBrokerException {
        ClassDescriptor classDescriptor = this.getClassDescriptor(query.getSearchClass());
        this.deleteByQuery(query, classDescriptor);
    }

    private void deleteReferences(Object object, Vector vector) throws PersistenceBrokerException {
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            Object object2;
            ObjectReferenceDescriptor objectReferenceDescriptor = (ObjectReferenceDescriptor)iterator.next();
            if (!objectReferenceDescriptor.getCascadeDelete() || (object2 = objectReferenceDescriptor.getPersistentField().get(object)) == null) continue;
            this.delete(object2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deleteCollections(Object object, Vector vector) throws PersistenceBrokerException {
        Iterator iterator = vector.iterator();
        ArrayIterator arrayIterator = null;
        while (iterator.hasNext()) {
            Object var8_8;
            CollectionDescriptor collectionDescriptor = (CollectionDescriptor)iterator.next();
            arrayIterator = null;
            if (collectionDescriptor.isMtoNRelation()) {
                this.deleteMtoNImplementor(collectionDescriptor, object);
            }
            if (!collectionDescriptor.getCascadeDelete()) continue;
            try {
                try {
                    Object object2 = collectionDescriptor.getPersistentField().get(object);
                    if (object2 != null) {
                        if (object2 instanceof ManageableCollection) {
                            arrayIterator = ((ManageableCollection)object2).ojbIterator();
                        } else if (object2 instanceof Collection) {
                            arrayIterator = ((Collection)object2).iterator();
                        } else {
                            if (!object2.getClass().isArray()) {
                                throw new OJBRuntimeException(object2.getClass() + " can not be managed by OJB, use Array, Collection or ManageableCollection instead !");
                            }
                            arrayIterator = new ArrayIterator(object2);
                        }
                        while (arrayIterator.hasNext()) {
                            this.delete(arrayIterator.next());
                        }
                    }
                    var8_8 = null;
                    if (arrayIterator == null) continue;
                }
                catch (Exception exception) {
                    this.logger.error(exception);
                    throw new PersistenceBrokerException(exception);
                }
            }
            catch (Throwable throwable) {
                var8_8 = null;
                if (arrayIterator != null && arrayIterator instanceof OJBIterator) {
                    ((OJBIterator)((Object)arrayIterator)).releaseDbResources();
                }
                throw throwable;
            }
            if (!(arrayIterator instanceof OJBIterator)) continue;
            ((OJBIterator)((Object)arrayIterator)).releaseDbResources();
        }
        return;
    }

    public void store(Object object) throws PersistenceBrokerException {
        boolean bl;
        Identity identity;
        ClassDescriptor classDescriptor;
        if (object != null && !this.nowStoring.contains(object)) {
            if ((object = ProxyHelper.getRealObjectIfMaterialized(object)) == null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("No materialized object could be found -> nothing to store");
                }
                return;
            }
            classDescriptor = this.getClassDescriptor(object.getClass());
            identity = new Identity(object, this, classDescriptor);
            bl = false;
            if (this.objectCache.lookup(identity) == null && this.dbAccess.materializeObject(classDescriptor, identity) == null) {
                bl = true;
            }
        } else {
            return;
        }
        this.store(object, identity, classDescriptor, bl);
        this.connectionManager.executeBatchIfNecessary();
    }

    private void storeReferences(Object object, Vector vector) {
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            ObjectReferenceDescriptor objectReferenceDescriptor = (ObjectReferenceDescriptor)iterator.next();
            Object object2 = objectReferenceDescriptor.getPersistentField().get(object);
            if (objectReferenceDescriptor.getCascadeStore()) {
                this.store(object2);
                continue;
            }
            if (!this.logger.isEnabledFor(2)) continue;
            this.logger.info("Cascade store for this reference-descriptor (" + objectReferenceDescriptor.getAttributeName() + ") was set to false.");
        }
    }

    private void assertFkAssignment(Object object, Object object2, ObjectReferenceDescriptor objectReferenceDescriptor) {
        Object[] objectArray;
        Object object3 = ProxyHelper.getRealObject(object);
        Class<?> clazz = object3.getClass();
        ClassDescriptor classDescriptor = this.getClassDescriptor(clazz);
        FieldDescriptor[] fieldDescriptorArray = objectReferenceDescriptor.getForeignKeyFieldDescriptors(classDescriptor);
        if (fieldDescriptorArray == null) {
            throw new PersistenceBrokerException("No ForeignKeyFields !");
        }
        if (object2 == null) {
            objectArray = new Object[fieldDescriptorArray.length];
        } else {
            Class clazz2 = ProxyHelper.getRealClass(object2);
            ClassDescriptor classDescriptor2 = this.getClassDescriptor(clazz2);
            objectArray = this.brokerHelper.getKeyValues(classDescriptor2, object2, false);
        }
        for (int i = 0; i < fieldDescriptorArray.length; ++i) {
            fieldDescriptorArray[i].getPersistentField().set(object3, objectArray[i]);
        }
    }

    private void storeCollections(Object object, Vector vector, boolean bl) throws PersistenceBrokerException {
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            ArrayIterator arrayIterator;
            CollectionDescriptor collectionDescriptor = (CollectionDescriptor)iterator.next();
            Object object2 = collectionDescriptor.getPersistentField().get(object);
            Collection collection = null;
            if (object2 == null) {
                if (bl || !collectionDescriptor.isMtoNRelation()) continue;
                this.deleteMtoNImplementor(collectionDescriptor, object);
                continue;
            }
            if (object2 instanceof CollectionProxy && !((CollectionProxy)object2).isLoaded()) continue;
            if (collectionDescriptor.isMtoNRelation()) {
                collection = this.getMtoNImplementor(collectionDescriptor, object);
                if (!bl) {
                    this.deleteMtoNImplementor(collectionDescriptor, object, (Collection)object2, collection);
                }
            }
            if (object2 instanceof ManageableCollection) {
                arrayIterator = ((ManageableCollection)object2).ojbIterator();
            } else if (object2 instanceof Collection) {
                arrayIterator = ((Collection)object2).iterator();
            } else if (object2.getClass().isArray()) {
                arrayIterator = new ArrayIterator(object2);
            } else {
                throw new OJBRuntimeException(object2.getClass() + " can not be managed by OJB, use Array, Collection or ManageableCollection instead !");
            }
            while (arrayIterator.hasNext()) {
                Object e = arrayIterator.next();
                if (collectionDescriptor.isMtoNRelation()) {
                    this.storeCollectionObject(collectionDescriptor, e);
                    this.storeMtoNImplementor(collectionDescriptor, object, e, collection);
                    continue;
                }
                if (collectionDescriptor.getCascadeStore()) {
                    this.assertFkAssignment(e, object, collectionDescriptor);
                }
                this.storeCollectionObject(collectionDescriptor, e);
            }
            if (!(object2 instanceof ManageableCollection)) continue;
            ((ManageableCollection)object2).afterStore(this);
        }
    }

    private void storeCollectionObject(CollectionDescriptor collectionDescriptor, Object object) {
        if (collectionDescriptor.getCascadeStore()) {
            this.store(object);
        } else if (this.logger.isEnabledFor(2)) {
            this.logger.info("Cascade store for this collection-descriptor (" + collectionDescriptor.getAttributeName() + ") was set to false.");
        }
    }

    private void storeMtoNImplementor(CollectionDescriptor collectionDescriptor, Object object, Object object2, Collection collection) {
        object2 = ProxyHelper.getRealObject(object2);
        ClassDescriptor classDescriptor = this.getDescriptorRepository().getDescriptorFor(object.getClass());
        Object[] objectArray = this.brokerHelper.getKeyValues(classDescriptor, object);
        String[] stringArray = collectionDescriptor.getFksToThisClass();
        ClassDescriptor classDescriptor2 = this.getDescriptorRepository().getDescriptorFor(object2.getClass());
        Object[] objectArray2 = this.brokerHelper.getKeyValues(classDescriptor2, object2);
        String[] stringArray2 = collectionDescriptor.getFksToItemClass();
        String string = collectionDescriptor.getIndirectionTable();
        Key key = new Key(objectArray2);
        if (collection.contains(key)) {
            return;
        }
        String string2 = this.sqlGenerator.getInsertMNStatement(string, stringArray, stringArray2);
        this.dbAccess.executeUpdateSQL(string2, classDescriptor, objectArray, objectArray2);
    }

    private Collection getMtoNImplementor(CollectionDescriptor collectionDescriptor, Object object) {
        ResultSetAndStatement resultSetAndStatement = null;
        ArrayList<Key> arrayList = new ArrayList<Key>();
        ClassDescriptor classDescriptor = this.getDescriptorRepository().getDescriptorFor(object.getClass());
        Object[] objectArray = this.brokerHelper.getKeyValues(classDescriptor, object);
        String[] stringArray = collectionDescriptor.getFksToThisClass();
        String[] stringArray2 = collectionDescriptor.getFksToItemClass();
        String string = collectionDescriptor.getIndirectionTable();
        String string2 = this.sqlGenerator.getSelectMNStatement(string, stringArray2, stringArray);
        try {
            resultSetAndStatement = this.dbAccess.executeSQL(string2, classDescriptor, objectArray, false);
            while (resultSetAndStatement.m_rs.next()) {
                Object[] objectArray2 = new Object[stringArray2.length];
                for (int i = 0; i < objectArray2.length; ++i) {
                    objectArray2[i] = resultSetAndStatement.m_rs.getObject(i + 1);
                }
                arrayList.add(new Key(objectArray2));
            }
        }
        catch (Exception exception) {
            throw new PersistenceBrokerException(exception);
        }
        finally {
            resultSetAndStatement.close();
        }
        return arrayList;
    }

    private void deleteMtoNImplementor(CollectionDescriptor collectionDescriptor, Object object) {
        ClassDescriptor classDescriptor = this.getDescriptorRepository().getDescriptorFor(object.getClass());
        Object[] objectArray = this.brokerHelper.getKeyValues(classDescriptor, object);
        String[] stringArray = collectionDescriptor.getFksToThisClass();
        String string = collectionDescriptor.getIndirectionTable();
        String string2 = this.sqlGenerator.getDeleteMNStatement(string, stringArray, null);
        this.dbAccess.executeUpdateSQL(string2, classDescriptor, objectArray, null);
    }

    private void deleteMtoNImplementor(CollectionDescriptor collectionDescriptor, Object object, Collection collection, Collection collection2) {
        if (collection2.isEmpty() || collection == null) {
            return;
        }
        ArrayList arrayList = new ArrayList(collection2);
        ClassDescriptor classDescriptor = this.getDescriptorRepository().getDescriptorFor(collectionDescriptor.getItemClass());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Key key = new Key(this.brokerHelper.getKeyValues(classDescriptor, e, true));
            arrayList.remove(key);
        }
        ClassDescriptor classDescriptor2 = this.getDescriptorRepository().getDescriptorFor(object.getClass());
        Object[] objectArray = this.brokerHelper.getKeyValues(classDescriptor2, object);
        String[] stringArray = collectionDescriptor.getFksToThisClass();
        String[] stringArray2 = collectionDescriptor.getFksToItemClass();
        String string = collectionDescriptor.getIndirectionTable();
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Object[] objectArray2 = ((Key)iterator.next()).m_key;
            String string2 = this.sqlGenerator.getDeleteMNStatement(string, stringArray, stringArray2);
            this.dbAccess.executeUpdateSQL(string2, classDescriptor2, objectArray, objectArray2);
        }
    }

    public void retrieveAllReferences(Object object) throws PersistenceBrokerException {
        ClassDescriptor classDescriptor = this.getClassDescriptor(object.getClass());
        this.retrieveReferences(object, classDescriptor, true);
        this.retrieveCollections(object, classDescriptor, true);
    }

    private boolean addRetrievalTask(Object object, Object object2) {
        ArrayList<Object> arrayList = (ArrayList<Object>)this.m_retrievalTasks.get(object2);
        boolean bl = false;
        if (arrayList == null) {
            arrayList = new ArrayList<Object>();
            this.m_retrievalTasks.put(object2, arrayList);
            bl = true;
        }
        arrayList.add(object);
        return bl;
    }

    public void retrieveReference(Object object, String string) throws PersistenceBrokerException {
        ClassDescriptor classDescriptor = this.getClassDescriptor(object.getClass());
        CollectionDescriptor collectionDescriptor = classDescriptor.getCollectionDescriptorByName(string);
        if (collectionDescriptor != null) {
            this.retrieveCollection(object, classDescriptor, collectionDescriptor, true);
        } else {
            ObjectReferenceDescriptor objectReferenceDescriptor = classDescriptor.getObjectReferenceDescriptorByName(string);
            if (objectReferenceDescriptor != null) {
                this.retrieveReference(object, classDescriptor, objectReferenceDescriptor, true);
            } else {
                throw new PersistenceBrokerException("did not find attribute " + string + " for class " + object.getClass().getName());
            }
        }
    }

    public void retrieveReferences(Object object, ClassDescriptor classDescriptor, boolean bl) throws PersistenceBrokerException {
        Iterator iterator = classDescriptor.getObjectReferenceDescriptors().iterator();
        ObjectReferenceDescriptor objectReferenceDescriptor = null;
        Class clazz = this.classToPrefetch;
        this.classToPrefetch = null;
        while (iterator.hasNext()) {
            objectReferenceDescriptor = (ObjectReferenceDescriptor)iterator.next();
            this.retrieveReference(object, classDescriptor, objectReferenceDescriptor, bl);
        }
        this.classToPrefetch = clazz;
    }

    private void retrieveReference(Object object, ClassDescriptor classDescriptor, ObjectReferenceDescriptor objectReferenceDescriptor, boolean bl) {
        Object object2 = null;
        if (bl || objectReferenceDescriptor.getCascadeRetrieve()) {
            Identity identity = this.getReferencedObjectIdentity(object, objectReferenceDescriptor, classDescriptor);
            boolean bl2 = true;
            if (identity == null) {
                object2 = null;
            } else if (this.objectCache.lookup(identity) != null) {
                object2 = this.getObjectByIdentity(identity);
            } else if (this.m_retrievalTasks != null && !objectReferenceDescriptor.isLazy() && objectReferenceDescriptor.getItemProxyClass() == null) {
                this.addRetrievalTask(object, objectReferenceDescriptor);
                bl2 = false;
            } else {
                object2 = this.getReferencedObject(identity, objectReferenceDescriptor, classDescriptor);
            }
            if (bl2) {
                IndirectionHandler indirectionHandler;
                PersistentField persistentField = objectReferenceDescriptor.getPersistentField();
                persistentField.set(object, object2);
                if (object2 != null && this.m_retrievalTasks != null && objectReferenceDescriptor.getProxyPrefetchingLimit() > 0 && (indirectionHandler = PersistenceBrokerImpl.getIndirectionHandler(object2)) != null && this.addRetrievalTask(object, objectReferenceDescriptor)) {
                    indirectionHandler.addListener(new PBMaterializationListener(this.m_retrievalTasks, objectReferenceDescriptor, objectReferenceDescriptor.getProxyPrefetchingLimit()));
                }
            }
        }
    }

    private static IndirectionHandler getIndirectionHandler(Object object) {
        if (Proxy.isProxyClass(object.getClass())) {
            return (IndirectionHandler)Proxy.getInvocationHandler(object);
        }
        if (object instanceof VirtualProxy) {
            return VirtualProxy.getIndirectionHandler((VirtualProxy)object);
        }
        return null;
    }

    private void retrieveCollection(Object object, ClassDescriptor classDescriptor, CollectionDescriptor collectionDescriptor, boolean bl) {
        if (bl || collectionDescriptor.getCascadeRetrieve()) {
            if (this.m_retrievalTasks != null && !collectionDescriptor.isLazy() && !collectionDescriptor.isMtoNRelation() && collectionDescriptor.getItemProxyClass() == null && collectionDescriptor.getQueryCustomizer() == null) {
                this.addRetrievalTask(object, collectionDescriptor);
            } else {
                Object object2;
                Class clazz = collectionDescriptor.getCollectionClass();
                PersistentField persistentField = collectionDescriptor.getPersistentField();
                org.apache.ojb.broker.query.Query query = this.getFKQuery(object, classDescriptor, collectionDescriptor);
                if (clazz == null) {
                    Collection collection = this.getCollectionByQuery(query, collectionDescriptor.isLazy());
                    if (persistentField.getType().isArray()) {
                        int n = collection.size();
                        Class<?> clazz2 = persistentField.getType().getComponentType();
                        Object object3 = Array.newInstance(clazz2, n);
                        for (int i = 0; i < n; ++i) {
                            Array.set(object3, i, ((Vector)collection).get(i));
                        }
                        persistentField.set(object, object3);
                    } else {
                        persistentField.set(object, collection);
                    }
                    object2 = collection;
                } else {
                    ManageableCollection manageableCollection = this.getCollectionByQuery(clazz, query, collectionDescriptor.isLazy());
                    persistentField.set(object, manageableCollection);
                    object2 = manageableCollection;
                }
                if (this.m_retrievalTasks != null && collectionDescriptor.getProxyPrefetchingLimit() > 0 && !collectionDescriptor.isMtoNRelation() && collectionDescriptor.getQueryCustomizer() == null && object2 instanceof CollectionProxy && this.addRetrievalTask(object, collectionDescriptor)) {
                    ((CollectionProxy)object2).addListener(new PBCollectionProxyListener(this.m_retrievalTasks, collectionDescriptor, collectionDescriptor.getProxyPrefetchingLimit()));
                }
            }
        }
    }

    private org.apache.ojb.broker.query.Query getFKQuery(Object object, ClassDescriptor classDescriptor, CollectionDescriptor collectionDescriptor) {
        org.apache.ojb.broker.query.Query query = null;
        QueryByCriteria queryByCriteria = null;
        queryByCriteria = collectionDescriptor.isMtoNRelation() ? this.getFKQueryMtoN(object, classDescriptor, collectionDescriptor) : this.getFKQuery1toN(object, classDescriptor, collectionDescriptor);
        if (!collectionDescriptor.getOrderBy().isEmpty()) {
            Iterator iterator = collectionDescriptor.getOrderBy().iterator();
            while (iterator.hasNext()) {
                queryByCriteria.addOrderBy((FieldHelper)iterator.next());
            }
        }
        query = collectionDescriptor.getQueryCustomizer() != null ? collectionDescriptor.getQueryCustomizer().customizeQuery(object, this, collectionDescriptor, queryByCriteria) : queryByCriteria;
        return query;
    }

    private org.apache.ojb.broker.query.Query getPKQuery(Identity identity) {
        Object[] objectArray = identity.getPrimaryKeyValues();
        ClassDescriptor classDescriptor = this.getClassDescriptor(identity.getObjectsTopLevelClass());
        FieldDescriptor[] fieldDescriptorArray = classDescriptor.getPkFields();
        Criteria criteria = new Criteria();
        for (int i = 0; i < fieldDescriptorArray.length; ++i) {
            FieldDescriptor fieldDescriptor = fieldDescriptorArray[i];
            criteria.addEqualTo(fieldDescriptor.getAttributeName(), objectArray[i]);
        }
        return QueryFactory.newQuery(classDescriptor.getClassOfObject(), criteria);
    }

    public void retrieveCollections(Object object, ClassDescriptor classDescriptor, boolean bl) throws PersistenceBrokerException {
        Iterator iterator = classDescriptor.getCollectionDescriptors().iterator();
        Class clazz = this.classToPrefetch;
        this.classToPrefetch = null;
        while (iterator.hasNext()) {
            CollectionDescriptor collectionDescriptor = (CollectionDescriptor)iterator.next();
            this.retrieveCollection(object, classDescriptor, collectionDescriptor, bl);
        }
        this.classToPrefetch = clazz;
    }

    public void refreshRelationships(Object object, ClassDescriptor classDescriptor) {
        Iterator iterator = classDescriptor.getCollectionDescriptors().iterator();
        while (iterator.hasNext()) {
            CollectionDescriptor collectionDescriptor = (CollectionDescriptor)iterator.next();
            if (!collectionDescriptor.isRefresh()) continue;
            this.retrieveCollection(object, classDescriptor, collectionDescriptor, false);
        }
        iterator = classDescriptor.getObjectReferenceDescriptors().iterator();
        while (iterator.hasNext()) {
            ObjectReferenceDescriptor objectReferenceDescriptor = (ObjectReferenceDescriptor)iterator.next();
            if (!objectReferenceDescriptor.isRefresh()) continue;
            this.retrieveReference(object, classDescriptor, objectReferenceDescriptor, false);
        }
    }

    private Identity getReferencedObjectIdentity(Object object, ObjectReferenceDescriptor objectReferenceDescriptor, ClassDescriptor classDescriptor) {
        Object[] objectArray = objectReferenceDescriptor.getForeignKeyValues(object, classDescriptor);
        boolean bl = true;
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null) continue;
            bl = false;
            break;
        }
        if (bl) {
            return null;
        }
        return new Identity(objectReferenceDescriptor.getItemClass(), this.getTopLevelClass(objectReferenceDescriptor.getItemClass()), objectArray);
    }

    private Object getReferencedObject(Identity identity, ObjectReferenceDescriptor objectReferenceDescriptor, ClassDescriptor classDescriptor) {
        Class clazz = objectReferenceDescriptor.isLazy() ? this.getClassDescriptor(objectReferenceDescriptor.getItemClass()).getDynamicProxyClass() : objectReferenceDescriptor.getItemProxyClass();
        if (clazz != null) {
            try {
                return VirtualProxy.createProxy(this.getPBKey(), clazz, identity);
            }
            catch (Exception exception) {
                this.logger.error("Error instantiating obj: " + exception.getMessage(), exception);
                throw new PersistenceBrokerException(exception);
            }
        }
        return this.getObjectByIdentity(identity);
    }

    private ManageableCollection getCollectionByQuery(Class clazz, Class clazz2, org.apache.ojb.broker.query.Query query) throws ClassNotPersistenceCapableException, PersistenceBrokerException {
        boolean bl;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getCollectionByQuery (" + clazz + ", " + clazz2 + ", " + query + ")");
        }
        ClassDescriptor classDescriptor = this.getClassDescriptor(clazz2);
        ManageableCollection manageableCollection = null;
        OJBIterator oJBIterator = null;
        boolean bl2 = bl = this.m_retrievalTasks == null;
        if (bl) {
            this.m_retrievalTasks = new HashMap();
        }
        try {
            block21: {
                try {
                    Object object;
                    manageableCollection = (ManageableCollection)clazz.newInstance();
                    oJBIterator = this.getIteratorFromQuery(query, classDescriptor);
                    int n = query.getStartAtIndex();
                    int n2 = query.getEndAtIndex();
                    if (n > 1) {
                        oJBIterator.absolute(n - 1);
                    }
                    if (n2 < n) {
                        n2 = oJBIterator.size() + 1;
                    }
                    int n3 = n2 - n;
                    int n4 = 0;
                    while ((n2 == 0 || n4 < n3) && oJBIterator.hasNext()) {
                        object = oJBIterator.next();
                        if (object == null) continue;
                        IndirectionHandler indirectionHandler = PersistenceBrokerImpl.getIndirectionHandler(object);
                        if (indirectionHandler != null || clazz2.isAssignableFrom(object.getClass())) {
                            manageableCollection.ojbAdd(object);
                            ++n4;
                        } else {
                            this.logger.warn("Candidate object [" + object + "] class [" + object.getClass().getName() + "] is not a subtype of [" + clazz2.getName() + "] or any type of proxy. NOT INCLUDED in result collection");
                        }
                        if (indirectionHandler == null || classDescriptor.getProxyPrefetchingLimit() <= 0 || !this.addRetrievalTask(object, this)) continue;
                        indirectionHandler.addListener(new PBMaterializationListener(this.m_retrievalTasks, this, classDescriptor.getProxyPrefetchingLimit()));
                    }
                    if (bl) {
                        object = this.classToPrefetch;
                        this.classToPrefetch = null;
                        this.performRetrievalTasks();
                        this.classToPrefetch = object;
                    }
                    if (n == 0 && n2 == 0) {
                        query.fullSize(n4);
                        break block21;
                    }
                    if (n3 > n4) {
                        if (n != 0) {
                            query.fullSize(n4 + query.getStartAtIndex() - 1);
                        } else {
                            query.fullSize(n4);
                        }
                        break block21;
                    }
                    query.fullSize(oJBIterator.size());
                }
                catch (InstantiationException instantiationException) {
                    this.logger.error(instantiationException);
                    throw new PersistenceBrokerException(instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    this.logger.error(illegalAccessException);
                    throw new PersistenceBrokerException(illegalAccessException);
                }
            }
            Object var15_16 = null;
            if (oJBIterator != null) {
                oJBIterator.releaseDbResources();
            }
            if (bl) {
                this.m_retrievalTasks = null;
            }
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            if (oJBIterator != null) {
                oJBIterator.releaseDbResources();
            }
            if (bl) {
                this.m_retrievalTasks = null;
            }
            throw throwable;
        }
        return manageableCollection;
    }

    private void performRetrievalTasks() {
        if (this.m_retrievalTasks == null) {
            return;
        }
        while (this.m_retrievalTasks.size() > 0) {
            HashMap hashMap = this.m_retrievalTasks;
            this.m_retrievalTasks = new HashMap();
            Iterator iterator = hashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k = entry.getKey();
                if (!(k instanceof ObjectReferenceDescriptor)) continue;
                ObjectReferenceDescriptor objectReferenceDescriptor = (ObjectReferenceDescriptor)k;
                ArrayList arrayList = (ArrayList)entry.getValue();
                if (objectReferenceDescriptor.isLazy() || objectReferenceDescriptor.getItemProxyClass() != null) continue;
                RelationshipPrefetcherImpl relationshipPrefetcherImpl = objectReferenceDescriptor instanceof CollectionDescriptor ? new CollectionPrefetcher((PersistenceBroker)this, objectReferenceDescriptor) : new ReferencePrefetcher((PersistenceBroker)this, objectReferenceDescriptor);
                relationshipPrefetcherImpl.prefetchRelationship(arrayList);
                iterator.remove();
            }
        }
    }

    public ManageableCollection getCollectionByQuery(Class clazz, org.apache.ojb.broker.query.Query query) throws PersistenceBrokerException {
        return this.getCollectionByQuery(clazz, query, false);
    }

    public ManageableCollection getCollectionByQuery(Class clazz, org.apache.ojb.broker.query.Query query, boolean bl) throws PersistenceBrokerException {
        try {
            ManageableCollection manageableCollection = query == null ? (ManageableCollection)clazz.newInstance() : (bl ? ProxyHelper.createCollectionProxy(this, query, clazz) : this.getCollectionByQuery(clazz, query.getSearchClass(), query));
            return manageableCollection;
        }
        catch (Throwable throwable) {
            throw new PersistenceBrokerException(throwable);
        }
    }

    public Collection getCollectionByQuery(org.apache.ojb.broker.query.Query query) throws PersistenceBrokerException {
        return this.getCollectionByQuery(query, false);
    }

    public Collection getCollectionByQuery(org.apache.ojb.broker.query.Query query, boolean bl) throws PersistenceBrokerException {
        return (Collection)((Object)this.getCollectionByQuery(class$org$apache$ojb$broker$util$collections$RemovalAwareCollection == null ? (class$org$apache$ojb$broker$util$collections$RemovalAwareCollection = PersistenceBrokerImpl.class$("org.apache.ojb.broker.util.collections.RemovalAwareCollection")) : class$org$apache$ojb$broker$util$collections$RemovalAwareCollection, query, bl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getDBObject(Identity identity) throws ClassNotPersistenceCapableException {
        ClassDescriptor classDescriptor;
        Object object;
        Class clazz = identity.getObjectsRealClass();
        if (clazz == null) {
            this.logger.info("Real class for used Identity object is 'null', use top-level class instead");
            clazz = identity.getObjectsTopLevelClass();
        }
        ClassDescriptor classDescriptor2 = this.getClassDescriptor(clazz);
        Object object2 = null;
        if (!classDescriptor2.isInterface()) {
            object2 = this.dbAccess.materializeObject(classDescriptor2, identity);
        }
        if (object2 == null && classDescriptor2.isExtent()) {
            object = classDescriptor2.getAllConcreteExtentClasses().iterator();
            while (object.hasNext() && (object2 = this.dbAccess.materializeObject(classDescriptor = this.getClassDescriptor((Class)object.next()), identity)) == null) {
            }
        }
        if (object2 != null) {
            if (identity.getObjectsRealClass() == null) {
                identity.setObjectsRealClass(object2.getClass());
            }
            object = object2;
            synchronized (object) {
                this.objectCache.cache(identity, object2);
                classDescriptor = this.getClassDescriptor(object2.getClass());
                this.retrieveReferences(object2, classDescriptor, false);
                this.retrieveCollections(object2, classDescriptor, false);
            }
        }
        return object2;
    }

    public Iterator getIteratorByQuery(org.apache.ojb.broker.query.Query query) throws PersistenceBrokerException {
        Class clazz = query.getSearchClass();
        ClassDescriptor classDescriptor = this.getClassDescriptor(clazz);
        return this.getIteratorFromQuery(query, classDescriptor);
    }

    private OJBIterator getIteratorFromQuery(org.apache.ojb.broker.query.Query query, ClassDescriptor classDescriptor) throws PersistenceBrokerException {
        RsIteratorFactory rsIteratorFactory = RsIteratorFactoryImpl.getInstance();
        return this.getRsIteratorFromQuery(query, classDescriptor, rsIteratorFactory);
    }

    public Object getObjectByIdentity(Identity identity) throws PersistenceBrokerException {
        Object object;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getObjectByIdentity " + identity);
        }
        if ((object = this.objectCache.lookup(identity)) == null) {
            object = this.getDBObject(identity);
        } else {
            ClassDescriptor classDescriptor = this.getClassDescriptor(object.getClass());
            if (classDescriptor.isAlwaysRefresh()) {
                this.refreshInstance(object, identity, classDescriptor);
            }
            this.refreshRelationships(object, classDescriptor);
        }
        this.AFTER_LOOKUP_EVENT.setTarget(object);
        this.fireBrokerEvent(this.AFTER_LOOKUP_EVENT);
        return object;
    }

    private void refreshInstance(Object object, Identity identity, ClassDescriptor classDescriptor) {
        Object object2 = this.getDBObject(identity);
        FieldDescriptor[] fieldDescriptorArray = classDescriptor.getFieldDescriptions();
        for (int i = 0; i < fieldDescriptorArray.length; ++i) {
            FieldDescriptor fieldDescriptor = fieldDescriptorArray[i];
            PersistentField persistentField = fieldDescriptor.getPersistentField();
            persistentField.set(object, persistentField.get(object2));
        }
    }

    public Object getObjectByQuery(org.apache.ojb.broker.query.Query query) throws PersistenceBrokerException {
        if (query instanceof QueryByIdentity) {
            Object object = query.getExampleObject();
            Identity identity = null;
            identity = object instanceof Identity ? (Identity)object : new Identity(object, this);
            return this.getObjectByIdentity(identity);
        }
        Vector vector = (Vector)this.getCollectionByQuery(query);
        if (vector == null || vector.size() == 0) {
            return null;
        }
        return vector.get(0);
    }

    public Enumeration getPKEnumerationByQuery(Class clazz, org.apache.ojb.broker.query.Query query) throws PersistenceBrokerException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getPKEnumerationByQuery " + query);
        }
        ClassDescriptor classDescriptor = this.getClassDescriptor(query.getSearchClass());
        return new PkEnumeration(query, classDescriptor, clazz, this);
    }

    public void store(Object object, ObjectModification objectModification) throws PersistenceBrokerException {
        object = ProxyHelper.getRealObject(object);
        ClassDescriptor classDescriptor = this.getClassDescriptor(object.getClass());
        Identity identity = new Identity(object, this, classDescriptor);
        if (objectModification.needsInsert()) {
            this.store(object, identity, classDescriptor, true);
        } else if (objectModification.needsUpdate()) {
            this.store(object, identity, classDescriptor, false);
        } else {
            this.storeCollections(object, classDescriptor.getCollectionDescriptors(), objectModification.needsInsert());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store(Object object, Identity identity, ClassDescriptor classDescriptor, boolean bl) {
        if (bl) {
            this.BEFORE_STORE_EVENT.setTarget(object);
            this.fireBrokerEvent(this.BEFORE_STORE_EVENT);
        } else {
            this.BEFORE_UPDATE_EVENT.setTarget(object);
            this.fireBrokerEvent(this.BEFORE_UPDATE_EVENT);
        }
        if (object != null) {
            this.nowStoring.add(object);
            try {
                this.storeToDb(object, classDescriptor, identity, bl);
            }
            finally {
                this.nowStoring.remove(object);
            }
        } else {
            return;
        }
        if (bl) {
            this.AFTER_STORE_EVENT.setTarget(object);
            this.fireBrokerEvent(this.AFTER_STORE_EVENT);
        } else {
            this.AFTER_UPDATE_EVENT.setTarget(object);
            this.fireBrokerEvent(this.AFTER_UPDATE_EVENT);
        }
    }

    private void storeToDb(Object object, ClassDescriptor classDescriptor, Identity identity, boolean bl) {
        Vector vector = classDescriptor.getObjectReferenceDescriptors();
        if (vector.size() > 0) {
            this.storeReferences(object, vector);
            this.assignReferenceFKs(object, vector);
        }
        Object[] objectArray = identity.getPrimaryKeyValues();
        if (!this.assertValidPkFields(classDescriptor.getPkFields(), objectArray)) {
            objectArray = this.serviceBrokerHelper().getKeyValues(classDescriptor, object);
            if (!this.assertValidPkFields(classDescriptor.getPkFields(), objectArray)) {
                String string = bl ? " on insert" : " on update";
                throw new PersistenceBrokerException("assertValidPkFields failed for Object of type: " + classDescriptor.getClassNameOfObject() + string);
            }
        }
        try {
            this.sequenceManager.setReferenceFKs(object, classDescriptor);
        }
        catch (SequenceManagerException sequenceManagerException) {
            this.logger.error("Setting of reference FK failed", (Throwable)((Object)sequenceManagerException));
            throw new PersistenceBrokerException((Throwable)((Object)sequenceManagerException));
        }
        this.storeSuperClasses(object, classDescriptor, identity, bl);
        if (bl) {
            this.dbAccess.executeInsert(classDescriptor, object);
            try {
                this.sequenceManager.afterStore(this.dbAccess, classDescriptor, object);
            }
            catch (SequenceManagerException sequenceManagerException) {
                this.logger.error("SQLException during SequenceManager.afterStore (for a " + classDescriptor.getClassOfObject().getName() + "): " + sequenceManagerException.getMessage(), (Throwable)((Object)sequenceManagerException));
                throw new PersistenceBrokerException((Throwable)((Object)sequenceManagerException));
            }
        } else {
            this.dbAccess.executeUpdate(classDescriptor, object);
        }
        Identity identity2 = new Identity(object, this, classDescriptor);
        this.objectCache.cache(identity2, object);
        this.storeCollections(object, classDescriptor.getCollectionDescriptors(), bl);
    }

    private boolean assertValidPkFields(FieldDescriptor[] fieldDescriptorArray, Object[] objectArray) {
        int n = fieldDescriptorArray.length;
        for (int i = 0; i < n; ++i) {
            if (fieldDescriptorArray[i].isAutoIncrement() || fieldDescriptorArray[i].isLocking() || this.assertValidPkValue(objectArray[i])) continue;
            return false;
        }
        return true;
    }

    private boolean assertValidPkValue(Object object) {
        if (object == null) {
            return false;
        }
        return !(object instanceof String) || object.toString().trim().length() != 0;
    }

    private void storeSuperClasses(Object object, ClassDescriptor classDescriptor, Identity identity, boolean bl) {
        if (classDescriptor.getSuperClass() != null) {
            ClassDescriptor classDescriptor2 = this.getDescriptorRepository().getDescriptorFor(classDescriptor.getSuperClass());
            this.storeToDb(object, classDescriptor2, identity, bl);
            this.storeCollections(object, classDescriptor.getCollectionDescriptors(), bl);
        }
    }

    private void assignReferenceFKs(Object object, Vector vector) throws PersistenceBrokerException {
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            ObjectReferenceDescriptor objectReferenceDescriptor = (ObjectReferenceDescriptor)iterator.next();
            Object object2 = objectReferenceDescriptor.getPersistentField().get(object);
            this.assertFkAssignment(object, object2, objectReferenceDescriptor);
        }
    }

    public boolean isInTransaction() {
        return this.connectionManager.isInLocalTransaction();
    }

    private QueryByCriteria getFKQuery1toN(Object object, ClassDescriptor classDescriptor, CollectionDescriptor collectionDescriptor) {
        Object[] objectArray = this.brokerHelper.getKeyValues(classDescriptor, object);
        ClassDescriptor classDescriptor2 = this.getClassDescriptor(collectionDescriptor.getItemClass());
        FieldDescriptor[] fieldDescriptorArray = collectionDescriptor.getForeignKeyFieldDescriptors(classDescriptor2);
        Criteria criteria = new Criteria();
        for (int i = 0; i < fieldDescriptorArray.length; ++i) {
            FieldDescriptor fieldDescriptor = fieldDescriptorArray[i];
            criteria.addEqualTo(fieldDescriptor.getAttributeName(), objectArray[i]);
        }
        return QueryFactory.newQuery(classDescriptor2.getClassOfObject(), criteria);
    }

    private QueryByCriteria getFKQueryMtoN(Object object, ClassDescriptor classDescriptor, CollectionDescriptor collectionDescriptor) {
        int n;
        Object[] objectArray = this.brokerHelper.getKeyValues(classDescriptor, object);
        String[] stringArray = collectionDescriptor.getFksToThisClass();
        String[] stringArray2 = collectionDescriptor.getFksToItemClass();
        ClassDescriptor classDescriptor2 = this.getClassDescriptor(collectionDescriptor.getItemClass());
        Criteria criteria = new Criteria();
        for (n = 0; n < stringArray.length; ++n) {
            criteria.addColumnEqualTo(collectionDescriptor.getIndirectionTable() + "." + stringArray[n], objectArray[n]);
        }
        for (n = 0; n < stringArray2.length; ++n) {
            criteria.addColumnEqualToField(collectionDescriptor.getIndirectionTable() + "." + stringArray2[n].toString(), classDescriptor2.getPkFields()[n].getAttributeName());
        }
        return QueryFactory.newQuery(classDescriptor2.getClassOfObject(), collectionDescriptor.getIndirectionTable(), criteria);
    }

    public void removeFromCache(Object object) throws PersistenceBrokerException {
        Identity identity = object instanceof Identity ? (Identity)object : new Identity(object, this);
        this.objectCache.remove(identity);
    }

    public ClassDescriptor getClassDescriptor(Class clazz) throws PersistenceBrokerException {
        return this.descriptorRepository.getDescriptorFor(clazz);
    }

    public boolean hasClassDescriptor(Class clazz) {
        return this.descriptorRepository.hasDescriptorFor(clazz);
    }

    public void clearCache() throws PersistenceBrokerException {
        this.objectCache.clear();
    }

    public Class getExtentClass(Class clazz) throws PersistenceBrokerException {
        return this.getTopLevelClass(clazz);
    }

    public Class getTopLevelClass(Class clazz) throws PersistenceBrokerException {
        try {
            return this.descriptorRepository.getTopLevelClass(clazz);
        }
        catch (ClassNotPersistenceCapableException classNotPersistenceCapableException) {
            throw new PersistenceBrokerException((Throwable)((Object)classNotPersistenceCapableException));
        }
    }

    public void invalidate(Identity identity) throws PersistenceBrokerException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount(org.apache.ojb.broker.query.Query query) throws PersistenceBrokerException {
        ReportQueryByCriteria reportQueryByCriteria;
        Criteria criteria = null;
        FieldDescriptor[] fieldDescriptorArray = this.getClassDescriptor(query.getSearchClass()).getPkFields();
        String[] stringArray = new String[fieldDescriptorArray.length];
        int n = 0;
        if (query.getCriteria() != null) {
            criteria = query.getCriteria().copy(false, false, false);
        }
        for (int i = 0; i < fieldDescriptorArray.length; ++i) {
            stringArray[i] = query.isDistinct() ? "count(distinct " + fieldDescriptorArray[i].getAttributeName() + ")" : "count(" + fieldDescriptorArray[i].getAttributeName() + ")";
        }
        if (query instanceof MtoNQuery) {
            reportQueryByCriteria = new ReportQueryByMtoNCriteria(query.getSearchClass(), stringArray, criteria);
            ((ReportQueryByMtoNCriteria)reportQueryByCriteria).setIndirectionTable(((MtoNQuery)((Object)query)).getIndirectionTable());
        } else {
            reportQueryByCriteria = new ReportQueryByCriteria(query.getSearchClass(), stringArray, criteria);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getCount " + reportQueryByCriteria.getSearchClass() + ", " + reportQueryByCriteria);
        }
        Iterator iterator = this.getReportQueryIteratorByQuery(reportQueryByCriteria);
        try {
            while (iterator.hasNext()) {
                Object[] objectArray = (Object[])iterator.next();
                n += ((Number)objectArray[0]).intValue();
            }
        }
        finally {
            if (iterator instanceof OJBIterator) {
                ((OJBIterator)iterator).releaseDbResources();
            }
        }
        return n;
    }

    public Iterator getReportQueryIteratorByQuery(org.apache.ojb.broker.query.Query query) throws PersistenceBrokerException {
        ClassDescriptor classDescriptor = this.getClassDescriptor(query.getSearchClass());
        return this.getReportQueryIteratorFromQuery(query, classDescriptor);
    }

    private OJBIterator getRsIteratorFromQuery(org.apache.ojb.broker.query.Query query, ClassDescriptor classDescriptor, RsIteratorFactory rsIteratorFactory) throws PersistenceBrokerException {
        if (query instanceof QueryBySQL) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Creating SQL-RsIterator for class [" + classDescriptor.getClassNameOfObject() + "]");
            }
            String string = ((QueryBySQL)query).getSql();
            return rsIteratorFactory.createRsIterator(string, classDescriptor, this);
        }
        if (!classDescriptor.isExtent() || !query.getWithExtents()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Creating RsIterator for class [" + classDescriptor.getClassNameOfObject() + "]");
            }
            return rsIteratorFactory.createRsIterator(query, classDescriptor, this);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Creating ChainingIterator for class [" + classDescriptor.getClassNameOfObject() + "]");
        }
        ChainingIterator chainingIterator = new ChainingIterator();
        if (!classDescriptor.isInterface()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Adding RsIterator for class [" + classDescriptor.getClassNameOfObject() + "] to ChainingIterator");
            }
            chainingIterator.addIterator(rsIteratorFactory.createRsIterator(query, classDescriptor, this));
        }
        Iterator iterator = classDescriptor.getAllConcreteExtentClasses().iterator();
        while (iterator.hasNext()) {
            Class clazz = (Class)iterator.next();
            ClassDescriptor classDescriptor2 = this.getClassDescriptor(clazz);
            if (chainingIterator.containsIteratorForTable(classDescriptor2.getFullTableName())) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Skipping class [" + classDescriptor2.getClassNameOfObject() + "]");
                continue;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Adding RsIterator of class [" + clazz + "] to ChainingIterator");
            }
            chainingIterator.addIterator(rsIteratorFactory.createRsIterator(query, classDescriptor2, this));
        }
        return chainingIterator;
    }

    private OJBIterator getReportQueryIteratorFromQuery(org.apache.ojb.broker.query.Query query, ClassDescriptor classDescriptor) throws PersistenceBrokerException {
        RsIteratorFactory rsIteratorFactory = ReportRsIteratorFactoryImpl.getInstance();
        return this.getRsIteratorFromQuery(query, classDescriptor, rsIteratorFactory);
    }

    public Query query() {
        return new QueryImpl(this);
    }

    public DescriptorRepository getDescriptorRepository() {
        return this.descriptorRepository;
    }

    protected void finalize() {
        if (!this.isClosed) {
            this.close();
        }
    }

    private void clearRegistrationLists() {
        this.markedForDelete.clear();
    }

    private void removePrefetchingListeners() {
        if (this.prefetchingListeners != null) {
            Iterator iterator = this.prefetchingListeners.iterator();
            while (iterator.hasNext()) {
                PBPrefetchingListener pBPrefetchingListener = (PBPrefetchingListener)iterator.next();
                pBPrefetchingListener.removeThisListener();
            }
            this.prefetchingListeners.clear();
        }
    }

    public void deleteMtoNImplementor(MtoNImplementor mtoNImplementor) throws PersistenceBrokerException {
        Object[] objectArray;
        DescriptorRepository descriptorRepository = this.getDescriptorRepository();
        Object object = mtoNImplementor.getLeftObject();
        Class<?> clazz = object.getClass();
        Object object2 = mtoNImplementor.getRightObject();
        Class<?> clazz2 = object2.getClass();
        this.logger.debug("Deleting MtoN implementor [" + clazz + "] [" + clazz2 + "]");
        ClassDescriptor classDescriptor = descriptorRepository.getDescriptorFor(clazz);
        ClassDescriptor classDescriptor2 = descriptorRepository.getDescriptorFor(clazz2);
        Vector vector = classDescriptor.getCollectionDescriptors();
        Object[] objectArray2 = null;
        Object[] objectArray3 = vector.iterator();
        while (objectArray3.hasNext()) {
            objectArray = (Object[])objectArray3.next();
            if (!objectArray.getItemClass().isAssignableFrom(clazz2)) continue;
            objectArray2 = objectArray;
        }
        if (objectArray2 == null) {
            throw new PersistenceBrokerException("Can't find reasonable collection descriptor for MtoN implementor left[" + clazz + "] right[" + clazz2 + "]");
        }
        if (object != null && object2 != null) {
            objectArray3 = this.brokerHelper.getKeyValues(classDescriptor, object);
            objectArray = this.brokerHelper.getKeyValues(classDescriptor2, object2);
            String[] stringArray = objectArray2.getFksToThisClass();
            String[] stringArray2 = objectArray2.getFksToItemClass();
            String string = objectArray2.getIndirectionTable();
            if (string == null) {
                throw new PersistenceBrokerException("Can't remove MtoN implementor withou an indirection table");
            }
            String string2 = this.sqlGenerator.getDeleteMNStatement(string, stringArray, stringArray2);
            this.dbAccess.executeUpdateSQL(string2, classDescriptor, objectArray3, objectArray);
        }
    }

    public void addMtoNImplementor(MtoNImplementor mtoNImplementor) throws PersistenceBrokerException {
        throw new UnsupportedOperationException();
    }

    public Class getClassToPrefetch() {
        return this.classToPrefetch;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class PBCollectionProxyListener
    extends PBPrefetchingListener
    implements CollectionProxyListener {
        CollectionProxy _listenedCollection;

        PBCollectionProxyListener(HashMap hashMap, CollectionDescriptor collectionDescriptor, int n) {
            super(hashMap, collectionDescriptor, n);
        }

        protected void addThisListenerTo(Object object) {
            this._listenedCollection = (CollectionProxy)object;
            this._listenedCollection.addListener(this);
        }

        protected void removeThisListener() {
            if (this._listenedCollection != null) {
                this._listenedCollection.removeListener(this);
                this._listenedCollection = null;
            }
        }

        protected BasePrefetcher getPrefetcher(Object object) {
            return new CollectionPrefetcher((PersistenceBroker)PersistenceBrokerImpl.this, (CollectionDescriptor)this._key);
        }

        public void beforeLoading(CollectionProxy collectionProxy) {
            this.prefetch(collectionProxy);
        }

        public void afterLoading(CollectionProxy collectionProxy) {
        }
    }

    class PBMaterializationListener
    extends PBPrefetchingListener
    implements MaterializationListener {
        private IndirectionHandler _listenedHandler;

        PBMaterializationListener(HashMap hashMap, Object object, int n) {
            super(hashMap, object, n);
        }

        protected void addThisListenerTo(Object object) {
            this._listenedHandler = PersistenceBrokerImpl.getIndirectionHandler(object);
            if (this._listenedHandler != null) {
                this._listenedHandler.addListener(this);
            }
        }

        protected void removeThisListener() {
            if (this._listenedHandler != null) {
                this._listenedHandler.removeListener(this);
                this._listenedHandler = null;
            }
        }

        protected BasePrefetcher getPrefetcher(Object object) {
            if (this._key instanceof ObjectReferenceDescriptor) {
                return new ReferencePrefetcher((PersistenceBroker)PersistenceBrokerImpl.this, (ObjectReferenceDescriptor)this._key);
            }
            IndirectionHandler indirectionHandler = (IndirectionHandler)object;
            return new PlainPrefetcher(PersistenceBrokerImpl.this, indirectionHandler.getIdentity().getObjectsTopLevelClass());
        }

        public void beforeMaterialization(IndirectionHandler indirectionHandler, Identity identity) {
            this.prefetch(indirectionHandler);
        }

        public void afterMaterialization(IndirectionHandler indirectionHandler, Object object) {
        }
    }

    abstract class PBPrefetchingListener {
        private HashMap _retrievalTasks;
        private int _limit;
        protected Object _key;

        PBPrefetchingListener(HashMap hashMap, Object object, int n) {
            this._retrievalTasks = hashMap;
            this._key = object;
            this._limit = n + 1;
            if (PersistenceBrokerImpl.this.prefetchingListeners == null) {
                PersistenceBrokerImpl.this.prefetchingListeners = new ArrayList();
            }
            PersistenceBrokerImpl.this.prefetchingListeners.add(this);
        }

        protected abstract void addThisListenerTo(Object var1);

        protected abstract void removeThisListener();

        protected abstract BasePrefetcher getPrefetcher(Object var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void prefetch(Object object) {
            boolean bl;
            List list;
            ArrayList arrayList = (ArrayList)this._retrievalTasks.get(this._key);
            this.removeThisListener();
            if (arrayList == null) {
                return;
            }
            BasePrefetcher basePrefetcher = this.getPrefetcher(object);
            if (arrayList.size() <= this._limit) {
                list = arrayList;
                bl = true;
            } else {
                list = arrayList.subList(0, this._limit);
                bl = false;
            }
            Class clazz = PersistenceBrokerImpl.this.classToPrefetch;
            PersistenceBrokerImpl.this.classToPrefetch = basePrefetcher.getItemClassDescriptor().getClassOfObject();
            try {
                basePrefetcher.prefetchRelationship(list);
            }
            finally {
                PersistenceBrokerImpl.this.classToPrefetch = clazz;
            }
            if (bl) {
                this._retrievalTasks.remove(this._key);
            } else {
                list.clear();
                this.addThisListenerTo(arrayList.get(0));
            }
        }
    }

    private final class Key {
        final Object[] m_key;

        Key(Object[] objectArray) {
            this.m_key = new Object[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                this.m_key[i] = objectArray[i] instanceof Number ? new Long(((Number)objectArray[i]).longValue()) : objectArray[i];
            }
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof Key) {
                Key key = (Key)object;
                if (key.m_key.length == this.m_key.length) {
                    for (int i = 0; i < this.m_key.length; ++i) {
                        if (!key.m_key[i].equals(this.m_key[i])) {
                            bl = false;
                            break;
                        }
                        bl = true;
                    }
                }
            }
            return bl;
        }
    }
}

