/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.core;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.ManageableCollection;
import org.apache.ojb.broker.MtoNImplementor;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PBLifeCycleEvent;
import org.apache.ojb.broker.PBListener;
import org.apache.ojb.broker.PBState;
import org.apache.ojb.broker.PBStateEvent;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerEvent;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.TransactionAbortedException;
import org.apache.ojb.broker.TransactionInProgressException;
import org.apache.ojb.broker.TransactionNotInProgressException;
import org.apache.ojb.broker.accesslayer.ConnectionManagerIF;
import org.apache.ojb.broker.accesslayer.JdbcAccess;
import org.apache.ojb.broker.accesslayer.StatementManagerIF;
import org.apache.ojb.broker.accesslayer.sql.SqlGenerator;
import org.apache.ojb.broker.cache.ObjectCache;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.util.BrokerHelper;
import org.apache.ojb.broker.util.ObjectModification;
import org.apache.ojb.broker.util.configuration.Configuration;
import org.apache.ojb.broker.util.configuration.ConfigurationException;
import org.apache.ojb.broker.util.sequence.SequenceManager;
import org.odbms.Query;

public class DelegatingPersistenceBroker
implements PersistenceBroker,
PBState {
    protected PersistenceBroker m_broker;

    public DelegatingPersistenceBroker(PersistenceBroker persistenceBroker) {
        this.m_broker = persistenceBroker;
    }

    protected PersistenceBroker getBroker() {
        if (this.m_broker != null) {
            return this.m_broker;
        }
        throw new IllegalStateException("This PersistenceBroker instance is already closed and no longer useable. It's not possible to re-use a closed instance.");
    }

    public PersistenceBroker getDelegate() {
        return this.m_broker;
    }

    public void setDelegate(PersistenceBroker persistenceBroker) {
        this.m_broker = persistenceBroker;
    }

    public PersistenceBroker getInnermostDelegate() {
        PersistenceBroker persistenceBroker = this.m_broker;
        while (persistenceBroker != null && persistenceBroker instanceof DelegatingPersistenceBroker) {
            if (this != (persistenceBroker = ((DelegatingPersistenceBroker)persistenceBroker).getDelegate())) continue;
            return null;
        }
        return persistenceBroker;
    }

    public boolean isInTransaction() throws PersistenceBrokerException {
        return this.m_broker != null ? this.getBroker().isInTransaction() : false;
    }

    public boolean isClosed() {
        return this.m_broker != null ? this.getBroker().isClosed() : true;
    }

    public void setClosed(boolean bl) {
        ((PBState)((Object)this.getBroker())).setClosed(bl);
    }

    public void beginTransaction() throws TransactionInProgressException, TransactionAbortedException {
        this.getBroker().beginTransaction();
    }

    public void commitTransaction() throws TransactionNotInProgressException, TransactionAbortedException {
        this.getBroker().commitTransaction();
    }

    public void abortTransaction() throws TransactionNotInProgressException {
        this.getBroker().abortTransaction();
    }

    public boolean close() {
        return this.getBroker().close();
    }

    public SqlGenerator serviceSqlGenerator() {
        return this.getBroker().serviceSqlGenerator();
    }

    public JdbcAccess serviceJdbcAccess() {
        return this.getBroker().serviceJdbcAccess();
    }

    public void delete(Object object) throws PersistenceBrokerException {
        this.getBroker().delete(object);
    }

    public void store(Object object) throws PersistenceBrokerException {
        this.getBroker().store(object);
    }

    public void store(Object object, ObjectModification objectModification) throws PersistenceBrokerException {
        this.getBroker().store(object, objectModification);
    }

    public PBKey getPBKey() {
        return this.getBroker().getPBKey();
    }

    public void removeFromCache(Object object) throws PersistenceBrokerException {
        this.getBroker().removeFromCache(object);
    }

    public void clearCache() throws PersistenceBrokerException {
        this.getBroker().clearCache();
    }

    public DescriptorRepository getDescriptorRepository() {
        return this.getBroker().getDescriptorRepository();
    }

    public void removeAllListeners() throws PersistenceBrokerException {
        this.getBroker().removeAllListeners();
    }

    public void removeAllListeners(boolean bl) throws PersistenceBrokerException {
        this.getBroker().removeAllListeners(bl);
    }

    public void retrieveReference(Object object, String string) throws PersistenceBrokerException {
        this.getBroker().retrieveReference(object, string);
    }

    public void retrieveAllReferences(Object object) throws PersistenceBrokerException {
        this.getBroker().retrieveAllReferences(object);
    }

    public ConnectionManagerIF serviceConnectionManager() {
        return this.getBroker().serviceConnectionManager();
    }

    public StatementManagerIF serviceStatementManager() {
        return this.getBroker().serviceStatementManager();
    }

    public SequenceManager serviceSequenceManager() {
        return this.getBroker().serviceSequenceManager();
    }

    public BrokerHelper serviceBrokerHelper() {
        return this.getBroker().serviceBrokerHelper();
    }

    public ObjectCache serviceObjectCache() {
        return this.getBroker().serviceObjectCache();
    }

    public void fireBrokerEvent(PersistenceBrokerEvent persistenceBrokerEvent) {
        this.getBroker().fireBrokerEvent(persistenceBrokerEvent);
    }

    public void fireBrokerEvent(PBLifeCycleEvent pBLifeCycleEvent) {
        this.getBroker().fireBrokerEvent(pBLifeCycleEvent);
    }

    public void fireBrokerEvent(PBStateEvent pBStateEvent) {
        this.getBroker().fireBrokerEvent(pBStateEvent);
    }

    public void addListener(PBListener pBListener) throws PersistenceBrokerException {
        this.getBroker().addListener(pBListener);
    }

    public void addListener(PBListener pBListener, boolean bl) throws PersistenceBrokerException {
        this.getBroker().addListener(pBListener, bl);
    }

    public void removeListener(PBListener pBListener) throws PersistenceBrokerException {
    }

    public Class getTopLevelClass(Class clazz) throws PersistenceBrokerException {
        return this.getBroker().getTopLevelClass(clazz);
    }

    public boolean hasClassDescriptor(Class clazz) {
        return this.getBroker().hasClassDescriptor(clazz);
    }

    public ClassDescriptor getClassDescriptor(Class clazz) throws PersistenceBrokerException {
        return this.getBroker().getClassDescriptor(clazz);
    }

    public Enumeration getPKEnumerationByQuery(Class clazz, org.apache.ojb.broker.query.Query query) throws PersistenceBrokerException {
        return this.getBroker().getPKEnumerationByQuery(clazz, query);
    }

    public Object getObjectByQuery(org.apache.ojb.broker.query.Query query) throws PersistenceBrokerException {
        return this.getBroker().getObjectByQuery(query);
    }

    public Object getObjectByIdentity(Identity identity) throws PersistenceBrokerException {
        return this.getBroker().getObjectByIdentity(identity);
    }

    public Iterator getReportQueryIteratorByQuery(org.apache.ojb.broker.query.Query query) throws PersistenceBrokerException {
        return this.getBroker().getReportQueryIteratorByQuery(query);
    }

    public Iterator getIteratorByQuery(org.apache.ojb.broker.query.Query query) throws PersistenceBrokerException {
        return this.getBroker().getIteratorByQuery(query);
    }

    public ManageableCollection getCollectionByQuery(Class clazz, org.apache.ojb.broker.query.Query query) throws PersistenceBrokerException {
        return this.getBroker().getCollectionByQuery(clazz, query);
    }

    public int getCount(org.apache.ojb.broker.query.Query query) throws PersistenceBrokerException {
        return this.getBroker().getCount(query);
    }

    public Collection getCollectionByQuery(org.apache.ojb.broker.query.Query query) throws PersistenceBrokerException {
        return this.getBroker().getCollectionByQuery(query);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.getBroker().configure(configuration);
    }

    public Query query() {
        return this.getBroker().query();
    }

    public void deleteByQuery(org.apache.ojb.broker.query.Query query) throws PersistenceBrokerException {
        this.getBroker().deleteByQuery(query);
    }

    public void deleteMtoNImplementor(MtoNImplementor mtoNImplementor) throws PersistenceBrokerException {
        this.getBroker().deleteMtoNImplementor(mtoNImplementor);
    }

    public void addMtoNImplementor(MtoNImplementor mtoNImplementor) throws PersistenceBrokerException {
        this.getBroker().addMtoNImplementor(mtoNImplementor);
    }
}

