/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.cache;

import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PBStateEvent;
import org.apache.ojb.broker.PBStateListener;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.VirtualProxy;
import org.apache.ojb.broker.cache.ObjectCache;
import org.apache.ojb.broker.cache.ObjectCacheDefaultImpl;
import org.apache.ojb.broker.core.PersistenceBrokerImpl;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class TwoLevelCache
implements ObjectCache,
PBStateListener {
    protected Map objectTable = null;
    private static ObjectCache secondLevelCache = new ObjectCacheDefaultImpl(null, null);
    private int secondLevelFoundCount;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private DescriptorRepository descriptorRepository;
    private PBKey pbKey;
    private PersistenceBroker myBroker;
    private int hitCount = 0;
    private int failCount = 0;
    private int gcCount = 0;

    public TwoLevelCache(PersistenceBroker persistenceBroker, Properties properties) {
        this.objectTable = new HashMap();
        this.descriptorRepository = persistenceBroker.getDescriptorRepository();
        this.myBroker = persistenceBroker;
        this.pbKey = persistenceBroker.getPBKey();
        persistenceBroker.addListener(this, true);
    }

    private PBKey getPbKey() {
        return this.pbKey;
    }

    protected final DescriptorRepository getDescriptorRepository() {
        return this.descriptorRepository;
    }

    public void clear() {
        this.objectTable.clear();
    }

    public static void clearSecondLevel() {
        secondLevelCache.clear();
    }

    public void cache(Identity identity, Object object) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Caching object with identity " + identity);
        }
        if (object != null) {
            SoftReference<Object> softReference = new SoftReference<Object>(object);
            this.objectTable.put(identity, softReference);
        }
    }

    private void insertInto2ndLevel(Identity identity, Object object) {
        try {
            Object object2 = this.clone(object);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("inserting clone into 2. level cache " + identity);
            }
            this.unsetReferences(object2, object);
            secondLevelCache.cache(identity, object2);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("cache insert: " + this.myBroker + ": " + identity);
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            this.logger.error("second level caching failed: " + cloneNotSupportedException);
        }
    }

    private Object lookupFrom2ndLevel(Identity identity) {
        Object object = secondLevelCache.lookup(identity);
        if (object != null) {
            try {
                Object object2 = this.clone(object);
                this.initReferences(object2);
                this.initLookedUpCollections(object2, object);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("+++ retrieved object from second level cache.");
                }
                this.objectTable.put(identity, new SoftReference<Object>(object2));
                ++this.secondLevelFoundCount;
                return object2;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                this.logger.error("Cannot clone object from 2nd level cache: " + object);
            }
        } else {
            ++this.failCount;
        }
        return null;
    }

    private Object getReferenceProxy(ClassDescriptor classDescriptor, ObjectReferenceDescriptor objectReferenceDescriptor, Object object) {
        Object[] objectArray = objectReferenceDescriptor.getForeignKeyValues(object, classDescriptor);
        boolean bl = true;
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null) continue;
            bl = false;
            break;
        }
        if (bl) {
            return null;
        }
        Class clazz = objectReferenceDescriptor.getItemProxyClass();
        if (clazz == null) {
            clazz = this.descriptorRepository.getDescriptorFor(objectReferenceDescriptor.getItemClass()).getDynamicProxyClass();
        }
        return this.getProxy(objectReferenceDescriptor.getItemClass(), clazz, objectArray);
    }

    protected final Object getProxy(Class clazz, Class clazz2, Object[] objectArray) {
        Class clazz3 = this.descriptorRepository.getTopLevelClass(clazz);
        Object object = VirtualProxy.createProxy(this.getPbKey(), clazz2, new Identity(null, clazz3, objectArray));
        return object;
    }

    private Method getCloneMethod(Object object) {
        Class<?> clazz = object.getClass();
        while (true) {
            try {
                return clazz.getDeclaredMethod("clone", null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if ((clazz = clazz.getSuperclass()) != null) continue;
                throw new NoCloneMethod(object.getClass());
            }
            break;
        }
    }

    protected Object clone(Object object) throws CloneNotSupportedException {
        Method method = this.getCloneMethod(object);
        try {
            return method.invoke(object, null);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new OJBRuntimeException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new OJBRuntimeException(invocationTargetException);
        }
    }

    private void initReferences(Object object) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("initializing references");
        }
        ClassDescriptor classDescriptor = this.descriptorRepository.getDescriptorFor(object.getClass());
        Iterator iterator = classDescriptor.getObjectReferenceDescriptors().iterator();
        while (iterator.hasNext()) {
            ObjectReferenceDescriptor objectReferenceDescriptor = (ObjectReferenceDescriptor)iterator.next();
            Object object2 = this.getReferenceProxy(classDescriptor, objectReferenceDescriptor, object);
            PersistentField persistentField = objectReferenceDescriptor.getPersistentField();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("setting reference: " + persistentField.getName() + ", " + (object2 == null ? "<null>" : object2.getClass().getName()));
            }
            persistentField.set(object, object2);
        }
    }

    protected void initLookedUpCollections(Object object, Object object2) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("initializing collections");
        }
        ClassDescriptor classDescriptor = this.descriptorRepository.getDescriptorFor(object.getClass());
        ((PersistenceBrokerImpl)this.myBroker).retrieveCollections(object, classDescriptor, false);
    }

    private void unsetReferences(Object object, Object object2) {
        ObjectReferenceDescriptor objectReferenceDescriptor;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("unsetting references");
        }
        ClassDescriptor classDescriptor = this.descriptorRepository.getDescriptorFor(object.getClass());
        Iterator iterator = classDescriptor.getObjectReferenceDescriptors().iterator();
        while (iterator.hasNext()) {
            objectReferenceDescriptor = (ObjectReferenceDescriptor)iterator.next();
            PersistentField persistentField = objectReferenceDescriptor.getPersistentField();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("unsetting reference: " + persistentField.getName());
            }
            persistentField.set(object, null);
        }
        iterator = classDescriptor.getCollectionDescriptors().iterator();
        while (iterator.hasNext()) {
            objectReferenceDescriptor = (CollectionDescriptor)iterator.next();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("unsetting collection: " + objectReferenceDescriptor.getAttributeName());
            }
            this.initCacheCollectionField((CollectionDescriptor)objectReferenceDescriptor, object, object2);
        }
    }

    protected void initCacheCollectionField(CollectionDescriptor collectionDescriptor, Object object, Object object2) {
        PersistentField persistentField = collectionDescriptor.getPersistentField();
        persistentField.set(object, null);
    }

    public Object lookup(Identity identity) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("****** lookup " + this.myBroker + ": " + identity);
        }
        ++this.hitCount;
        Object object = null;
        SoftReference softReference = (SoftReference)this.objectTable.get(identity);
        if (softReference != null) {
            object = softReference.get();
            if (object == null) {
                ++this.gcCount;
                this.objectTable.remove(identity);
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("cache hit: " + this.myBroker + ": " + identity);
            }
        }
        if (object == null) {
            object = this.lookupFrom2ndLevel(identity);
        }
        return object;
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE);
        toStringBuilder.append((Object)"CACHE STATISTICS");
        toStringBuilder.append("Count of cached objects", this.objectTable.keySet().size());
        toStringBuilder.append("lookups", this.hitCount);
        toStringBuilder.append("failures", this.failCount);
        toStringBuilder.append("reclaimed", this.gcCount);
        toStringBuilder.append("2. level success", this.secondLevelFoundCount);
        toStringBuilder.append((Object)secondLevelCache.toString());
        return toStringBuilder.toString();
    }

    public void remove(Identity identity) {
        if (identity != null) {
            this.objectTable.remove(identity);
            secondLevelCache.remove(identity);
        }
    }

    public void beforeClose(PBStateEvent pBStateEvent) {
        this.clear();
    }

    public void afterOpen(PBStateEvent pBStateEvent) {
    }

    public void beforeBegin(PBStateEvent pBStateEvent) {
    }

    public void afterBegin(PBStateEvent pBStateEvent) {
    }

    public void beforeCommit(PBStateEvent pBStateEvent) {
    }

    public void afterCommit(PBStateEvent pBStateEvent) {
        Iterator iterator = this.objectTable.keySet().iterator();
        while (iterator.hasNext()) {
            Identity identity = (Identity)iterator.next();
            SoftReference softReference = (SoftReference)this.objectTable.get(identity);
            Object t = softReference.get();
            if (t == null) continue;
            this.insertInto2ndLevel(identity, t);
        }
    }

    public void beforeRollback(PBStateEvent pBStateEvent) {
        this.clear();
    }

    public void afterRollback(PBStateEvent pBStateEvent) {
        this.clear();
    }

    static class NoCloneMethod
    extends OJBRuntimeException {
        NoCloneMethod(Class clazz) {
            super(clazz.toString() + " has no clone method.");
        }
    }
}

