/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.cache;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.cache.ObjectCache;

public final class ObjectCacheSoftImpl
implements ObjectCache {
    private final SoftHashMap m_map;
    int m_hardSize = 100;

    public ObjectCacheSoftImpl() {
        this.m_map = new SoftHashMap(this.m_hardSize);
    }

    public ObjectCacheSoftImpl(int n) {
        this.m_hardSize = n;
        this.m_map = new SoftHashMap(this.m_hardSize);
    }

    public final void cache(Identity identity, Object object) {
        this.m_map.put(identity, object);
    }

    public final Object lookup(Identity identity) {
        return this.m_map.get(identity);
    }

    public final void remove(Identity identity) {
        this.m_map.remove(identity);
    }

    public final synchronized void clear() {
        this.m_map.clear();
    }

    public final class SoftHashMap
    extends AbstractMap {
        private final HashMap hash = new HashMap();
        private final int HARD_SIZE;
        private FixSizedLinkedHashMap hardCacheMap = null;
        private final ReferenceQueue queue = new ReferenceQueue();

        public SoftHashMap() {
            this(100);
            this.hardCacheMap = new FixSizedLinkedHashMap(100);
        }

        public SoftHashMap(int n) {
            this.HARD_SIZE = n;
            this.hardCacheMap = new FixSizedLinkedHashMap(n);
        }

        public final void clear() {
            this.processQueue();
            this.hash.clear();
            this.hardCacheMap.clear();
        }

        public final Object get(Object object) {
            if (object == null) {
                return null;
            }
            Object v = null;
            SoftReference softReference = (SoftReference)this.hash.get(object);
            if (softReference != null) {
                v = softReference.get();
                if (v == null) {
                    this.hash.remove(object);
                } else if (!this.hardCacheMap.containsKey(object)) {
                    this.hardCacheMap.put(object, v);
                } else {
                    this.hardCacheMap.get(object);
                }
            }
            return v;
        }

        private void processQueue() {
            SoftValue softValue;
            while ((softValue = (SoftValue)this.queue.poll()) != null) {
                this.hash.remove(softValue.key);
            }
        }

        public final Object put(Object object, Object object2) {
            if (object == null || object2 == null) {
                return null;
            }
            this.processQueue();
            this.hardCacheMap.put(object, object2);
            return this.hash.put(object, new SoftValue(object2, object, this.queue));
        }

        public final Object remove(Object object) {
            this.processQueue();
            Object var2_2 = null;
            Object v = this.hash.remove(object);
            if (v != null && v instanceof SoftValue) {
                var2_2 = ((SoftValue)v).get();
            }
            return var2_2;
        }

        public final int size() {
            this.processQueue();
            return this.hash.size();
        }

        public final Set entrySet() {
            throw new UnsupportedOperationException();
        }

        public final Enumeration elements() {
            throw new UnsupportedOperationException();
        }

        private final class SoftValue
        extends SoftReference {
            private final Object key;

            private SoftValue(Object object, Object object2, ReferenceQueue referenceQueue) {
                super(object, referenceQueue);
                this.key = object2;
            }
        }
    }

    public static final class FixSizedLinkedHashMap
    extends LinkedHashMap {
        private int capacity = 0;

        public FixSizedLinkedHashMap(int n) {
            super(n, 1.0f, true);
            this.capacity = n;
        }

        protected final boolean removeEldestEntry(Map.Entry entry) {
            return this.size() > this.capacity;
        }
    }
}

