/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.cache;

import java.util.Properties;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.jcs.JCS;
import org.apache.jcs.access.exception.CacheException;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.cache.JCSHelper;
import org.apache.ojb.broker.cache.ObjectCache;
import org.apache.ojb.broker.cache.RuntimeCacheException;

public class ObjectCacheJCSImpl
implements ObjectCache {
    private JCS jcsCache;
    private String regionName = "ojbDefault";

    public ObjectCacheJCSImpl(PersistenceBroker persistenceBroker, Properties properties) {
        this(null);
    }

    public ObjectCacheJCSImpl(String string) {
        this.regionName = string != null ? string : this.regionName;
        this.jcsCache = JCSHelper.newInstance(this.regionName);
    }

    public String getRegionName() {
        return this.regionName;
    }

    public void cache(Identity identity, Object object) {
        try {
            this.jcsCache.put((Object)identity, object);
        }
        catch (CacheException cacheException) {
            throw new RuntimeCacheException(cacheException);
        }
    }

    public Object lookup(Identity identity) {
        return this.jcsCache.get((Object)identity);
    }

    public void remove(Identity identity) {
        try {
            this.jcsCache.remove((Object)identity);
        }
        catch (CacheException cacheException) {
            throw new RuntimeCacheException(cacheException.getMessage());
        }
    }

    public void clear() {
        if (this.jcsCache != null) {
            try {
                this.jcsCache.remove();
            }
            catch (CacheException cacheException) {
                throw new RuntimeCacheException(cacheException);
            }
        }
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this, ToStringStyle.DEFAULT_STYLE);
        toStringBuilder.append("JCS region name", (Object)this.regionName);
        toStringBuilder.append("JCS region", (Object)this.jcsCache);
        return toStringBuilder.toString();
    }
}

