/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.cache;

import java.util.Properties;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.cache.CacheDistributor;
import org.apache.ojb.broker.cache.CacheFilter;
import org.apache.ojb.broker.cache.CacheFilterRegistry;
import org.apache.ojb.broker.cache.ObjectCache;
import org.apache.ojb.broker.core.PersistenceBrokerConfiguration;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.configuration.impl.OjbConfigurator;
import org.apache.ojb.broker.util.factory.ConfigurableFactory;

public class ObjectCacheFactory
extends ConfigurableFactory {
    private static ObjectCacheFactory singleton = new ObjectCacheFactory();
    private ObjectCache defaultCache;
    static /* synthetic */ Class class$org$apache$ojb$broker$PersistenceBroker;
    static /* synthetic */ Class class$java$util$Properties;
    static /* synthetic */ Class class$org$apache$ojb$broker$cache$ObjectCache;

    public static ObjectCacheFactory getInstance() {
        return singleton;
    }

    public ObjectCache createObjectCache(PersistenceBroker persistenceBroker) {
        ObjectCache objectCache;
        try {
            this.getLogger().info("Start creating new ObjectCache instance");
            objectCache = this.defaultCache = (ObjectCache)this.createNewInstance(new Class[]{class$org$apache$ojb$broker$PersistenceBroker == null ? (class$org$apache$ojb$broker$PersistenceBroker = ObjectCacheFactory.class$("org.apache.ojb.broker.PersistenceBroker")) : class$org$apache$ojb$broker$PersistenceBroker, class$java$util$Properties == null ? (class$java$util$Properties = ObjectCacheFactory.class$("java.util.Properties")) : class$java$util$Properties}, new Object[]{persistenceBroker, null});
            this.getLogger().info("Default ObjectCache class was " + objectCache.getClass().getName());
            objectCache = new CacheDistributor(persistenceBroker, objectCache);
            this.getLogger().info("Instantiate new " + objectCache.getClass().getName() + " class object");
            if (this.useCacheFilter()) {
                this.getLogger().info("Enable CacheFilters");
                CacheFilterRegistry cacheFilterRegistry = new CacheFilterRegistry(objectCache);
                String[] stringArray = this.getFiltersFromConfiguration();
                for (int i = 0; i < stringArray.length; ++i) {
                    this.getLogger().info("Create CacheFilter: " + (stringArray[i] != null ? stringArray[i].getClass().getName() : null));
                    cacheFilterRegistry.addCacheFilter((CacheFilter)ClassHelper.newInstance(stringArray[i], new Class[]{class$org$apache$ojb$broker$PersistenceBroker == null ? ObjectCacheFactory.class$("org.apache.ojb.broker.PersistenceBroker") : class$org$apache$ojb$broker$PersistenceBroker, class$org$apache$ojb$broker$cache$ObjectCache == null ? ObjectCacheFactory.class$("org.apache.ojb.broker.cache.ObjectCache") : class$org$apache$ojb$broker$cache$ObjectCache}, new Object[]{persistenceBroker, objectCache}));
                }
                objectCache = cacheFilterRegistry;
            }
            this.getLogger().debug("Object cache created, using cache:" + objectCache);
        }
        catch (Exception exception) {
            this.getLogger().error("Error while ObjectCache initiation, please check your configuration files and the used implementation class - use default cache " + this.defaultCache + "instead", exception);
            objectCache = this.defaultCache;
        }
        this.getLogger().info("New ObjectCache instance was created");
        return objectCache;
    }

    protected String getConfigurationKey() {
        return "ObjectCacheClass";
    }

    private boolean useCacheFilter() {
        return this.getFiltersFromConfiguration() != null;
    }

    private String[] getFiltersFromConfiguration() {
        return ((PersistenceBrokerConfiguration)((Object)OjbConfigurator.getInstance().getConfigurationFor(null))).getCacheFilters();
    }

    protected ObjectCache createNewCacheInstance(Class clazz, PersistenceBroker persistenceBroker, Properties properties) throws Exception {
        ObjectCache objectCache = null;
        try {
            objectCache = (ObjectCache)ClassHelper.newInstance(clazz, new Class[]{class$org$apache$ojb$broker$PersistenceBroker == null ? (class$org$apache$ojb$broker$PersistenceBroker = ObjectCacheFactory.class$("org.apache.ojb.broker.PersistenceBroker")) : class$org$apache$ojb$broker$PersistenceBroker, class$java$util$Properties == null ? (class$java$util$Properties = ObjectCacheFactory.class$("java.util.Properties")) : class$java$util$Properties}, new Object[]{persistenceBroker, properties});
        }
        catch (Exception exception) {
            this.getLogger().error("Can not create ObjectCache instance using class " + clazz, exception);
            throw exception;
        }
        return objectCache;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

