/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.cache;

import java.lang.ref.SoftReference;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.cache.ObjectCache;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class ObjectCacheDefaultImpl
implements ObjectCache {
    protected static Map objectTable = new Hashtable();
    private static long hitCount = 0L;
    private static long failCount = 0L;
    private static long gcCount = 0L;
    private long timeout = 900000L;

    public ObjectCacheDefaultImpl(PersistenceBroker persistenceBroker, Properties properties) {
        this.timeout = properties == null ? this.timeout : new Long(properties.getProperty("timeout", "" + this.timeout));
    }

    public void clear() {
        objectTable.clear();
    }

    public void cache(Identity identity, Object object) {
        if (object != null) {
            SoftReference<CacheEntry> softReference = new SoftReference<CacheEntry>(new CacheEntry(object));
            objectTable.put(identity, softReference);
        }
    }

    public Object lookup(Identity identity) {
        ++hitCount;
        CacheEntry cacheEntry = null;
        SoftReference softReference = (SoftReference)objectTable.get(identity);
        if (softReference != null) {
            cacheEntry = (CacheEntry)softReference.get();
            if (cacheEntry == null || cacheEntry.lifetime < System.currentTimeMillis()) {
                ++gcCount;
                objectTable.remove(identity);
                cacheEntry = null;
            }
        } else {
            ++failCount;
        }
        return cacheEntry != null ? cacheEntry.object : null;
    }

    public void remove(Identity identity) {
        if (identity != null) {
            objectTable.remove(identity);
        }
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this, ToStringStyle.DEFAULT_STYLE);
        toStringBuilder.append("Count of cached objects", objectTable.keySet().size());
        toStringBuilder.append("Lookup hits", hitCount);
        toStringBuilder.append("Failures", failCount);
        toStringBuilder.append("Reclaimed", gcCount);
        return toStringBuilder.toString();
    }

    public void finalize() {
        Logger logger = LoggerFactory.getDefaultLogger();
        logger.debug("Finalize ObjectCache: " + this.toString());
    }

    class CacheEntry {
        long lifetime;
        Object object;

        public CacheEntry(Object object) {
            this.object = object;
            this.lifetime = System.currentTimeMillis() + ObjectCacheDefaultImpl.this.timeout;
        }
    }
}

