/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.cache;

import java.util.ArrayList;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.cache.AbstractMetaCache;
import org.apache.ojb.broker.cache.CacheFilter;
import org.apache.ojb.broker.cache.ObjectCache;
import org.apache.ojb.broker.cache.RuntimeCacheException;

public class CacheFilterRegistry
extends AbstractMetaCache {
    private ArrayList filterList = new ArrayList();
    private ObjectCache realCache;

    public CacheFilterRegistry(ObjectCache objectCache) {
        this.realCache = objectCache;
    }

    protected void addCacheFilter(CacheFilter cacheFilter) {
        this.filterList.add(cacheFilter);
    }

    public ObjectCache getCache(Identity identity, Object object, int n) {
        return this.checkFilterList(n, identity, object) ? this.realCache : null;
    }

    public void clear() {
        this.realCache.clear();
    }

    private boolean checkFilterList(int n, Identity identity, Object object) {
        boolean bl = true;
        if (n == 1) {
            for (int i = this.filterList.size() - 1; i >= 0; --i) {
                boolean bl2 = bl = bl && ((CacheFilter)this.filterList.get(i)).beforeCache(identity, object);
                if (bl) continue;
                return false;
            }
        } else if (n == 2) {
            for (int i = this.filterList.size() - 1; i >= 0; --i) {
                boolean bl3 = bl = bl && ((CacheFilter)this.filterList.get(i)).beforeLookup(identity);
                if (bl) continue;
                return false;
            }
        } else if (n == 3) {
            for (int i = this.filterList.size() - 1; i >= 0; --i) {
                boolean bl4 = bl = bl && ((CacheFilter)this.filterList.get(i)).beforeRemove(identity);
                if (bl) continue;
                return false;
            }
        } else {
            throw new RuntimeCacheException("Unkown filter method id: " + n);
        }
        return bl;
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE);
        toStringBuilder.append(" - used filters", (Object)this.filterList).append(" - underlying ObjectCache", (Object)this.realCache);
        return toStringBuilder.toString();
    }
}

