/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.cache;

import java.util.StringTokenizer;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.cache.CacheFilter;
import org.apache.ojb.broker.cache.ObjectCache;

public class CacheFilterPackageImpl
implements CacheFilter {
    public static final String EXCLUDE_PACKAGES = "exclude-packages";
    private static final String COMMA = ",";
    private PersistenceBroker broker;
    private ObjectCache cache;
    private StringTokenizer tok;
    private String filterPackages;

    public CacheFilterPackageImpl(PersistenceBroker persistenceBroker, ObjectCache objectCache) {
        this.broker = persistenceBroker;
        this.cache = objectCache;
    }

    public boolean beforeCache(Identity identity, Object object) {
        this.filterPackages = null;
        this.filterPackages = this.broker.serviceConnectionManager().getConnectionDescriptor().getAttribute(EXCLUDE_PACKAGES);
        this.filterPackages = this.broker.getDescriptorRepository().getAttribute(EXCLUDE_PACKAGES) + (this.filterPackages != null ? COMMA + this.filterPackages : "");
        return this.matchFilterPackages(this.filterPackages, identity.getObjectsRealClass());
    }

    public boolean beforeLookup(Identity identity) {
        return true;
    }

    public boolean beforeRemove(Identity identity) {
        return true;
    }

    public ObjectCache getObjectCache() {
        return this.cache;
    }

    private boolean matchFilterPackages(String string, Class clazz) {
        boolean bl = true;
        if (string != null && string != "") {
            this.tok = new StringTokenizer(string, COMMA);
            while (this.tok.hasMoreTokens()) {
                String string2 = this.tok.nextToken().trim();
                if (string2.equals("") || !clazz.getName().startsWith(string2)) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }
}

