/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.ant;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.ojb.broker.ant.RepositoryVerifierHandler;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class VerifyMappingsTask
extends Task {
    private int m_errorCount = 0;
    private int m_warningCount = 0;
    private String m_repositoryPath = null;
    private String m_PropertiesFile = null;
    private String m_jdbcDriver = null;
    private String m_url = null;
    private String m_logon = null;
    private String m_password = null;
    private boolean m_ignoreCase = false;
    private boolean m_UseStrictTypeChecking = true;
    private String m_classPath = null;
    private URLClassLoader m_classLoader = null;
    private Class m_persistenceClass = null;
    private boolean m_useXMLValidation = true;
    private boolean m_failOnError = true;
    static /* synthetic */ Class class$org$apache$ojb$broker$metadata$fieldaccess$PersistentFieldPrivilegedImpl;

    public void execute() throws BuildException {
        block4: {
            if (this.getRepositoryFile() == null) {
                throw new BuildException("Could not find the repository file.");
            }
            try {
                System.setProperty("OJB.properties", this.getPropertiesFile());
                this.logWarning("IgnoreFieldNameCase: " + String.valueOf(this.getIgnoreFieldNameCase()));
                this.logWarning("UseStrictTypeChecking: " + String.valueOf(this.getUseStrictTypeChecking()));
                this.logWarning("UseXMLValidation: " + String.valueOf(this.getUseXMLValidation()));
                this.logWarning("UseStrictTypeChecking: " + String.valueOf(this.getUseStrictTypeChecking()));
                this.verifyRepository(this.getRepositoryFile());
                this.logWarning(this.getSummaryString(this.getErrorCount(), this.getWarningCount()));
            }
            catch (Exception exception) {
                this.logWarning("There was an exception while verifying the repsitory: " + exception.getMessage());
                if (!this.getFailOnError()) break block4;
                throw new BuildException("There was an exception while verifying the repsitory.", (Throwable)exception);
            }
        }
        if (this.getFailOnError() && this.getErrorCount() > 0) {
            throw new BuildException("Failed because 'failonerror' = true and there are " + String.valueOf(this.getErrorCount()) + " mapping error(s).");
        }
    }

    private String getSummaryString(int n, int n2) {
        return "\n---------------------------------------------------\n       Found " + String.valueOf(n) + " error(s) in the repository. \n       Found " + String.valueOf(n2) + " warning(s) in the repository.      \n---------------------------------------------------";
    }

    private void verifyRepository(String string) throws ParserConfigurationException, SAXException, IOException {
        this.log("verifyRepository: Entered.");
        long l = System.currentTimeMillis();
        SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
        XMLReader xMLReader = null;
        xMLReader = sAXParser.getXMLReader();
        xMLReader.setFeature("http://xml.org/sax/features/validation", this.getUseXMLValidation());
        RepositoryVerifierHandler repositoryVerifierHandler = new RepositoryVerifierHandler(this);
        this.logInfo("Starting Parser...");
        xMLReader.setContentHandler(repositoryVerifierHandler);
        xMLReader.parse(string);
        this.logInfo("Done Parsing.");
        long l2 = System.currentTimeMillis();
        this.setErrorCount(repositoryVerifierHandler.getErrorCount());
        this.setWarningCount(repositoryVerifierHandler.getWarningCount());
        this.logWarning("loading XML took " + (l2 - l) + " msecs");
    }

    public void logWarning(String string) {
        this.log(string, 1);
    }

    public void logInfo(String string) {
        this.log(string, 2);
    }

    protected int getErrorCount() {
        return this.m_errorCount;
    }

    protected void setErrorCount(int n) {
        this.m_errorCount = n;
    }

    protected int getWarningCount() {
        return this.m_warningCount;
    }

    protected void setWarningCount(int n) {
        this.m_warningCount = n;
    }

    public void setRepositoryFile(String string) {
        this.m_repositoryPath = string;
    }

    public String getRepositoryFile() {
        return this.m_repositoryPath;
    }

    public void setPropertiesFile(String string) {
        this.m_PropertiesFile = string;
    }

    public String getPropertiesFile() {
        return this.m_PropertiesFile;
    }

    public void setJdbcDriver(String string) {
        this.m_jdbcDriver = string;
    }

    public String getJdbcDriver() {
        return this.m_jdbcDriver;
    }

    public void setUrl(String string) {
        this.m_url = string;
    }

    public String getUrl() {
        return this.m_url;
    }

    public void setLogon(String string) {
        this.m_logon = string;
    }

    public String getLogon() {
        return this.m_logon;
    }

    public void setPassword(String string) {
        this.m_password = string;
    }

    public String getPassword() {
        return this.m_password;
    }

    public boolean hasConnectionInfo() {
        return this.m_jdbcDriver != null && this.m_url != null && this.m_logon != null && this.m_password != null;
    }

    public void setIgnoreFieldNameCase(String string) {
        this.m_ignoreCase = Boolean.valueOf(string);
    }

    public boolean getIgnoreFieldNameCase() {
        return this.m_ignoreCase;
    }

    public void setUseStrictTypeChecking(String string) {
        this.m_UseStrictTypeChecking = Boolean.valueOf(string);
    }

    public boolean getUseStrictTypeChecking() {
        return this.m_UseStrictTypeChecking;
    }

    public void setVerifyClassPath(String string) {
        this.m_classPath = string;
    }

    public String getVerifyClassPath() {
        return this.m_classPath;
    }

    public URLClassLoader getClassLoader() throws MalformedURLException {
        if (this.m_classLoader == null) {
            this.logInfo("Initializing ClassLoader...");
            this.m_classLoader = URLClassLoader.newInstance(this.getURLArray(), null);
            Thread.currentThread().setContextClassLoader(this.m_classLoader);
            this.logInfo("Done Initializing ClassLoader.");
        }
        return this.m_classLoader;
    }

    private URL[] getURLArray() throws MalformedURLException {
        StringTokenizer stringTokenizer = new StringTokenizer(this.cleanClassPath(this.getVerifyClassPath()), System.getProperty("path.separator"));
        URL[] uRLArray = new URL[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (!(string.endsWith(".jar") || string.endsWith(".zip") || string.endsWith("/"))) {
                string = string + "/";
            }
            this.logInfo("Adding URL: file://" + string);
            uRLArray[n++] = new URL("file://" + string);
        }
        return uRLArray;
    }

    private String cleanClassPath(String string) {
        return string.replace('\\', '/');
    }

    public Class getPersistentFieldClass() {
        if (this.m_persistenceClass == null) {
            Properties properties = new Properties();
            try {
                this.logWarning("Loading properties file: " + this.getPropertiesFile());
                properties.load(new FileInputStream(this.getPropertiesFile()));
                String string = properties.getProperty("PersistentFieldClass");
                this.m_persistenceClass = Class.forName(string, true, this.getClassLoader());
            }
            catch (Exception exception) {
                this.logWarning("Could not load properties file '" + this.getPropertiesFile() + "'. Using PersistentFieldDefaultImpl.");
                exception.printStackTrace();
                this.m_persistenceClass = class$org$apache$ojb$broker$metadata$fieldaccess$PersistentFieldPrivilegedImpl == null ? (class$org$apache$ojb$broker$metadata$fieldaccess$PersistentFieldPrivilegedImpl = VerifyMappingsTask.class$("org.apache.ojb.broker.metadata.fieldaccess.PersistentFieldPrivilegedImpl")) : class$org$apache$ojb$broker$metadata$fieldaccess$PersistentFieldPrivilegedImpl;
            }
            this.logWarning("PersistentFieldClass: " + this.m_persistenceClass.toString());
        }
        return this.m_persistenceClass;
    }

    public void setUseXMLValidation(String string) {
        this.m_useXMLValidation = Boolean.valueOf(string);
    }

    public boolean getUseXMLValidation() {
        return this.m_useXMLValidation;
    }

    public void setFailOnError(String string) {
        this.m_failOnError = Boolean.valueOf(string);
    }

    public boolean getFailOnError() {
        return this.m_failOnError;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

