/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer.sql;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.ojb.broker.accesslayer.sql.SqlCacheKey;
import org.apache.ojb.broker.accesslayer.sql.SqlDeleteByPkStatement;
import org.apache.ojb.broker.accesslayer.sql.SqlDeleteByQuery;
import org.apache.ojb.broker.accesslayer.sql.SqlDeleteMNStatement;
import org.apache.ojb.broker.accesslayer.sql.SqlGenerator;
import org.apache.ojb.broker.accesslayer.sql.SqlInsertMNStatement;
import org.apache.ojb.broker.accesslayer.sql.SqlInsertStatement;
import org.apache.ojb.broker.accesslayer.sql.SqlProcedureStatement;
import org.apache.ojb.broker.accesslayer.sql.SqlSelectByPkStatement;
import org.apache.ojb.broker.accesslayer.sql.SqlSelectMNStatement;
import org.apache.ojb.broker.accesslayer.sql.SqlSelectStatement;
import org.apache.ojb.broker.accesslayer.sql.SqlStatement;
import org.apache.ojb.broker.accesslayer.sql.SqlUpdateStatement;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.DeleteProcedureDescriptor;
import org.apache.ojb.broker.metadata.InsertProcedureDescriptor;
import org.apache.ojb.broker.metadata.UpdateProcedureDescriptor;
import org.apache.ojb.broker.platforms.Platform;
import org.apache.ojb.broker.query.BetweenCriteria;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.ExistsCriteria;
import org.apache.ojb.broker.query.FieldCriteria;
import org.apache.ojb.broker.query.InCriteria;
import org.apache.ojb.broker.query.NullCriteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.ReportQuery;
import org.apache.ojb.broker.query.SelectionCriteria;
import org.apache.ojb.broker.query.SqlCriteria;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class SqlGeneratorDefaultImpl
implements SqlGenerator {
    private Logger logger = LoggerFactory.getLogger(class$org$apache$ojb$broker$accesslayer$sql$SqlGeneratorDefaultImpl == null ? (class$org$apache$ojb$broker$accesslayer$sql$SqlGeneratorDefaultImpl = SqlGeneratorDefaultImpl.class$("org.apache.ojb.broker.accesslayer.sql.SqlGeneratorDefaultImpl")) : class$org$apache$ojb$broker$accesslayer$sql$SqlGeneratorDefaultImpl);
    private Map m_sqlCacheMap = new WeakHashMap();
    private Platform pf;
    static /* synthetic */ Class class$org$apache$ojb$broker$accesslayer$sql$SqlGeneratorDefaultImpl;

    public SqlGeneratorDefaultImpl(Platform platform) {
        this.pf = platform;
    }

    public String getPreparedDeleteStatement(ClassDescriptor classDescriptor) {
        DeleteProcedureDescriptor deleteProcedureDescriptor = classDescriptor.getDeleteProcedure();
        SqlStatement sqlStatement = deleteProcedureDescriptor == null ? new SqlDeleteByPkStatement(classDescriptor, this.logger) : new SqlProcedureStatement(deleteProcedureDescriptor, this.logger);
        String string = sqlStatement.getStatement();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SQL:" + string);
        }
        return string;
    }

    public String getPreparedInsertStatement(ClassDescriptor classDescriptor) {
        InsertProcedureDescriptor insertProcedureDescriptor = classDescriptor.getInsertProcedure();
        SqlStatement sqlStatement = insertProcedureDescriptor == null ? new SqlInsertStatement(classDescriptor, this.logger) : new SqlProcedureStatement(insertProcedureDescriptor, this.logger);
        String string = sqlStatement.getStatement();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SQL:" + string);
        }
        return string;
    }

    public String getPreparedSelectByPkStatement(ClassDescriptor classDescriptor) {
        SqlSelectByPkStatement sqlSelectByPkStatement = new SqlSelectByPkStatement(classDescriptor, this.logger);
        String string = sqlSelectByPkStatement.getStatement();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SQL:" + string);
        }
        return string;
    }

    public String getPreparedSelectStatement(Query query, ClassDescriptor classDescriptor) {
        SqlCacheKey sqlCacheKey = new SqlCacheKey(query, classDescriptor, 1);
        String string = (String)this.m_sqlCacheMap.get(sqlCacheKey);
        if (string == null) {
            String[] stringArray = null;
            if (query instanceof ReportQuery) {
                stringArray = ((ReportQuery)((Object)query)).getColumns();
            }
            SqlSelectStatement sqlSelectStatement = new SqlSelectStatement(this.pf, classDescriptor, stringArray, query, this.logger);
            string = sqlSelectStatement.getStatement();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("SQL:" + string);
            }
            this.m_sqlCacheMap.put(sqlCacheKey, string);
        }
        return string;
    }

    public String getPreparedUpdateStatement(ClassDescriptor classDescriptor) {
        UpdateProcedureDescriptor updateProcedureDescriptor = classDescriptor.getUpdateProcedure();
        SqlStatement sqlStatement = updateProcedureDescriptor == null ? new SqlUpdateStatement(classDescriptor, this.logger) : new SqlProcedureStatement(updateProcedureDescriptor, this.logger);
        String string = sqlStatement.getStatement();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SQL:" + string);
        }
        return string;
    }

    public String getInsertMNStatement(String string, String[] stringArray, String[] stringArray2) {
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        SqlInsertMNStatement sqlInsertMNStatement = new SqlInsertMNStatement(string, stringArray3, this.logger);
        String string2 = sqlInsertMNStatement.getStatement();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SQL:" + string2);
        }
        return string2;
    }

    public String getSelectMNStatement(String string, String[] stringArray, String[] stringArray2) {
        SqlSelectMNStatement sqlSelectMNStatement = new SqlSelectMNStatement(string, stringArray, stringArray2, this.logger);
        String string2 = sqlSelectMNStatement.getStatement();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SQL:" + string2);
        }
        return string2;
    }

    public String getDeleteMNStatement(String string, String[] stringArray, String[] stringArray2) {
        String[] stringArray3;
        if (stringArray2 == null) {
            stringArray3 = stringArray;
        } else {
            stringArray3 = new String[stringArray.length + stringArray2.length];
            System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
            System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        }
        SqlDeleteMNStatement sqlDeleteMNStatement = new SqlDeleteMNStatement(string, stringArray3, this.logger);
        String string2 = sqlDeleteMNStatement.getStatement();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SQL:" + string2);
        }
        return string2;
    }

    public String getSelectStatementDep(Query query, ClassDescriptor classDescriptor) {
        SqlCacheKey sqlCacheKey = new SqlCacheKey(query, classDescriptor, 1);
        String string = (String)this.m_sqlCacheMap.get(sqlCacheKey);
        if (string == null) {
            String[] stringArray = null;
            if (query instanceof ReportQuery) {
                stringArray = ((ReportQuery)((Object)query)).getColumns();
            }
            SqlSelectStatement sqlSelectStatement = new SqlSelectStatement(this.pf, classDescriptor, stringArray, query, this.logger);
            string = sqlSelectStatement.getStatement();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("SQL:" + string);
            }
            this.m_sqlCacheMap.put(sqlCacheKey, string);
        }
        return string;
    }

    public String asSQLStatement(Criteria criteria, ClassDescriptor classDescriptor) {
        Enumeration enumeration = criteria.getElements();
        StringBuffer stringBuffer = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            Object object;
            Object e = enumeration.nextElement();
            if (e instanceof Criteria) {
                String string;
                Criteria criteria2 = (Criteria)e;
                if (criteria2.isEmbraced()) {
                    object = " (";
                    string = ") ";
                } else {
                    object = "";
                    string = "";
                }
                switch (criteria2.getType()) {
                    case 0: {
                        stringBuffer.append(" OR " + (String)object);
                        stringBuffer.append(this.asSQLStatement(criteria2, classDescriptor));
                        stringBuffer.append(string);
                        break;
                    }
                    case 1: {
                        stringBuffer.insert(0, "( ");
                        stringBuffer.append(") ");
                        stringBuffer.append(" AND " + (String)object);
                        stringBuffer.append(this.asSQLStatement(criteria2, classDescriptor));
                        stringBuffer.append(string);
                    }
                }
                continue;
            }
            object = (SelectionCriteria)e;
            if (stringBuffer.length() == 0) {
                stringBuffer.append(this.asSQLClause((SelectionCriteria)object, classDescriptor));
                continue;
            }
            stringBuffer.insert(0, "(");
            stringBuffer.append(") ");
            stringBuffer.append(" AND ");
            stringBuffer.append(this.asSQLClause((SelectionCriteria)object, classDescriptor));
        }
        if (stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    protected String asSQLClause(SelectionCriteria selectionCriteria, ClassDescriptor classDescriptor) {
        if (selectionCriteria instanceof FieldCriteria) {
            return this.toSQLClause((FieldCriteria)selectionCriteria, classDescriptor);
        }
        if (selectionCriteria instanceof NullCriteria) {
            return this.toSQLClause((NullCriteria)selectionCriteria, classDescriptor);
        }
        if (selectionCriteria instanceof BetweenCriteria) {
            return this.toSQLClause((BetweenCriteria)selectionCriteria, classDescriptor);
        }
        if (selectionCriteria instanceof InCriteria) {
            return this.toSQLClause((InCriteria)selectionCriteria, classDescriptor);
        }
        if (selectionCriteria instanceof SqlCriteria) {
            return this.toSQLClause((SqlCriteria)selectionCriteria, classDescriptor);
        }
        if (selectionCriteria instanceof ExistsCriteria) {
            return this.toSQLClause((ExistsCriteria)selectionCriteria, classDescriptor);
        }
        return this.toSQLClause(selectionCriteria, classDescriptor);
    }

    private String toSqlClause(Object object, ClassDescriptor classDescriptor) {
        String string;
        if (object instanceof Query) {
            Query query = (Query)object;
            string = this.getPreparedSelectStatement(query, classDescriptor.getRepository().getDescriptorFor(query.getSearchClass()));
        } else {
            string = (String)object;
        }
        return string;
    }

    private String toSQLClause(NullCriteria nullCriteria, ClassDescriptor classDescriptor) {
        String string = (String)nullCriteria.getAttribute();
        return string + nullCriteria.getClause();
    }

    private String toSQLClause(FieldCriteria fieldCriteria, ClassDescriptor classDescriptor) {
        String string = this.toSqlClause(fieldCriteria.getAttribute(), classDescriptor);
        return string + fieldCriteria.getClause() + fieldCriteria.getValue();
    }

    private String toSQLClause(BetweenCriteria betweenCriteria, ClassDescriptor classDescriptor) {
        String string = this.toSqlClause(betweenCriteria.getAttribute(), classDescriptor);
        return string + betweenCriteria.getClause() + " ? AND ? ";
    }

    private String toSQLClause(InCriteria inCriteria, ClassDescriptor classDescriptor) {
        StringBuffer stringBuffer = new StringBuffer();
        Collection collection = (Collection)inCriteria.getValue();
        int n = collection.size();
        stringBuffer.append(inCriteria.getAttribute());
        stringBuffer.append(inCriteria.getClause());
        stringBuffer.append("(");
        for (int i = 0; i < n - 1; ++i) {
            stringBuffer.append("?,");
        }
        stringBuffer.append("?)");
        return stringBuffer.toString();
    }

    private String toSQLClause(SelectionCriteria selectionCriteria, ClassDescriptor classDescriptor) {
        String string = this.toSqlClause(selectionCriteria.getAttribute(), classDescriptor);
        return string + selectionCriteria.getClause() + " ? ";
    }

    private String toSQLClause(SqlCriteria sqlCriteria, ClassDescriptor classDescriptor) {
        return sqlCriteria.getClause();
    }

    private String toSQLClause(ExistsCriteria existsCriteria, ClassDescriptor classDescriptor) {
        StringBuffer stringBuffer = new StringBuffer();
        Query query = (Query)existsCriteria.getValue();
        stringBuffer.append(existsCriteria.getClause());
        stringBuffer.append(" (");
        if (classDescriptor != null) {
            stringBuffer.append(this.getPreparedSelectStatement(query, classDescriptor.getRepository().getDescriptorFor(query.getSearchClass())));
        } else {
            stringBuffer.append(query);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String getPreparedDeleteStatement(Query query, ClassDescriptor classDescriptor) {
        SqlCacheKey sqlCacheKey = new SqlCacheKey(query, classDescriptor, 4);
        String string = (String)this.m_sqlCacheMap.get(sqlCacheKey);
        if (string == null) {
            SqlDeleteByQuery sqlDeleteByQuery = new SqlDeleteByQuery(this.pf, classDescriptor, query, this.logger);
            string = sqlDeleteByQuery.getStatement();
            this.m_sqlCacheMap.put(sqlCacheKey, string);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("SQL:" + string);
            }
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

