/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.sql.SQLException;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.accesslayer.ResultSetAndStatement;
import org.apache.ojb.broker.accesslayer.RsIterator;
import org.apache.ojb.broker.core.PersistenceBrokerImpl;
import org.apache.ojb.broker.metadata.ClassDescriptor;

public class SqlBasedRsIterator
extends RsIterator {
    private String m_sql;

    public SqlBasedRsIterator(String string, ClassDescriptor classDescriptor, PersistenceBrokerImpl persistenceBrokerImpl) throws PersistenceBrokerException {
        super(classDescriptor, persistenceBrokerImpl);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SqlBasedRsIterator(" + string + ", " + classDescriptor + ")");
        }
        this.m_sql = string;
        this.m_rsAndStmt = persistenceBrokerImpl.serviceJdbcAccess().executeSQL(string, classDescriptor, true);
    }

    protected Object getObjectFromResultSet() throws PersistenceBrokerException {
        try {
            return super.getObjectFromResultSet();
        }
        catch (PersistenceBrokerException persistenceBrokerException) {
            Identity identity = this.getIdentityFromResultSet();
            return this.m_broker.getObjectByIdentity(identity);
        }
    }

    protected int countedSize() throws PersistenceBrokerException {
        int n;
        String string = "";
        int n2 = 0;
        int n3 = this.m_sql.toUpperCase().indexOf(" FROM ");
        if (n3 >= 0) {
            string = "select count(*)" + this.m_sql.substring(n3);
        }
        if ((n = string.toUpperCase().indexOf(" ORDER BY ")) >= 0) {
            string = string.substring(0, n);
        }
        ResultSetAndStatement resultSetAndStatement = this.m_broker.serviceJdbcAccess().executeSQL(string, this.m_cld, false);
        try {
            if (resultSetAndStatement.m_rs.next()) {
                n2 = resultSetAndStatement.m_rs.getInt(1);
            }
        }
        catch (SQLException sQLException) {
            throw new PersistenceBrokerException(sQLException);
        }
        finally {
            resultSetAndStatement.close();
        }
        return n2;
    }
}

