/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PBLifeCycleEvent;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.VirtualProxy;
import org.apache.ojb.broker.accesslayer.OJBIterator;
import org.apache.ojb.broker.accesslayer.RelationshipPrefetcher;
import org.apache.ojb.broker.accesslayer.RelationshipPrefetcherFactory;
import org.apache.ojb.broker.accesslayer.ResultSetAndStatement;
import org.apache.ojb.broker.cache.ObjectCache;
import org.apache.ojb.broker.core.PersistenceBrokerImpl;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class RsIterator
implements OJBIterator {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected PBLifeCycleEvent afterLookupEvent;
    protected ObjectCache cache;
    protected PersistenceBrokerImpl m_broker;
    protected ResultSetAndStatement m_rsAndStmt;
    protected ClassDescriptor m_cld;
    protected Class itemProxyClass;
    private Class itemTopLevelClass = null;
    protected Map m_row = null;
    protected boolean hasCalledCheck = false;
    protected boolean inBatchedMode = false;
    protected boolean hasNext = false;
    private boolean advancedJDBCSupport = false;
    private boolean JDBCSupportAssessed = false;
    private Query m_query = null;
    private int m_current_row = 0;
    private boolean resourcesAreReleased = false;

    protected RsIterator(ClassDescriptor classDescriptor, PersistenceBrokerImpl persistenceBrokerImpl) {
        this.cache = persistenceBrokerImpl.serviceObjectCache();
        this.m_row = new HashMap();
        this.m_broker = persistenceBrokerImpl;
        this.m_cld = classDescriptor;
        Class clazz = persistenceBrokerImpl.getClassToPrefetch();
        this.itemProxyClass = clazz != null && clazz.isAssignableFrom(classDescriptor.getClassOfObject()) ? null : classDescriptor.getProxyClass();
        this.afterLookupEvent = new PBLifeCycleEvent(this.m_broker, PBLifeCycleEvent.Type.AFTER_LOOKUP);
    }

    public RsIterator(Query query, ClassDescriptor classDescriptor, PersistenceBrokerImpl persistenceBrokerImpl) {
        this(classDescriptor, persistenceBrokerImpl);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("RsIterator(" + query + ", " + classDescriptor + ")");
        }
        this.m_query = query;
        this.m_rsAndStmt = persistenceBrokerImpl.serviceJdbcAccess().executeQuery(query, classDescriptor);
        this.prefetchRelationships(query);
    }

    protected Class getTopLevelClass() {
        if (this.itemTopLevelClass == null) {
            this.itemTopLevelClass = this.m_broker.getTopLevelClass(this.m_cld.getClassOfObject());
        }
        return this.itemTopLevelClass;
    }

    public synchronized boolean hasNext() {
        try {
            if (!this.hasCalledCheck) {
                this.hasCalledCheck = true;
                this.hasNext = this.m_rsAndStmt.m_rs.next();
                if (!this.hasNext) {
                    this.releaseDbResources();
                }
            }
        }
        catch (Exception exception) {
            this.hasNext = false;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("hasNext() -> " + this.hasNext);
        }
        return this.hasNext;
    }

    public synchronized Object next() throws NoSuchElementException {
        try {
            if (!this.hasCalledCheck) {
                this.hasNext();
            }
            this.hasCalledCheck = false;
            if (this.hasNext) {
                Object object = this.getObjectFromResultSet();
                ++this.m_current_row;
                this.afterLookupEvent.setTarget(object);
                this.m_broker.fireBrokerEvent(this.afterLookupEvent);
                return object;
            }
            throw new NoSuchElementException("inner hasNext was false");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.logger.error(exception);
            throw new NoSuchElementException("Could not obtain next object: " + exception.getMessage());
        }
    }

    public void remove() {
        throw new UnsupportedOperationException("removing not supported by RsIterator");
    }

    private Collection getOwnerObjects() {
        Vector<Object> vector = new Vector<Object>();
        while (this.hasNext()) {
            vector.add(this.next());
        }
        return vector;
    }

    private void prefetchRelationships(Query query) {
        int n;
        if (query == null || query.getPrefetchedRelationships() == null || query.getPrefetchedRelationships().isEmpty()) {
            return;
        }
        if (!this.supportsAdvancedJDBCCursorControl()) {
            this.logger.info("prefetching relationships requires JDBC level 2.0");
            return;
        }
        this.inBatchedMode = true;
        List list = query.getPrefetchedRelationships();
        RelationshipPrefetcher[] relationshipPrefetcherArray = new RelationshipPrefetcher[list.size()];
        for (n = 0; n < list.size(); ++n) {
            String string = (String)list.get(n);
            relationshipPrefetcherArray[n] = RelationshipPrefetcherFactory.createRelationshipPrefetcher(this.m_broker, this.m_cld, string);
            relationshipPrefetcherArray[n].prepareRelationshipSettings();
        }
        Collection collection = this.getOwnerObjects();
        for (n = 0; n < list.size(); ++n) {
            relationshipPrefetcherArray[n].prefetchRelationship(collection);
        }
        for (n = 0; n < list.size(); ++n) {
            relationshipPrefetcherArray[n].restoreRelationshipSettings();
        }
        try {
            this.m_rsAndStmt.m_rs.beforeFirst();
        }
        catch (SQLException sQLException) {
            this.logger.error("beforeFirst failed !", sQLException);
        }
        this.inBatchedMode = false;
        this.hasCalledCheck = false;
    }

    protected Identity getIdentityFromResultSet() throws PersistenceBrokerException {
        FieldDescriptor[] fieldDescriptorArray = this.m_cld.getPkFields();
        Object[] objectArray = new Object[fieldDescriptorArray.length];
        for (int i = 0; i < fieldDescriptorArray.length; ++i) {
            FieldDescriptor fieldDescriptor = fieldDescriptorArray[i];
            objectArray[i] = this.m_row.get(fieldDescriptor.getColumnName());
        }
        return new Identity(this.m_cld.getClassOfObject(), this.getTopLevelClass(), objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getObjectFromResultSet() throws PersistenceBrokerException {
        if (this.itemProxyClass != null) {
            this.m_cld.getRowReader().readPkValuesFrom(this.m_rsAndStmt.m_rs, this.m_row);
            return this.getProxyFromResultSet();
        }
        this.m_cld.getRowReader().readObjectArrayFrom(this.m_rsAndStmt.m_rs, this.m_row);
        Identity identity = this.getIdentityFromResultSet();
        Object object = null;
        object = this.cache.lookup(identity);
        if (object == null) {
            object = this.m_cld.getRowReader().readObjectFrom(this.m_row);
            if (object != null) {
                Object object2 = object;
                synchronized (object2) {
                    this.cache.cache(identity, object);
                    ClassDescriptor classDescriptor = this.m_cld.getRepository().getDescriptorFor(object.getClass());
                    this.m_broker.retrieveReferences(object, classDescriptor, false);
                    this.m_broker.retrieveCollections(object, classDescriptor, false);
                }
            }
        } else {
            ClassDescriptor classDescriptor = this.m_cld.getRepository().getDescriptorFor(object.getClass());
            if (classDescriptor.isAlwaysRefresh()) {
                this.m_cld.getRowReader().refreshObject(object, this.m_row);
            }
            this.m_broker.refreshRelationships(object, classDescriptor);
        }
        return object;
    }

    protected Object getProxyFromResultSet() throws PersistenceBrokerException {
        Identity identity = this.getIdentityFromResultSet();
        return VirtualProxy.createProxy(this.m_broker.getPBKey(), this.itemProxyClass, identity);
    }

    private boolean supportsAdvancedJDBCCursorControl() {
        if (!this.JDBCSupportAssessed) {
            if (this.getConnectionDescriptor().getJdbcLevel() >= 2.0) {
                this.advancedJDBCSupport = true;
            }
            this.JDBCSupportAssessed = true;
        }
        return this.advancedJDBCSupport;
    }

    protected int countedSize() throws PersistenceBrokerException {
        return this.m_broker.getCount(this.m_query);
    }

    public int size() throws PersistenceBrokerException {
        int n = 0;
        boolean bl = true;
        try {
            bl = this.m_rsAndStmt.m_stmt.getResultSetType() == 1003;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (!this.supportsAdvancedJDBCCursorControl() || this.m_broker.serviceConnectionManager().getSupportedPlatform().useCountForResultsetSize() || bl) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Executing count(*) to get size()");
            }
            n = this.countedSize();
        } else {
            int n2 = 1;
            try {
                if (this.m_rsAndStmt.m_rs != null) {
                    n2 = this.m_rsAndStmt.m_rs.getRow();
                    n = this.m_rsAndStmt.m_rs.last() ? this.m_rsAndStmt.m_rs.getRow() : 0;
                    if (n2 > 0) {
                        this.m_rsAndStmt.m_rs.absolute(n2);
                    } else {
                        this.m_rsAndStmt.m_rs.beforeFirst();
                    }
                }
            }
            catch (SQLException sQLException) {
                this.advancedJDBCSupport = false;
            }
        }
        return n;
    }

    public boolean absolute(int n) throws PersistenceBrokerException {
        boolean bl;
        block11: {
            bl = false;
            if (this.supportsAdvancedJDBCCursorControl()) {
                try {
                    if (this.m_rsAndStmt.m_rs != null) {
                        bl = this.m_rsAndStmt.m_rs.absolute(n);
                        this.m_current_row = n;
                        this.hasCalledCheck = false;
                    }
                }
                catch (SQLException sQLException) {
                    this.advancedJDBCSupport = false;
                }
            } else if (n > this.m_current_row) {
                try {
                    while (this.m_current_row < n && this.m_rsAndStmt.m_rs.next()) {
                        ++this.m_current_row;
                    }
                    if (this.m_current_row == n) {
                        bl = true;
                        break block11;
                    }
                    this.hasCalledCheck = true;
                    this.hasNext = false;
                    bl = false;
                    this.releaseDbResources();
                }
                catch (Exception exception) {
                    this.hasCalledCheck = true;
                    this.hasNext = false;
                    bl = false;
                }
            } else {
                this.logger.info("Your driver does not support advanced JDBC Functionality, you cannot call absolute() with a position < current");
            }
        }
        return bl;
    }

    public boolean relative(int n) throws SQLException {
        boolean bl = false;
        if (this.supportsAdvancedJDBCCursorControl()) {
            try {
                if (this.m_rsAndStmt.m_rs != null) {
                    bl = this.m_rsAndStmt.m_rs.relative(n);
                    this.m_current_row += n;
                }
            }
            catch (SQLException sQLException) {
                this.advancedJDBCSupport = false;
            }
        } else {
            if (n >= 0) {
                return this.absolute(this.m_current_row + n);
            }
            this.logger.info("Your driver does not support advanced JDBC Functionality, you cannot call relative() with a negative value");
        }
        return bl;
    }

    public void releaseDbResources() {
        if (!this.inBatchedMode && !this.resourcesAreReleased) {
            this.resourcesAreReleased = true;
            this.m_broker.serviceStatementManager().closeResources(this.m_rsAndStmt.m_stmt, this.m_rsAndStmt.m_rs);
        }
    }

    protected DescriptorRepository getDescriptorRepository() {
        return this.m_broker.getDescriptorRepository();
    }

    protected JdbcConnectionDescriptor getConnectionDescriptor() {
        return this.m_broker.serviceConnectionManager().getConnectionDescriptor();
    }

    protected void finalize() {
        this.releaseDbResources();
    }

    public String toString() {
        return super.toString() + "\n" + this.m_cld.toString();
    }

    public ClassDescriptor getClassDescriptor() {
        return this.m_cld;
    }
}

