/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.apache.ojb.broker.PBFactoryException;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.accesslayer.RowReader;
import org.apache.ojb.broker.accesslayer.conversions.FieldConversion;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.util.ConstructorHelper;
import org.apache.ojb.broker.util.SqlHelper;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class RowReaderDefaultImpl
implements RowReader {
    private ClassDescriptor m_cld;
    static /* synthetic */ Class class$org$apache$ojb$broker$accesslayer$RowReaderDefaultImpl;

    public RowReaderDefaultImpl(ClassDescriptor classDescriptor) {
        this.m_cld = classDescriptor;
    }

    public Object readObjectFrom(Map map) throws PersistenceBrokerException {
        ClassDescriptor classDescriptor = this.selectClassDescriptor(map);
        return this.buildWithReflection(map, classDescriptor);
    }

    public void readObjectArrayFrom(ResultSet resultSet, Map map) {
        FieldDescriptor[] fieldDescriptorArray = null;
        fieldDescriptorArray = this.m_cld.getSuperClass() != null ? this.m_cld.getFieldDescriptorsInHeirarchy() : this.m_cld.getRepository().getFieldDescriptorsForMultiMappedTable(this.m_cld);
        int n = fieldDescriptorArray.length;
        FieldDescriptor fieldDescriptor = null;
        FieldConversion fieldConversion = null;
        Object object = null;
        try {
            for (int i = 0; i < n; ++i) {
                fieldDescriptor = fieldDescriptorArray[i];
                fieldConversion = fieldDescriptor.getFieldConversion();
                object = SqlHelper.getObjectFromColumn(resultSet, fieldDescriptor);
                map.put(fieldDescriptor.getColumnName(), fieldConversion.sqlToJava(object));
            }
        }
        catch (SQLException sQLException) {
            throw new PersistenceBrokerException("Error reading class type: " + this.m_cld.getClassNameOfObject() + " from result set", sQLException);
        }
    }

    protected ClassDescriptor selectClassDescriptor(Map map) throws PersistenceBrokerException {
        FieldDescriptor fieldDescriptor = this.m_cld.getFieldDescriptorByName("ojbConcreteClass");
        if (fieldDescriptor == null) {
            return this.m_cld;
        }
        try {
            String string = (String)map.get(fieldDescriptor.getColumnName());
            if (string == null || string.trim().length() == 0) {
                throw new PersistenceBrokerException("ojbConcreteClass field returned null or 0-length string");
            }
            string = string.trim();
            ClassDescriptor classDescriptor = this.m_cld.getRepository().getDescriptorFor(string);
            if (classDescriptor == null) {
                LoggerFactory.getDefaultLogger().warn("[" + (class$org$apache$ojb$broker$accesslayer$RowReaderDefaultImpl == null ? (class$org$apache$ojb$broker$accesslayer$RowReaderDefaultImpl = RowReaderDefaultImpl.class$("org.apache.ojb.broker.accesslayer.RowReaderDefaultImpl")) : class$org$apache$ojb$broker$accesslayer$RowReaderDefaultImpl).getName() + "] Can not find class-descriptor for ojbConcreteClass " + string + ", use given class-descriptor '" + this.m_cld.getClassNameOfObject() + "' instead");
                classDescriptor = this.m_cld;
            }
            return classDescriptor;
        }
        catch (PBFactoryException pBFactoryException) {
            throw new PersistenceBrokerException((Throwable)((Object)pBFactoryException));
        }
    }

    protected Object buildWithReflection(Map map, ClassDescriptor classDescriptor) {
        FieldDescriptor[] fieldDescriptorArray;
        Object object = null;
        FieldDescriptor fieldDescriptor = null;
        if (null == classDescriptor.getFactoryClass() || null == classDescriptor.getFactoryMethod()) {
            try {
                fieldDescriptorArray = classDescriptor.getZeroArgumentConstructor();
                object = ConstructorHelper.instantiate((Constructor)fieldDescriptorArray);
            }
            catch (Exception exception) {
                throw new PersistenceBrokerException("Unable to build object instance (MAYBE you don't have a constructor available):" + this.m_cld.getClassOfObject(), exception);
            }
        }
        try {
            object = classDescriptor.getFactoryMethod().invoke(null, null);
        }
        catch (Exception exception) {
            throw new PersistenceBrokerException("Unable to build object instance of class " + this.m_cld.getClassOfObject() + " from factory:" + this.m_cld.getFactoryClass() + "." + this.m_cld.getFactoryMethod(), exception);
        }
        if (null != object) {
            fieldDescriptorArray = classDescriptor.getFieldDescriptions();
            for (int i = 0; i < fieldDescriptorArray.length; ++i) {
                fieldDescriptor = fieldDescriptorArray[i];
                fieldDescriptor.getPersistentField().set(object, map.get(fieldDescriptor.getColumnName()));
            }
            Method method = classDescriptor.getInitializationMethod();
            Object[] objectArray = new Object[]{};
            if (method != null) {
                try {
                    method.invoke(object, objectArray);
                }
                catch (Exception exception) {
                    throw new PersistenceBrokerException("Unable to invoke initialization method:" + method.getName() + " for class:" + this.m_cld.getClassOfObject(), exception);
                }
            }
        }
        return object;
    }

    protected Object buildWithMultiArgsConstructor(Map map, Constructor constructor) throws SQLException, InstantiationException, IllegalAccessException, InvocationTargetException, PersistenceBrokerException {
        Object[] objectArray = map.values().toArray();
        Object t = constructor.newInstance(objectArray);
        return t;
    }

    public void readPkValuesFrom(ResultSet resultSet, Map map) {
        try {
            FieldDescriptor[] fieldDescriptorArray = this.m_cld.getPkFields();
            for (int i = 0; i < fieldDescriptorArray.length; ++i) {
                FieldDescriptor fieldDescriptor = fieldDescriptorArray[i];
                FieldConversion fieldConversion = fieldDescriptor.getFieldConversion();
                Object object = SqlHelper.getObjectFromColumn(resultSet, fieldDescriptor);
                map.put(fieldDescriptor.getColumnName(), fieldConversion.sqlToJava(object));
            }
        }
        catch (SQLException sQLException) {
            throw new PersistenceBrokerException("Error reading from result set", sQLException);
        }
    }

    public void setClassDescriptor(ClassDescriptor classDescriptor) {
        this.m_cld = classDescriptor;
    }

    public ClassDescriptor getClassDescriptor() {
        return this.m_cld;
    }

    public void refreshObject(Object object, Map map) {
        ClassDescriptor classDescriptor = this.selectClassDescriptor(map);
        FieldDescriptor[] fieldDescriptorArray = classDescriptor.getFieldDescriptions();
        for (int i = 0; i < fieldDescriptorArray.length; ++i) {
            FieldDescriptor fieldDescriptor = fieldDescriptorArray[i];
            fieldDescriptor.getPersistentField().set(object, map.get(fieldDescriptor.getColumnName()));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

